/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzahg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zzot;
import java.util.Locale;

public final class zzahh {
    private int zzcmv;
    private boolean zzcnd;
    private boolean zzcne;
    private int zzcni;
    private int zzcnm;
    private int zzcnn;
    private String zzcmy;
    private int zzcnj;
    private int zzcnk;
    private int zzcnl;
    private boolean zzcnq;
    private int zzcnr;
    private double zzcno;
    private boolean zzcnp;
    private String zzcns;
    private String zzcnt;
    private boolean zzcmw;
    private boolean zzcmx;
    private String zzcmz;
    private boolean zzcna;
    private final boolean zzcnb;
    private boolean zzcnc;
    private String zzcnf;
    private String zzcng;
    private float zzahm;
    private int zzcgu;
    private int zzcgv;
    private String zzcnh;
    private boolean zzcnu;

    public zzahh(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzo(context);
        this.zzp(context);
        this.zzq(context);
        Locale locale = Locale.getDefault();
        this.zzcmw = zzahh.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzcmx = zzahh.zza(packageManager, "http://www.google.com") != null;
        this.zzcmz = locale.getCountry();
        zzkd.zziz();
        this.zzcna = zzaoa.zztu();
        this.zzcnb = DeviceProperties.isLatchsky((Context)context);
        this.zzcnc = DeviceProperties.isSidewinder((Context)context);
        this.zzcnf = locale.getLanguage();
        this.zzcng = zzahh.zza(context, packageManager);
        this.zzcnh = zzahh.zzr(context);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzahm = displayMetrics.density;
        this.zzcgu = displayMetrics.widthPixels;
        this.zzcgv = displayMetrics.heightPixels;
    }

    public zzahh(Context context, zzahg zzahg2) {
        this.zzo(context);
        this.zzp(context);
        this.zzq(context);
        Context context2 = context;
        zzahh zzahh2 = this;
        this.zzcns = Build.FINGERPRINT;
        zzahh2.zzcnt = Build.DEVICE;
        zzahh2.zzcnu = PlatformVersion.isAtLeastIceCreamSandwichMR1() && zzot.zzi(context2);
        this.zzcmw = zzahg2.zzcmw;
        this.zzcmx = zzahg2.zzcmx;
        this.zzcmz = zzahg2.zzcmz;
        this.zzcna = zzahg2.zzcna;
        this.zzcnb = zzahg2.zzcnb;
        this.zzcnc = zzahg2.zzcnc;
        this.zzcnf = zzahg2.zzcnf;
        this.zzcng = zzahg2.zzcng;
        this.zzcnh = zzahg2.zzcnh;
        this.zzahm = zzahg2.zzahm;
        this.zzcgu = zzahg2.zzcgu;
        this.zzcgv = zzahg2.zzcgv;
    }

    private final void zzo(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            try {
                this.zzcmv = audioManager.getMode();
                this.zzcnd = audioManager.isMusicActive();
                this.zzcne = audioManager.isSpeakerphoneOn();
                this.zzcni = audioManager.getStreamVolume(3);
                this.zzcnm = audioManager.getRingerMode();
                this.zzcnn = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbv.zzeo().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzcmv = -2;
        this.zzcnd = false;
        this.zzcne = false;
        this.zzcni = 0;
        this.zzcnm = 0;
        this.zzcnn = 0;
    }

    @TargetApi(value=16)
    private final void zzp(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzcmy = telephonyManager.getNetworkOperator();
        this.zzcnk = telephonyManager.getNetworkType();
        this.zzcnl = telephonyManager.getPhoneType();
        this.zzcnj = -2;
        this.zzcnq = false;
        this.zzcnr = -1;
        zzbv.zzek();
        if (zzalo.zzn(context, "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzcnj = networkInfo.getType();
                this.zzcnr = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzcnj = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzcnq = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzq(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzcno = (float)n2 / (float)n3;
            this.zzcnp = n == 2 || n == 5;
            return;
        }
        this.zzcno = -1.0;
        this.zzcnp = false;
    }

    private static String zzr(Context context) {
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zza(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzahh.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzbv.zzeo().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzahg zzqb() {
        return new zzahg(this.zzcmv, this.zzcmw, this.zzcmx, this.zzcmy, this.zzcmz, this.zzcna, this.zzcnb, this.zzcnc, this.zzcnd, this.zzcne, this.zzcnf, this.zzcng, this.zzcnh, this.zzcni, this.zzcnj, this.zzcnk, this.zzcnl, this.zzcnm, this.zzcnn, this.zzahm, this.zzcgu, this.zzcgv, this.zzcno, this.zzcnp, this.zzcnq, this.zzcnr, this.zzcns, this.zzcnu, this.zzcnt);
    }
}

