/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzajo;
import com.google.android.gms.internal.ads.zzajp;
import com.google.android.gms.internal.ads.zzajq;
import com.google.android.gms.internal.ads.zzajr;
import com.google.android.gms.internal.ads.zzajs;
import com.google.android.gms.internal.ads.zzajv;
import com.google.android.gms.internal.ads.zzajx;
import com.google.android.gms.internal.ads.zzajy;
import com.google.android.gms.internal.ads.zzaka;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalm;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzamz;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzaox;
import com.google.android.gms.internal.ads.zzapi;
import com.google.android.gms.internal.ads.zzapn;
import com.google.android.gms.internal.ads.zzbgz;
import com.google.android.gms.internal.ads.zzbhn;
import com.google.android.gms.internal.ads.zzbho;
import com.google.android.gms.internal.ads.zzbhp;
import com.google.android.gms.internal.ads.zzbhq;
import com.google.android.gms.internal.ads.zzbht;
import com.google.android.gms.internal.ads.zzbhu;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
@ParametersAreNonnullByDefault
public final class zzajn
implements zzajy {
    private static List<Future<Void>> zzcpv = Collections.synchronizedList(new ArrayList());
    private static ScheduledExecutorService zzcpw = Executors.newSingleThreadScheduledExecutor();
    @GuardedBy(value="mLock")
    private final zzbhn zzcpx;
    @GuardedBy(value="mLock")
    private final LinkedHashMap<String, zzbht> zzcpy;
    @GuardedBy(value="mLock")
    private final List<String> zzcpz = new ArrayList<String>();
    @GuardedBy(value="mLock")
    private final List<String> zzcqa = new ArrayList<String>();
    private final Context mContext;
    private final zzaka zzcqb;
    @VisibleForTesting
    private boolean zzcqc;
    private final zzajv zzcmj;
    private final zzakb zzcqd;
    private final Object mLock = new Object();
    private HashSet<String> zzcqe = new HashSet();
    private boolean zzcqf = false;
    private boolean zzcqg = false;
    private boolean zzcqh = false;

    public zzajn(Context context, zzaop zzaop2, zzajv zzajv2, String string2, zzaka zzaka2) {
        Preconditions.checkNotNull((Object)((Object)zzajv2), (Object)"SafeBrowsing config is not present.");
        this.mContext = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzcpy = new LinkedHashMap();
        this.zzcqb = zzaka2;
        this.zzcmj = zzajv2;
        for (String string3 : this.zzcmj.zzcqr) {
            this.zzcqe.add(string3.toLowerCase(Locale.ENGLISH));
        }
        this.zzcqe.remove("cookie".toLowerCase(Locale.ENGLISH));
        String string4 = string2;
        zzaop zzaop3 = zzaop2;
        zzajn zzajn2 = this;
        zzbhn zzbhn2 = new zzbhn();
        new zzbhn().zzeiq = 8;
        zzbhn2.url = string4;
        zzbhn2.zzeis = string4;
        zzbhn2.zzeiu = new zzbho();
        zzbhn2.zzeiu.zzcqn = zzajn2.zzcmj.zzcqn;
        zzbhu zzbhu2 = new zzbhu();
        new zzbhu().zzekb = zzaop3.zzcx;
        zzbhu2.zzekd = Wrappers.packageManager((Context)zzajn2.mContext).isCallerInstantApp();
        long l = GoogleApiAvailabilityLight.getInstance().getApkVersion(zzajn2.mContext);
        if (l > 0L) {
            zzbhu2.zzekc = l;
        }
        zzbhn2.zzeje = zzbhu2;
        this.zzcpx = zzbhn2;
        this.zzcqd = new zzakb(this.mContext, this.zzcmj.zzcqu, this);
    }

    @Override
    public final zzajv zzqt() {
        return this.zzcmj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcj(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcpx.zzeiw = string2;
            return;
        }
    }

    @Override
    public final boolean zzqu() {
        return PlatformVersion.isAtLeastKitKat() && this.zzcmj.zzcqp && !this.zzcqg;
    }

    @Override
    public final void zzs(View view) {
        if (!this.zzcmj.zzcqp) {
            return;
        }
        if (this.zzcqg) {
            return;
        }
        zzbv.zzek();
        Bitmap bitmap = zzalo.zzu(view);
        if (bitmap == null) {
            zzajx.zzco("Failed to capture the webview bitmap.");
            return;
        }
        this.zzcqg = true;
        zzalo.zzc(new zzajq(this, bitmap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(String string2, Map<String, String> map, int n) {
        Object object = this.mLock;
        synchronized (object) {
            if (n == 3) {
                this.zzcqh = true;
            }
            if (this.zzcpy.containsKey(string2)) {
                if (n == 3) {
                    this.zzcpy.get((Object)string2).zzejz = n;
                }
                return;
            }
            zzbht zzbht2 = new zzbht();
            new zzbht().zzejz = n;
            zzbht2.zzejt = this.zzcpy.size();
            zzbht2.url = string2;
            zzbht2.zzeju = new zzbhq();
            if (this.zzcqe.size() > 0 && map != null) {
                ArrayList<zzbhp> arrayList = new ArrayList<zzbhp>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    try {
                        String string3 = entry.getKey() != null ? entry.getKey() : "";
                        String string4 = entry.getValue() != null ? entry.getValue() : "";
                        String string5 = string3.toLowerCase(Locale.ENGLISH);
                        if (!this.zzcqe.contains(string5)) continue;
                        zzbhp zzbhp2 = new zzbhp();
                        new zzbhp().zzeji = string3.getBytes("UTF-8");
                        zzbhp2.zzejj = string4.getBytes("UTF-8");
                        arrayList.add(zzbhp2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        zzajx.zzco("Cannot convert string to bytes, skip header.");
                    }
                }
                zzbhp[] zzbhpArray = new zzbhp[arrayList.size()];
                arrayList.toArray(zzbhpArray);
                zzbht2.zzeju.zzejl = zzbhpArray;
            }
            this.zzcpy.put(string2, zzbht2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzck(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcpz.add(string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzcl(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcqa.add(string2);
            return;
        }
    }

    @Override
    public final String[] zzb(String[] stringArray) {
        return this.zzcqd.zzc(stringArray).toArray(new String[0]);
    }

    @Override
    public final void zzqv() {
        this.zzcqf = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzbht zzcm(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcpy.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzqw() {
        Object object = this.mLock;
        synchronized (object) {
            zzapi zzapi2 = zzaox.zza(this.zzcqb.zza(this.mContext, this.zzcpy.keySet()), new zzajo(this), zzapn.zzczx);
            zzapi zzapi3 = zzaox.zza(zzapi2, 10L, TimeUnit.SECONDS, zzcpw);
            zzaox.zza(zzapi2, new zzajr(this, zzapi3), zzapn.zzczx);
            zzcpv.add(zzapi3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final zzapi<Void> zzqx() {
        if (!(this.zzcqc && this.zzcmj.zzcqt || this.zzcqh && this.zzcmj.zzcqs || !this.zzcqc && this.zzcmj.zzcqq)) {
            return zzaox.zzj(null);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.zzcpx.zzeiv = new zzbht[this.zzcpy.size()];
            this.zzcpy.values().toArray(this.zzcpx.zzeiv);
            this.zzcpx.zzejf = this.zzcpz.toArray(new String[0]);
            this.zzcpx.zzejg = this.zzcqa.toArray(new String[0]);
            if (zzajx.isEnabled()) {
                zzbht[] zzbhtArray = this.zzcpx.url;
                String string2 = this.zzcpx.zzeiw;
                StringBuilder stringBuilder = new StringBuilder(new StringBuilder(53 + String.valueOf(zzbhtArray).length() + String.valueOf(string2).length()).append("Sending SB report\n  url: ").append((String)zzbhtArray).append("\n  clickUrl: ").append(string2).append("\n  resources: \n").toString());
                zzbhtArray = this.zzcpx.zzeiv;
                int n = this.zzcpx.zzeiv.length;
                for (int i = 0; i < n; ++i) {
                    zzbht zzbht2 = zzbhtArray[i];
                    stringBuilder.append("    [");
                    stringBuilder.append(zzbht2.zzeka.length);
                    stringBuilder.append("] ");
                    stringBuilder.append(zzbht2.url);
                }
                zzajx.zzco(stringBuilder.toString());
            }
            String string3 = this.zzcmj.zzcqo;
            byte[] byArray = zzbgz.zzb((zzbgz)this.zzcpx);
            zzajn zzajn2 = this;
            zzapi<String> zzapi2 = new zzamz(zzajn2.mContext).zza(1, string3, null, byArray);
            if (zzajx.isEnabled()) {
                zzapi2.zza(new zzajs(zzajn2), zzalm.zzcve);
            }
            return zzaox.zza(zzapi2, zzajp.zzcqj, zzapn.zzczx);
        }
    }

    static final /* synthetic */ Void zzcn(String string2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ zzapi zzm(Map map) throws Exception {
        try {
            Map map2;
            Map map3 = map2 = map;
            zzajn zzajn2 = this;
            if (map3 != null) {
                for (String string2 : map3.keySet()) {
                    String string3 = (String)map3.get(string2);
                    JSONArray jSONArray = new JSONObject(string3).optJSONArray("matches");
                    if (jSONArray == null) continue;
                    Object object = zzajn2.mLock;
                    synchronized (object) {
                        int n = jSONArray.length();
                        zzbht zzbht2 = zzajn2.zzcm(string2);
                        if (zzbht2 == null) {
                            String string4 = String.valueOf(string2);
                            zzajx.zzco(string4.length() != 0 ? "Cannot find the corresponding resource object for ".concat(string4) : new String("Cannot find the corresponding resource object for "));
                            continue;
                        }
                        zzbht2.zzeka = new String[n];
                        for (int i = 0; i < n; ++i) {
                            zzbht2.zzeka[i] = jSONArray.getJSONObject(i).getString("threat_type");
                        }
                        zzajn2.zzcqc = zzajn2.zzcqc | n > 0;
                    }
                }
            }
            if (this.zzcqc) {
                Object object = this.mLock;
                synchronized (object) {
                    this.zzcpx.zzeiq = 9;
                }
            }
            return this.zzqx();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            String string5 = "Failed to get SafeBrowsing metadata";
            zznl zznl2 = zznw.zzbfq;
            if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
                zzalg.zza((String)string5, (Throwable)jSONException2);
            }
            return zzaox.zzd(new Exception("Safebrowsing report transmission failed."));
        }
    }

    static /* synthetic */ Object zza(zzajn zzajn2) {
        return zzajn2.mLock;
    }

    static /* synthetic */ zzbhn zzb(zzajn zzajn2) {
        return zzajn2.zzcpx;
    }

    static /* synthetic */ List zzqy() {
        return zzcpv;
    }
}

