/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzamr;
import com.google.android.gms.internal.ads.zzamz;
import com.google.android.gms.internal.ads.zzapi;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
public final class zzamq {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private String zzcwj = "";
    @GuardedBy(value="mLock")
    private String zzcwk = "";
    @GuardedBy(value="mLock")
    private boolean zzcwl = false;
    @VisibleForTesting
    private String zzcwm = "";

    public final void zzf(Context context, String string2, String string3) {
        if (!this.zzg(context, string2, string3)) {
            this.zza(context, "In-app preview failed to load because of a system error. Please try again later.", true, true);
            return;
        }
        if ("2".equals(this.zzcwm)) {
            zzalg.zzco((String)"Creative is not pushed for this device.");
            this.zza(context, "There was no creative pushed from DFP to the device.", false, false);
            return;
        }
        if ("1".equals(this.zzcwm)) {
            zzalg.zzco((String)"The app is not linked for creative preview.");
            this.zzj(context, string2, string3);
            return;
        }
        if ("0".equals(this.zzcwm)) {
            zzalg.zzco((String)"Device is linked for in app preview.");
            this.zza(context, "The device is successfully linked for creative preview.", false, true);
        }
    }

    public final void zza(Context context, String string2, String string3, @Nullable String string4) {
        boolean bl = this.zztl();
        if (this.zzh(context, string2, string3)) {
            if (!bl && !TextUtils.isEmpty((CharSequence)string4)) {
                this.zzb(context, string3, string4, string2);
            }
            zzalg.zzco((String)"Device is linked for debug signals.");
            this.zza(context, "The device is successfully linked for troubleshooting.", false, true);
            return;
        }
        this.zzj(context, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzg(Context context, String string2, String string3) {
        String string4;
        Object object = zznw.zzbgk;
        String string5 = zzamq.zzi(context, this.zzc(context, (String)zzkd.zzjd().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzalg.zzco((String)"Not linked for in app preview.");
            return false;
        }
        string5 = string5.trim();
        try {
            JSONObject jSONObject = new JSONObject(string5);
            string4 = jSONObject.optString("gct");
            this.zzcwm = jSONObject.optString("status");
        }
        catch (JSONException jSONException) {
            zzalg.zzc((String)"Fail to get in app preview response json.", (Throwable)jSONException);
            return false;
        }
        String string6 = string4;
        object = this;
        Object object2 = object.mLock;
        synchronized (object2) {
            object.zzcwk = string6;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzh(Context context, String string2, String string3) {
        String string4;
        Object object = zznw.zzbgl;
        String string5 = zzamq.zzi(context, this.zzc(context, (String)zzkd.zzjd().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzalg.zzco((String)"Not linked for debug signals.");
            return false;
        }
        string5 = string5.trim();
        try {
            string4 = new JSONObject(string5).optString("debug_mode");
        }
        catch (JSONException jSONException) {
            zzalg.zzc((String)"Fail to get debug mode response json.", (Throwable)jSONException);
            return false;
        }
        boolean bl = "1".equals(string4);
        object = this;
        Object object2 = object.mLock;
        synchronized (object2) {
            object.zzcwl = bl;
        }
        return bl;
    }

    @VisibleForTesting
    private static String zzi(Context context, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzbv.zzek().zzo(context, string3));
        zzapi<String> zzapi2 = new zzamz(context).zzc(string2, hashMap);
        try {
            zznl zznl2 = zznw.zzbgn;
            return (String)zzapi2.get(((Integer)zzkd.zzjd().zzd(zznl2)).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            String string4 = String.valueOf(string2);
            zzalg.zzb((String)(string4.length() != 0 ? "Timeout while retriving a response from: ".concat(string4) : new String("Timeout while retriving a response from: ")), (Throwable)timeoutException);
            zzapi2.cancel(true);
        }
        catch (InterruptedException interruptedException) {
            String string5 = String.valueOf(string2);
            zzalg.zzb((String)(string5.length() != 0 ? "Interrupted while retriving a response from: ".concat(string5) : new String("Interrupted while retriving a response from: ")), (Throwable)interruptedException);
            zzapi2.cancel(true);
        }
        catch (Exception exception) {
            String string6 = String.valueOf(string2);
            zzalg.zzb((String)(string6.length() != 0 ? "Error retriving a response from: ".concat(string6) : new String("Error retriving a response from: ")), (Throwable)exception);
        }
        return null;
    }

    private final void zzj(Context context, String string2, String string3) {
        zzbv.zzek();
        zznl zznl2 = zznw.zzbgj;
        zzalo.zza(context, this.zzc(context, (String)zzkd.zzjd().zzd(zznl2), string2, string3));
    }

    public final void zzb(Context context, String string2, String string3, String string4) {
        zznl zznl2 = zznw.zzbgm;
        Uri.Builder builder = this.zzc(context, (String)zzkd.zzjd().zzd(zznl2), string4, string2).buildUpon();
        builder.appendQueryParameter("debugData", string3);
        zzbv.zzek();
        zzalo.zzc(context, string2, builder.build().toString());
    }

    private final Uri zzc(Context context, String string2, String string3, String string4) {
        Uri.Builder builder = Uri.parse((String)string2).buildUpon();
        builder.appendQueryParameter("linkedDeviceId", this.zzbb(context));
        builder.appendQueryParameter("adSlotPath", string3);
        builder.appendQueryParameter("afmaVersion", string4);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zzbb(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)this.zzcwj)) {
                zzbv.zzek();
                this.zzcwj = zzalo.zzp(context, "debug_signals_id.txt");
                if (TextUtils.isEmpty((CharSequence)this.zzcwj)) {
                    zzbv.zzek();
                    this.zzcwj = zzalo.zzsw();
                    zzbv.zzek();
                    zzalo.zzd(context, "debug_signals_id.txt", this.zzcwj);
                }
            }
            return this.zzcwj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zztk() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcwk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zztl() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcwl;
        }
    }

    @VisibleForTesting
    private final void zza(Context context, String string2, boolean bl, boolean bl2) {
        if (!(context instanceof Activity)) {
            zzalg.zzdo((String)"Can not create dialog without Activity Context");
            return;
        }
        zzalo.zzcvi.post((Runnable)new zzamr(this, context, string2, bl, bl2));
    }
}

