/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzapi;
import com.google.android.gms.internal.ads.zzapj;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzaer
@ParametersAreNonnullByDefault
public class zzaps<T>
implements zzapi<T> {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private T mValue;
    @GuardedBy(value="mLock")
    private Throwable zzdad;
    @GuardedBy(value="mLock")
    private boolean zzdae;
    @GuardedBy(value="mLock")
    private boolean zzbxo;
    private final zzapj zzdaf = new zzapj();

    @Override
    public final void zza(Runnable runnable, Executor executor) {
        this.zzdaf.zza(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbxo) {
                return;
            }
            if (this.zzuc()) {
                zzbv.zzeo().zzb(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.set");
                return;
            }
            this.zzdae = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzdaf.zzua();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbxo) {
                return;
            }
            if (this.zzuc()) {
                zzbv.zzeo().zzb(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.setException");
                return;
            }
            this.zzdad = throwable;
            this.mLock.notifyAll();
            this.zzdaf.zzua();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzuc()) {
                this.mLock.wait();
            }
            if (this.zzdad != null) {
                throw new ExecutionException(this.zzdad);
            }
            if (this.zzbxo) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzuc()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzdad != null) {
                throw new ExecutionException(this.zzdad);
            }
            if (!this.zzdae) {
                throw new TimeoutException("SettableFuture timed out.");
            }
            if (this.zzbxo) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzuc()) {
                return false;
            }
            this.zzbxo = true;
            this.zzdae = true;
            this.mLock.notifyAll();
            this.zzdaf.zzua();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzbxo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzuc();
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zzuc() {
        return this.zzdad != null || this.zzdae;
    }
}

