/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzaqf;
import com.google.android.gms.internal.ads.zzaqg;
import com.google.android.gms.internal.ads.zzaqh;
import com.google.android.gms.internal.ads.zzaqi;
import com.google.android.gms.internal.ads.zzaqj;
import com.google.android.gms.internal.ads.zzaqk;
import com.google.android.gms.internal.ads.zzaql;
import com.google.android.gms.internal.ads.zzaqm;
import com.google.android.gms.internal.ads.zzaqn;
import com.google.android.gms.internal.ads.zzaqo;
import com.google.android.gms.internal.ads.zzaqp;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzarf;
import com.google.android.gms.internal.ads.zzarh;
import com.google.android.gms.internal.ads.zzho;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzaer
@TargetApi(value=14)
public final class zzaqe
extends zzaqp
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzdam = new HashMap<Integer, String>();
    private final zzarh zzdan;
    private final boolean zzdao;
    private int zzdap = 0;
    private int zzdaq = 0;
    private MediaPlayer zzdar;
    private Uri zzdas;
    private int zzdat;
    private int zzdau;
    private int zzdav;
    private int zzdaw;
    private int zzdax;
    private zzare zzday;
    private boolean zzdaz;
    private int zzdba;
    private zzaqo zzdbb;

    public zzaqe(Context context, boolean bl, boolean bl2, zzarf zzarf2, zzarh zzarh2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzdan = zzarh2;
        this.zzdaz = bl;
        this.zzdao = bl2;
        this.zzdan.zzb(this);
    }

    @Override
    public final String zzud() {
        String string2 = String.valueOf(this.zzdaz ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzaqo zzaqo2) {
        this.zzdbb = zzaqo2;
    }

    @Override
    public final void setVideoPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzaqe zzaqe2 = this;
        zzho zzho2 = zzho.zzd(uri);
        zzaqe2.zzdas = zzho2 == null ? uri : Uri.parse((String)zzho2.url);
        zzaqe2.zzdba = 0;
        zzaqe2.zzue();
        zzaqe2.requestLayout();
        zzaqe2.invalidate();
    }

    @Override
    public final void stop() {
        zzalg.v("AdMediaPlayerView stop");
        if (this.zzdar != null) {
            this.zzdar.stop();
            this.zzdar.release();
            this.zzdar = null;
            this.zzan(0);
            this.zzdaq = 0;
        }
        this.zzdan.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzalg.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzdat = mediaPlayer.getVideoWidth();
        this.zzdau = mediaPlayer.getVideoHeight();
        if (this.zzdat != 0 && this.zzdau != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzalg.v("AdMediaPlayerView prepared");
        this.zzan(2);
        this.zzdan.zzuj();
        zzalo.zzcvi.post((Runnable)new zzaqg(this));
        this.zzdat = mediaPlayer.getVideoWidth();
        this.zzdau = mediaPlayer.getVideoHeight();
        if (this.zzdba != 0) {
            ((zzaqp)this).seekTo(this.zzdba);
        }
        this.zzuf();
        int n = this.zzdat;
        int n2 = this.zzdau;
        zzalg.zzdo((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzdaq == 3) {
            ((zzaqp)this).play();
        }
        ((zzaqp)this).zzuh();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzalg.v("AdMediaPlayerView completion");
        this.zzan(5);
        this.zzdaq = 5;
        zzalo.zzcvi.post((Runnable)new zzaqh(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzdam.get(n);
        String string3 = zzdam.get(n2);
        zzalg.v(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzdam.get(n);
        String string3 = zzdam.get(n2);
        zzalg.zzdp((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzan(-1);
        this.zzdaq = -1;
        zzalo.zzcvi.post((Runnable)new zzaqi(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzdav = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzalg.v("AdMediaPlayerView surface created");
        this.zzue();
        zzalo.zzcvi.post((Runnable)new zzaqj(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzalg.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzdaq == 3;
        boolean bl3 = bl = this.zzdat == n && this.zzdau == n2;
        if (this.zzdar != null && bl2 && bl) {
            if (this.zzdba != 0) {
                ((zzaqp)this).seekTo(this.zzdba);
            }
            ((zzaqp)this).play();
        }
        if (this.zzday != null) {
            this.zzday.zzh(n, n2);
        }
        zzalo.zzcvi.post((Runnable)new zzaqk(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzalg.v("AdMediaPlayerView surface destroyed");
        if (this.zzdar != null && this.zzdba == 0) {
            this.zzdba = this.zzdar.getCurrentPosition();
        }
        if (this.zzday != null) {
            this.zzday.zzuw();
        }
        zzalo.zzcvi.post((Runnable)new zzaql(this));
        this.zzag(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzdan.zzc(this);
        this.zzdbi.zza(surfaceTexture, this.zzdbb);
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzalg.v(new StringBuilder(58).append("AdMediaPlayerView window visibility changed to ").append(n).toString());
        zzalo.zzcvi.post((Runnable)new zzaqf(this, n));
        super.onWindowVisibilityChanged(n);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzaqe.getDefaultSize((int)this.zzdat, (int)n);
        int n4 = zzaqe.getDefaultSize((int)this.zzdau, (int)n2);
        if (this.zzdat > 0 && this.zzdau > 0 && this.zzday == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzdat * n4 < n3 * this.zzdau) {
                    n3 = n4 * this.zzdat / this.zzdau;
                } else if (this.zzdat * n4 > n3 * this.zzdau) {
                    n4 = n3 * this.zzdau / this.zzdat;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzdau / this.zzdat;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzdat / this.zzdau;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzdat;
                n4 = this.zzdau;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzdat / this.zzdau;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzdau / this.zzdat;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzday != null) {
            this.zzday.zzh(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzdaw > 0 && this.zzdaw != n3 || this.zzdax > 0 && this.zzdax != n4) {
                this.zzuf();
            }
            this.zzdaw = n3;
            this.zzdax = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzue() {
        zzalg.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzdas == null || surfaceTexture == null) {
            return;
        }
        this.zzag(false);
        try {
            Surface surface;
            zzbv.zzfc();
            this.zzdar = new MediaPlayer();
            this.zzdar.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzdar.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzdar.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzdar.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzdar.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzdar.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzdav = 0;
            if (this.zzdaz) {
                this.zzday = new zzare(this.getContext());
                this.zzday.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzday.start();
                surface = this.zzday.zzux();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzday.zzuw();
                    this.zzday = null;
                }
            }
            this.zzdar.setDataSource(this.getContext(), this.zzdas);
            zzbv.zzfd();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzdar.setSurface(surface);
            this.zzdar.setAudioStreamType(3);
            this.zzdar.setScreenOnWhilePlaying(true);
            this.zzdar.prepareAsync();
            this.zzan(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzdas);
            zzalg.zzc((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzdar, 1, 0);
            return;
        }
    }

    private final void zzuf() {
        if (!this.zzdao) {
            return;
        }
        if (this.zzug() && this.zzdar.getCurrentPosition() > 0 && this.zzdaq != 3) {
            zzalg.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzdar.start();
            int n = this.zzdar.getCurrentPosition();
            long l = zzbv.zzer().currentTimeMillis();
            while (this.zzug() && this.zzdar.getCurrentPosition() == n && zzbv.zzer().currentTimeMillis() - l <= 250L) {
            }
            this.zzdar.pause();
            ((zzaqp)this).zzuh();
        }
    }

    private final void zzag(boolean bl) {
        zzalg.v("AdMediaPlayerView release");
        if (this.zzday != null) {
            this.zzday.zzuw();
            this.zzday = null;
        }
        if (this.zzdar != null) {
            this.zzdar.reset();
            this.zzdar.release();
            this.zzdar = null;
            this.zzan(0);
            if (bl) {
                this.zzdaq = 0;
                this.zzdaq = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzalg.v("AdMediaPlayerView play");
        if (this.zzug()) {
            this.zzdar.start();
            this.zzan(3);
            this.zzdbi.zzuk();
            zzalo.zzcvi.post((Runnable)new zzaqm(this));
        }
        this.zzdaq = 3;
    }

    @Override
    public final void pause() {
        zzalg.v("AdMediaPlayerView pause");
        if (this.zzug() && this.zzdar.isPlaying()) {
            this.zzdar.pause();
            this.zzan(4);
            zzalo.zzcvi.post((Runnable)new zzaqn(this));
        }
        this.zzdaq = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzug()) {
            return this.zzdar.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzug()) {
            return this.zzdar.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzalg.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzug()) {
            this.zzdar.seekTo(n);
            this.zzdba = 0;
            return;
        }
        this.zzdba = n;
    }

    private final boolean zzug() {
        return this.zzdar != null && this.zzdap != -1 && this.zzdap != 0 && this.zzdap != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzday != null) {
            this.zzday.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzdar != null) {
            return this.zzdar.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzdar != null) {
            return this.zzdar.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzuh() {
        this.zza(this.zzdbj.getVolume());
    }

    private final void zza(float f) {
        if (this.zzdar != null) {
            try {
                this.zzdar.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzalg.zzdp((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzan(int n) {
        if (n == 3) {
            this.zzdan.zzvj();
            this.zzdbj.zzvj();
        } else if (this.zzdap == 3) {
            this.zzdan.zzvk();
            this.zzdbj.zzvk();
        }
        this.zzdap = n;
    }

    final /* synthetic */ void zzao(int n) {
        if (this.zzdbb != null) {
            this.zzdbb.onWindowVisibilityChanged(n);
        }
    }

    static /* synthetic */ zzaqo zza(zzaqe zzaqe2) {
        return zzaqe2.zzdbb;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzdam.put(-1004, "MEDIA_ERROR_IO");
            zzdam.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzdam.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzdam.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzdam.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzdam.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzdam.put(1, "MEDIA_ERROR_UNKNOWN");
        zzdam.put(1, "MEDIA_INFO_UNKNOWN");
        zzdam.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzdam.put(701, "MEDIA_INFO_BUFFERING_START");
        zzdam.put(702, "MEDIA_INFO_BUFFERING_END");
        zzdam.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzdam.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzdam.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzdam.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzdam.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

