/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzarb;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzaer
@TargetApi(value=14)
public final class zzare
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzard {
    private static final float[] zzdct = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzarb zzdcu;
    private final float[] zzdcq;
    private final float[] zzdcv;
    private final float[] zzdcw;
    private final float[] zzdcx;
    private final float[] zzdcy;
    private final float[] zzdcz;
    private final float[] zzdda;
    private float zzddb;
    private float zzddc;
    private float zzddd;
    private int zzvc;
    private int zzvb;
    private SurfaceTexture zzdde;
    private SurfaceTexture zzddf;
    private int zzddg;
    private int zzddh;
    private int zzddi;
    private FloatBuffer zzddj = ByteBuffer.allocateDirect(zzdct.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzddk;
    private final Object zzddl;
    private EGL10 zzddm;
    private EGLDisplay zzddn;
    private EGLContext zzddo;
    private EGLSurface zzddp;
    private volatile boolean zzddq;
    private volatile boolean zzddr;

    public zzare(Context context) {
        super("SphericalVideoProcessor");
        this.zzddj.put(zzdct).position(0);
        this.zzdcq = new float[9];
        this.zzdcv = new float[9];
        this.zzdcw = new float[9];
        this.zzdcx = new float[9];
        this.zzdcy = new float[9];
        this.zzdcz = new float[9];
        this.zzdda = new float[9];
        this.zzddb = Float.NaN;
        this.zzdcu = new zzarb(context);
        this.zzdcu.zza(this);
        this.zzddk = new CountDownLatch(1);
        this.zzddl = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzvb = n;
        this.zzvc = n2;
        this.zzddf = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(int n, int n2) {
        Object object = this.zzddl;
        synchronized (object) {
            this.zzvb = n;
            this.zzvc = n2;
            this.zzddq = true;
            this.zzddl.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzuw() {
        Object object = this.zzddl;
        synchronized (object) {
            this.zzddr = true;
            this.zzddf = null;
            this.zzddl.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzux() {
        if (this.zzddf == null) {
            return null;
        }
        try {
            this.zzddk.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzdde;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzddi;
        Object object = this.zzddl;
        synchronized (object) {
            this.zzddl.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzoy() {
        Object object = this.zzddl;
        synchronized (object) {
            this.zzddl.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zznl zznl2;
        Object object;
        Object[] objectArray;
        Object object2;
        boolean bl2;
        if (this.zzddf == null) {
            zzalg.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzddk.countDown();
            return;
        }
        zzare zzare2 = this;
        this.zzddm = (EGL10)EGLContext.getEGL();
        zzare2.zzddn = zzare2.zzddm.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzare2.zzddn == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzare2.zzddm.eglInitialize(zzare2.zzddn, nArray)) {
                bl2 = false;
            } else {
                object2 = zzare2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                objectArray = new int[1];
                object = ((zzare)object2).zzddm.eglChooseConfig(((zzare)object2).zzddn, nArray2, eGLConfigArray, 1, objectArray) && objectArray[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray3 = new int[]{12440, 2, 12344};
                    zzare2.zzddo = zzare2.zzddm.eglCreateContext(zzare2.zzddn, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray3);
                    if (zzare2.zzddo == null || zzare2.zzddo == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzare2.zzddp = zzare2.zzddm.eglCreateWindowSurface(zzare2.zzddn, (EGLConfig)object, (Object)zzare2.zzddf, null);
                        bl2 = zzare2.zzddp == null || zzare2.zzddp == EGL10.EGL_NO_SURFACE ? false : zzare2.zzddm.eglMakeCurrent(zzare2.zzddn, zzare2.zzddp, zzare2.zzddp, zzare2.zzddo);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzare2 = this;
        zznl zznl3 = zznl2 = zznw.zzbcu;
        if (!((String)zzkd.zzjd().zzd(zznl3)).equals(zznl2.zzjy())) {
            zznl3 = zznl2;
            string2 = (String)zzkd.zzjd().zzd(zznl3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzare.zzd(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zznl3 = zznl2 = zznw.zzbcv;
            if (!((String)zzkd.zzjd().zzd(zznl3)).equals(zznl2.zzjy())) {
                zznl3 = zznl2;
                string3 = (String)zzkd.zzjd().zzd(zznl3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzare.zzd(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzare.zzdt("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzare.zzdt("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzare.zzdt("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzare.zzdt("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzare.zzdt("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzare.zzdt("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzare.zzdt("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzddg = n;
        GLES20.glUseProgram((int)zzare2.zzddg);
        zzare.zzdt("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzare2.zzddg, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzare2.zzddj);
        zzare.zzdt("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzare.zzdt("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzare.zzdt("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzare.zzdt("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzare.zzdt("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzare.zzdt("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzare.zzdt("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzare.zzdt("texParameteri");
        zzare2.zzddh = GLES20.glGetUniformLocation((int)zzare2.zzddg, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzare2.zzddh, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzddg != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzddm.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzalg.e((String)string6);
            zzbv.zzeo().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zzuy();
            this.zzddk.countDown();
            return;
        }
        this.zzdde = new SurfaceTexture(n7);
        this.zzdde.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzddk.countDown();
        this.zzdcu.start();
        try {
            this.zzddq = true;
            while (!this.zzddr) {
                zzare2 = this;
                while (zzare2.zzddi > 0) {
                    zzare2.zzdde.updateTexImage();
                    --zzare2.zzddi;
                }
                if (zzare2.zzdcu.zza(zzare2.zzdcq)) {
                    if (Float.isNaN(zzare2.zzddb)) {
                        float[] fArray = zzare2.zzdcq;
                        objectArray = new float[]{0.0f, 1.0f, 0.0f};
                        object2 = zzare2.zzdcq;
                        float[] fArray2 = new float[]{(float)(object2[0] * objectArray[0] + object2[1] * objectArray[1] + object2[2] * objectArray[2]), (float)(object2[3] * objectArray[0] + object2[4] * objectArray[1] + object2[5] * objectArray[2]), (float)(object2[6] * objectArray[0] + object2[7] * objectArray[1] + object2[8] * objectArray[2])};
                        zzare2.zzddb = -((float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f);
                    }
                    zzare.zzb(zzare2.zzdcz, zzare2.zzddb + zzare2.zzddc);
                } else {
                    zzare.zza(zzare2.zzdcq, -1.5707964f);
                    zzare.zzb(zzare2.zzdcz, zzare2.zzddc);
                }
                zzare.zza(zzare2.zzdcv, 1.5707964f);
                zzare.zza(zzare2.zzdcw, zzare2.zzdcz, zzare2.zzdcv);
                zzare.zza(zzare2.zzdcx, zzare2.zzdcq, zzare2.zzdcw);
                zzare.zza(zzare2.zzdcy, zzare2.zzddd);
                zzare.zza(zzare2.zzdda, zzare2.zzdcy, zzare2.zzdcx);
                GLES20.glUniformMatrix3fv((int)zzare2.zzddh, (int)1, (boolean)false, (float[])zzare2.zzdda, (int)0);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                zzare.zzdt("drawArrays");
                GLES20.glFinish();
                zzare2.zzddm.eglSwapBuffers(zzare2.zzddn, zzare2.zzddp);
                if (this.zzddq) {
                    zzare2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzare2.zzvb, (int)zzare2.zzvc);
                    zzare.zzdt("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzare2.zzddg, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzare2.zzddg, (String)"uFOVy");
                    if (zzare2.zzvb > zzare2.zzvc) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzare2.zzvc / (float)zzare2.zzvb));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzare2.zzvb / (float)zzare2.zzvc));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzddq = false;
                }
                try {
                    Object object3 = this.zzddl;
                    synchronized (object3) {
                        if (!this.zzddr && !this.zzddq && this.zzddi == 0) {
                            this.zzddl.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzalg.zzdp((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzalg.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbv.zzeo().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzdcu.stop();
            this.zzdde.setOnFrameAvailableListener(null);
            this.zzdde = null;
            this.zzuy();
        }
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzvb > this.zzvc) {
            f4 = 1.7453293f * f / (float)this.zzvb;
            f3 = 1.7453293f * f2 / (float)this.zzvb;
        } else {
            f4 = 1.7453293f * f / (float)this.zzvc;
            f3 = 1.7453293f * f2 / (float)this.zzvc;
        }
        this.zzddc -= f4;
        this.zzddd -= f3;
        if (this.zzddd < -1.5707964f) {
            this.zzddd = -1.5707964f;
        }
        if (this.zzddd > 1.5707964f) {
            this.zzddd = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzd(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzare.zzdt("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzare.zzdt("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzare.zzdt("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzare.zzdt("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzare.zzdt("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    @VisibleForTesting
    private final boolean zzuy() {
        boolean bl = false;
        if (this.zzddp != null && this.zzddp != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzddm.eglMakeCurrent(this.zzddn, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzddm.eglDestroySurface(this.zzddn, this.zzddp);
            this.zzddp = null;
        }
        if (this.zzddo != null) {
            bl |= this.zzddm.eglDestroyContext(this.zzddn, this.zzddo);
            this.zzddo = null;
        }
        if (this.zzddn != null) {
            bl |= this.zzddm.eglTerminate(this.zzddn);
            this.zzddn = null;
        }
        return bl;
    }

    private static void zzdt(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

