/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzanp;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzaoe;
import com.google.android.gms.internal.ads.zzarg;
import com.google.android.gms.internal.ads.zzarr;
import com.google.android.gms.internal.ads.zzars;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzaer
public final class zzarx
extends zzarr {
    private static final Set<String> zzdfg = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzdfh = new DecimalFormat("#,###");
    private File zzdfi;
    private boolean zzdfj;

    public zzarx(zzarg zzarg2) {
        super(zzarg2);
        File file = this.mContext.getCacheDir();
        if (file == null) {
            zzalg.zzdp((String)"Context.getCacheDir() returned null");
            return;
        }
        this.zzdfi = new File(file, "admobVideoStreams");
        if (!this.zzdfi.isDirectory() && !this.zzdfi.mkdirs()) {
            String string2 = String.valueOf(this.zzdfi.getAbsolutePath());
            zzalg.zzdp((String)(string2.length() != 0 ? "Could not create preload cache directory at ".concat(string2) : new String("Could not create preload cache directory at ")));
            this.zzdfi = null;
            return;
        }
        if (!this.zzdfi.setReadable(true, false) || !this.zzdfi.setExecutable(true, false)) {
            String string3 = String.valueOf(this.zzdfi.getAbsolutePath());
            zzalg.zzdp((String)(string3.length() != 0 ? "Could not set cache file permissions at ".concat(string3) : new String("Could not set cache file permissions at ")));
            this.zzdfi = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzdu(String string2) {
        int n;
        Object object;
        int n2;
        Object object2;
        block41: {
            int n3;
            if (this.zzdfi == null) {
                this.zza(string2, null, "noCacheDir", null);
                return false;
            }
            do {
                int n4;
                object2 = this;
                if (((zzarx)object2).zzdfi == null) {
                    n4 = 0;
                } else {
                    n2 = 0;
                    object = ((zzarx)object2).zzdfi.listFiles();
                    int n5 = ((File[])object).length;
                    for (n = 0; n < n5; ++n) {
                        if (object[n].getName().endsWith(".done")) continue;
                        ++n2;
                    }
                    n4 = n2;
                }
                object2 = zznw.zzayx;
                if (n4 <= (Integer)zzkd.zzjd().zzd((zznl)object2)) break block41;
                object2 = this;
                if (((zzarx)object2).zzdfi == null) {
                    n3 = 0;
                    continue;
                }
                File file = null;
                long l = Long.MAX_VALUE;
                for (File file2 : ((zzarx)object2).zzdfi.listFiles()) {
                    long l2;
                    if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
                    file = file2;
                    l = l2;
                }
                n = 0;
                if (file != null) {
                    n = file.delete() ? 1 : 0;
                    File file3 = super.zzc(file);
                    if (file3.isFile()) {
                        n &= file3.delete();
                    }
                }
                n3 = n;
            } while (n3 != 0);
            zzalg.zzdp((String)"Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        object2 = string2;
        zzkd.zziz();
        String string3 = zzaoa.zzdj((String)object2);
        File file = new File(this.zzdfi, string3);
        File file4 = this.zzc(file);
        if (file.isFile() && file4.isFile()) {
            int n6 = (int)file.length();
            String string4 = String.valueOf(string2);
            zzalg.zzco((String)(string4.length() != 0 ? "Stream cache hit at ".concat(string4) : new String("Stream cache hit at ")));
            this.zza(string2, file.getAbsolutePath(), n6);
            return true;
        }
        String string5 = String.valueOf(this.zzdfi.getAbsolutePath());
        String string6 = String.valueOf(string2);
        String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        Object object3 = zzdfg;
        synchronized (object3) {
            if (zzdfg.contains(string7)) {
                String string8 = String.valueOf(string2);
                zzalg.zzdp((String)(string8.length() != 0 ? "Stream cache already in progress at ".concat(string8) : new String("Stream cache already in progress at ")));
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzdfg.add(string7);
        }
        object3 = null;
        String string9 = "error";
        String string10 = null;
        try {
            int n7;
            int n8;
            HttpURLConnection httpURLConnection;
            block42: {
                zzbv.zzex();
                object2 = zznw.zzazc;
                n2 = (Integer)zzkd.zzjd().zzd((zznl)object2);
                object2 = string2;
                URL uRL = new URL((String)object2);
                n = 0;
                while (++n <= 20) {
                    File file2;
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(n2);
                    uRLConnection.setReadTimeout(n2);
                    if (!(uRLConnection instanceof HttpURLConnection)) {
                        throw new IOException("Invalid protocol.");
                    }
                    httpURLConnection = (HttpURLConnection)uRLConnection;
                    file2 = new zzaoe();
                    file2.zza(httpURLConnection, null);
                    httpURLConnection.setInstanceFollowRedirects(false);
                    int n9 = httpURLConnection.getResponseCode();
                    file2.zza(httpURLConnection, n9);
                    if (n9 / 100 == 3) {
                        String string11 = httpURLConnection.getHeaderField("Location");
                        if (string11 == null) {
                            throw new IOException("Missing Location header in redirect");
                        }
                        String string12 = (uRL = new URL(uRL, string11)).getProtocol();
                        if (string12 == null) {
                            throw new IOException("Protocol is null");
                        }
                        if (!string12.equals("http") && !string12.equals("https")) {
                            String string13 = String.valueOf(string12);
                            throw new IOException(string13.length() != 0 ? "Unsupported scheme: ".concat(string13) : new String("Unsupported scheme: "));
                        }
                        String string14 = String.valueOf(string11);
                        zzalg.zzco((String)(string14.length() != 0 ? "Redirecting to ".concat(string14) : new String("Redirecting to ")));
                        httpURLConnection.disconnect();
                        continue;
                    }
                    break block42;
                }
                throw new IOException("Too many redirects (20)");
            }
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            if (httpURLConnection2 instanceof HttpURLConnection && (n8 = httpURLConnection2.getResponseCode()) >= 400) {
                string9 = "badUrl";
                String string15 = String.valueOf(Integer.toString(n8));
                string10 = string15.length() != 0 ? "HTTP request failed. Code: ".concat(string15) : new String("HTTP request failed. Code: ");
                throw new IOException(new StringBuilder(32 + String.valueOf(string2).length()).append("HTTP status code ").append(n8).append(" at ").append(string2).toString());
            }
            n8 = httpURLConnection2.getContentLength();
            if (n8 < 0) {
                String string16 = String.valueOf(string2);
                zzalg.zzdp((String)(string16.length() != 0 ? "Stream cache aborted, missing content-length header at ".concat(string16) : new String("Stream cache aborted, missing content-length header at ")));
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzdfg.remove(string7);
                return false;
            }
            String string17 = zzdfh.format(n8);
            object2 = zznw.zzayy;
            int n10 = (Integer)zzkd.zzjd().zzd((zznl)object2);
            if (n8 > n10) {
                zzalg.zzdp((String)new StringBuilder(33 + String.valueOf(string17).length() + String.valueOf(string2).length()).append("Content length ").append(string17).append(" exceeds limit at ").append(string2).toString());
                String string18 = String.valueOf(string17);
                String string19 = string18.length() != 0 ? "File too big for full file cache. Size: ".concat(string18) : new String("File too big for full file cache. Size: ");
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string19);
                zzdfg.remove(string7);
                return false;
            }
            zzalg.zzco((String)new StringBuilder(20 + String.valueOf(string17).length() + String.valueOf(string2).length()).append("Caching ").append(string17).append(" bytes from ").append(string2).toString());
            ReadableByteChannel readableByteChannel = Channels.newChannel(httpURLConnection2.getInputStream());
            object3 = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object3).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            Clock clock = zzbv.zzer();
            int n11 = 0;
            long l = clock.currentTimeMillis();
            object2 = zznw.zzazb;
            long l3 = (Long)zzkd.zzjd().zzd((zznl)object2);
            zzanp zzanp2 = new zzanp(l3);
            object2 = zznw.zzaza;
            long l4 = (Long)zzkd.zzjd().zzd((zznl)object2);
            while ((n7 = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n11 += n7) > n10) {
                    string9 = "sizeExceeded";
                    String string20 = String.valueOf(Integer.toString(n11));
                    string10 = string20.length() != 0 ? "File too big for full file cache. Size: ".concat(string20) : new String("File too big for full file cache. Size: ");
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                if (clock.currentTimeMillis() - l > l4 * 1000L) {
                    string9 = "downloadTimeout";
                    String string21 = Long.toString(l4);
                    string10 = new StringBuilder(29 + String.valueOf(string21).length()).append("Timeout exceeded. Limit: ").append(string21).append(" sec").toString();
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzdfj) {
                    string9 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzanp2.tryAcquire()) continue;
                n = n8;
                int n12 = n11;
                object = file.getAbsolutePath();
                String string22 = string2;
                object2 = this;
                zzaoa.zztc.post((Runnable)new zzars((zzarr)object2, string22, (String)object, n12, n, false));
            }
            ((FileOutputStream)object3).close();
            if (zzalg.isLoggable((int)3)) {
                String string23 = zzdfh.format(n11);
                zzalg.zzco((String)new StringBuilder(22 + String.valueOf(string23).length() + String.valueOf(string2).length()).append("Preloaded ").append(string23).append(" bytes from ").append(string2).toString());
            }
            file.setReadable(true, false);
            object2 = file4;
            if (((File)object2).isFile()) {
                ((File)object2).setLastModified(System.currentTimeMillis());
            } else {
                try {
                    ((File)object2).createNewFile();
                }
                catch (IOException iOException) {}
            }
            this.zza(string2, file.getAbsolutePath(), n11);
            zzdfg.remove(string7);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            Exception exception2 = exception;
            if (exception instanceof RuntimeException) {
                zzbv.zzeo().zza(exception2, "VideoStreamFullFileCache.preload");
            }
            try {
                ((FileOutputStream)object3).close();
            }
            catch (IOException | NullPointerException exception3) {}
            if (this.zzdfj) {
                zzalg.zzdo((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Preload aborted for URL \"").append(string2).append("\"").toString());
            } else {
                zzalg.zzc((String)new StringBuilder(25 + String.valueOf(string2).length()).append("Preload failed for URL \"").append(string2).append("\"").toString(), (Throwable)exception2);
            }
            if (file.exists() && !file.delete()) {
                String string24 = String.valueOf(file.getAbsolutePath());
                zzalg.zzdp((String)(string24.length() != 0 ? "Could not delete partial cache file at ".concat(string24) : new String("Could not delete partial cache file at ")));
            }
            this.zza(string2, file.getAbsolutePath(), string9, string10);
            zzdfg.remove(string7);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzdfj = true;
    }

    private final File zzc(File file) {
        return new File(this.zzdfi, String.valueOf(file.getName()).concat(".done"));
    }
}

