/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.gmsg.zza;
import com.google.android.gms.ads.internal.gmsg.zzaa;
import com.google.android.gms.ads.internal.gmsg.zzab;
import com.google.android.gms.ads.internal.gmsg.zzac;
import com.google.android.gms.ads.internal.gmsg.zzb;
import com.google.android.gms.ads.internal.gmsg.zzc;
import com.google.android.gms.ads.internal.gmsg.zzd;
import com.google.android.gms.ads.internal.gmsg.zzf;
import com.google.android.gms.ads.internal.gmsg.zzu;
import com.google.android.gms.ads.internal.gmsg.zzx;
import com.google.android.gms.ads.internal.gmsg.zzy;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzt;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzabh;
import com.google.android.gms.internal.ads.zzabq;
import com.google.android.gms.internal.ads.zzabs;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzajy;
import com.google.android.gms.internal.ads.zzakg;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzaoe;
import com.google.android.gms.internal.ads.zzapn;
import com.google.android.gms.internal.ads.zzarv;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzasi;
import com.google.android.gms.internal.ads.zzasj;
import com.google.android.gms.internal.ads.zzask;
import com.google.android.gms.internal.ads.zzasl;
import com.google.android.gms.internal.ads.zzatn;
import com.google.android.gms.internal.ads.zzato;
import com.google.android.gms.internal.ads.zzatp;
import com.google.android.gms.internal.ads.zzatq;
import com.google.android.gms.internal.ads.zzatr;
import com.google.android.gms.internal.ads.zzck;
import com.google.android.gms.internal.ads.zzcl;
import com.google.android.gms.internal.ads.zzhl;
import com.google.android.gms.internal.ads.zzho;
import com.google.android.gms.internal.ads.zzhv;
import com.google.android.gms.internal.ads.zzhx;
import com.google.android.gms.internal.ads.zzjc;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznh;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzaer
@ParametersAreNonnullByDefault
@VisibleForTesting
public class zzash
extends WebViewClient
implements zzatn {
    private static final String[] zzdfo = new String[]{"UNKNOWN", "HOST_LOOKUP", "UNSUPPORTED_AUTH_SCHEME", "AUTHENTICATION", "PROXY_AUTHENTICATION", "CONNECT", "IO", "TIMEOUT", "REDIRECT_LOOP", "UNSUPPORTED_SCHEME", "FAILED_SSL_HANDSHAKE", "BAD_URL", "FILE", "FILE_NOT_FOUND", "TOO_MANY_REQUESTS"};
    private static final String[] zzdfp = new String[]{"NOT_YET_VALID", "EXPIRED", "ID_MISMATCH", "UNTRUSTED", "DATE_INVALID", "INVALID"};
    private zzasg zzbss;
    @Nullable
    private final zzhv zzcsc;
    private final HashMap<String, List<zzu<? super zzasg>>> zzdfq = new HashMap();
    private final Object mLock = new Object();
    private zzjc zzatc;
    private zzn zzdfr;
    private zzato zzdfs;
    private zzatp zzdft;
    private zzb zzbov;
    private zzd zzbow;
    private zzatq zzdfu;
    private boolean zzdfv = false;
    @GuardedBy(value="mLock")
    private boolean zzafc;
    @GuardedBy(value="mLock")
    private boolean zzdfw;
    @GuardedBy(value="mLock")
    private ViewTreeObserver.OnGlobalLayoutListener zzdfx;
    @GuardedBy(value="mLock")
    private ViewTreeObserver.OnScrollChangedListener zzdfy;
    @GuardedBy(value="mLock")
    private boolean zzdfz;
    private zzt zzdga;
    private final zzabq zzdgb;
    private zzw zzbqf;
    private zzabh zzbqg;
    private zzatr zzdgc;
    @Nullable
    protected zzajy zzxo;
    private boolean zzdgd;
    private boolean zzdge;
    private int zzdgf;
    private boolean zzcjl;
    private View.OnAttachStateChangeListener zzdgg;

    public zzash(zzasg zzasg2, zzhv zzhv2, boolean bl) {
        this(zzasg2, zzhv2, bl, new zzabq(zzasg2, zzasg2.zzvq(), new zznh(zzasg2.getContext())), null);
    }

    @VisibleForTesting
    private zzash(zzasg zzasg2, zzhv zzhv2, boolean bl, zzabq zzabq2, zzabh zzabh2) {
        this.zzcsc = zzhv2;
        this.zzbss = zzasg2;
        this.zzafc = bl;
        this.zzdgb = zzabq2;
        this.zzbqg = null;
    }

    @Override
    public final void zza(int n, int n2, boolean bl) {
        this.zzdgb.zzc(n, n2);
        if (this.zzbqg != null) {
            this.zzbqg.zza(n, n2, bl);
        }
    }

    @Override
    public final void zza(zzjc zzjc2, zzb zzb2, zzn zzn2, zzd zzd2, zzt zzt2, boolean bl, @Nullable zzy zzy2, zzw zzw2, zzabs zzabs2, @Nullable zzajy zzajy2) {
        boolean bl2;
        if (zzw2 == null) {
            zzw2 = new zzw(this.zzbss.getContext(), zzajy2, null);
        }
        this.zzbqg = new zzabh(this.zzbss, zzabs2);
        this.zzxo = zzajy2;
        zznl zznl2 = zznw.zzbbo;
        if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            this.zza("/adMetadata", new zza(zzb2));
        }
        this.zza("/appEvent", new zzc(zzd2));
        this.zza("/backButton", zzf.zzbpg);
        this.zza("/refresh", zzf.zzbph);
        this.zza("/canOpenURLs", zzf.zzbox);
        this.zza("/canOpenIntents", zzf.zzboy);
        this.zza("/click", zzf.zzboz);
        this.zza("/close", zzf.zzbpa);
        this.zza("/customClose", zzf.zzbpb);
        this.zza("/instrument", zzf.zzbpk);
        this.zza("/delayPageLoaded", zzf.zzbpm);
        this.zza("/delayPageClosed", zzf.zzbpn);
        this.zza("/getLocationInfo", zzf.zzbpo);
        this.zza("/httpTrack", zzf.zzbpc);
        this.zza("/log", zzf.zzbpd);
        this.zza("/mraid", new zzab(zzw2, this.zzbqg, zzabs2));
        this.zza("/mraidLoaded", this.zzdgb);
        this.zza("/open", new zzac(zzw2, this.zzbqg));
        this.zza("/precache", new zzarv());
        this.zza("/touch", zzf.zzbpf);
        this.zza("/video", zzf.zzbpi);
        this.zza("/videoMeta", zzf.zzbpj);
        if (zzbv.zzfj().zzu(this.zzbss.getContext())) {
            this.zza("/logScionEvent", new zzaa(this.zzbss.getContext()));
        }
        if (zzy2 != null) {
            this.zza("/setInterstitialProperties", new zzx(zzy2));
        }
        this.zzatc = zzjc2;
        this.zzdfr = zzn2;
        this.zzbov = zzb2;
        this.zzbow = zzd2;
        this.zzdga = zzt2;
        this.zzbqf = zzw2;
        this.zzdfv = bl2 = bl;
    }

    @Override
    public final zzw zzwk() {
        return this.zzbqf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzfy() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzafc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzwl() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdfw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnGlobalLayoutListener zzwm() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdfx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnScrollChangedListener zzwn() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdfy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzwo() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdfz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPageFinished(WebView webView, String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbss.isDestroyed()) {
                zzalg.v("Blank page loaded, 1...");
                this.zzbss.zzwb();
                return;
            }
        }
        this.zzdgd = true;
        zzash zzash2 = this;
        if (zzash2.zzdft != null) {
            zzash2.zzdft.zzng();
            zzash2.zzdft = null;
        }
        this.zzwu();
    }

    private final void zza(View view, zzajy zzajy2, int n) {
        if (zzajy2.zzqu() && n > 0) {
            zzajy2.zzs(view);
            if (zzajy2.zzqu()) {
                zzalo.zzcvi.postDelayed((Runnable)new zzasj(this, view, zzajy2, n), 100L);
            }
        }
    }

    private final void zzwp() {
        if (this.zzdgg == null) {
            return;
        }
        this.zzbss.getView().removeOnAttachStateChangeListener(this.zzdgg);
    }

    @Override
    public final void zzwq() {
        zzajy zzajy2 = this.zzxo;
        if (zzajy2 != null) {
            WebView webView = this.zzbss.getWebView();
            if (ViewCompat.isAttachedToWindow((View)webView)) {
                this.zza((View)webView, zzajy2, 10);
                return;
            }
            zzajy zzajy3 = zzajy2;
            zzash zzash2 = this;
            zzash2.zzwp();
            zzash2.zzdgg = new zzask(zzash2, zzajy3);
            zzash2.zzbss.getView().addOnAttachStateChangeListener(zzash2.zzdgg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzwr() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdfz = true;
        }
        ++this.zzdgf;
        this.zzwu();
    }

    @Override
    public final void zzws() {
        --this.zzdgf;
        this.zzwu();
    }

    @Override
    public final void zzwt() {
        this.zzdge = true;
        this.zzwu();
    }

    private final void zzwu() {
        if (this.zzdfs != null && (this.zzdgd && this.zzdgf <= 0 || this.zzdge)) {
            this.zzdfs.zze(!this.zzdge);
            this.zzdfs = null;
        }
        this.zzbss.zzwg();
    }

    public final void zza(com.google.android.gms.ads.internal.overlay.zzc zzc2) {
        boolean bl = this.zzbss.zzwa();
        this.zza(new AdOverlayInfoParcel(zzc2, (zzjc)(bl && !this.zzbss.zzvt().zzxl() ? null : this.zzatc), bl ? null : this.zzdfr, this.zzdga, this.zzbss.zzvf()));
    }

    public final void zza(boolean bl, int n) {
        boolean bl2 = this.zzbss.zzwa();
        this.zza(new AdOverlayInfoParcel((zzjc)(bl2 && !this.zzbss.zzvt().zzxl() ? null : this.zzatc), this.zzdfr, this.zzdga, this.zzbss, bl, n, this.zzbss.zzvf()));
    }

    public final void zza(boolean bl, int n, String string2) {
        boolean bl2 = this.zzbss.zzwa();
        this.zza(new AdOverlayInfoParcel((zzjc)(bl2 && !this.zzbss.zzvt().zzxl() ? null : this.zzatc), bl2 ? null : new zzasl(this.zzbss, this.zzdfr), this.zzbov, this.zzbow, this.zzdga, this.zzbss, bl, n, string2, this.zzbss.zzvf()));
    }

    public final void zza(boolean bl, int n, String string2, String string3) {
        boolean bl2 = this.zzbss.zzwa();
        this.zza(new AdOverlayInfoParcel((zzjc)(bl2 && !this.zzbss.zzvt().zzxl() ? null : this.zzatc), bl2 ? null : new zzasl(this.zzbss, this.zzdfr), this.zzbov, this.zzbow, this.zzdga, this.zzbss, bl, n, string2, string3, this.zzbss.zzvf()));
    }

    private final void zza(AdOverlayInfoParcel adOverlayInfoParcel) {
        boolean bl = false;
        if (this.zzbqg != null) {
            bl = this.zzbqg.zzoq();
        }
        zzbv.zzei();
        zzl.zza(this.zzbss.getContext(), adOverlayInfoParcel, !bl);
        if (this.zzxo != null) {
            String string2 = adOverlayInfoParcel.url;
            if (string2 == null && adOverlayInfoParcel.zzcbw != null) {
                string2 = adOverlayInfoParcel.zzcbw.url;
            }
            this.zzxo.zzcj(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, zzu<? super zzasg> zzu2) {
        Object object = this.mLock;
        synchronized (object) {
            List<zzu<? super zzasg>> list = this.zzdfq.get(string2);
            if (list == null) {
                list = new CopyOnWriteArrayList<zzu<? super zzasg>>();
                this.zzdfq.put(string2, list);
            }
            list.add(zzu2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(String string2, zzu<? super zzasg> zzu2) {
        Object object = this.mLock;
        synchronized (object) {
            List<zzu<? super zzasg>> list = this.zzdfq.get(string2);
            if (list == null) {
                return;
            }
            list.remove(zzu2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, Predicate<zzu<? super zzasg>> predicate) {
        Object object = this.mLock;
        synchronized (object) {
            List<zzu<? super zzasg>> list = this.zzdfq.get(string2);
            if (list == null) {
                return;
            }
            ArrayList<zzu<? super zzasg>> arrayList = new ArrayList<zzu<? super zzasg>>();
            for (zzu<? super zzasg> zzu2 : list) {
                if (!predicate.apply(zzu2)) continue;
                arrayList.add(zzu2);
            }
            list.removeAll(arrayList);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        if (this.zzxo != null) {
            this.zzxo.zzqw();
            this.zzxo = null;
        }
        this.zzwp();
        Object object = this.mLock;
        synchronized (object) {
            this.zzdfq.clear();
            this.zzatc = null;
            this.zzdfr = null;
            this.zzdfs = null;
            this.zzdft = null;
            this.zzbov = null;
            this.zzbow = null;
            this.zzdfv = false;
            this.zzafc = false;
            this.zzdfw = false;
            this.zzdfz = false;
            this.zzdga = null;
            this.zzdfu = null;
            if (this.zzbqg != null) {
                this.zzbqg.zzm(true);
                this.zzbqg = null;
            }
            return;
        }
    }

    @Override
    public final void zza(zzato zzato2) {
        this.zzdfs = zzato2;
    }

    @Override
    public final void zza(zzatp zzatp2) {
        this.zzdft = zzatp2;
    }

    @Override
    public final void zza(zzatq zzatq2) {
        this.zzdfu = zzatq2;
    }

    @Override
    public final void zza(zzatr zzatr2) {
        this.zzdgc = zzatr2;
    }

    public final zzatr zzwv() {
        return this.zzdgc;
    }

    public final void onLoadResource(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzalg.v(string3.length() != 0 ? "Loading resource: ".concat(string3) : new String("Loading resource: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzi(uri);
        }
    }

    public final void onReceivedError(WebView webView, int n, String string2, String string3) {
        String string4 = n < 0 && -n - 1 < zzdfo.length ? zzdfo[-n - 1] : String.valueOf(n);
        this.zzd(this.zzbss.getContext(), "http_err", string4, string3);
        super.onReceivedError(webView, n, string2, string3);
    }

    public final void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
        if (sslError != null) {
            int n = sslError.getPrimaryError();
            String string2 = n >= 0 && n < zzdfp.length ? zzdfp[n] : String.valueOf(n);
            this.zzd(this.zzbss.getContext(), "ssl_err", string2, zzbv.zzem().zza(sslError));
        }
        super.onReceivedSslError(webView, sslErrorHandler, sslError);
    }

    private final void zzd(Context context, String string2, String string3, String string4) {
        Uri uri;
        Object object = zznw.zzbdb;
        if (!((Boolean)zzkd.zzjd().zzd(object)).booleanValue()) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("err", string2);
        bundle.putString("code", string3);
        object = string4;
        bundle.putString("host", !TextUtils.isEmpty((CharSequence)object) && (uri = Uri.parse((String)object)).getHost() != null ? uri.getHost() : "");
        zzbv.zzek().zza(context, this.zzbss.zzvf().zzcx, "gmob-apps", bundle, true);
    }

    public final boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzalg.v(string3.length() != 0 ? "AdWebView shouldOverrideUrlLoading: ".concat(string3) : new String("AdWebView shouldOverrideUrlLoading: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzi(uri);
        } else {
            String string4;
            if (this.zzdfv && webView == this.zzbss.getWebView() && ("http".equalsIgnoreCase(string4 = uri.getScheme()) || "https".equalsIgnoreCase(string4))) {
                if (this.zzatc != null) {
                    this.zzatc.onAdClicked();
                    if (this.zzxo != null) {
                        this.zzxo.zzcj(string2);
                    }
                    this.zzatc = null;
                }
                return super.shouldOverrideUrlLoading(webView, string2);
            }
            if (!this.zzbss.getWebView().willNotDraw()) {
                try {
                    zzck zzck2 = this.zzbss.zzvy();
                    if (zzck2 != null && zzck2.zzb(uri)) {
                        uri = zzck2.zza(uri, this.zzbss.getContext(), this.zzbss.getView(), this.zzbss.zzvc());
                    }
                }
                catch (zzcl zzcl2) {
                    String string5 = String.valueOf(string2);
                    zzalg.zzdp((String)(string5.length() != 0 ? "Unable to append parameter to URL: ".concat(string5) : new String("Unable to append parameter to URL: ")));
                }
                if (this.zzbqf == null || this.zzbqf.zzcz()) {
                    this.zza(new com.google.android.gms.ads.internal.overlay.zzc("android.intent.action.VIEW", uri.toString(), null, null, null, null, null));
                } else {
                    this.zzbqf.zzu(string2);
                }
            } else {
                String string6 = String.valueOf(string2);
                zzalg.zzdp((String)(string6.length() != 0 ? "AdWebView unable to handle URL: ".concat(string6) : new String("AdWebView unable to handle URL: ")));
            }
        }
        return true;
    }

    @TargetApi(value=11)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
        return this.zzd(string2, Collections.emptyMap());
    }

    @Nullable
    protected final WebResourceResponse zzd(String string2, Map<String, String> map) {
        try {
            zzhl zzhl2;
            String string3 = zzakg.zzb(string2, this.zzbss.getContext(), this.zzcjl);
            if (!string3.equals(string2)) {
                return this.zze(string3, map);
            }
            zzho zzho2 = zzho.zzad(string2);
            if (zzho2 != null && (zzhl2 = zzbv.zzeq().zza(zzho2)) != null && zzhl2.zzhi()) {
                return new WebResourceResponse("", "", zzhl2.zzhj());
            }
            if (zzaoe.isEnabled()) {
                zznl zznl2 = zznw.zzbcs;
                if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
                    return this.zze(string2, map);
                }
            }
            return null;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            zzbv.zzeo().zza(throwable, "AdWebViewClient.interceptRequest");
            return null;
        }
    }

    private final WebResourceResponse zze(String string2, Map<String, String> map) throws IOException {
        URL uRL = new URL(string2);
        int n = 0;
        while (++n <= 20) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(10000);
            uRLConnection.setReadTimeout(10000);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            if (!(uRLConnection instanceof HttpURLConnection)) {
                throw new IOException("Invalid protocol.");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            zzbv.zzek().zza(this.zzbss.getContext(), this.zzbss.zzvf().zzcx, false, httpURLConnection);
            zzaoe zzaoe22 = new zzaoe();
            zzaoe22.zza(httpURLConnection, null);
            int n2 = httpURLConnection.getResponseCode();
            zzaoe22.zza(httpURLConnection, n2);
            if (n2 >= 300 && n2 < 400) {
                String string3 = httpURLConnection.getHeaderField("Location");
                if (string3 == null) {
                    throw new IOException("Missing Location header in redirect");
                }
                String string4 = (uRL = new URL(uRL, string3)).getProtocol();
                if (string4 == null) {
                    zzalg.zzdp((String)"Protocol is null");
                    return null;
                }
                if (!string4.equals("http") && !string4.equals("https")) {
                    String string5 = String.valueOf(string4);
                    zzalg.zzdp((String)(string5.length() != 0 ? "Unsupported scheme: ".concat(string5) : new String("Unsupported scheme: ")));
                    return null;
                }
                String string6 = String.valueOf(string3);
                zzalg.zzco((String)(string6.length() != 0 ? "Redirecting to ".concat(string6) : new String("Redirecting to ")));
                httpURLConnection.disconnect();
                continue;
            }
            zzbv.zzek();
            return zzalo.zzc(httpURLConnection);
        }
        throw new IOException(new StringBuilder(32).append("Too many redirects (20)").toString());
    }

    public final void zzai(boolean bl) {
        this.zzdfv = bl;
    }

    @Override
    public final zzajy zzww() {
        return this.zzxo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdfw = true;
            this.zzbss.zzwf();
            this.zzdfx = onGlobalLayoutListener;
            this.zzdfy = onScrollChangedListener;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzov() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdfv = false;
            this.zzafc = true;
            zzapn.zzczw.execute(new zzasi(this));
            return;
        }
    }

    public final void zzam(boolean bl) {
        this.zzcjl = bl;
    }

    @Override
    public final void zzb(int n, int n2) {
        if (this.zzbqg != null) {
            this.zzbqg.zzb(n, n2);
        }
    }

    public boolean shouldOverrideKeyEvent(WebView webView, KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 222: {
                return true;
            }
        }
        return false;
    }

    private final void zzi(Uri uri) {
        String string2 = uri.getPath();
        List<zzu<? super zzasg>> list = this.zzdfq.get(string2);
        if (list != null) {
            zzbv.zzek();
            Map<String, String> map = zzalo.zzg(uri);
            if (zzalg.isLoggable((int)2)) {
                String string3 = String.valueOf(string2);
                zzalg.v(string3.length() != 0 ? "Received GMSG: ".concat(string3) : new String("Received GMSG: "));
                for (String string4 : map.keySet()) {
                    String string5 = map.get(string4);
                    zzalg.v(new StringBuilder(4 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("  ").append(string4).append(": ").append(string5).toString());
                }
            }
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza(this.zzbss, map);
            }
            return;
        }
        String string6 = String.valueOf(uri);
        zzalg.v(new StringBuilder(32 + String.valueOf(string6).length()).append("No GMSG handler found for GMSG: ").append(string6).toString());
    }

    public boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        if (this.zzcsc != null) {
            this.zzcsc.zza(zzhx.zza.zzb.zzamc);
        }
        if (webView.getParent() instanceof ViewGroup) {
            ((ViewGroup)webView.getParent()).removeView((View)webView);
        }
        webView.destroy();
        return true;
    }

    final /* synthetic */ void zzwx() {
        this.zzbss.zzwf();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzbss.zzvr();
        if (zzd2 != null) {
            zzd2.zzov();
        }
        if (this.zzdfu != null) {
            this.zzdfu.zzdc();
            this.zzdfu = null;
        }
    }

    static /* synthetic */ void zza(zzash zzash2, View view, zzajy zzajy2, int n) {
        zzash2.zza(view, zzajy2, n);
    }
}

