/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.gmsg.zzu;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzbo;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.ads.zzabr;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzamh;
import com.google.android.gms.internal.ads.zzanz;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzaqa;
import com.google.android.gms.internal.ads.zzaqx;
import com.google.android.gms.internal.ads.zzarq;
import com.google.android.gms.internal.ads.zzarr;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzasw;
import com.google.android.gms.internal.ads.zzasz;
import com.google.android.gms.internal.ads.zzati;
import com.google.android.gms.internal.ads.zzatn;
import com.google.android.gms.internal.ads.zzats;
import com.google.android.gms.internal.ads.zzatt;
import com.google.android.gms.internal.ads.zzatu;
import com.google.android.gms.internal.ads.zzauc;
import com.google.android.gms.internal.ads.zzaud;
import com.google.android.gms.internal.ads.zzaug;
import com.google.android.gms.internal.ads.zzck;
import com.google.android.gms.internal.ads.zzfv;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zzoc;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzoi;
import com.google.android.gms.internal.ads.zzoj;
import com.google.android.gms.internal.ads.zzpk;
import com.google.android.gms.internal.ads.zzvl;
import com.google.android.gms.internal.ads.zzvm;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONObject;

@zzaer
@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzaub
extends zzaug
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzasg,
zzvl {
    private final zzats zzdiv;
    private final zzatu zzdiw;
    @Nullable
    private final zzck zzbmj;
    private final zzaop zzys;
    private final zzbo zzdhb;
    private final zzv zzwp;
    @GuardedBy(value="this")
    private zzd zzdhg;
    @GuardedBy(value="this")
    private zzatt zzdhi;
    @GuardedBy(value="this")
    private String zzvd;
    @GuardedBy(value="this")
    private boolean zzdhj;
    @GuardedBy(value="this")
    private boolean zzdhk;
    @GuardedBy(value="this")
    private boolean zzdhl;
    @GuardedBy(value="this")
    private int zzdhm;
    @GuardedBy(value="this")
    private boolean zzdhn = true;
    @GuardedBy(value="this")
    private boolean zzdho = false;
    @GuardedBy(value="this")
    private String zzdec = "";
    @GuardedBy(value="this")
    private zzasw zzdhp;
    @GuardedBy(value="this")
    private boolean zzdhq;
    @GuardedBy(value="this")
    private boolean zzdhr;
    @GuardedBy(value="this")
    private zzpk zzdhs;
    @GuardedBy(value="this")
    private int zzdht;
    @GuardedBy(value="this")
    private int zzdhu;
    private zzoh zzdhv;
    private zzoh zzded;
    private zzoh zzdhw;
    private zzoi zzdhx;
    private WeakReference<View.OnClickListener> zzdhy;
    @GuardedBy(value="this")
    private zzd zzdhz;
    private zzanz zzaew;
    private final AtomicReference<IObjectWrapper> zzdix = new AtomicReference();
    private int zzcak = -1;
    private int zzcaj = -1;
    private int zzcam = -1;
    private int zzcan = -1;
    private float zzdiy;
    private Map<String, zzarr> zzdib;
    private final WindowManager zzafm;

    @VisibleForTesting
    protected zzaub(zzats zzats2, zzatu zzatu2, zzatt zzatt2, String string2, boolean bl, boolean bl2, @Nullable zzck zzck2, zzaop zzaop2, zzoj zzoj2, zzbo zzbo2, zzv zzv2) {
        super((Context)zzats2, zzatu2);
        this.zzdiv = zzats2;
        this.zzdiw = zzatu2;
        this.zzdhi = zzatt2;
        this.zzvd = string2;
        this.zzdhk = bl;
        this.zzdhm = -1;
        this.zzbmj = zzck2;
        this.zzys = zzaop2;
        this.zzdhb = zzbo2;
        this.zzwp = zzv2;
        this.zzafm = (WindowManager)this.getContext().getSystemService("window");
        this.zzaew = new zzanz(this.zzdiv.zzvc(), (View)this, this, null);
        zzbv.zzek().zza((Context)zzats2, zzaop2.zzcx, this.getSettings());
        this.setDownloadListener(this);
        this.zzdiy = zzats2.getResources().getDisplayMetrics().density;
        this.zzxb();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            ((zzaud)this).addJavascriptInterface(zzasz.zzk(this), "googleAdsJsInterface");
        }
        zzoj zzoj3 = zzoj2;
        zzaub zzaub2 = this;
        zzaub2.zzxf();
        zzaub2.zzdhx = new zzoi(new zzoj(true, "make_wv", zzaub2.zzvd));
        zzaub2.zzdhx.zzki().zzc(zzoj3);
        zzaub2.zzded = zzoc.zzb(zzaub2.zzdhx.zzki());
        zzaub2.zzdhx.zza("native:view_create", zzaub2.zzded);
        zzaub2.zzdhw = null;
        zzaub2.zzdhv = null;
        zzbv.zzem().zzay((Context)zzats2);
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zzv zzbi() {
        return this.zzwp;
    }

    private final boolean zzwy() {
        int n;
        int n2;
        if (!this.zzdiw.zzfy() && !this.zzdiw.zzwl()) {
            return false;
        }
        zzbv.zzek();
        DisplayMetrics displayMetrics = zzalo.zza(this.zzafm);
        zzkd.zziz();
        int n3 = zzaoa.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzkd.zziz();
        int n4 = zzaoa.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.heightPixels);
        Activity activity = this.zzdiv.zzvc();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbv.zzek();
            int[] nArray = zzalo.zzg(activity);
            zzkd.zziz();
            n2 = zzaoa.zzb((DisplayMetrics)displayMetrics, (int)nArray[0]);
            zzkd.zziz();
            n = zzaoa.zzb((DisplayMetrics)displayMetrics, (int)nArray[1]);
        }
        if (this.zzcaj == n3 && this.zzcak == n4 && this.zzcam == n2 && this.zzcan == n) {
            return false;
        }
        boolean bl = this.zzcaj != n3 || this.zzcak != n4;
        this.zzcaj = n3;
        this.zzcak = n4;
        this.zzcam = n2;
        this.zzcan = n;
        new zzabr(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzafm.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final synchronized void zzc(String string2, String string3, @Nullable String string4) {
        zznl zznl2 = zznw.zzbbi;
        String string5 = (Boolean)zzkd.zzjd().zzd(zznl2) != false ? zzati.zzb(string3, zzati.zzxh()) : string3;
        super.loadDataWithBaseURL(string2, string5, "text/html", "UTF-8", string4);
    }

    @Override
    public final synchronized void zzbh(String string2) {
        if (!this.isDestroyed()) {
            super.zzbh(string2);
            return;
        }
        zzalg.zzdp((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final void zzvo() {
        this.zzxa();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzys.zzcx);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzvm.zza((zzvl)this, "onhide", hashMap2);
    }

    @Override
    public final void zzap(int n) {
        if (n == 0) {
            zzaub zzaub2 = this;
            zzoc.zza(zzaub2.zzdhx.zzki(), zzaub2.zzded, "aebb2");
        }
        this.zzxa();
        if (this.zzdhx.zzki() != null) {
            this.zzdhx.zzki().zze("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzys.zzcx);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzvm.zza((zzvl)this, "onhide", hashMap2);
    }

    private final void zzxa() {
        zzoc.zza(this.zzdhx.zzki(), this.zzded, "aeh2");
    }

    @Override
    public final void zzoz() {
        if (this.zzdhv == null) {
            zzoc.zza(this.zzdhx.zzki(), this.zzded, "aes2");
            this.zzdhv = zzoc.zzb(this.zzdhx.zzki());
            this.zzdhx.zza("native:view_show", this.zzdhv);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzys.zzcx);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onshow";
        zzvm.zza((zzvl)this, "onshow", hashMap2);
    }

    @Override
    public final void zzvp() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzbv.zzep().zzdp()));
        hashMap.put("app_volume", String.valueOf(zzbv.zzep().zzdo()));
        hashMap.put("device_volume", String.valueOf(zzamh.zzba(this.getContext())));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "volume";
        zzvm.zza((zzvl)this, "volume", hashMap2);
    }

    @Override
    public final synchronized zzd zzvr() {
        return this.zzdhg;
    }

    @Override
    public final IObjectWrapper zzvz() {
        return this.zzdix.get();
    }

    @Override
    public final synchronized zzd zzvs() {
        return this.zzdhz;
    }

    @Override
    public final synchronized zzatt zzvt() {
        return this.zzdhi;
    }

    @Override
    public final synchronized String zzvu() {
        return this.zzvd;
    }

    @Override
    public final WebViewClient zzvw() {
        return this.zzdiw;
    }

    @Override
    public final synchronized boolean zzvx() {
        return this.zzdhj;
    }

    @Override
    public final zzck zzvy() {
        return this.zzbmj;
    }

    @Override
    public final zzaop zzvf() {
        return this.zzys;
    }

    @Override
    public final synchronized boolean zzwa() {
        return this.zzdhk;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbv.zzek();
            zzalo.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzalg.zzco((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzdiw.zzwl()) {
            zzaub zzaub2 = this;
            synchronized (zzaub2) {
                if (this.zzdhs != null) {
                    this.zzdhs.zzc(motionEvent);
                }
            }
        } else if (this.zzbmj != null) {
            this.zzbmj.zza(motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f = motionEvent.getAxisValue(9);
        float f2 = motionEvent.getAxisValue(10);
        if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
            return false;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzdhk || this.zzdhi.zzxm()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzdhi.zzxo()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzdhi.zzxn()) {
            zznl zznl2 = zznw.zzbeq;
            if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
                super.onMeasure(n, n2);
                return;
            }
            float f = 0.0f;
            zzasw zzasw2 = this.zzva();
            if (zzasw2 != null) {
                f = zzasw2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzdhi.isFluid()) {
            int n11;
            Object object = zznw.zzbev;
            if (((Boolean)zzkd.zzjd().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzauc((zzaub)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            ((zzaud)this).zzbh(string2);
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzdhu) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzdhu * this.zzdiy);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzdhi.zzxl()) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.zzafm.getDefaultDisplay().getMetrics(displayMetrics);
            this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzdhi.widthPixels > n17 || this.zzdhi.heightPixels > n18 ? 1 : 0;
        zznl zznl3 = zznw.zzbho;
        if (((Boolean)zzkd.zzjd().zzd(zznl3)).booleanValue()) {
            int n20 = n4 = !((float)this.zzdhi.widthPixels / this.zzdiy > (float)n17 / this.zzdiy) && !((float)this.zzdhi.heightPixels / this.zzdiy > (float)n18 / this.zzdiy) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzdhi.widthPixels / this.zzdiy);
            int n21 = (int)((float)this.zzdhi.heightPixels / this.zzdiy);
            int n22 = (int)((float)n14 / this.zzdiy);
            int n23 = (int)((float)n16 / this.zzdiy);
            zzalg.zzdp((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.getVisibility() != 8) {
            this.setVisibility(0);
        }
        this.setMeasuredDimension(this.zzdhi.widthPixels, this.zzdhi.heightPixels);
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzwy();
        zzd zzd2 = this.zzvr();
        if (zzd2 != null && bl) {
            zzd2.zzoy();
        }
    }

    @Override
    public final synchronized void zza(zzd zzd2) {
        this.zzdhg = zzd2;
    }

    @Override
    public final void zzaa(IObjectWrapper iObjectWrapper) {
        this.zzdix.set(iObjectWrapper);
    }

    @Override
    public final synchronized void zzb(zzd zzd2) {
        this.zzdhz = zzd2;
    }

    @Override
    public final synchronized void zza(zzatt zzatt2) {
        this.zzdhi = zzatt2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzaj(boolean bl) {
        boolean bl2 = bl != this.zzdhk;
        this.zzdhk = bl;
        this.zzxb();
        if (bl2) {
            new zzabr(this).zzcd(bl ? "expanded" : "default");
        }
    }

    @Override
    public final void zzwf() {
        this.zzaew.zztq();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzaew.onAttachedToWindow();
        }
        boolean bl = this.zzdhq;
        if (this.zzdiw != null && this.zzdiw.zzwl()) {
            bl = true;
            if (!this.zzdhr) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdiw.zzwm();
                if (onGlobalLayoutListener != null) {
                    zzbv.zzfi();
                    zzaub zzaub2 = this;
                    if (zzaub2 == null) {
                        throw null;
                    }
                    zzaqa.zza((View)zzaub2, onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdiw.zzwn()) != null) {
                    zzbv.zzfi();
                    zzaub zzaub3 = this;
                    if (zzaub3 == null) {
                        throw null;
                    }
                    zzaqa.zza((View)zzaub3, onScrollChangedListener);
                }
                this.zzdhr = true;
            }
            this.zzwy();
        }
        this.zzan(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzaub zzaub2 = this;
        synchronized (zzaub2) {
            if (!this.isDestroyed()) {
                this.zzaew.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzdhr && this.zzdiw != null && this.zzdiw.zzwl() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdiw.zzwm();
                if (onGlobalLayoutListener != null) {
                    zzbv.zzem().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdiw.zzwn()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzdhr = false;
            }
        }
        this.zzan(false);
    }

    @Override
    public final void zzbn(Context context) {
        this.zzdiv.setBaseContext(context);
        this.zzaew.zzj(this.zzdiv.zzvc());
    }

    @Override
    public final synchronized void zzu(boolean bl) {
        if (this.zzdhg != null) {
            this.zzdhg.zza(this.zzdiw.zzfy(), bl);
            return;
        }
        this.zzdhj = bl;
    }

    @Override
    public final synchronized int getRequestedOrientation() {
        return this.zzdhm;
    }

    @Override
    public final void zzwb() {
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzdhm = n;
        if (this.zzdhg != null) {
            this.zzdhg.setRequestedOrientation(this.zzdhm);
        }
    }

    @Override
    public final Activity zzvc() {
        return this.zzdiv.zzvc();
    }

    @Override
    public final Context zzvq() {
        return this.zzdiv.zzvq();
    }

    private final synchronized void zzxb() {
        if (this.zzdhk || this.zzdhi.zzxl()) {
            zzalg.zzco((String)"Enabling hardware acceleration on an overlay.");
            this.zzxd();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzalg.zzco((String)"Disabling hardware acceleration on an AdView.");
            this.zzxc();
            return;
        }
        zzalg.zzco((String)"Enabling hardware acceleration on an AdView.");
        this.zzxd();
    }

    private final synchronized void zzxc() {
        if (!this.zzdhl) {
            zzbv.zzem().zzaa((View)this);
        }
        this.zzdhl = true;
    }

    private final synchronized void zzxd() {
        if (this.zzdhl) {
            zzbv.zzem().zzz((View)this);
        }
        this.zzdhl = false;
    }

    @Override
    protected final synchronized void zzao(boolean bl) {
        if (!bl) {
            this.zzxf();
            this.zzaew.zztr();
            if (this.zzdhg != null) {
                this.zzdhg.close();
                this.zzdhg.onDestroy();
                this.zzdhg = null;
            }
        }
        this.zzdix.set(null);
        this.zzdiw.destroy();
        zzbv.zzfh();
        zzarq.zzb(this);
        this.zzxe();
    }

    @Override
    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzdiw != null && this.zzdiw.zzwv() != null) {
            this.zzdiw.zzwv().zzdb();
        }
    }

    @Override
    public final void zzwg() {
        if (this.zzdhw == null) {
            this.zzdhw = zzoc.zzb(this.zzdhx.zzki());
            this.zzdhx.zza("native:view_load", this.zzdhw);
        }
    }

    @Override
    public final void onPause() {
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzwj() {
        zzalg.v("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void zzam(boolean bl) {
        this.zzdiw.zzam(bl);
    }

    @Override
    public final void stopLoading() {
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzak(boolean bl) {
        this.zzdhn = bl;
    }

    @Override
    public final synchronized boolean zzwc() {
        return this.zzdhn;
    }

    @Override
    public final synchronized boolean zzwd() {
        return this.zzdho;
    }

    @Override
    public final synchronized void zzck() {
        this.zzdho = true;
        if (this.zzdhb != null) {
            this.zzdhb.zzck();
        }
    }

    @Override
    public final synchronized void zzcl() {
        this.zzdho = false;
        if (this.zzdhb != null) {
            this.zzdhb.zzcl();
        }
    }

    private final synchronized void zzxe() {
        this.zzdib = null;
    }

    @Override
    public final synchronized void zzdw(String string2) {
        this.zzdec = string2 == null ? "" : string2;
    }

    @Override
    public final synchronized String zzvd() {
        return this.zzdec;
    }

    @Override
    public final zzaqx zzuz() {
        return null;
    }

    @Override
    public final zzoh zzvb() {
        return this.zzded;
    }

    @Override
    public final zzoi zzve() {
        return this.zzdhx;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzdhy = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener getOnClickListener() {
        return (View.OnClickListener)this.zzdhy.get();
    }

    @Override
    public final synchronized void zzb(zzpk zzpk2) {
        this.zzdhs = zzpk2;
    }

    @Override
    public final synchronized zzpk zzwh() {
        return this.zzdhs;
    }

    @Override
    public final synchronized void zzvi() {
    }

    @Override
    public final synchronized zzasw zzva() {
        return this.zzdhp;
    }

    @Override
    public final synchronized void zza(zzasw zzasw2) {
        if (this.zzdhp != null) {
            zzalg.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzdhp = zzasw2;
    }

    @Override
    public final synchronized boolean zzwe() {
        return this.zzdht > 0;
    }

    @Override
    public final synchronized void zzal(boolean bl) {
        this.zzdht += bl ? 1 : -1;
        if (this.zzdht <= 0 && this.zzdhg != null) {
            this.zzdhg.zzpb();
        }
    }

    private final void zzxf() {
        if (this.zzdhx == null) {
            return;
        }
        zzoj zzoj2 = this.zzdhx.zzki();
        if (zzoj2 != null && zzbv.zzeo().zzrl() != null) {
            zzbv.zzeo().zzrl().zza(zzoj2);
        }
    }

    @Override
    public final void zzwi() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzai(boolean bl) {
        this.zzdiw.zzai(bl);
    }

    @Override
    public final void zzpa() {
        zzd zzd2 = this.zzvr();
        if (zzd2 != null) {
            zzd2.zzpa();
        }
    }

    @Override
    public final int zzvg() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzvh() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzdiw.zza(zzc2);
    }

    @Override
    public final void zza(boolean bl, int n) {
        this.zzdiw.zza(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzdiw.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzdiw.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzfv zzfv2) {
        zzaub zzaub2 = this;
        synchronized (zzaub2) {
            this.zzdhq = zzfv2.zztk;
        }
        this.zzan(zzfv2.zztk);
    }

    private final void zzan(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onAdVisibilityChanged";
        zzvm.zza((zzvl)this, "onAdVisibilityChanged", hashMap2);
    }

    @Override
    public final void zza(String string2, zzu<? super zzasg> zzu2) {
        if (this.zzdiw != null) {
            this.zzdiw.zza(string2, zzu2);
        }
    }

    @Override
    public final void zzb(String string2, zzu<? super zzasg> zzu2) {
        if (this.zzdiw != null) {
            this.zzdiw.zzb(string2, zzu2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzu<? super zzasg>> predicate) {
        if (this.zzdiw != null) {
            this.zzdiw.zza(string2, predicate);
        }
    }

    @Override
    public final /* synthetic */ zzatn zzvv() {
        return this.zzdiw;
    }

    static /* synthetic */ int zza(zzaub zzaub2) {
        return zzaub2.zzdhu;
    }

    static /* synthetic */ int zza(zzaub zzaub2, int n) {
        zzaub2.zzdhu = n;
        return zzaub2.zzdhu;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        zzvm.zza((zzvl)this, string2, jSONObject);
    }

    @Override
    public final void zzf(String string2, String string3) {
        zzvm.zza((zzvl)this, string2, string3);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        zzvm.zzb(this, string2, jSONObject);
    }

    public final void zza(String string2, Map map) {
        zzvm.zza((zzvl)this, string2, map);
    }
}

