/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzavt;
import com.google.android.gms.internal.ads.zzavx;
import com.google.android.gms.internal.ads.zzayn;
import com.google.android.gms.internal.ads.zzayp;
import com.google.android.gms.internal.ads.zzayr;
import com.google.android.gms.internal.ads.zzayt;
import com.google.android.gms.internal.ads.zzayv;
import com.google.android.gms.internal.ads.zzbaw;
import com.google.android.gms.internal.ads.zzbay;
import com.google.android.gms.internal.ads.zzbbd;
import com.google.android.gms.internal.ads.zzbbu;
import com.google.android.gms.internal.ads.zzbdd;
import com.google.android.gms.internal.ads.zzbdl;
import com.google.android.gms.internal.ads.zzbel;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

final class zzawx
implements zzavt<zzavx> {
    zzawx() {
    }

    private final zzavx zzh(zzbbu zzbbu2) throws GeneralSecurityException {
        try {
            zzbaw zzbaw2;
            zzayp zzayp2;
            zzayp zzayp3;
            zzayp zzayp4 = zzayp3 = zzayp.zzae(zzbbu2);
            zzayp zzayp5 = zzayp3;
            if (!(zzayp3 instanceof zzayp)) {
                throw new GeneralSecurityException("expected HmacKey proto");
            }
            zzayp zzayp6 = zzayp2 = zzayp5;
            zzbbd.zzj(zzayp2.getVersion(), 0);
            if (zzayp6.zzyp().size() < 16) {
                throw new GeneralSecurityException("key too short");
            }
            zzawx.zza(zzayp6.zzaag());
            zzayn zzayn2 = zzayp2.zzaag().zzaam();
            byte[] byArray = zzayp2.zzyp().toByteArray();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
            int n = zzayp2.zzaag().zzaan();
            switch (zzayn2) {
                case zzdnv: {
                    zzbaw2 = new zzbaw("HMACSHA1", secretKeySpec, n);
                    break;
                }
                case zzdnw: {
                    zzbaw2 = new zzbaw("HMACSHA256", secretKeySpec, n);
                    break;
                }
                case zzdnx: {
                    zzbaw2 = new zzbaw("HMACSHA512", secretKeySpec, n);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("unknown hash");
                }
            }
            return zzbaw2;
        }
        catch (zzbdl zzbdl2) {
            throw new GeneralSecurityException("expected serialized HmacKey proto", zzbdl2);
        }
    }

    @Override
    public final zzbel zzb(zzbbu zzbbu2) throws GeneralSecurityException {
        try {
            zzayr zzayr2 = zzayr.zzag(zzbbu2);
            return this.zzb((zzbel)zzayr2);
        }
        catch (zzbdl zzbdl2) {
            throw new GeneralSecurityException("expected serialized HmacKeyFormat proto", zzbdl2);
        }
    }

    @Override
    public final zzbel zzb(zzbel zzbel2) throws GeneralSecurityException {
        zzayr zzayr2;
        if (!(zzbel2 instanceof zzayr)) {
            throw new GeneralSecurityException("expected HmacKeyFormat proto");
        }
        zzayr zzayr3 = zzayr2 = (zzayr)zzbel2;
        if (zzayr2.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzawx.zza(zzayr3.zzaag());
        return (zzbdd)zzayp.zzaah().zzbc(0).zzc(zzayr2.zzaag()).zzaf(zzbbu.zzo((byte[])zzbay.zzbo(zzayr2.getKeySize()))).zzafk();
    }

    @Override
    public final zzayv zzc(zzbbu zzbbu2) throws GeneralSecurityException {
        zzayp zzayp2 = (zzayp)this.zzb(zzbbu2);
        return (zzayv)((zzbdd)zzayv.zzaat().zzeg("type.googleapis.com/google.crypto.tink.HmacKey").zzai(zzayp2.zzacp()).zzb(zzayv.zzb.zzdol).zzafk());
    }

    @Override
    public final String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.HmacKey";
    }

    @Override
    public final int getVersion() {
        return 0;
    }

    private static void zza(zzayt zzayt2) throws GeneralSecurityException {
        if (zzayt2.zzaan() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzayt2.zzaam()) {
            case zzdnv: {
                if (zzayt2.zzaan() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzdnw: {
                if (zzayt2.zzaan() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzdnx: {
                if (zzayt2.zzaan() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ Object zza(zzbel zzbel2) throws GeneralSecurityException {
        zzayp zzayp2;
        zzbel zzbel3 = zzbel2;
        if (!(zzbel3 instanceof zzayp)) {
            throw new GeneralSecurityException("expected HmacKey proto");
        }
        zzayp zzayp3 = zzayp2 = (zzayp)zzbel3;
        zzbbd.zzj(zzayp2.getVersion(), 0);
        if (zzayp3.zzyp().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzawx.zza(zzayp3.zzaag());
        zzayn zzayn2 = zzayp2.zzaag().zzaam();
        byte[] byArray = zzayp2.zzyp().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zzayp2.zzaag().zzaan();
        switch (zzayn2) {
            case zzdnv: {
                return new zzbaw("HMACSHA1", secretKeySpec, n);
            }
            case zzdnw: {
                return new zzbaw("HMACSHA256", secretKeySpec, n);
            }
            case zzdnx: {
                return new zzbaw("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public final /* synthetic */ Object zza(zzbbu zzbbu2) throws GeneralSecurityException {
        return this.zzh(zzbbu2);
    }
}

