/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzavm;
import com.google.android.gms.internal.ads.zzbay;
import com.google.android.gms.internal.ads.zzbbd;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzazv
implements zzavm {
    private final byte[] zzdqk;
    private final byte[] zzdql;
    private final SecretKeySpec zzdqh;
    private final int zzdqm;

    public zzazv(byte[] byArray, int n) throws GeneralSecurityException {
        if (n != 12 && n != 16) {
            throw new IllegalArgumentException("IV size should be either 12 or 16 bytes");
        }
        this.zzdqm = n;
        zzbbd.zzbp(byArray.length);
        this.zzdqh = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NOPADDING");
        cipher.init(1, this.zzdqh);
        byte[] byArray2 = cipher.doFinal(new byte[16]);
        this.zzdqk = zzazv.zzl(byArray2);
        this.zzdql = zzazv.zzl(this.zzdqk);
    }

    private static byte[] zzd(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    private static byte[] zzl(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < 15; ++i) {
            byArray2[i] = (byte)(byArray[i] << 1 ^ (byArray[i + 1] & 0xFF) >>> 7);
        }
        byArray2[15] = (byte)(byArray[15] << 1 ^ ((byArray[0] & 0x80) == 0 ? 0 : 135));
        return byArray2;
    }

    private final byte[] zza(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2;
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = byArray3;
        byArray3[15] = (byte)n;
        if (n3 == 0) {
            return cipher.doFinal(zzazv.zzd(byArray4, this.zzdqk));
        }
        byArray4 = cipher.doFinal(byArray4);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                int n5 = i;
                byArray4[n5] = (byte)(byArray4[n5] ^ byArray[n2 + n4 + i]);
            }
            byArray4 = cipher.doFinal(byArray4);
            n4 += 16;
        }
        byte[] byArray5 = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3);
        zzazv zzazv2 = this;
        if (byArray5.length == 16) {
            byArray2 = zzazv.zzd(byArray5, zzazv2.zzdqk);
        } else {
            byte[] byArray6 = Arrays.copyOf(zzazv2.zzdql, 16);
            for (int i = 0; i < byArray5.length; ++i) {
                int n6 = i;
                byArray6[n6] = (byte)(byArray6[n6] ^ byArray5[i]);
            }
            byArray6[byArray5.length] = (byte)(byArray6[byArray5.length] ^ 0x80);
            byArray2 = byArray6;
        }
        byte[] byArray7 = byArray2;
        byArray4 = zzazv.zzd(byArray4, byArray7);
        return cipher.doFinal(byArray4);
    }

    @Override
    public final byte[] zzc(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray.length > Integer.MAX_VALUE - this.zzdqm - 16) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] byArray3 = new byte[this.zzdqm + byArray.length + 16];
        byte[] byArray4 = zzbay.zzbo(this.zzdqm);
        System.arraycopy(byArray4, 0, byArray3, 0, this.zzdqm);
        Cipher cipher = Cipher.getInstance("AES/ECB/NOPADDING");
        cipher.init(1, this.zzdqh);
        byte[] byArray5 = this.zza(cipher, 0, byArray4, 0, byArray4.length);
        byte[] byArray6 = byArray2;
        if (byArray2 == null) {
            byArray6 = new byte[]{};
        }
        byte[] byArray7 = this.zza(cipher, 1, byArray6, 0, byArray6.length);
        Cipher cipher2 = Cipher.getInstance("AES/CTR/NOPADDING");
        cipher2.init(1, (Key)this.zzdqh, new IvParameterSpec(byArray5));
        cipher2.doFinal(byArray, 0, byArray.length, byArray3, this.zzdqm);
        byte[] byArray8 = this.zza(cipher, 2, byArray3, this.zzdqm, byArray.length);
        int n = byArray.length + this.zzdqm;
        for (int i = 0; i < 16; ++i) {
            byArray3[n + i] = (byte)(byArray7[i] ^ byArray5[i] ^ byArray8[i]);
        }
        return byArray3;
    }
}

