/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.ads.zzavd;
import com.google.android.gms.internal.ads.zzbb;
import com.google.android.gms.internal.ads.zzbf;
import com.google.android.gms.internal.ads.zzbgz;
import com.google.android.gms.internal.ads.zzbm;
import com.google.android.gms.internal.ads.zzce;
import com.google.android.gms.internal.ads.zzcm;
import com.google.android.gms.internal.ads.zzcn;
import com.google.android.gms.internal.ads.zzcy;
import com.google.android.gms.internal.ads.zzdc;
import com.google.android.gms.internal.ads.zzdd;
import com.google.android.gms.internal.ads.zzde;
import com.google.android.gms.internal.ads.zzdf;
import com.google.android.gms.internal.ads.zzdi;
import com.google.android.gms.internal.ads.zzei;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdb {
    private static final String TAG = zzdb.class.getSimpleName();
    protected Context zzrx;
    private ExecutorService zzry;
    private DexClassLoader zzrz;
    private zzcm zzsa;
    private byte[] zzsb;
    private volatile AdvertisingIdClient zzsc = null;
    private volatile boolean zzqx = false;
    private Future zzsd = null;
    private boolean zzse;
    private volatile zzbb zzsf = null;
    private Future zzsg = null;
    private zzce zzsh;
    private boolean zzsi = false;
    private boolean zzsj = false;
    private Map<Pair<String, String>, zzei> zzsk;
    private boolean zzsl = false;
    private boolean zzsm = true;
    private boolean zzsn = false;

    public static zzdb zza(Context context, String string2, String string3, boolean bl) {
        zzdb zzdb2 = new zzdb(context);
        try {
            Object object;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdb zzdb3 = zzdb2;
            zzdb2.zzry = Executors.newCachedThreadPool(new zzdc());
            boolean bl3 = bl2;
            zzdb zzdb4 = zzdb3;
            zzdb3.zzqx = bl3;
            if (bl3) {
                zzdb4.zzsd = zzdb4.zzry.submit(new zzdd(zzdb4));
            }
            zzdb zzdb5 = zzdb3;
            zzdb5.zzry.execute(new zzdf(zzdb5));
            try {
                object = GoogleApiAvailabilityLight.getInstance();
                zzdb5.zzsi = object.getApkVersion(zzdb5.zzrx) > 0;
                zzdb5.zzsj = object.isGooglePlayServicesAvailable(zzdb5.zzrx) == 0;
            }
            catch (Throwable throwable) {}
            zzdb3.zza(0, true);
            if (zzdi.isMainThread()) {
                zzdb4 = zznw.zzbdv;
                if (((Boolean)zzkd.zzjd().zzd((zznl)zzdb4)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            object = string5;
            zzdb5 = zzdb3;
            zzdb3.zzsa = new zzcm(null);
            try {
                zzdb5.zzsb = zzdb5.zzsa.zzl((String)object);
            }
            catch (zzcn zzcn2) {
                throw new zzcy(zzcn2);
            }
            object = string4;
            zzdb5 = zzdb3;
            try {
                String string6;
                File file = zzdb5.zzrx.getCacheDir();
                if (file == null && (file = zzdb5.zzrx.getDir("dex", 0)) == null) {
                    throw new zzcy();
                }
                String string7 = string6 = "1529567361524";
                File file2 = file;
                Object object2 = object;
                zzdb zzdb6 = zzdb5;
                File file3 = new File(String.format("%s/%s.jar", file2, string7));
                if (!file3.exists()) {
                    byte[] byArray = zzdb6.zzsa.zza(zzdb6.zzsb, (String)object2);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdb5.zzb(file, string6);
                try {
                    zzdb5.zzrz = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdb5.zzrx.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdb.zzb(file4);
                    zzdb5.zza(file, string6);
                    zzdb.zzm(String.format("%s/%s.dex", file, string6));
                    throw throwable;
                }
                zzdb.zzb(file4);
                zzdb5.zza(file, string6);
                zzdb.zzm(String.format("%s/%s.dex", file, string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzcy(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzcy(iOException);
            }
            catch (zzcn zzcn3) {
                throw new zzcy(zzcn3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzcy(nullPointerException);
            }
            zzdb4 = zzdb3;
            if (!zzdb4.zzsn) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                zzdb4.zzrx.registerReceiver((BroadcastReceiver)zzdb4.new zza(null), intentFilter);
                zzdb4.zzsn = true;
            }
            zzdb3.zzsh = new zzce(zzdb3);
            zzdb3.zzsl = true;
        }
        catch (zzcy zzcy2) {}
        return zzdb2;
    }

    public final Context getContext() {
        return this.zzrx;
    }

    public final boolean isInitialized() {
        return this.zzsl;
    }

    public final ExecutorService zzab() {
        return this.zzry;
    }

    public final DexClassLoader zzac() {
        return this.zzrz;
    }

    public final zzcm zzad() {
        return this.zzsa;
    }

    public final byte[] zzae() {
        return this.zzsb;
    }

    public final boolean zzaf() {
        return this.zzsi;
    }

    public final zzce zzag() {
        return this.zzsh;
    }

    public final boolean zzah() {
        return this.zzsj;
    }

    public final boolean zzai() {
        return this.zzsm;
    }

    public final zzbb zzaj() {
        return this.zzsf;
    }

    public final Future zzak() {
        return this.zzsg;
    }

    private zzdb(Context context) {
        Context context2 = context.getApplicationContext();
        this.zzse = context2 != null;
        this.zzrx = this.zzse ? context2 : context;
        this.zzsk = new HashMap<Pair<String, String>, zzei>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdb.zzb(file2);
            return;
        }
        zzbf zzbf2 = new zzbf();
        new zzbf().zzgw = Build.VERSION.SDK.getBytes();
        zzbf2.zzgv = string2.getBytes();
        byte[] byArray2 = this.zzsa.zzb(this.zzsb, byArray).getBytes();
        zzbf2.data = byArray2;
        zzbf2.zzgu = zzbm.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = zzbgz.zzb((zzbgz)zzbf2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdb.zzb(file2);
        return;
        catch (zzcn | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdb.zzb(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdb.zzb(file2);
            throw throwable;
        }
    }

    private static void zzm(String string2) {
        zzdb.zzb(new File(string2));
    }

    private static void zzb(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbf zzbf2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdb.zzb(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzdb.zzb(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzbf2 = (zzbf)zzbgz.zza((zzbgz)new zzbf(), (byte[])byArray2);
                if (string2.equals(new String(zzbf2.zzgv)) && Arrays.equals(zzbf2.zzgu, zzbm.zzb(zzbf2.data)) && Arrays.equals(zzbf2.zzgw, Build.VERSION.SDK.getBytes())) break block30;
                zzdb.zzb(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzsa.zza(this.zzsb, new String(zzbf2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcn | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzsk.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzsk.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzei(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zza(String string2, String string3) {
        zzei zzei2 = this.zzsk.get(new Pair((Object)string2, (Object)string3));
        if (zzei2 == null) {
            return null;
        }
        return zzei2.zzaw();
    }

    private final void zzal() {
        try {
            if (this.zzsc == null && this.zzse) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzrx);
                advertisingIdClient.start();
                this.zzsc = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzsc = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzsj) {
            return;
        }
        Future<?> future = this.zzry.submit(new zzde(this, n, bl));
        if (n == 0) {
            this.zzsg = future;
        }
    }

    @VisibleForTesting
    final zzbb zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzam();
    }

    private static boolean zza(int n, zzbb zzbb2) {
        if (n < 4) {
            if (zzbb2 == null) {
                return true;
            }
            zznl zznl2 = zznw.zzbdy;
            if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue() && (zzbb2.zzcy == null || zzbb2.zzcy.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zznl2 = zznw.zzbdz;
            if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue() && (zzbb2.zzfr == null || zzbb2.zzfr.zzgp == null || zzbb2.zzfr.zzgp == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzbb zzam() {
        zzbb zzbb2 = null;
        try {
            PackageInfo packageInfo = this.zzrx.getPackageManager().getPackageInfo(this.zzrx.getPackageName(), 0);
            zzbb2 = zzavd.zzk((Context)this.zzrx, (String)this.zzrx.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzbb2;
    }

    public final AdvertisingIdClient zzan() {
        if (!this.zzqx) {
            return null;
        }
        if (this.zzsc != null) {
            return this.zzsc;
        }
        if (this.zzsd != null) {
            try {
                this.zzsd.get(2000L, TimeUnit.MILLISECONDS);
                this.zzsd = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzsd.cancel(true);
            }
        }
        return this.zzsc;
    }

    public final int zzx() {
        int n = Integer.MIN_VALUE;
        if (this.zzsh != null) {
            n = zzce.zzx();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdb zzdb2) {
        zzdb2.zzal();
    }

    static /* synthetic */ zzbb zza(zzdb zzdb2, zzbb zzbb2) {
        zzdb2.zzsf = zzbb2;
        return zzdb2.zzsf;
    }

    static /* synthetic */ boolean zzb(int n, zzbb zzbb2) {
        return zzdb.zza(n, zzbb2);
    }

    final class zza
    extends BroadcastReceiver {
        private zza() {
        }

        public final void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                zzdb.this.zzsm = true;
                return;
            }
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                zzdb.this.zzsm = false;
            }
        }

        /* synthetic */ zza(zzdc zzdc2) {
            this();
        }
    }
}

