/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzakm;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzamh;
import com.google.android.gms.internal.ads.zzanp;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzet;
import com.google.android.gms.internal.ads.zzeu;
import com.google.android.gms.internal.ads.zzex;
import com.google.android.gms.internal.ads.zzez;
import com.google.android.gms.internal.ads.zzfd;
import com.google.android.gms.internal.ads.zzfr;
import com.google.android.gms.internal.ads.zzgg;
import com.google.android.gms.internal.ads.zzjo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
@ParametersAreNonnullByDefault
public final class zzew
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object mLock = new Object();
    private final WeakReference<zzakm> zzafi;
    private WeakReference<ViewTreeObserver> zzafj;
    private final zzgg zzafk;
    protected final zzeu zzafl;
    private final Context zzafg;
    private final WindowManager zzafm;
    private final PowerManager zzafn;
    private final KeyguardManager zzafo;
    private final DisplayMetrics zzafp;
    @Nullable
    private zzfd zzafq;
    private boolean zzafr;
    private boolean zzabh = false;
    private boolean zzafs = false;
    private boolean zzaft;
    private boolean zzafu;
    private boolean zzafv;
    @Nullable
    @VisibleForTesting
    private BroadcastReceiver zzafw;
    private final HashSet<zzet> zzafx = new HashSet();
    private zzanp zzaer;
    private final HashSet<zzfr> zzafy = new HashSet();
    private final Rect zzafz = new Rect();
    private final zzez zzaga;
    private float zzagb;

    public zzew(Context context, zzjo zzjo2, zzakm zzakm2, zzaop zzaop2, zzgg zzgg2) {
        this.zzafi = new WeakReference<zzakm>(zzakm2);
        this.zzafk = zzgg2;
        this.zzafj = new WeakReference<Object>(null);
        this.zzaft = true;
        this.zzafv = false;
        this.zzaer = new zzanp(200L);
        this.zzafl = new zzeu(UUID.randomUUID().toString(), zzaop2, zzjo2.zzauq, zzakm2.zzcrn, zzakm2.zzfy(), zzjo2.zzaut);
        this.zzafm = (WindowManager)context.getSystemService("window");
        this.zzafn = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzafo = (KeyguardManager)context.getSystemService("keyguard");
        this.zzafg = context;
        this.zzaga = new zzez(this, new Handler());
        this.zzafg.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzaga);
        this.zzafp = context.getResources().getDisplayMetrics();
        Display display = this.zzafm.getDefaultDisplay();
        this.zzafz.right = display.getWidth();
        this.zzafz.bottom = display.getHeight();
        this.zzga();
    }

    public final void zzga() {
        this.zzagb = zzamh.zzba(this.zzafg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgb() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzaft) {
                this.zzafu = true;
                try {
                    JSONObject jSONObject = this.zzgf();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzalg.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzalg.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzafl.zzfx());
                zzalg.zzco((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzl(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzfr> iterator = this.zzafy.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzgj()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzaft) {
                return;
            }
            View view = this.zzafk.zzgg();
            boolean bl3 = view != null && zzbv.zzek().zza(view, this.zzafn, this.zzafo);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzafk.zzgh()) {
                this.zzgb();
                return;
            }
            if (n == 1 && !this.zzaer.tryAcquire() && bl == this.zzafv) {
                return;
            }
            if (!bl && !this.zzafv && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzafv = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzalg.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzew zzew2 = this;
            View view2 = zzew2.zzafk.zzgi().zzgg();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzew2.zzafj.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzew2.zzge();
                    if (!zzew2.zzafr || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzew2.zzafr = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzew2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzew2);
                    }
                    zzew2.zzafj = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzgc();
            return;
        }
    }

    private final void zzgc() {
        if (this.zzafq != null) {
            this.zzafq.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzgd() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaft;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zzc(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzafl.zzfx());
    }

    final void zzd(Map<String, String> map) {
        this.zzl(3);
    }

    final void zza(zzfr zzfr2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzafl.zzfx());
        zzalg.zzco((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzfr2);
    }

    final void zze(Map<String, String> map) {
        boolean bl;
        if (!map.containsKey("isVisible")) {
            return;
        }
        boolean bl2 = bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
        zzew zzew2 = this;
        Iterator<zzet> iterator = zzew2.zzafx.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzew2, bl2);
        }
    }

    private final void zzge() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzafj.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzgf() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzafl.zzfv()).put("activeViewJSON", (Object)this.zzafl.zzfw()).put("timestamp", zzbv.zzer().elapsedRealtime()).put("adFormat", (Object)this.zzafl.zzfu()).put("hashCode", (Object)this.zzafl.zzfx()).put("isMraid", this.zzafl.zzfy()).put("isStopped", this.zzafs).put("isPaused", this.zzabh).put("isNative", this.zzafl.zzfz()).put("isScreenOn", this.isScreenOn()).put("appMuted", zzbv.zzep().zzdp()).put("appVolume", (double)zzbv.zzep().zzdo()).put("deviceVolume", (double)this.zzagb);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzew.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzew zzew2 = this;
            ArrayList<zzfr> arrayList = new ArrayList<zzfr>(zzew2.zzafy);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzfr zzfr2 = arrayList.get(i);
                zzfr2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzalg.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfr zzfr2) {
        if (this.zzafy.isEmpty()) {
            zzew zzew2 = this;
            Object object = zzew2.mLock;
            synchronized (object) {
                if (zzew2.zzafw != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzew2.zzafw = new zzex(zzew2);
                    zzbv.zzfg().zza(zzew2.zzafg, zzew2.zzafw, intentFilter);
                }
            }
            this.zzl(3);
        }
        this.zzafy.add(zzfr2);
        try {
            JSONObject jSONObject = zzew.zza(this.zza(this.zzafk.zzgg(), null));
            zzfr2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzalg.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzfr zzfr2) {
        this.zzafy.remove(zzfr2);
        zzfr2.zzgk();
        if (this.zzafy.isEmpty()) {
            zzew zzew2 = this;
            Object object = zzew2.mLock;
            synchronized (object) {
                zzew2.zzge();
                zzew zzew3 = zzew2;
                Object object2 = zzew3.mLock;
                synchronized (object2) {
                    if (zzew3.zzafw != null) {
                        try {
                            zzbv.zzfg().zza(zzew3.zzafg, zzew3.zzafw);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzalg.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbv.zzeo().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzew3.zzafw = null;
                    }
                }
                zzew2.zzafg.getContentResolver().unregisterContentObserver((ContentObserver)zzew2.zzaga);
                zzew2.zzaft = false;
                zzew2.zzgc();
                zzew3 = zzew2;
                ArrayList<zzfr> arrayList = new ArrayList<zzfr>(zzew3.zzafy);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzfr zzfr3 = arrayList.get(i);
                    zzfr zzfr4 = zzfr3;
                    zzew3.zzb(zzfr4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzew zzew2 = this;
            return zzew2.zzgf().put("isAttachedToWindow", false).put("isScreenOn", zzew2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbv.zzem().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzgf();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzew.zza(this.zzafz.top, this.zzafp)).put("bottom", zzew.zza(this.zzafz.bottom, this.zzafp)).put("left", zzew.zza(this.zzafz.left, this.zzafp)).put("right", zzew.zza(this.zzafz.right, this.zzafp))).put("adBox", (Object)new JSONObject().put("top", zzew.zza(rect.top, this.zzafp)).put("bottom", zzew.zza(rect.bottom, this.zzafp)).put("left", zzew.zza(rect.left, this.zzafp)).put("right", zzew.zza(rect.right, this.zzafp))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzew.zza(rect2.top, this.zzafp)).put("bottom", zzew.zza(rect2.bottom, this.zzafp)).put("left", zzew.zza(rect2.left, this.zzafp)).put("right", zzew.zza(rect2.right, this.zzafp))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzew.zza(rect3.top, this.zzafp)).put("bottom", zzew.zza(rect3.bottom, this.zzafp)).put("left", zzew.zza(rect3.left, this.zzafp)).put("right", zzew.zza(rect3.right, this.zzafp))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzew.zza(rect4.top, this.zzafp)).put("bottom", zzew.zza(rect4.bottom, this.zzafp)).put("left", zzew.zza(rect4.left, this.zzafp)).put("right", zzew.zza(rect4.right, this.zzafp))).put("screenDensity", (double)this.zzafp.density);
        if (bl == null) {
            bl = zzbv.zzek().zza(view, this.zzafn, this.zzafo);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    @VisibleForTesting
    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzafn.isInteractive();
        }
        return this.zzafn.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzl(1);
    }

    public final void onGlobalLayout() {
        this.zzl(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfd zzfd2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzafq = zzfd2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzafs = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzabh = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzabh = false;
            this.zzl(3);
            return;
        }
    }
}

