/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzanp;
import com.google.android.gms.internal.ads.zzft;
import com.google.android.gms.internal.ads.zzfu;
import com.google.android.gms.internal.ads.zzfv;
import com.google.android.gms.internal.ads.zzfw;
import com.google.android.gms.internal.ads.zzfx;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

@zzaer
@TargetApi(value=14)
public final class zzfs
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzagu;
    private final Context zzafg;
    private Application zzagv;
    private final WindowManager zzafm;
    private final PowerManager zzafn;
    private final KeyguardManager zzafo;
    @Nullable
    @VisibleForTesting
    private BroadcastReceiver zzafw;
    private WeakReference<ViewTreeObserver> zzagw;
    private WeakReference<View> zzagx;
    private zzfx zzagy;
    private zzanp zzaer = new zzanp(zzagu);
    private boolean zzafv = false;
    private int zzagz = -1;
    private final HashSet<zzfw> zzaha = new HashSet();
    private final DisplayMetrics zzahb;
    private final Rect zzafz;

    public zzfs(Context context, View view) {
        this.zzafg = context.getApplicationContext();
        this.zzafm = (WindowManager)context.getSystemService("window");
        this.zzafn = (PowerManager)this.zzafg.getSystemService("power");
        this.zzafo = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzafg instanceof Application) {
            this.zzagv = (Application)this.zzafg;
            this.zzagy = new zzfx((Application)this.zzafg, this);
        }
        this.zzahb = context.getResources().getDisplayMetrics();
        this.zzafz = new Rect();
        this.zzafz.right = this.zzafm.getDefaultDisplay().getWidth();
        this.zzafz.bottom = this.zzafm.getDefaultDisplay().getHeight();
        View view2 = view;
        zzfs zzfs2 = this;
        View view3 = zzfs2.zzagx != null ? (View)zzfs2.zzagx.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzfs2);
            zzfs2.zzf(view3);
        }
        zzfs2.zzagx = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzbv.zzem().isAttachedToWindow(view2)) {
                zzfs2.zze(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzfs2);
        }
    }

    public final void zza(zzfw zzfw2) {
        this.zzaha.add(zzfw2);
        this.zzm(3);
    }

    public final void zzb(zzfw zzfw2) {
        this.zzaha.remove(zzfw2);
    }

    private final void zzao() {
        zzbv.zzek();
        zzalo.zzcvi.post((Runnable)new zzft(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzagz = -1;
        this.zze(view);
        this.zzm(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzagz = -1;
        this.zzm(3);
        this.zzao();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzagx == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzagx.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzagz = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzm(3);
        this.zzao();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzm(3);
        this.zzao();
    }

    public final void onGlobalLayout() {
        this.zzm(2);
        this.zzao();
    }

    public final void onScrollChanged() {
        this.zzm(1);
    }

    public final void zzgl() {
        this.zzm(4);
    }

    private final void zzm(int n) {
        boolean bl;
        if (this.zzaha.size() == 0) {
            return;
        }
        if (this.zzagx == null) {
            return;
        }
        View view = (View)this.zzagx.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzalg.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzagz != -1 ? this.zzagz : n2;
        boolean bl6 = bl = !bl3 && zzbv.zzek().zza(view, this.zzafn, this.zzafo) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzaer.tryAcquire() && bl == this.zzafv) {
            return;
        }
        if (!bl && !this.zzafv && n == 1) {
            return;
        }
        zzfv zzfv2 = new zzfv(zzbv.zzer().elapsedRealtime(), this.zzafn.isScreenOn(), view != null ? zzbv.zzem().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(this.zzafz), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzahb.density, bl);
        Iterator<zzfw> iterator = this.zzaha.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzfv2);
        }
        this.zzafv = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzn(rect.left), this.zzn(rect.top), this.zzn(rect.right), this.zzn(rect.bottom));
    }

    private final int zzn(int n) {
        float f = this.zzahb.density;
        return (int)((float)n / f);
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzagw = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzfs zzfs2 = this;
        if (zzfs2.zzafw == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzfs2.zzafw = new zzfu(zzfs2);
            zzbv.zzfg().zza(zzfs2.zzafg, zzfs2.zzafw, intentFilter);
        }
        if (this.zzagv != null) {
            try {
                this.zzagv.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzagy);
                return;
            }
            catch (Exception exception) {
                zzalg.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzagw != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzagw.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzagw = null;
            }
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzfs zzfs2 = this;
        if (zzfs2.zzafw != null) {
            try {
                zzbv.zzfg().zza(zzfs2.zzafg, zzfs2.zzafw);
            }
            catch (IllegalStateException illegalStateException) {
                zzalg.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzbv.zzeo().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzfs2.zzafw = null;
        }
        if (this.zzagv != null) {
            try {
                this.zzagv.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzagy);
                return;
            }
            catch (Exception exception) {
                zzalg.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ void zza(zzfs zzfs2, int n) {
        zzfs2.zzm(3);
    }

    static {
        zznl zznl2 = zznw.zzbcy;
        zzagu = (Long)zzkd.zzjd().zzd(zznl2);
    }
}

