/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzck;
import com.google.android.gms.internal.ads.zzpm;
import com.google.android.gms.internal.ads.zzpn;
import com.google.android.gms.internal.ads.zzpo;
import com.google.android.gms.internal.ads.zzpq;
import com.google.android.gms.internal.ads.zzsc;
import com.google.android.gms.internal.ads.zzyz;
import com.google.android.gms.internal.ads.zzzc;
import com.google.android.gms.internal.ads.zzzf;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@zzaer
@ParametersAreNonnullByDefault
public final class zzpl
extends zzpq {
    @Nullable
    private zzyz zzblz;
    @Nullable
    private zzzc zzbma;
    @Nullable
    private zzzf zzbmb;
    private final zzpn zzbmc;
    @Nullable
    private zzpm zzbmd;
    private boolean zzbme = false;
    private boolean zzbmf = false;
    private final Object mLock = new Object();

    public zzpl(Context context, zzpn zzpn2, zzck zzck2, zzyz zzyz2, zzpo zzpo2) {
        this(context, zzpn2, zzck2, zzpo2);
        this.zzblz = zzyz2;
    }

    public zzpl(Context context, zzpn zzpn2, zzck zzck2, zzzc zzzc2, zzpo zzpo2) {
        this(context, zzpn2, zzck2, zzpo2);
        this.zzbma = zzzc2;
    }

    public zzpl(Context context, zzpn zzpn2, zzck zzck2, zzzf zzzf2, zzpo zzpo2) {
        this(context, zzpn2, zzck2, zzpo2);
        this.zzbmb = zzzf2;
    }

    private zzpl(Context context, zzpn zzpn2, zzck zzck2, zzpo zzpo2) {
        super(context, zzpn2, null, zzck2, null, zzpo2, null, null);
        this.zzbmc = zzpn2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final View zza(View.OnClickListener onClickListener, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmd != null) {
                return this.zzbmd.zza(onClickListener, bl);
            }
            IObjectWrapper iObjectWrapper = null;
            try {
                if (this.zzbmb != null) {
                    iObjectWrapper = this.zzbmb.zzof();
                } else if (this.zzblz != null) {
                    iObjectWrapper = this.zzblz.zzof();
                } else if (this.zzbma != null) {
                    iObjectWrapper = this.zzbma.zzof();
                }
            }
            catch (RemoteException remoteException) {
                zzalg.zzc((String)"Failed to call getAdChoicesContent", (Throwable)remoteException);
            }
            if (iObjectWrapper != null) {
                return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzln() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmd != null) {
                return this.zzbmd.zzln();
            }
            return this.zzbmc.zzct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzlo() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmd != null) {
                return this.zzbmd.zzlo();
            }
            return this.zzbmc.zzcv();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzlp() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmd != null) {
                return this.zzbmd.zzlp();
            }
            return this.zzbmc.zzcu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzsc zzsc2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmd != null) {
                this.zzbmd.zza(zzsc2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancelUnconfirmedClick() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmd != null) {
                this.zzbmd.cancelUnconfirmedClick();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setClickConfirmingView(View view) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmd != null) {
                this.zzbmd.setClickConfirmingView(view);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(View view, Map<String, WeakReference<View>> map) {
        Preconditions.checkMainThread((String)"recordImpression must be called on the main UI thread.");
        Object object = this.mLock;
        synchronized (object) {
            this.zzbmk = true;
            if (this.zzbmd != null) {
                this.zzbmd.zza(view, map);
                this.zzbmc.recordImpression();
            } else {
                try {
                    if (this.zzbmb != null && !this.zzbmb.getOverrideImpressionRecording()) {
                        this.zzbmb.recordImpression();
                        this.zzbmc.recordImpression();
                    } else if (this.zzblz != null && !this.zzblz.getOverrideImpressionRecording()) {
                        this.zzblz.recordImpression();
                        this.zzbmc.recordImpression();
                    } else if (this.zzbma != null && !this.zzbma.getOverrideImpressionRecording()) {
                        this.zzbma.recordImpression();
                        this.zzbmc.recordImpression();
                    }
                }
                catch (RemoteException remoteException) {
                    zzalg.zzc((String)"Failed to call recordImpression", (Throwable)remoteException);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzlq() {
        Preconditions.checkMainThread((String)"recordDownloadedImpression must be called on main UI thread.");
        Object object = this.mLock;
        synchronized (object) {
            this.zzbml = true;
            if (this.zzbmd != null) {
                this.zzbmd.zzlq();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzd(MotionEvent motionEvent) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmd != null) {
                this.zzbmd.zzd(motionEvent);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        Preconditions.checkMainThread((String)"performClick must be called on the main UI thread.");
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmf && ((zzpq)this).zzlo()) {
                return;
            }
            if (this.zzbmd != null) {
                this.zzbmd.zza(view, map, bundle, view2);
                this.zzbmc.onAdClicked();
            } else {
                this.zzl(view);
            }
            return;
        }
    }

    @Override
    public final void zzll() {
        this.zzbmf = true;
        if (this.zzbmd != null) {
            this.zzbmd.zzll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzlm() {
        Preconditions.checkMainThread((String)"recordCustomClickGesture must be called on the main UI thread.");
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmd != null) {
                if (this.zzbmf) {
                    this.zzbmd.zzll();
                }
                this.zzbmd.zzlm();
                this.zzbmc.onAdClicked();
            } else {
                if (!this.zzbmf) {
                    zzalg.zzdp((String)"Custom click reporting for 3p ads failed. enableCustomClickGesture is not set.");
                    return;
                }
                if (!((zzpq)this).zzlo()) {
                    zzalg.zzdp((String)"Custom click reporting for 3p ads failed. Ad unit id not whitelisted.");
                    return;
                }
                if (this.zzlx() != null) {
                    this.zzl(this.zzlx().zzma());
                }
            }
            return;
        }
    }

    private final void zzl(View view) {
        try {
            if (this.zzbmb != null && !this.zzbmb.getOverrideClickHandling()) {
                this.zzbmb.zzk(ObjectWrapper.wrap((Object)view));
                this.zzbmc.onAdClicked();
                return;
            }
            if (this.zzblz != null && !this.zzblz.getOverrideClickHandling()) {
                this.zzblz.zzk(ObjectWrapper.wrap((Object)view));
                this.zzbmc.onAdClicked();
                return;
            }
            if (this.zzbma != null && !this.zzbma.getOverrideClickHandling()) {
                this.zzbma.zzk(ObjectWrapper.wrap((Object)view));
                this.zzbmc.onAdClicked();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzalg.zzc((String)"Failed to call performClick", (Throwable)remoteException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzbme = true;
            HashMap<String, View> hashMap = zzpl.zzb(map);
            HashMap<String, View> hashMap2 = zzpl.zzb(map2);
            try {
                if (this.zzbmb != null) {
                    this.zzbmb.zzb(ObjectWrapper.wrap((Object)view), ObjectWrapper.wrap(hashMap), ObjectWrapper.wrap(hashMap2));
                } else if (this.zzblz != null) {
                    this.zzblz.zzb(ObjectWrapper.wrap((Object)view), ObjectWrapper.wrap(hashMap), ObjectWrapper.wrap(hashMap2));
                    this.zzblz.zzl(ObjectWrapper.wrap((Object)view));
                } else if (this.zzbma != null) {
                    this.zzbma.zzb(ObjectWrapper.wrap((Object)view), ObjectWrapper.wrap(hashMap), ObjectWrapper.wrap(hashMap2));
                    this.zzbma.zzl(ObjectWrapper.wrap((Object)view));
                }
            }
            catch (RemoteException remoteException) {
                zzalg.zzc((String)"Failed to call prepareAd", (Throwable)remoteException);
            }
            this.zzbme = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, View> zzb(Map<String, WeakReference<View>> map) {
        HashMap<String, View> hashMap = new HashMap<String, View>();
        if (map == null) {
            return hashMap;
        }
        Map<String, WeakReference<View>> map2 = map;
        synchronized (map2) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view = (View)entry.getValue().get();
                if (view == null) continue;
                hashMap.put(entry.getKey(), view);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(View view, Map<String, WeakReference<View>> map) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzbmb != null) {
                    this.zzbmb.zzm(ObjectWrapper.wrap((Object)view));
                } else if (this.zzblz != null) {
                    this.zzblz.zzm(ObjectWrapper.wrap((Object)view));
                } else if (this.zzbma != null) {
                    this.zzbma.zzm(ObjectWrapper.wrap((Object)view));
                }
            }
            catch (RemoteException remoteException) {
                zzalg.zzc((String)"Failed to call untrackView", (Throwable)remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzlr() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzbme;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc(@Nullable zzpm zzpm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzbmd = zzpm2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzpm zzls() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzbmd;
        }
    }

    @Override
    @Nullable
    public final zzasg zzlt() {
        return null;
    }

    @Override
    public final void zzlu() {
    }

    @Override
    public final void zzlv() {
    }

    @Override
    public final void zzcq() {
        if (this.zzbmd != null) {
            this.zzbmd.zzcq();
        }
    }

    @Override
    public final void zzcr() {
        if (this.zzbmd != null) {
            this.zzbmd.zzcr();
        }
    }
}

