/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzadw;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzakc;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzalw;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzaov;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzasm;
import com.google.android.gms.internal.ads.zzasq;
import com.google.android.gms.internal.ads.zzatt;
import com.google.android.gms.internal.ads.zzcg;
import com.google.android.gms.internal.ads.zzck;
import com.google.android.gms.internal.ads.zzhv;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zzov;
import com.google.android.gms.internal.ads.zzow;
import com.google.android.gms.internal.ads.zzoy;
import com.google.android.gms.internal.ads.zzpk;
import com.google.android.gms.internal.ads.zzpm;
import com.google.android.gms.internal.ads.zzpn;
import com.google.android.gms.internal.ads.zzpo;
import com.google.android.gms.internal.ads.zzpp;
import com.google.android.gms.internal.ads.zzps;
import com.google.android.gms.internal.ads.zzqf;
import com.google.android.gms.internal.ads.zzqk;
import com.google.android.gms.internal.ads.zzql;
import com.google.android.gms.internal.ads.zzsc;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
@ParametersAreNonnullByDefault
public class zzpq
implements zzpm {
    private final Object mLock = new Object();
    private final zzpn zzbmc;
    private final Context mContext;
    private final zzow zzbmg;
    @Nullable
    private final JSONObject zzbmh;
    @Nullable
    private final zzadw zzaar;
    @Nullable
    private final zzpo zzbmi;
    private final zzck zzbmj;
    @Nullable
    private final zzaop zzys;
    @VisibleForTesting
    boolean zzbmk;
    @VisibleForTesting
    boolean zzbml;
    @Nullable
    private String zzaas;
    @Nullable
    private zzakc zzzi;
    @Nullable
    private zzqf zzbmm;
    private boolean zzbmf = false;
    private long zzbmn = 0L;
    private long zzbmo = 0L;
    private WeakReference<View> zzbmp = null;

    public zzpq(Context context, zzpn zzpn2, @Nullable zzadw zzadw2, zzck zzck2, @Nullable JSONObject jSONObject, @Nullable zzpo zzpo2, @Nullable zzaop zzaop2, @Nullable String string2) {
        this.mContext = context;
        this.zzbmc = zzpn2;
        this.zzaar = zzadw2;
        this.zzbmj = zzck2;
        this.zzbmh = jSONObject;
        this.zzbmi = zzpo2;
        this.zzys = zzaop2;
        this.zzaas = string2;
        this.zzbmg = new zzow(this.zzaar);
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zzov zzov2 = this.zzbmi.zzkz();
        if (zzov2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zzov2.zzku()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zzoy zzoy2 = new zzoy(this.mContext, zzov2, layoutParams);
        zzoy2.setOnClickListener(onClickListener);
        zznl zznl2 = zznw.zzben;
        zzoy2.setContentDescription((CharSequence)zzkd.zzjd().zzd(zznl2));
        return zzoy2;
    }

    @Override
    public boolean zzln() {
        zzov zzov2 = this.zzbmi.zzkz();
        return zzov2 != null && zzov2.zzkv();
    }

    @Override
    public boolean zzlp() {
        return this.zzbmh != null && this.zzbmh.optBoolean("allow_pub_owned_ad_view", false);
    }

    @Override
    public boolean zzlo() {
        return this.zzbmh != null && this.zzbmh.optBoolean("allow_custom_click_gesture", false);
    }

    private final boolean zzat(String string2) {
        JSONObject jSONObject = this.zzbmh == null ? null : this.zzbmh.optJSONObject("allow_pub_event_reporting");
        if (jSONObject == null) {
            return false;
        }
        return jSONObject.optBoolean(string2, false);
    }

    @Override
    public final void zza(View view, String string2, @Nullable Bundle bundle, Map<String, WeakReference<View>> map, View view2, boolean bl) {
        JSONObject jSONObject = this.zza(map, view2);
        JSONObject jSONObject2 = this.zzp(view2);
        JSONObject jSONObject3 = zzpq.zzq(view2);
        JSONObject jSONObject4 = this.zzr(view2);
        JSONObject jSONObject5 = null;
        try {
            JSONObject jSONObject6 = zzbv.zzek().zza(bundle, null);
            jSONObject5 = new JSONObject();
            jSONObject5.put("click_point", (Object)jSONObject6);
            jSONObject5.put("asset_id", (Object)string2);
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Error occurred while grabbing click signals.", (Throwable)exception);
        }
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        Preconditions.checkMainThread((String)"Invalid call from a non-UI thread.");
        if (map != null) {
            Map<String, WeakReference<View>> map2 = map;
            synchronized (map2) {
                for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                    View view3 = (View)entry.getValue().get();
                    if (!view.equals(view3)) continue;
                    this.zza(view, entry.getKey(), bundle, map, view2, false);
                    return;
                }
            }
        }
        if ("6".equals(this.zzbmi.zzky())) {
            this.zza(view, "3099", bundle, map, view2, false);
            return;
        }
        if ("2".equals(this.zzbmi.zzky())) {
            this.zza(view, "2099", bundle, map, view2, false);
            return;
        }
        if ("1".equals(this.zzbmi.zzky())) {
            this.zza(view, "1099", bundle, map, view2, false);
        }
    }

    @Override
    public final void performClick(Bundle bundle) {
        if (bundle == null) {
            zzalg.zzco((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzat("click_reporting")) {
            zzalg.e((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        String string2 = bundle.getBundle("click_signal").getString("asset_id");
        JSONObject jSONObject = zzbv.zzek().zza(bundle, null);
        this.zza(null, null, null, null, null, string2, null, jSONObject, false);
    }

    private final void zza(View view, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, String string2, JSONObject jSONObject5, JSONObject jSONObject6, boolean bl) {
        Preconditions.checkMainThread((String)"Invalid call from a non-UI thread.");
        try {
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("ad", (Object)this.zzbmh);
            if (jSONObject2 != null) {
                jSONObject7.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject7.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject5 != null) {
                jSONObject7.put("click_signal", (Object)jSONObject5);
            }
            if (jSONObject3 != null) {
                jSONObject7.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject7.put("lock_screen_signal", (Object)jSONObject4);
            }
            JSONObject jSONObject8 = new JSONObject();
            long l = zzbv.zzer().currentTimeMillis();
            jSONObject8.put("time_from_last_touch_down", l - this.zzbmo);
            jSONObject8.put("time_from_last_touch", l - this.zzbmn);
            jSONObject7.put("touch_signal", (Object)jSONObject8);
            JSONObject jSONObject9 = new JSONObject();
            jSONObject9.put("asset_id", (Object)string2);
            jSONObject9.put("template", (Object)this.zzbmi.zzky());
            zzbv.zzem();
            jSONObject9.put("is_privileged_process", zzalw.zzte());
            Object object = zznw.zzbes;
            if (((Boolean)zzkd.zzjd().zzd((zznl)object)).booleanValue() && this.zzbmg.zzkw() != null && this.zzbmh.optBoolean("custom_one_point_five_click_enabled", false)) {
                jSONObject9.put("custom_one_point_five_click_eligible", true);
            }
            jSONObject9.put("timestamp", l);
            jSONObject9.put("has_custom_click_handler", this.zzbmc.zzt(this.zzbmi.getCustomTemplateId()) != null);
            boolean bl2 = bl;
            JSONObject jSONObject10 = jSONObject9;
            object = this;
            if (((zzpq)object).zzbmf && ((zzpq)object).zzlo()) {
                jSONObject10.put("custom_click_gesture_eligible", true);
            }
            if (bl2) {
                jSONObject10.put("is_custom_click_gesture", true);
            }
            jSONObject7.put("has_custom_click_handler", this.zzbmc.zzt(this.zzbmi.getCustomTemplateId()) != null);
            try {
                JSONObject jSONObject11 = this.zzbmh.optJSONObject("tracking_urls_and_actions");
                if (jSONObject11 == null) {
                    jSONObject11 = new JSONObject();
                }
                String string3 = jSONObject11.optString("click_string");
                String string4 = this.zzbmj.zzaa().zza(this.mContext, string3, view);
                jSONObject9.put("click_signals", (Object)string4);
            }
            catch (Exception exception) {
                zzalg.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject7.put("click", (Object)jSONObject9);
            if (jSONObject6 != null) {
                jSONObject7.put("provided_signals", (Object)jSONObject6);
            }
            jSONObject7.put("ads_id", (Object)this.zzaas);
            zzaov.zza(this.zzaar.zzi(jSONObject7), "NativeAdEngineImpl.performClick");
            return;
        }
        catch (JSONException jSONException) {
            zzalg.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public void zzd(MotionEvent motionEvent) {
        this.zzbmn = zzbv.zzer().currentTimeMillis();
        if (motionEvent.getAction() == 0) {
            this.zzbmo = zzbv.zzer().currentTimeMillis();
        }
        this.zzbmj.zza(motionEvent);
    }

    @Override
    public final void reportTouchEvent(Bundle bundle) {
        if (bundle == null) {
            zzalg.zzco((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzat("touch_reporting")) {
            zzalg.e((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzbmj.zzaa().zza(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(View view, Map<String, WeakReference<View>> map) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbmk) {
                return;
            }
            if (zzpq.zzn(view)) {
                this.zza(view, map);
                return;
            }
            zznl zznl2 = zznw.zzber;
            if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue() && map != null) {
                Map<String, WeakReference<View>> map2 = map;
                synchronized (map2) {
                    Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        View view2 = (View)iterator.next().getValue().get();
                        if (view2 == null || !zzpq.zzn(view2)) continue;
                        this.zza(view, map);
                        return;
                    }
                }
            }
            return;
        }
    }

    private static boolean zzn(View view) {
        return view.isShown() && view.getGlobalVisibleRect(new Rect(), null);
    }

    @Override
    public void zzcq() {
        this.zzbmc.zzcq();
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map) {
        JSONObject jSONObject = this.zzp(view);
        JSONObject jSONObject2 = this.zza(map, view);
        JSONObject jSONObject3 = zzpq.zzq(view);
        JSONObject jSONObject4 = this.zzr(view);
        this.zza(jSONObject, jSONObject2, jSONObject3, jSONObject4, null);
    }

    @Override
    public final boolean recordImpression(Bundle bundle) {
        if (!this.zzat("impression_reporting")) {
            zzalg.e((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzbv.zzek().zza(bundle, null);
        return this.zza(null, null, null, null, jSONObject);
    }

    private final boolean zza(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, JSONObject jSONObject5) {
        Preconditions.checkMainThread((String)"Invalid call from a non-UI thread.");
        if (this.zzbmk) {
            return true;
        }
        this.zzbmk = true;
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzbmh);
            jSONObject6.put("ads_id", (Object)this.zzaas);
            if (jSONObject2 != null) {
                jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject6.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject3 != null) {
                jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject6.put("lock_screen_signal", (Object)jSONObject4);
            }
            if (jSONObject5 != null) {
                jSONObject6.put("provided_signals", (Object)jSONObject5);
            }
            zzaov.zza(this.zzaar.zzj(jSONObject6), "NativeAdEngineImpl.recordImpression");
        }
        catch (JSONException jSONException) {
            zzalg.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        this.zzbmc.zza(this);
        this.zzbmc.zzbv();
        this.zzcq();
        return true;
    }

    @Override
    public void zzlq() {
        Preconditions.checkMainThread((String)"Invalid call from a non-UI thread.");
        if (this.zzbml) {
            return;
        }
        this.zzbml = true;
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzbmh);
            jSONObject.put("ads_id", (Object)this.zzaas);
            zzaov.zza(this.zzaar.zzk(jSONObject), "NativeAdEngineImpl.recordDownloadedImpression");
            return;
        }
        catch (JSONException jSONException) {
            zzaok.zzb((String)"", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final View zzlw() {
        if (this.zzbmp != null) {
            return (View)this.zzbmp.get();
        }
        return null;
    }

    @Override
    public final void zzm(View view) {
        this.zzbmp = new WeakReference<View>(view);
    }

    @Override
    public final void zzj(View view) {
        zzcg zzcg2;
        zznl zznl2 = zznw.zzbdo;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return;
        }
        if (this.zzbmj != null && (zzcg2 = this.zzbmj.zzaa()) != null) {
            zzcg2.zzb(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        View view2;
        Iterator<Map.Entry<String, WeakReference<View>>> iterator;
        Map<String, WeakReference<View>> map3;
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map != null) {
            map3 = map;
            synchronized (map3) {
                iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    view2 = (View)iterator.next().getValue().get();
                    if (view2 == null) continue;
                    view2.setOnTouchListener(onTouchListener);
                    view2.setClickable(true);
                    view2.setOnClickListener(onClickListener);
                }
            }
        }
        if (map2 != null) {
            map3 = map2;
            synchronized (map3) {
                iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    view2 = (View)iterator.next().getValue().get();
                    if (view2 == null) continue;
                    view2.setOnTouchListener(onTouchListener);
                }
                return;
            }
        }
    }

    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
    }

    public zzasg zzlt() throws zzasq {
        if (this.zzbmh == null || this.zzbmh.optJSONObject("overlay") == null) {
            return null;
        }
        zzpq zzpq2 = this;
        zzbv.zzel();
        zzaop zzaop2 = zzpq2.zzys;
        zzck zzck2 = zzpq2.zzbmj;
        zzjo zzjo2 = zzjo.zzf((Context)zzpq2.mContext);
        Context context = zzpq2.mContext;
        zzasg zzasg2 = zzasm.zza(context, zzatt.zzb(zzjo2), zzjo2.zzauq, false, false, zzck2, zzaop2, null, null, null, zzhv.zzhm());
        if (zzasg2 != null) {
            zzasg2.getView().setVisibility(8);
            new zzps(zzasg2).zza(this.zzaar);
        }
        return zzasg2;
    }

    public final void zzf(Map<String, WeakReference<View>> map) {
        if (this.zzbmi.zzla() != null) {
            if ("2".equals(this.zzbmi.zzky())) {
                zzbv.zzeo().zzru().zzb(this.zzbmc.getAdUnitId(), this.zzbmi.zzky(), map != null && (map.containsKey("2011") || map.containsKey("3010")));
                return;
            }
            if ("1".equals(this.zzbmi.zzky())) {
                zzbv.zzeo().zzru().zzb(this.zzbmc.getAdUnitId(), this.zzbmi.zzky(), map != null && (map.containsKey("1009") || map.containsKey("3010")));
            }
        }
    }

    public final boolean zzb(View view, zzpk zzpk2) {
        zznl zznl2 = zznw.zzbeq;
        FrameLayout.LayoutParams layoutParams = (Boolean)zzkd.zzjd().zzd(zznl2) != false ? new FrameLayout.LayoutParams(-1, -1, 17) : new FrameLayout.LayoutParams(-2, -2, 17);
        View view2 = this.zzbmi.zzla();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).removeAllViews();
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzbmc.zza(zzpk2);
            return true;
        }
        return false;
    }

    public final void zzi(View view) {
        this.zzbmc.zzi(view);
    }

    @Override
    public final void zza(View view, zzpk zzpk2) {
        Object object;
        zzqk zzqk2;
        if (this.zzb(view, zzpk2)) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        ((FrameLayout)view).removeAllViews();
        if (!(this.zzbmi instanceof zzpp)) {
            return;
        }
        zzpp zzpp2 = (zzpp)this.zzbmi;
        if (zzpp2.getImages() != null && zzpp2.getImages().size() > 0 && (zzqk2 = (object = zzpp2.getImages().get(0)) instanceof IBinder ? zzql.zzj((IBinder)((IBinder)object)) : null) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzqk2.zzld();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
                    object = this;
                    ImageView imageView = new ImageView(((zzpq)object).mContext);
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
                return;
            }
            catch (RemoteException remoteException) {
                zzalg.zzdp((String)"Could not get drawable from image");
            }
        }
    }

    @Override
    public void zza(zzsc zzsc2) {
        zznl zznl2 = zznw.zzbes;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return;
        }
        if (!this.zzbmh.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzalg.zzdp((String)"setUnconfirmedClickListener: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        this.zzbmg.zza(zzsc2);
    }

    @Override
    public void cancelUnconfirmedClick() {
        zznl zznl2 = zznw.zzbes;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            return;
        }
        if (!this.zzbmh.optBoolean("custom_one_point_five_click_enabled", false)) {
            return;
        }
        this.zzbmg.cancelUnconfirmedClick();
    }

    @Override
    public void setClickConfirmingView(View view) {
        Object object = zznw.zzbes;
        if (!((Boolean)zzkd.zzjd().zzd(object)).booleanValue()) {
            return;
        }
        if (!this.zzbmh.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzalg.zzdp((String)"setClickConfirmingView: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        View view2 = view;
        object = this.zzbmg;
        if (view2 != null) {
            view2.setOnClickListener((View.OnClickListener)object);
            view2.setClickable(true);
            object.zzbkq = new WeakReference<View>(view2);
        }
    }

    @Override
    public void zzll() {
        this.zzbmf = true;
    }

    @Override
    public void zzlm() {
        if (this.zzbmm == null) {
            zzalg.zzco((String)"Ad should be associated with an ad view before calling recordCustomClickGesture()");
            return;
        }
        if (!this.zzbmf) {
            zzalg.zzco((String)"Custom click reporting failed. enableCustomClickGesture is not set.");
            return;
        }
        if (!this.zzlo()) {
            zzalg.zzco((String)"Custom click reporting failed. Ad unit id not whitelisted.");
            return;
        }
        this.zza(this.zzbmm.zzma(), "3099", null, this.zzbmm.zzlz(), this.zzbmm.zzma(), true);
    }

    public final void zza(zzqf zzqf2) {
        this.zzbmm = zzqf2;
    }

    @Nullable
    public final zzqf zzlx() {
        return this.zzbmm;
    }

    @Override
    public void zzlv() {
        this.zzbmc.zzcs();
    }

    @Override
    public void zzcr() {
        this.zzbmc.zzcr();
    }

    @Override
    public void zzlu() {
        this.zzaar.zznk();
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @VisibleForTesting
    private static int[] zzo(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    @VisibleForTesting
    private final int zzaa(int n) {
        zzkd.zziz();
        return zzaoa.zzb((Context)this.mContext, (int)n);
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzaa(rect.right - rect.left));
        jSONObject.put("height", this.zzaa(rect.bottom - rect.top));
        jSONObject.put("x", this.zzaa(rect.left));
        jSONObject.put("y", this.zzaa(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzp(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = zzpq.zzo(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzaa(view.getMeasuredWidth()));
            jSONObject3.put("height", this.zzaa(view.getMeasuredHeight()));
            jSONObject3.put("x", this.zzaa(nArray[0]));
            jSONObject3.put("y", this.zzaa(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("x", this.zzaa(nArray[0]));
                jSONObject2.put("y", this.zzaa(nArray[1]));
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzalg.zzdp((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private static JSONObject zzq(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbv.zzek();
            int n = zzalo.zzy(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zzr(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbv.zzek();
            jSONObject.put("can_show_on_lock_screen", zzalo.zzx(view));
            zzbv.zzek();
            jSONObject.put("is_keyguard_locked", zzalo.zzat(this.mContext));
        }
        catch (JSONException jSONException) {
            zzalg.zzdp((String)"Unable to get lock screen information");
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzpq.zzo(view);
        Map<String, WeakReference<View>> map2 = map;
        synchronized (map2) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (view2 == null) continue;
                int[] nArray2 = zzpq.zzo(view2);
                JSONObject jSONObject2 = new JSONObject();
                JSONObject jSONObject3 = new JSONObject();
                try {
                    JSONObject jSONObject4;
                    jSONObject3.put("width", this.zzaa(view2.getMeasuredWidth()));
                    jSONObject3.put("height", this.zzaa(view2.getMeasuredHeight()));
                    jSONObject3.put("x", this.zzaa(nArray2[0] - nArray[0]));
                    jSONObject3.put("y", this.zzaa(nArray2[1] - nArray[1]));
                    jSONObject3.put("relative_to", (Object)"ad_view");
                    jSONObject2.put("frame", (Object)jSONObject3);
                    Rect rect = new Rect();
                    if (view2.getLocalVisibleRect(rect)) {
                        jSONObject4 = this.zzb(rect);
                    } else {
                        jSONObject4 = new JSONObject();
                        jSONObject4.put("width", 0);
                        jSONObject4.put("height", 0);
                        jSONObject4.put("x", this.zzaa(nArray2[0] - nArray[0]));
                        jSONObject4.put("y", this.zzaa(nArray2[1] - nArray[1]));
                        jSONObject4.put("relative_to", (Object)"ad_view");
                    }
                    jSONObject2.put("visible_bounds", (Object)jSONObject4);
                    if (view2 instanceof TextView) {
                        TextView textView = (TextView)view2;
                        jSONObject2.put("text_color", textView.getCurrentTextColor());
                        jSONObject2.put("font_size", (double)textView.getTextSize());
                        jSONObject2.put("text", (Object)textView.getText());
                    }
                    jSONObject.put(entry.getKey(), (Object)jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzalg.zzdp((String)"Unable to get asset views information");
                }
            }
        }
        return jSONObject;
    }

    @Nullable
    public final zzakc zzly() {
        if (zzbv.zzfj().zzu(this.mContext)) {
            if (this.zzzi == null) {
                this.zzzi = new zzakc(this.mContext, this.zzbmc.getAdUnitId());
            }
            return this.zzzi;
        }
        return null;
    }
}

