/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzahh;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzjk;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zztr;
import com.google.android.gms.internal.ads.zzuw;
import com.google.android.gms.internal.ads.zzux;
import com.google.android.gms.internal.ads.zzuy;
import com.google.android.gms.internal.ads.zzuz;
import com.google.android.gms.internal.ads.zzvb;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;

@zzaer
@ParametersAreNonnullByDefault
public final class zzuv {
    private final Map<zzuw, zzux> zzbrj = new HashMap<zzuw, zzux>();
    private final LinkedList<zzuw> zzbrk = new LinkedList();
    @Nullable
    private zztr zzbrl;

    final void zza(zztr zztr2) {
        if (this.zzbrl == null) {
            this.zzbrl = zztr2.zzmk();
            zzuv zzuv2 = this;
            if (zzuv2.zzbrl != null) {
                SharedPreferences sharedPreferences = zzuv2.zzbrl.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
                zzuv zzuv3 = zzuv2;
                while (zzuv3.zzbrk.size() > 0) {
                    zzuw zzuw2 = zzuv3.zzbrk.remove();
                    zzux zzux2 = zzuv3.zzbrj.get(zzuw2);
                    zzuv.zza("Flushing interstitial queue for %s.", zzuw2);
                    while (zzux2.size() > 0) {
                        zzux2.zzl(null).zzbrq.zzdj();
                    }
                    zzuv3.zzbrj.remove(zzuw2);
                }
                try {
                    zzuw zzuw2;
                    HashMap<String, zzuw> hashMap = new HashMap<String, zzuw>();
                    for (Map.Entry stringArray : sharedPreferences.getAll().entrySet()) {
                        if (((String)stringArray.getKey()).equals("PoolKeys")) continue;
                        zzvb zzvb2 = zzvb.zzbd((String)stringArray.getValue());
                        zzuw2 = new zzuw(zzvb2.zzabf, zzvb2.zzyr, zzvb2.zzbro);
                        if (zzuv2.zzbrj.containsKey(zzuw2)) continue;
                        zzux zzux2 = new zzux(zzvb2.zzabf, zzvb2.zzyr, zzvb2.zzbro);
                        zzuv2.zzbrj.put(zzuw2, zzux2);
                        hashMap.put(zzuw2.toString(), zzuw2);
                        zzuv.zza("Restored interstitial queue for %s.", zzuw2);
                    }
                    for (String string2 : zzuv.zzba(sharedPreferences.getString("PoolKeys", ""))) {
                        zzuw2 = (zzuw)hashMap.get(string2);
                        if (!zzuv2.zzbrj.containsKey(zzuw2)) continue;
                        zzuv2.zzbrk.add(zzuw2);
                    }
                    return;
                }
                catch (IOException | RuntimeException exception) {
                    zzbv.zzeo().zza(exception, "InterstitialAdPool.restore");
                    zzalg.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
                    zzuv2.zzbrj.clear();
                    zzuv2.zzbrk.clear();
                }
            }
        }
    }

    @Nullable
    final zzuy zza(zzjk zzjk2, String string2) {
        Object object;
        Object object2;
        zznl zznl2;
        String string3;
        if (zzuv.zzbb(string2)) {
            return null;
        }
        Context context = this.zzbrl.getApplicationContext();
        int n = new zzahh((Context)context).zzqb().zzcnj;
        zzjk zzjk3 = zzuv.zzj(zzjk2);
        zzuw zzuw2 = new zzuw(zzjk3, string3 = zzuv.zzbc(string2), n);
        zzux zzux2 = this.zzbrj.get(zzuw2);
        if (zzux2 == null) {
            zzuv.zza("Interstitial pool created at %s.", zzuw2);
            zzux2 = new zzux(zzjk3, string3, n);
            this.zzbrj.put(zzuw2, zzux2);
        }
        this.zzbrk.remove(zzuw2);
        this.zzbrk.add(zzuw2);
        zzux2.zzmq();
        while (true) {
            zznl2 = zznw.zzbch;
            if (this.zzbrk.size() <= (Integer)zzkd.zzjd().zzd(zznl2)) break;
            object2 = this.zzbrk.remove();
            object = this.zzbrj.get(object2);
            zzuv.zza("Evicting interstitial queue for %s.", (zzuw)object2);
            while (((zzux)object).size() > 0) {
                zzuy zzuy2 = ((zzux)object).zzl(null);
                if (zzuy2.zzwn) {
                    zzuz.zzms().zzmu();
                }
                zzuy2.zzbrq.zzdj();
            }
            this.zzbrj.remove(object2);
        }
        while (zzux2.size() > 0) {
            object2 = zzux2.zzl(zzjk3);
            if (((zzuy)object2).zzwn) {
                zznl2 = zznw.zzbcj;
                if (zzbv.zzer().currentTimeMillis() - ((zzuy)object2).zzbrt > 1000L * (long)((Integer)zzkd.zzjd().zzd(zznl2)).intValue()) {
                    zzuv.zza("Expired interstitial at %s.", zzuw2);
                    zzuz.zzms().zzmt();
                    continue;
                }
            }
            object = ((zzuy)object2).zzbrr != null ? " (inline) " : " ";
            zzuv.zza(new StringBuilder(34 + String.valueOf(object).length()).append("Pooled interstitial").append((String)object).append("returned at %s.").toString(), zzuw2);
            return object2;
        }
        return null;
    }

    final void zzb(zzjk zzjk2, String string2) {
        String string3;
        if (this.zzbrl == null) {
            return;
        }
        Context context = this.zzbrl.getApplicationContext();
        int n = new zzahh((Context)context).zzqb().zzcnj;
        zzjk zzjk3 = zzuv.zzj(zzjk2);
        zzuw zzuw2 = new zzuw(zzjk3, string3 = zzuv.zzbc(string2), n);
        zzux zzux2 = this.zzbrj.get(zzuw2);
        if (zzux2 == null) {
            zzuv.zza("Interstitial pool created at %s.", zzuw2);
            zzux2 = new zzux(zzjk3, string3, n);
            this.zzbrj.put(zzuw2, zzux2);
        }
        zzux2.zza(this.zzbrl, zzjk2);
        zzux2.zzmq();
        zzuv.zza("Inline entry added to the queue at %s.", zzuw2);
    }

    final void zzml() {
        zzuv zzuv2;
        if (this.zzbrl == null) {
            return;
        }
        for (Map.Entry<zzuw, zzux> entry : this.zzbrj.entrySet()) {
            int n;
            zzuw zzuw2 = entry.getKey();
            zzux zzux2 = entry.getValue();
            if (zzalg.isLoggable((int)2)) {
                n = zzux2.size();
                int n2 = zzux2.zzmo();
                if (n2 < n) {
                    zzalg.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzuw2));
                }
            }
            n = 0 + zzux2.zzmp();
            while (true) {
                zzuv2 = zznw.zzbci;
                if (zzux2.size() >= (Integer)zzkd.zzjd().zzd((zznl)zzuv2)) break;
                zzuv.zza("Pooling and loading one new interstitial for %s.", zzuw2);
                if (!zzux2.zzb(this.zzbrl)) continue;
                ++n;
            }
            zzuz.zzms().zzad(n);
        }
        zzuv2 = this;
        if (zzuv2.zzbrl != null) {
            SharedPreferences.Editor editor = zzuv2.zzbrl.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0).edit();
            editor.clear();
            for (Map.Entry<zzuw, zzux> entry : zzuv2.zzbrj.entrySet()) {
                zzuw zzuw3 = entry.getKey();
                zzux zzux3 = entry.getValue();
                if (!zzux3.zzmr()) continue;
                String string2 = new zzvb(zzux3).zznc();
                String string3 = zzuw3.toString();
                editor.putString(string3, string2);
                zzuv.zza("Saved interstitial queue for %s.", zzuw3);
            }
            editor.putString("PoolKeys", zzuv2.zzmm());
            editor.apply();
        }
    }

    private final String zzmm() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbrk.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzuw)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String[] zzba(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static boolean zzbb(String string2) {
        try {
            zznl zznl2 = zznw.zzbck;
            return Pattern.matches((String)zzkd.zzjd().zzd(zznl2), string2);
        }
        catch (RuntimeException runtimeException) {
            zzbv.zzeo().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zzh(zzjk zzjk2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzjk2.extras.keySet());
        Bundle bundle = zzjk2.zzatr.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zzjk zzi(zzjk zzjk2) {
        zzjk zzjk3 = zzuv.zzk(zzjk2);
        String string2 = "_skipMediation";
        zzjk zzjk4 = zzjk3;
        Bundle bundle = zzjk3.zzatr.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            bundle.putBoolean(string2, true);
        }
        zzjk4.extras.putBoolean(string2, true);
        return zzjk3;
    }

    @VisibleForTesting
    private static zzjk zzj(zzjk zzjk2) {
        zzjk zzjk3 = zzuv.zzk(zzjk2);
        zznl zznl2 = zznw.zzbcg;
        for (String string2 : ((String)zzkd.zzjd().zzd(zznl2)).split(",")) {
            zzuv.zzb(zzjk3.zzatr, string2);
            String string3 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string2.startsWith(string3)) continue;
            String string4 = string2.replaceFirst(string3, "");
            zzuv.zzb(zzjk3.extras, string4);
        }
        return zzjk3;
    }

    @VisibleForTesting
    private static String zzbc(String string2) {
        try {
            Matcher matcher = Pattern.compile("([^/]+/[0-9]+).*").matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    @VisibleForTesting
    private static zzjk zzk(zzjk zzjk2) {
        Parcel parcel = Parcel.obtain();
        zzjk2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzjk zzjk3 = (zzjk)zzjk.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzjk3.zziq();
    }

    private static void zzb(Bundle bundle, String string2) {
        String[] stringArray;
        while ((stringArray = string2.split("/", 2)).length != 0) {
            String string3 = stringArray[0];
            if (stringArray.length == 1) {
                bundle.remove(string3);
                return;
            }
            Bundle bundle2 = bundle.getBundle(string3);
            if (bundle2 == null) {
                return;
            }
            string2 = stringArray[1];
            bundle = bundle2;
        }
        return;
    }

    private static void zza(String string2, zzuw zzuw2) {
        if (zzalg.isLoggable((int)2)) {
            zzalg.v(String.format(string2, zzuw2));
        }
    }
}

