/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzaqb;
import com.google.android.gms.internal.ads.zzaqh;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzaxo;
import com.google.android.gms.internal.ads.zzbgz;
import com.google.android.gms.internal.ads.zzbhf;
import com.google.android.gms.internal.ads.zzbii;
import com.google.android.gms.internal.ads.zzwj;
import com.google.android.gms.internal.ads.zzyt;
import java.util.Collections;

@zzard
public class zzd
extends zzaqh
implements zzx {
    @VisibleForTesting
    private static final int zzdjk = Color.argb((int)0, (int)0, (int)0, (int)0);
    protected final Activity mActivity;
    @VisibleForTesting
    AdOverlayInfoParcel zzdjl;
    @VisibleForTesting
    zzbgz zzdjm;
    @VisibleForTesting
    private zzj zzdjn;
    @VisibleForTesting
    private zzp zzdjo;
    @VisibleForTesting
    private boolean zzdjp = false;
    @VisibleForTesting
    private FrameLayout zzdjq;
    @VisibleForTesting
    private WebChromeClient.CustomViewCallback zzdjr;
    @VisibleForTesting
    private boolean zzdjs = false;
    @VisibleForTesting
    private boolean zzdjt = false;
    @VisibleForTesting
    private zzi zzdju;
    @VisibleForTesting
    private boolean zzdjv = false;
    @VisibleForTesting
    int zzdjw = 0;
    private final Object zzdjx = new Object();
    private Runnable zzdjy;
    private boolean zzdjz;
    private boolean zzdka;
    private boolean zzdkb = false;
    private boolean zzdkc = false;
    private boolean zzdkd = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzdjw = 2;
        this.mActivity.finish();
    }

    public final void zzte() {
        if (this.zzdjl != null && this.zzdjp) {
            this.setRequestedOrientation(this.zzdjl.orientation);
        }
        if (this.zzdjq != null) {
            this.mActivity.setContentView((View)this.zzdju);
            this.zzdka = true;
            this.zzdjq.removeAllViews();
            this.zzdjq = null;
        }
        if (this.zzdjr != null) {
            this.zzdjr.onCustomViewHidden();
            this.zzdjr = null;
        }
        this.zzdjp = false;
    }

    @Override
    public final void zztf() {
        this.zzdjw = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzdjw = 0;
    }

    public final boolean zztg() {
        this.zzdjw = 0;
        if (this.zzdjm == null) {
            return true;
        }
        boolean bl = this.zzdjm.zzaap();
        if (!bl) {
            this.zzdjm.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzdjs = bundle != null && bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false);
        try {
            this.zzdjl = AdOverlayInfoParcel.zzc(this.mActivity.getIntent());
            if (this.zzdjl == null) {
                throw new zzh("Could not get info for ad overlay.");
            }
            if (this.zzdjl.zzbtc.zzdzd > 7500000) {
                this.zzdjw = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzdkd = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzdjt = this.zzdjl.zzdkt != null ? this.zzdjl.zzdkt.zzbre : false;
            if (this.zzdjt && this.zzdjl.zzdkt.zzbrj != -1) {
                new com.google.android.gms.ads.internal.overlay.zzk(this, null).zzvi();
            }
            if (bundle == null) {
                if (this.zzdjl.zzdkm != null && this.zzdkd) {
                    this.zzdjl.zzdkm.zzta();
                }
                if (this.zzdjl.zzdkr != 1 && this.zzdjl.zzcgi != null) {
                    this.zzdjl.zzcgi.onAdClicked();
                }
            }
            this.zzdju = new zzi((Context)this.mActivity, this.zzdjl.zzdks, this.zzdjl.zzbtc.zzbsx);
            this.zzdju.setId(1000);
            zzk.zzli().zzg(this.mActivity);
            switch (this.zzdjl.zzdkr) {
                case 1: {
                    this.zzad(false);
                    return;
                }
                case 2: {
                    this.zzdjn = new zzj(this.zzdjl.zzdbs);
                    this.zzad(false);
                    return;
                }
                case 3: {
                    this.zzad(true);
                    return;
                }
            }
            throw new zzh("Could not determine ad overlay type.");
        }
        catch (zzh zzh2) {
            zzawz.zzep((String)zzh2.getMessage());
            this.zzdjw = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzacj zzacj2 = zzacu.zzcui;
        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            if (this.zzdjm != null && !this.zzdjm.isDestroyed()) {
                zzk.zzli();
                zzaxo.zzb(this.zzdjm);
                return;
            }
            zzawz.zzep((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzdjl.zzdkm != null) {
            this.zzdjl.zzdkm.onResume();
        }
        this.zza(this.mActivity.getResources().getConfiguration());
        zzacj zzacj2 = zzacu.zzcui;
        if (!((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            if (this.zzdjm != null && !this.zzdjm.isDestroyed()) {
                zzk.zzli();
                zzaxo.zzb(this.zzdjm);
                return;
            }
            zzawz.zzep((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzte();
        if (this.zzdjl.zzdkm != null) {
            this.zzdjl.zzdkm.onPause();
        }
        zzacj zzacj2 = zzacu.zzcui;
        if (!(((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue() || this.zzdjm == null || this.mActivity.isFinishing() && this.zzdjn != null)) {
            zzk.zzli();
            zzaxo.zza(this.zzdjm);
        }
        this.zzti();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzac(IObjectWrapper iObjectWrapper) {
        Configuration configuration = (Configuration)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza(configuration);
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzdjs);
    }

    public final void onStop() {
        zzacj zzacj2 = zzacu.zzcui;
        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue() && this.zzdjm != null && (!this.mActivity.isFinishing() || this.zzdjn == null)) {
            zzk.zzli();
            zzaxo.zza(this.zzdjm);
        }
        this.zzti();
    }

    public final void onDestroy() {
        if (this.zzdjm != null) {
            this.zzdju.removeView(this.zzdjm.getView());
        }
        this.zzti();
    }

    private final void zzac(boolean bl) {
        zzacj zzacj2 = zzacu.zzcuk;
        int n = (Integer)zzyt.zzpe().zzd(zzacj2);
        zzq zzq2 = new zzq();
        new zzq().size = 50;
        zzq2.paddingLeft = bl ? n : 0;
        zzq2.paddingRight = bl ? 0 : n;
        zzq2.paddingTop = 0;
        zzq2.paddingBottom = n;
        this.zzdjo = new zzp((Context)this.mActivity, zzq2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zza(bl, this.zzdjl.zzdko);
        this.zzdju.addView((View)this.zzdjo, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzdd() {
        this.zzdka = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        boolean bl3;
        zzacj zzacj2 = zzacu.zzcpe;
        boolean bl4 = (Boolean)zzyt.zzpe().zzd(zzacj2) != false && this.zzdjl != null && this.zzdjl.zzdkt != null && this.zzdjl.zzdkt.zzbrl;
        zzacj2 = zzacu.zzcpf;
        boolean bl5 = bl3 = (Boolean)zzyt.zzpe().zzd(zzacj2) != false && this.zzdjl != null && this.zzdjl.zzdkt != null && this.zzdjl.zzdkt.zzbrm;
        if (bl && bl2 && bl4 && !bl3) {
            new zzaqb(this.zzdjm, "useCustomClose").zzdh("Custom close has been disabled for interstitial ads in this ad slot.");
        }
        if (this.zzdjo != null) {
            this.zzdjo.zzaf(bl3 || bl2 && !bl4);
        }
    }

    public final void zzth() {
        this.zzdju.removeView((View)this.zzdjo);
        this.zzac(true);
    }

    public final void setRequestedOrientation(int n) {
        zzacj zzacj2 = zzacu.zzcwg;
        if (this.mActivity.getApplicationInfo().targetSdkVersion >= (Integer)zzyt.zzpe().zzd(zzacj2)) {
            zzacj2 = zzacu.zzcwh;
            if (this.mActivity.getApplicationInfo().targetSdkVersion <= (Integer)zzyt.zzpe().zzd(zzacj2)) {
                zzacj2 = zzacu.zzcwi;
                if (Build.VERSION.SDK_INT >= (Integer)zzyt.zzpe().zzd(zzacj2)) {
                    zzacj2 = zzacu.zzcwj;
                    if (Build.VERSION.SDK_INT <= (Integer)zzyt.zzpe().zzd(zzacj2)) {
                        return;
                    }
                }
            }
        }
        try {
            this.mActivity.setRequestedOrientation(n);
            return;
        }
        catch (Throwable throwable) {
            zzk.zzlk().zzb(throwable, "AdOverlay.setRequestedOrientation");
            return;
        }
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzdjq = new FrameLayout((Context)this.mActivity);
        this.zzdjq.setBackgroundColor(-16777216);
        this.zzdjq.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzdjq);
        this.zzdka = true;
        this.zzdjr = customViewCallback;
        this.zzdjp = true;
    }

    private final void zzad(boolean bl) throws zzh {
        ViewParent viewParent;
        Window window;
        if (!this.zzdka) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzh("Invalid activity, no window available.");
        }
        zzbii zzbii2 = this.zzdjl.zzdbs != null ? this.zzdjl.zzdbs.zzaai() : null;
        boolean bl2 = zzbii2 != null && zzbii2.zzaay();
        this.zzdjv = false;
        if (bl2) {
            int n = this.zzdjl.orientation;
            zzk.zzli();
            if (n == 6) {
                this.zzdjv = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else {
                int n2 = this.zzdjl.orientation;
                zzk.zzli();
                if (n2 == 7) {
                    this.zzdjv = this.mActivity.getResources().getConfiguration().orientation == 2;
                }
            }
        }
        boolean bl3 = this.zzdjv;
        zzawz.zzdp((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl3).toString());
        this.setRequestedOrientation(this.zzdjl.orientation);
        zzk.zzli();
        window.setFlags(0x1000000, 0x1000000);
        zzawz.zzdp((String)"Hardware acceleration on the AdActivity window enabled.");
        if (!this.zzdjt) {
            this.zzdju.setBackgroundColor(-16777216);
        } else {
            this.zzdju.setBackgroundColor(zzdjk);
        }
        this.mActivity.setContentView((View)this.zzdju);
        this.zzdka = true;
        if (bl) {
            try {
                zzk.zzlh();
                this.zzdjm = zzbhf.zza((Context)this.mActivity, this.zzdjl.zzdbs != null ? this.zzdjl.zzdbs.zzaag() : null, this.zzdjl.zzdbs != null ? this.zzdjl.zzdbs.zzaah() : null, true, bl2, null, this.zzdjl.zzbtc, null, null, this.zzdjl.zzdbs != null ? this.zzdjl.zzdbs.zzye() : null, zzwj.zznl());
            }
            catch (Exception exception) {
                zzawz.zzc((String)"Error obtaining webview.", (Throwable)exception);
                throw new zzh("Could not obtain webview for the overlay.");
            }
            this.zzdjm.zzaai().zza(null, this.zzdjl.zzczo, null, this.zzdjl.zzczp, this.zzdjl.zzdkq, true, null, this.zzdjl.zzdbs != null ? this.zzdjl.zzdbs.zzaai().zzaax() : null, null, null);
            this.zzdjm.zzaai().zza(new zze(this));
            if (this.zzdjl.url != null) {
                this.zzdjm.loadUrl(this.zzdjl.url);
            } else if (this.zzdjl.zzdkp != null) {
                this.zzdjm.loadDataWithBaseURL(this.zzdjl.zzdkn, this.zzdjl.zzdkp, "text/html", "UTF-8", null);
            } else {
                throw new zzh("No URL or HTML to display in ad overlay.");
            }
            if (this.zzdjl.zzdbs != null) {
                this.zzdjl.zzdbs.zzb(this);
            }
        } else {
            this.zzdjm = this.zzdjl.zzdbs;
            this.zzdjm.zzbn((Context)this.mActivity);
        }
        this.zzdjm.zza(this);
        if (this.zzdjl.zzdbs != null) {
            zzd.zzb(this.zzdjl.zzdbs.zzaam(), (View)this.zzdju);
        }
        if ((viewParent = this.zzdjm.getParent()) != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzdjm.getView());
        }
        if (this.zzdjt) {
            this.zzdjm.zzaau();
        }
        this.zzdju.addView(this.zzdjm.getView(), -1, -1);
        if (!bl && !this.zzdjv) {
            this.zztl();
        }
        this.zzac(bl2);
        if (this.zzdjm.zzaak()) {
            this.zza(bl2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzti() {
        if (!this.mActivity.isFinishing() || this.zzdkb) {
            return;
        }
        this.zzdkb = true;
        if (this.zzdjm != null) {
            int n = this.zzdjw;
            this.zzdjm.zzdi(n);
            Object object = this.zzdjx;
            synchronized (object) {
                if (!this.zzdjz && this.zzdjm.zzaaq()) {
                    this.zzdjy = new zzf(this);
                    zzacj zzacj2 = zzacu.zzcpd;
                    zzaxi.zzdvv.postDelayed(this.zzdjy, ((Long)zzyt.zzpe().zzd(zzacj2)).longValue());
                    return;
                }
            }
        }
        this.zztj();
    }

    @VisibleForTesting
    final void zztj() {
        if (this.zzdkc) {
            return;
        }
        this.zzdkc = true;
        if (this.zzdjm != null) {
            this.zzdju.removeView(this.zzdjm.getView());
            if (this.zzdjn != null) {
                this.zzdjm.zzbn(this.zzdjn.zzlj);
                this.zzdjm.zzaq(false);
                this.zzdjn.parent.addView(this.zzdjm.getView(), this.zzdjn.index, this.zzdjn.zzdkh);
                this.zzdjn = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzdjm.zzbn(this.mActivity.getApplicationContext());
            }
            this.zzdjm = null;
        }
        if (this.zzdjl != null && this.zzdjl.zzdkm != null) {
            this.zzdjl.zzdkm.zzsz();
        }
        if (this.zzdjl != null && this.zzdjl.zzdbs != null) {
            zzd.zzb(this.zzdjl.zzdbs.zzaam(), this.zzdjl.zzdbs.getView());
        }
    }

    private static void zzb(@Nullable IObjectWrapper iObjectWrapper, @Nullable View view) {
        if (iObjectWrapper != null && view != null) {
            zzk.zzlv().zza(iObjectWrapper, view);
        }
    }

    public final void zztk() {
        if (this.zzdjv) {
            this.zzdjv = false;
            this.zztl();
        }
    }

    private final void zztl() {
        this.zzdjm.zztl();
    }

    public final void zztm() {
        this.zzdju.zzdkg = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zztn() {
        Object object = this.zzdjx;
        synchronized (object) {
            this.zzdjz = true;
            if (this.zzdjy != null) {
                zzaxi.zzdvv.removeCallbacks(this.zzdjy);
                zzaxi.zzdvv.post(this.zzdjy);
            }
            return;
        }
    }

    private final void zza(Configuration configuration) {
        boolean bl = this.zzdjl.zzdkt != null && this.zzdjl.zzdkt.zzbrf;
        boolean bl2 = zzk.zzli().zza(this.mActivity, configuration);
        boolean bl3 = false;
        boolean bl4 = false;
        if (!(this.zzdjt && !bl || bl2)) {
            bl3 = true;
            if (Build.VERSION.SDK_INT >= 19 && this.zzdjl.zzdkt != null && this.zzdjl.zzdkt.zzbrk) {
                bl4 = true;
            }
        }
        Window window = this.mActivity.getWindow();
        zzacj zzacj2 = zzacu.zzcpg;
        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue() && Build.VERSION.SDK_INT >= 19) {
            View view = window.getDecorView();
            int n = 256;
            if (bl3) {
                n = 5380;
                if (bl4) {
                    n = 5894;
                }
            }
            view.setSystemUiVisibility(n);
            return;
        }
        if (bl3) {
            window.addFlags(1024);
            window.clearFlags(2048);
            if (Build.VERSION.SDK_INT >= 19 && bl4) {
                window.getDecorView().setSystemUiVisibility(4098);
                return;
            }
        } else {
            window.addFlags(2048);
            window.clearFlags(1024);
        }
    }
}

