/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzavh;
import com.google.android.gms.internal.ads.zzavi;
import com.google.android.gms.internal.ads.zzavj;
import com.google.android.gms.internal.ads.zzavk;
import com.google.android.gms.internal.ads.zzavl;
import com.google.android.gms.internal.ads.zzavm;
import com.google.android.gms.internal.ads.zzavn;
import com.google.android.gms.internal.ads.zzavo;
import com.google.android.gms.internal.ads.zzavp;
import com.google.android.gms.internal.ads.zzavq;
import com.google.android.gms.internal.ads.zzavr;
import com.google.android.gms.internal.ads.zzavs;
import com.google.android.gms.internal.ads.zzavt;
import com.google.android.gms.internal.ads.zzavu;
import com.google.android.gms.internal.ads.zzavv;
import com.google.android.gms.internal.ads.zzavw;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzazt;
import com.google.android.gms.internal.ads.zzbjf;
import com.google.android.gms.internal.ads.zzyt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzard
@ParametersAreNonnullByDefault
public final class zzavg {
    private final AtomicReference<ThreadPoolExecutor> zzdsd = new AtomicReference<Object>(null);
    private final Object zzdse = new Object();
    @GuardedBy(value="gmpAppIdLock")
    @Nullable
    private String zzdsf = null;
    @GuardedBy(value="gmpAppIdLock")
    @Nullable
    private String zzdsg = null;
    @VisibleForTesting
    private final AtomicBoolean zzdsh = new AtomicBoolean(false);
    @VisibleForTesting
    private final AtomicInteger zzdsi = new AtomicInteger(-1);
    private final AtomicReference<Object> zzdsj = new AtomicReference<Object>(null);
    private final AtomicReference<Object> zzdsk = new AtomicReference<Object>(null);
    private final ConcurrentMap<String, Method> zzdsl = new ConcurrentHashMap<String, Method>(9);
    private final AtomicReference<zzbjf> zzdsm = new AtomicReference<Object>(null);
    @GuardedBy(value="proxyReference")
    private final List<FutureTask> zzdsn = new ArrayList<FutureTask>();

    /*
     * Unable to fully structure code
     */
    public final boolean zzx(Context var1_1) {
        block4: {
            var2_2 = zzacu.zzcns;
            if (!((Boolean)zzyt.zzpe().zzd(var2_2)).booleanValue() || this.zzdsh.get()) {
                return false;
            }
            var2_2 = zzacu.zzcoc;
            if (((Boolean)zzyt.zzpe().zzd(var2_2)).booleanValue()) {
                return true;
            }
            if (this.zzdsi.get() != -1) break block4;
            zzyt.zzpa();
            var3_3 = var1_1;
            if (zzazt.zzc((Context)var3_3, (int)12451000)) ** GOTO lbl-1000
            zzyt.zzpa();
            if (zzazt.zzbg((Context)var1_1)) {
                zzawz.zzep((String)"Google Play Service is out of date, the Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires updated Google Play Service.");
                this.zzdsi.set(0);
            } else lbl-1000:
            // 2 sources

            {
                this.zzdsi.set(1);
            }
        }
        return this.zzdsi.get() == 1;
    }

    @VisibleForTesting
    private static boolean zzy(Context context) {
        zzacj zzacj2 = zzacu.zzcnz;
        if (!((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            zzacj2 = zzacu.zzcoa;
            if (!((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
                return false;
            }
        }
        zzacj2 = zzacu.zzcob;
        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            try {
                context.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return true;
            }
        }
        return true;
    }

    public final void zzd(Context context, String string2) {
        if (!this.zzx(context)) {
            return;
        }
        if (zzavg.zzy(context)) {
            this.zza("beginAdUnitExposure", new zzavh(string2));
            return;
        }
        this.zza(context, string2, "beginAdUnitExposure");
    }

    public final void zze(Context context, String string2) {
        if (!this.zzx(context)) {
            return;
        }
        if (zzavg.zzy(context)) {
            this.zza("endAdUnitExposure", new zzavi(string2));
            return;
        }
        this.zza(context, string2, "endAdUnitExposure");
    }

    public final String zzz(Context context) {
        if (!this.zzx(context)) {
            return "";
        }
        if (zzavg.zzy(context)) {
            return this.zza("getCurrentScreenNameOrScreenClass", "", zzavm.zzdst);
        }
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsj, true)) {
            return "";
        }
        try {
            String string2 = (String)this.zzl(context, "getCurrentScreenName").invoke(this.zzdsj.get(), new Object[0]);
            if (string2 == null) {
                string2 = (String)this.zzl(context, "getCurrentScreenClass").invoke(this.zzdsj.get(), new Object[0]);
            }
            if (string2 != null) {
                return string2;
            }
            return "";
        }
        catch (Exception exception) {
            this.zza(exception, "getCurrentScreenName", false);
            return "";
        }
    }

    public final void zzf(Context context, String string2) {
        if (!this.zzx(context)) {
            return;
        }
        if (!(context instanceof Activity)) {
            return;
        }
        if (zzavg.zzy(context)) {
            this.zza("setScreenName", new zzavn(context, string2));
            return;
        }
        if (!this.zza(context, "com.google.firebase.analytics.FirebaseAnalytics", this.zzdsk, false)) {
            return;
        }
        Method method = this.zzm(context, "setCurrentScreen");
        try {
            Activity activity = (Activity)context;
            method.invoke(this.zzdsk.get(), activity, string2, context.getPackageName());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "setCurrentScreen", false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzaa(Context context) {
        if (!this.zzx(context)) {
            return null;
        }
        Object object = this.zzdse;
        synchronized (object) {
            if (this.zzdsf != null) {
                return this.zzdsf;
            }
            this.zzdsf = zzavg.zzy(context) ? this.zza("getGmpAppId", this.zzdsf, zzavo.zzdst) : (String)this.zza("getGmpAppId", context);
            return this.zzdsf;
        }
    }

    @Nullable
    public final String zzab(Context context) {
        if (!this.zzx(context)) {
            return null;
        }
        zzacj zzacj2 = zzacu.zzcnx;
        long l = (Long)zzyt.zzpe().zzd(zzacj2);
        if (zzavg.zzy(context)) {
            try {
                if (l < 0L) {
                    return (String)this.zza("getAppInstanceId", zzavp.zzdst).get();
                }
                return (String)this.zza("getAppInstanceId", zzavq.zzdst).get(l, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                if (exception instanceof TimeoutException) {
                    return "TIME_OUT";
                }
                return null;
            }
        }
        if (l < 0L) {
            return (String)this.zza("getAppInstanceId", context);
        }
        Future future = this.zzui().submit(new zzavr(this, context));
        try {
            return (String)future.get(l, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            future.cancel(true);
            if (exception instanceof TimeoutException) {
                return "TIME_OUT";
            }
            return null;
        }
    }

    @Nullable
    public final String zzac(Context context) {
        if (!this.zzx(context)) {
            return null;
        }
        if (zzavg.zzy(context)) {
            Long l = this.zza("getAdEventId", null, zzavs.zzdst);
            if (l != null) {
                return Long.toString(l);
            }
            return null;
        }
        Object object = this.zza("generateEventId", context);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzad(Context context) {
        if (!this.zzx(context)) {
            return null;
        }
        Object object = this.zzdse;
        synchronized (object) {
            if (this.zzdsg != null) {
                return this.zzdsg;
            }
            this.zzdsg = zzavg.zzy(context) ? this.zza("getAppIdOrigin", this.zzdsg, zzavt.zzdst) : "fa";
            return this.zzdsg;
        }
    }

    public final void zzg(Context context, String string2) {
        this.zza(context, "_ac", string2, null);
    }

    public final void zzh(Context context, String string2) {
        this.zza(context, "_ai", string2, null);
    }

    public final void zzi(Context context, String string2) {
        this.zza(context, "_aq", string2, null);
    }

    public final void zzj(Context context, String string2) {
        this.zza(context, "_aa", string2, null);
    }

    public final void zza(Context context, String string2, String string3, String string4, int n) {
        if (!this.zzx(context)) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string3);
        bundle.putString("type", string4);
        bundle.putInt("value", n);
        this.zza(context, "_ar", string2, bundle);
        zzawz.zzds(new StringBuilder(75 + String.valueOf(string4).length()).append("Log a Firebase reward video event, reward type: ").append(string4).append(", reward value: ").append(n).toString());
    }

    private final void zza(Context context, String string2, String string3, @Nullable Bundle bundle) {
        if (!this.zzx(context)) {
            return;
        }
        Bundle bundle2 = zzavg.zzj(string3, string2);
        if (bundle != null) {
            bundle2.putAll(bundle);
        }
        if (zzavg.zzy(context)) {
            this.zza("logEventInternal", new zzavj(string2, bundle2));
            return;
        }
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsj, true)) {
            return;
        }
        Method method = this.zzae(context);
        try {
            method.invoke(this.zzdsj.get(), "am", string2, bundle2);
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return;
        }
    }

    private static Bundle zzj(String string2, String string3) {
        Bundle bundle = new Bundle();
        try {
            bundle.putLong("_aeid", Long.parseLong(string2));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String string4 = String.valueOf(string2);
            zzawz.zzc((String)(string4.length() != 0 ? "Invalid event ID: ".concat(string4) : new String("Invalid event ID: ")), (Throwable)runtimeException);
        }
        if ("_ac".equals(string3)) {
            bundle.putInt("_r", 1);
        }
        return bundle;
    }

    @Nullable
    private final Method zzae(Context context) {
        Method method = (Method)this.zzdsl.get("logEventInternal");
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod("logEventInternal", String.class, String.class, Bundle.class);
            this.zzdsl.put("logEventInternal", method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return null;
        }
    }

    @Nullable
    private final Method zzk(Context context, String string2) {
        Method method = (Method)this.zzdsl.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, String.class);
            this.zzdsl.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    @Nullable
    private final Method zzl(Context context, String string2) {
        Method method = (Method)this.zzdsl.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, new Class[0]);
            this.zzdsl.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final Method zzm(Context context, String string2) {
        Method method = (Method)this.zzdsl.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics").getDeclaredMethod(string2, Activity.class, String.class, String.class);
            this.zzdsl.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final void zza(Context context, String string2, String string3) {
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsj, true)) {
            return;
        }
        Method method = this.zzk(context, string3);
        try {
            method.invoke(this.zzdsj.get(), string2);
            zzawz.zzds(new StringBuilder(37 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string3).append(", Ad Unit Id: ").append(string2).toString());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, string3, false);
            return;
        }
    }

    private final Object zza(String string2, Context context) {
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzdsj, true)) {
            return null;
        }
        Method method = this.zzl(context, string2);
        try {
            return method.invoke(this.zzdsj.get(), new Object[0]);
        }
        catch (Exception exception) {
            this.zza(exception, string2, true);
            return null;
        }
    }

    private final void zza(Exception exception, String string2, boolean bl) {
        if (!this.zzdsh.get()) {
            zzawz.zzep((String)new StringBuilder(30 + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string2).append(" error.").toString());
            if (bl) {
                zzawz.zzep((String)"The Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires the latest Firebase SDK jar, but Firebase SDK is either missing or out of date");
                this.zzdsh.set(true);
            }
        }
    }

    private final ThreadPoolExecutor zzui() {
        if (this.zzdsd.get() == null) {
            Object object = zzacu.zzcny;
            int n = (Integer)zzyt.zzpe().zzd(object);
            object = zzacu.zzcny;
            int n2 = (Integer)zzyt.zzpe().zzd(object);
            object = this;
            this.zzdsd.compareAndSet(null, new ThreadPoolExecutor(n, n2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new zzavu((zzavg)object)));
        }
        return this.zzdsd.get();
    }

    private final boolean zza(Context context, String string2, AtomicReference<Object> atomicReference, boolean bl) {
        if (atomicReference.get() == null) {
            try {
                Method method = context.getClassLoader().loadClass(string2).getDeclaredMethod("getInstance", Context.class);
                atomicReference.compareAndSet(null, method.invoke(null, context));
            }
            catch (Exception exception) {
                this.zza(exception, "getInstance", bl);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string2, zzavw zzavw2) {
        AtomicReference<zzbjf> atomicReference = this.zzdsm;
        synchronized (atomicReference) {
            FutureTask<Object> futureTask = new FutureTask<Object>(new zzavk(this, zzavw2, string2), null);
            if (this.zzdsm.get() != null) {
                futureTask.run();
            } else {
                this.zzdsn.add(futureTask);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> Future<T> zza(String string2, zzavv<T> zzavv2) {
        AtomicReference<zzbjf> atomicReference = this.zzdsm;
        synchronized (atomicReference) {
            FutureTask futureTask = new FutureTask(new zzavl(this, zzavv2, string2));
            if (this.zzdsm.get() != null) {
                this.zzui().submit(futureTask);
            } else {
                this.zzdsn.add(futureTask);
            }
            return futureTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T zza(String string2, @Nullable T t, zzavv<T> zzavv2) {
        AtomicReference<zzbjf> atomicReference = this.zzdsm;
        synchronized (atomicReference) {
            if (this.zzdsm.get() != null) {
                try {
                    return zzavv2.zzb(this.zzdsm.get());
                }
                catch (Exception exception) {
                    this.zza(exception, string2, false);
                }
            }
            return t;
        }
    }

    final /* synthetic */ Object zza(zzavv zzavv2, String string2) throws Exception {
        try {
            return zzavv2.zzb(this.zzdsm.get());
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            throw exception;
        }
    }

    final /* synthetic */ void zza(zzavw zzavw2, String string2) {
        if (this.zzdsm.get() != null) {
            try {
                zzavw2.zza(this.zzdsm.get());
                return;
            }
            catch (Exception exception) {
                this.zza(exception, string2, false);
            }
        }
    }

    final /* synthetic */ String zzaf(Context context) throws Exception {
        return (String)this.zza("getAppInstanceId", context);
    }
}

