/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Looper;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawl;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxb;
import com.google.android.gms.internal.ads.zzaxd;
import com.google.android.gms.internal.ads.zzaxe;
import com.google.android.gms.internal.ads.zzaxg;
import com.google.android.gms.internal.ads.zzbbh;
import com.google.android.gms.internal.ads.zzuu;
import com.google.android.gms.internal.ads.zzyt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzard
public final class zzaxc
implements zzaxb {
    private final Object lock = new Object();
    private boolean zzduw;
    private final List<Runnable> zzdux = new ArrayList<Runnable>();
    private zzbbh<?> zzduy;
    @Nullable
    @GuardedBy(value="lock")
    private zzuu zzduz = null;
    @Nullable
    @GuardedBy(value="lock")
    private SharedPreferences zzckn;
    @Nullable
    @GuardedBy(value="lock")
    private SharedPreferences.Editor zzdva;
    @GuardedBy(value="lock")
    private boolean zzdvb = false;
    @GuardedBy(value="lock")
    private boolean zzdls = true;
    @Nullable
    @GuardedBy(value="lock")
    private String zzdvc;
    @Nullable
    @GuardedBy(value="lock")
    private String zzdvd;
    @GuardedBy(value="lock")
    private boolean zzdmh = false;
    @GuardedBy(value="lock")
    private String zzdmk = "";
    @GuardedBy(value="lock")
    private long zzdve = 0L;
    @GuardedBy(value="lock")
    private long zzdvf = 0L;
    @GuardedBy(value="lock")
    private long zzdvg = 0L;
    @GuardedBy(value="lock")
    private int zzdvh = -1;
    @GuardedBy(value="lock")
    private int zzdvi = 0;
    @GuardedBy(value="lock")
    private Set<String> zzdvj = Collections.emptySet();
    @GuardedBy(value="lock")
    private JSONObject zzdvk = new JSONObject();
    @GuardedBy(value="lock")
    private boolean zzdnt = true;
    @GuardedBy(value="lock")
    private boolean zzdoe = true;
    @GuardedBy(value="lock")
    private String zzdvl = null;

    public final void zza(Context context, String string2, boolean bl) {
        String string3;
        if (string2 == null) {
            string3 = "admob";
        } else {
            String string4 = String.valueOf("admob__");
            String string5 = String.valueOf(string2);
            string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        String string6 = string3;
        this.zzduy = zzaxg.zzc(new zzaxd(this, context, string6));
        this.zzduw = bl;
    }

    private final void zzvy() {
        if (this.zzduy == null) {
            return;
        }
        if (this.zzduy.isDone()) {
            return;
        }
        try {
            this.zzduy.get(1L, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            zzawz.zzd((String)"Interrupted while waiting for preferences loaded.", (Throwable)interruptedException);
            return;
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            zzawz.zzc((String)"Fail to initialize AdSharedPreferenceManager.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzvz() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("listener_registration_bundle", true);
        Object object = this.lock;
        synchronized (object) {
            bundle.putBoolean("use_https", this.zzdls);
            bundle.putBoolean("content_url_opted_out", this.zzdnt);
            bundle.putBoolean("content_vertical_opted_out", this.zzdoe);
            bundle.putBoolean("auto_collect_location", this.zzdmh);
            bundle.putInt("version_code", this.zzdvi);
            bundle.putStringArray("never_pool_slots", this.zzdvj.toArray(new String[0]));
            bundle.putString("app_settings_json", this.zzdmk);
            bundle.putLong("app_settings_last_update_ms", this.zzdve);
            bundle.putLong("app_last_background_time_ms", this.zzdvf);
            bundle.putInt("request_in_session_count", this.zzdvh);
            bundle.putLong("first_ad_req_time_ms", this.zzdvg);
            bundle.putString("native_advanced_settings", this.zzdvk.toString());
            bundle.putString("display_cutout", this.zzdvl);
            if (this.zzdvc != null) {
                bundle.putString("content_url_hashes", this.zzdvc);
            }
            if (this.zzdvd != null) {
                bundle.putString("content_vertical_hashes", this.zzdvd);
            }
        }
        return bundle;
    }

    private final void zzc(Bundle bundle) {
        zzaxg.zzdvp.execute(new zzaxe(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final zzuu zzvk() {
        if (!this.zzduw) {
            return null;
        }
        if (!PlatformVersion.isAtLeastIceCreamSandwich()) {
            return null;
        }
        if (this.zzvl() && this.zzvn()) {
            return null;
        }
        zzacj zzacj2 = zzacu.zzcna;
        if (!((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (Looper.getMainLooper() == null) {
                return null;
            }
            if (this.zzduz == null) {
                this.zzduz = new zzuu();
            }
            this.zzduz.zzmv();
            zzawz.zzeo((String)"start fetching content...");
            return this.zzduz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzai(boolean bl) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdnt == bl) {
                return;
            }
            this.zzdnt = bl;
            if (this.zzdva != null) {
                this.zzdva.putBoolean("content_url_opted_out", bl);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzdnt);
            bundle.putBoolean("content_vertical_opted_out", this.zzdoe);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzvl() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdt(@Nullable String string2) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdvc)) {
                return;
            }
            this.zzdvc = string2;
            if (this.zzdva != null) {
                this.zzdva.putString("content_url_hashes", string2);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_url_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzvm() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaj(boolean bl) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdoe == bl) {
                return;
            }
            this.zzdoe = bl;
            if (this.zzdva != null) {
                this.zzdva.putBoolean("content_vertical_opted_out", bl);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzdnt);
            bundle.putBoolean("content_vertical_opted_out", this.zzdoe);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzvn() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdoe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdu(@Nullable String string2) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdvd)) {
                return;
            }
            this.zzdvd = string2;
            if (this.zzdva != null) {
                this.zzdva.putString("content_vertical_hashes", string2);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_vertical_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzvo() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzak(boolean bl) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdmh == bl) {
                return;
            }
            this.zzdmh = bl;
            if (this.zzdva != null) {
                this.zzdva.putBoolean("auto_collect_location", bl);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("auto_collect_location", bl);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzvp() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdmh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzct(int n) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvi == n) {
                return;
            }
            this.zzdvi = n;
            if (this.zzdva != null) {
                this.zzdva.putInt("version_code", n);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("version_code", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzvq() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdv(String string2) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            long l;
            this.zzdve = l = zzk.zzln().currentTimeMillis();
            if (string2 == null || string2.equals(this.zzdmk)) {
                return;
            }
            this.zzdmk = string2;
            if (this.zzdva != null) {
                this.zzdva.putString("app_settings_json", string2);
                this.zzdva.putLong("app_settings_last_update_ms", l);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("app_settings_json", string2);
            bundle.putLong("app_settings_last_update_ms", l);
            this.zzc(bundle);
            Iterator<Runnable> iterator = this.zzdux.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzawl zzvr() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return new zzawl(this.zzdmk, this.zzdve);
        }
    }

    @Override
    public final void zzb(Runnable runnable) {
        this.zzdux.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzfc(long l) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvf == l) {
                return;
            }
            this.zzdvf = l;
            if (this.zzdva != null) {
                this.zzdva.putLong("app_last_background_time_ms", l);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("app_last_background_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzvs() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcu(int n) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvh == n) {
                return;
            }
            this.zzdvh = n;
            if (this.zzdva != null) {
                this.zzdva.putInt("request_in_session_count", n);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request_in_session_count", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzvt() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzfd(long l) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvg == l) {
                return;
            }
            this.zzdvg = l;
            if (this.zzdva != null) {
                this.zzdva.putLong("first_ad_req_time_ms", l);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("first_ad_req_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzvu() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(String string2, String string3, boolean bl) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            JSONObject jSONObject;
            JSONArray jSONArray = this.zzdvk.optJSONArray(string2);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            int n = jSONArray.length();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                if (jSONObject2 == null) {
                    return;
                }
                if (!string3.equals(jSONObject2.optString("template_id"))) continue;
                if (bl && jSONObject2.optBoolean("uses_media_view", false)) {
                    return;
                }
                n = i;
                break;
            }
            try {
                jSONObject = new JSONObject();
                jSONObject.put("template_id", (Object)string3);
                jSONObject.put("uses_media_view", bl);
                jSONObject.put("timestamp_ms", zzk.zzln().currentTimeMillis());
                jSONArray.put(n, (Object)jSONObject);
                this.zzdvk.put(string2, (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                zzawz.zzd((String)"Could not update native advanced settings", (Throwable)jSONException);
            }
            if (this.zzdva != null) {
                this.zzdva.putString("native_advanced_settings", this.zzdvk.toString());
                this.zzdva.apply();
            }
            jSONObject = new Bundle();
            jSONObject.putString("native_advanced_settings", this.zzdvk.toString());
            this.zzc((Bundle)jSONObject);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JSONObject zzvv() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzvw() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            this.zzdvk = new JSONObject();
            if (this.zzdva != null) {
                this.zzdva.remove("native_advanced_settings");
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("native_advanced_settings", "{}");
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String zzvx() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdw(String string2) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (TextUtils.equals((CharSequence)this.zzdvl, (CharSequence)string2)) {
                return;
            }
            this.zzdvl = string2;
            if (this.zzdva != null) {
                this.zzdva.putString("display_cutout", string2);
                this.zzdva.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("display_cutout", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zzo(Context context, String string2) {
        String string3 = string2;
        Context context2 = context;
        zzaxc zzaxc2 = this;
        SharedPreferences sharedPreferences = context2.getSharedPreferences(string3, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Object object = zzaxc2.lock;
        synchronized (object) {
            zzaxc2.zzckn = sharedPreferences;
            zzaxc2.zzdva = editor;
            zzaxc2.zzdvb = PlatformVersion.isAtLeastM() && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
            zzaxc2.zzdls = zzaxc2.zzckn.getBoolean("use_https", zzaxc2.zzdls);
            zzaxc2.zzdnt = zzaxc2.zzckn.getBoolean("content_url_opted_out", zzaxc2.zzdnt);
            zzaxc2.zzdvc = zzaxc2.zzckn.getString("content_url_hashes", zzaxc2.zzdvc);
            zzaxc2.zzdmh = zzaxc2.zzckn.getBoolean("auto_collect_location", zzaxc2.zzdmh);
            zzaxc2.zzdoe = zzaxc2.zzckn.getBoolean("content_vertical_opted_out", zzaxc2.zzdoe);
            zzaxc2.zzdvd = zzaxc2.zzckn.getString("content_vertical_hashes", zzaxc2.zzdvd);
            zzaxc2.zzdvi = zzaxc2.zzckn.getInt("version_code", zzaxc2.zzdvi);
            zzaxc2.zzdmk = zzaxc2.zzckn.getString("app_settings_json", zzaxc2.zzdmk);
            zzaxc2.zzdve = zzaxc2.zzckn.getLong("app_settings_last_update_ms", zzaxc2.zzdve);
            zzaxc2.zzdvf = zzaxc2.zzckn.getLong("app_last_background_time_ms", zzaxc2.zzdvf);
            zzaxc2.zzdvh = zzaxc2.zzckn.getInt("request_in_session_count", zzaxc2.zzdvh);
            zzaxc2.zzdvg = zzaxc2.zzckn.getLong("first_ad_req_time_ms", zzaxc2.zzdvg);
            zzaxc2.zzdvj = zzaxc2.zzckn.getStringSet("never_pool_slots", zzaxc2.zzdvj);
            zzaxc2.zzdvl = zzaxc2.zzckn.getString("display_cutout", zzaxc2.zzdvl);
            try {
                zzaxc2.zzdvk = new JSONObject(zzaxc2.zzckn.getString("native_advanced_settings", "{}"));
            }
            catch (JSONException jSONException) {
                zzawz.zzd((String)"Could not convert native advanced settings to json object", (Throwable)jSONException);
            }
            zzaxc2.zzc(zzaxc2.zzvz());
            return;
        }
    }
}

