/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxg;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzayc;
import com.google.android.gms.internal.ads.zzayd;
import com.google.android.gms.internal.ads.zzaye;
import com.google.android.gms.internal.ads.zzayf;
import com.google.android.gms.internal.ads.zzayg;
import com.google.android.gms.internal.ads.zzayh;
import com.google.android.gms.internal.ads.zzyt;
import java.util.ArrayList;
import java.util.List;

@zzard
public final class zzayb {
    private final Context zzlj;
    private String zzdks;
    private String zzchk;
    private String zzbsx;
    @Nullable
    private String zzdod;
    private int state = 0;
    private int zzdwe;
    private PointF zzdwf;
    private PointF zzdwg;
    private Handler handler;
    private Runnable zzdwh = new zzayc(this);

    public zzayb(Context context) {
        this.zzlj = context;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.zzdwe = viewConfiguration.getScaledTouchSlop();
        zzk.zzlu().zzwr();
        this.handler = zzk.zzlu().getHandler();
    }

    public zzayb(Context context, String string2) {
        this(context);
        this.zzdks = string2;
    }

    public final void zzd(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        int n2 = motionEvent.getHistorySize();
        int n3 = motionEvent.getPointerCount();
        if (n == 0) {
            this.state = 0;
            this.zzdwf = new PointF(motionEvent.getX(0), motionEvent.getY(0));
            return;
        }
        if (this.state == -1) {
            return;
        }
        if (this.state == 0 && n == 5) {
            this.state = 5;
            this.zzdwg = new PointF(motionEvent.getX(1), motionEvent.getY(1));
            zzacj zzacj2 = zzacu.zzcua;
            this.handler.postDelayed(this.zzdwh, ((Long)zzyt.zzpe().zzd(zzacj2)).longValue());
            return;
        }
        if (this.state == 5) {
            boolean bl = false;
            if (n3 != 2) {
                bl = true;
            } else if (n == 2) {
                for (int i = 0; i < n2; ++i) {
                    if (this.zza(motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i), motionEvent.getHistoricalX(1, i), motionEvent.getHistoricalY(1, i))) continue;
                    bl = true;
                }
                if (!this.zza(motionEvent.getX(), motionEvent.getY(), motionEvent.getX(1), motionEvent.getY(1))) {
                    bl = true;
                }
            }
            if (bl) {
                this.state = -1;
                this.handler.removeCallbacks(this.zzdwh);
            }
        }
    }

    private final boolean zza(float f, float f2, float f3, float f4) {
        return Math.abs(this.zzdwf.x - f) < (float)this.zzdwe && Math.abs(this.zzdwf.y - f2) < (float)this.zzdwe && Math.abs(this.zzdwg.x - f3) < (float)this.zzdwe && Math.abs(this.zzdwg.y - f4) < (float)this.zzdwe;
    }

    public final void showDialog() {
        try {
            zzayb zzayb2 = this;
            if (!(zzayb2.zzlj instanceof Activity)) {
                zzawz.zzeo((String)"Can not create dialog without Activity Context");
                return;
            }
            String string2 = !TextUtils.isEmpty((CharSequence)zzk.zzlq().zzwn()) ? "Creative Preview (Enabled)" : "Creative Preview";
            String string3 = zzk.zzlq().zzwo() ? "Troubleshooting (Enabled)" : "Troubleshooting";
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = zzayb.zza(arrayList, "Ad Information", true);
            int n2 = zzayb.zza(arrayList, string2, true);
            int n3 = zzayb.zza(arrayList, string3, true);
            AlertDialog.Builder builder = new AlertDialog.Builder(zzayb2.zzlj, zzk.zzli().zzwi());
            builder.setTitle((CharSequence)"Select a Debug Mode").setItems((CharSequence[])arrayList.toArray(new String[0]), (DialogInterface.OnClickListener)new zzayd(zzayb2, n, n2, n3));
            builder.create().show();
            return;
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzawz.zza("", badTokenException);
            return;
        }
    }

    public final void setAdUnitId(String string2) {
        this.zzchk = string2;
    }

    public final void zzp(String string2) {
        this.zzbsx = string2;
    }

    public final void zzee(String string2) {
        this.zzdks = string2;
    }

    public final void zzef(String string2) {
        this.zzdod = string2;
    }

    private static int zza(List<String> list, String string2, boolean bl) {
        list.add(string2);
        return list.size() - 1;
    }

    public final String toString() {
        return new StringBuilder(100).append("{Dialog: ").append(this.zzdks).append(",DebugSignal: ").append(this.zzdod).append(",AFMA Version: ").append(this.zzbsx).append(",Ad Unit ID: ").append(this.zzchk).append("}").toString();
    }

    final /* synthetic */ void zzwk() {
        zzk.zzlq().zza(this.zzlj, this.zzchk, this.zzbsx, this.zzdod);
    }

    final /* synthetic */ void zzwl() {
        zzk.zzlq().zze(this.zzlj, this.zzchk, this.zzbsx);
    }

    final /* synthetic */ void zza(String string2, DialogInterface dialogInterface, int n) {
        zzk.zzlg();
        zzaxi.zza(this.zzlj, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ void zza(int var1_1, int var2_2, int var3_3, DialogInterface var4_4, int var5_5) {
        block6: {
            if (var5_5 != var1_1) break block6;
            var6_6 = this;
            if (!(var6_6.zzlj instanceof Activity)) {
                zzawz.zzeo((String)"Can not create dialog without Activity Context");
                return;
            }
            var9_9 = var6_6.zzdks;
            if (TextUtils.isEmpty((CharSequence)var9_9)) ** GOTO lbl-1000
            var9_9 = var9_9.replaceAll("\\+", "%20");
            var10_10 = new Uri.Builder().encodedQuery(var9_9).build();
            var11_11 = new StringBuilder();
            zzk.zzlg();
            var12_12 = zzaxi.zzi(var10_10);
            for (String var14_14 : var12_12.keySet()) {
                var11_11.append(var14_14).append(" = ").append(var12_12.get(var14_14)).append("\n\n");
            }
            var13_13 = var11_11.toString().trim();
            if (!TextUtils.isEmpty((CharSequence)var13_13)) {
                v0 = var13_13;
            } else lbl-1000:
            // 2 sources

            {
                v0 = "No debug information";
            }
            var7_15 = v0;
            var8_16 = new AlertDialog.Builder(var6_6.zzlj);
            var8_16.setMessage((CharSequence)var7_15);
            var8_16.setTitle((CharSequence)"Ad Information");
            var8_16.setPositiveButton((CharSequence)"Share", (DialogInterface.OnClickListener)new zzaye(var6_6, var7_15));
            var8_16.setNegativeButton((CharSequence)"Close", zzayf.zzdwm);
            var8_16.create().show();
            return;
        }
        if (var5_5 == var2_2) {
            var6_7 = this;
            zzawz.zzdp((String)"Debug mode [Creative Preview] selected.");
            zzaxg.zzc(new zzayg(var6_7));
            return;
        }
        if (var5_5 == var3_3) {
            var6_8 = this;
            zzawz.zzdp((String)"Debug mode [Troubleshooting] selected.");
            zzaxg.zzc(new zzayh(var6_8));
        }
    }

    final /* synthetic */ void zzwm() {
        this.state = 4;
        this.showDialog();
    }
}

