/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzbce;
import com.google.android.gms.internal.ads.zzbcf;
import com.google.android.gms.internal.ads.zzbcg;
import com.google.android.gms.internal.ads.zzbch;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzbcj;
import com.google.android.gms.internal.ads.zzbck;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbcn;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbdd;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzvv;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzard
@TargetApi(value=14)
public final class zzbcd
extends zzbco
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzeav = new HashMap<Integer, String>();
    private final zzbdg zzeaw;
    private final boolean zzeax;
    private int zzeay = 0;
    private int zzeaz = 0;
    private MediaPlayer zzeba;
    private Uri zzebb;
    private int zzebc;
    private int zzebd;
    private int zzebe;
    private int zzebf;
    private int zzebg;
    private zzbdd zzebh;
    private boolean zzebi;
    private int zzebj;
    private zzbcn zzebk;

    public zzbcd(Context context, boolean bl, boolean bl2, zzbde zzbde2, zzbdg zzbdg2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzeaw = zzbdg2;
        this.zzebi = bl;
        this.zzeax = bl2;
        this.zzeaw.zzb(this);
    }

    @Override
    public final String zzxg() {
        String string2 = String.valueOf(this.zzebi ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzbcn zzbcn2) {
        this.zzebk = zzbcn2;
    }

    @Override
    public final void setVideoPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzbcd zzbcd2 = this;
        zzvv zzvv2 = zzvv.zze(uri);
        if (zzvv2 == null || zzvv2.url != null) {
            zzbcd2.zzebb = zzvv2 == null ? uri : Uri.parse((String)zzvv2.url);
            zzbcd2.zzebj = 0;
            zzbcd2.zzxh();
            zzbcd2.requestLayout();
            zzbcd2.invalidate();
        }
    }

    @Override
    public final void stop() {
        zzawz.zzds("AdMediaPlayerView stop");
        if (this.zzeba != null) {
            this.zzeba.stop();
            this.zzeba.release();
            this.zzeba = null;
            this.zzcw(0);
            this.zzeaz = 0;
        }
        this.zzeaw.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzawz.zzds(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzebc = mediaPlayer.getVideoWidth();
        this.zzebd = mediaPlayer.getVideoHeight();
        if (this.zzebc != 0 && this.zzebd != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzawz.zzds("AdMediaPlayerView prepared");
        this.zzcw(2);
        this.zzeaw.zzhd();
        zzaxi.zzdvv.post((Runnable)new zzbcf(this));
        this.zzebc = mediaPlayer.getVideoWidth();
        this.zzebd = mediaPlayer.getVideoHeight();
        if (this.zzebj != 0) {
            ((zzbco)this).seekTo(this.zzebj);
        }
        this.zzxi();
        int n = this.zzebc;
        int n2 = this.zzebd;
        zzawz.zzeo((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzeaz == 3) {
            ((zzbco)this).play();
        }
        ((zzbco)this).zzxk();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzawz.zzds("AdMediaPlayerView completion");
        this.zzcw(5);
        this.zzeaz = 5;
        zzaxi.zzdvv.post((Runnable)new zzbcg(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzeav.get(n);
        String string3 = zzeav.get(n2);
        zzawz.zzds(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzeav.get(n);
        String string3 = zzeav.get(n2);
        zzawz.zzep((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzcw(-1);
        this.zzeaz = -1;
        zzaxi.zzdvv.post((Runnable)new zzbch(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzebe = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzawz.zzds("AdMediaPlayerView surface created");
        this.zzxh();
        zzaxi.zzdvv.post((Runnable)new zzbci(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzawz.zzds("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzeaz == 3;
        boolean bl3 = bl = this.zzebc == n && this.zzebd == n2;
        if (this.zzeba != null && bl2 && bl) {
            if (this.zzebj != 0) {
                ((zzbco)this).seekTo(this.zzebj);
            }
            ((zzbco)this).play();
        }
        if (this.zzebh != null) {
            this.zzebh.zzm(n, n2);
        }
        zzaxi.zzdvv.post((Runnable)new zzbcj(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzawz.zzds("AdMediaPlayerView surface destroyed");
        if (this.zzeba != null && this.zzebj == 0) {
            this.zzebj = this.zzeba.getCurrentPosition();
        }
        if (this.zzebh != null) {
            this.zzebh.zzxx();
        }
        zzaxi.zzdvv.post((Runnable)new zzbck(this));
        this.zzam(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzeaw.zzc(this);
        this.zzebr.zza(surfaceTexture, this.zzebk);
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzawz.zzds(new StringBuilder(58).append("AdMediaPlayerView window visibility changed to ").append(n).toString());
        zzaxi.zzdvv.post((Runnable)new zzbce(this, n));
        super.onWindowVisibilityChanged(n);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzbcd.getDefaultSize((int)this.zzebc, (int)n);
        int n4 = zzbcd.getDefaultSize((int)this.zzebd, (int)n2);
        if (this.zzebc > 0 && this.zzebd > 0 && this.zzebh == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzebc * n4 < n3 * this.zzebd) {
                    n3 = n4 * this.zzebc / this.zzebd;
                } else if (this.zzebc * n4 > n3 * this.zzebd) {
                    n4 = n3 * this.zzebd / this.zzebc;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzebd / this.zzebc;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzebc / this.zzebd;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzebc;
                n4 = this.zzebd;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzebc / this.zzebd;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzebd / this.zzebc;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzebh != null) {
            this.zzebh.zzm(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzebf > 0 && this.zzebf != n3 || this.zzebg > 0 && this.zzebg != n4) {
                this.zzxi();
            }
            this.zzebf = n3;
            this.zzebg = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzxh() {
        zzawz.zzds("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzebb == null || surfaceTexture == null) {
            return;
        }
        this.zzam(false);
        try {
            Surface surface;
            zzk.zzlw();
            this.zzeba = new MediaPlayer();
            this.zzeba.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzeba.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzeba.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzeba.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzeba.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzeba.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzebe = 0;
            if (this.zzebi) {
                this.zzebh = new zzbdd(this.getContext());
                this.zzebh.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzebh.start();
                surface = this.zzebh.zzxy();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzebh.zzxx();
                    this.zzebh = null;
                }
            }
            this.zzeba.setDataSource(this.getContext(), this.zzebb);
            zzk.zzlx();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzeba.setSurface(surface);
            this.zzeba.setAudioStreamType(3);
            this.zzeba.setScreenOnWhilePlaying(true);
            this.zzeba.prepareAsync();
            this.zzcw(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzebb);
            zzawz.zzd((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzeba, 1, 0);
            return;
        }
    }

    private final void zzxi() {
        if (!this.zzeax) {
            return;
        }
        if (this.zzxj() && this.zzeba.getCurrentPosition() > 0 && this.zzeaz != 3) {
            zzawz.zzds("AdMediaPlayerView nudging MediaPlayer");
            this.zzd(0.0f);
            this.zzeba.start();
            int n = this.zzeba.getCurrentPosition();
            long l = zzk.zzln().currentTimeMillis();
            while (this.zzxj() && this.zzeba.getCurrentPosition() == n && zzk.zzln().currentTimeMillis() - l <= 250L) {
            }
            this.zzeba.pause();
            ((zzbco)this).zzxk();
        }
    }

    private final void zzam(boolean bl) {
        zzawz.zzds("AdMediaPlayerView release");
        if (this.zzebh != null) {
            this.zzebh.zzxx();
            this.zzebh = null;
        }
        if (this.zzeba != null) {
            this.zzeba.reset();
            this.zzeba.release();
            this.zzeba = null;
            this.zzcw(0);
            if (bl) {
                this.zzeaz = 0;
                this.zzeaz = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzawz.zzds("AdMediaPlayerView play");
        if (this.zzxj()) {
            this.zzeba.start();
            this.zzcw(3);
            this.zzebr.zzxm();
            zzaxi.zzdvv.post((Runnable)new zzbcl(this));
        }
        this.zzeaz = 3;
    }

    @Override
    public final void pause() {
        zzawz.zzds("AdMediaPlayerView pause");
        if (this.zzxj() && this.zzeba.isPlaying()) {
            this.zzeba.pause();
            this.zzcw(4);
            zzaxi.zzdvv.post((Runnable)new zzbcm(this));
        }
        this.zzeaz = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzxj()) {
            return this.zzeba.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzxj()) {
            return this.zzeba.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzawz.zzds(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzxj()) {
            this.zzeba.seekTo(n);
            this.zzebj = 0;
            return;
        }
        this.zzebj = n;
    }

    private final boolean zzxj() {
        return this.zzeba != null && this.zzeay != -1 && this.zzeay != 0 && this.zzeay != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzebh != null) {
            this.zzebh.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzeba != null) {
            return this.zzeba.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzeba != null) {
            return this.zzeba.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzxk() {
        this.zzd(this.zzebs.getVolume());
    }

    private final void zzd(float f) {
        if (this.zzeba != null) {
            try {
                this.zzeba.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzawz.zzep((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzcw(int n) {
        if (n == 3) {
            this.zzeaw.zzyl();
            this.zzebs.zzyl();
        } else if (this.zzeay == 3) {
            this.zzeaw.zzym();
            this.zzebs.zzym();
        }
        this.zzeay = n;
    }

    final /* synthetic */ void zzcx(int n) {
        if (this.zzebk != null) {
            this.zzebk.onWindowVisibilityChanged(n);
        }
    }

    static /* synthetic */ zzbcn zza(zzbcd zzbcd2) {
        return zzbcd2.zzebk;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzeav.put(-1004, "MEDIA_ERROR_IO");
            zzeav.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzeav.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzeav.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzeav.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzeav.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzeav.put(1, "MEDIA_ERROR_UNKNOWN");
        zzeav.put(1, "MEDIA_INFO_UNKNOWN");
        zzeav.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzeav.put(701, "MEDIA_INFO_BUFFERING_START");
        zzeav.put(702, "MEDIA_INFO_BUFFERING_END");
        zzeav.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzeav.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzeav.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzeav.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzeav.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

