/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzbei;
import com.google.android.gms.internal.ads.zzjp;
import com.google.android.gms.internal.ads.zzjq;
import com.google.android.gms.internal.ads.zzvs;
import com.google.android.gms.internal.ads.zzvv;
import com.google.android.gms.internal.ads.zzwi;
import com.google.android.gms.internal.ads.zzyt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzard
public final class zzbeh
implements zzjp {
    private InputStream zzegc;
    private boolean isOpen;
    private final Context zzlj;
    private final zzjp zzegd;
    private final WeakReference<zzbei> zzege;

    public zzbeh(Context context, zzjp zzjp2, zzbei zzbei2) {
        this.zzlj = context;
        this.zzegd = zzjp2;
        this.zzege = new WeakReference<zzbei>(zzbei2);
    }

    @Override
    public final void close() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to close an already closed CacheDataSource.");
        }
        this.isOpen = false;
        if (this.zzegc != null) {
            IOUtils.closeQuietly((Closeable)this.zzegc);
            this.zzegc = null;
            return;
        }
        this.zzegd.close();
    }

    /*
     * Loose catch block
     */
    @Override
    public final long zza(zzjq zzjq2) throws IOException {
        if (this.isOpen) {
            throw new IOException("Attempt to open an already open CacheDataSource.");
        }
        this.isOpen = true;
        zzvv zzvv2 = zzvv.zze(zzjq2.uri);
        zzacj zzacj2 = zzacu.zzcts;
        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            if (zzvv2 != null) {
                long l;
                Long l2;
                zzvv2.zzbwy = zzjq2.zzahv;
                if (zzvv2.zzbwx) {
                    zzacj2 = zzacu.zzctu;
                    l2 = (Long)zzyt.zzpe().zzd(zzacj2);
                } else {
                    zzacj2 = zzacu.zzctt;
                    l2 = (Long)zzyt.zzpe().zzd(zzacj2);
                }
                long l3 = l2;
                long l4 = zzk.zzln().elapsedRealtime();
                zzk.zzma();
                Future<InputStream> future = zzwi.zza(this.zzlj, zzvv2);
                try {
                    this.zzegc = future.get(l3, TimeUnit.MILLISECONDS);
                    l = zzk.zzln().elapsedRealtime() - l4;
                }
                catch (ExecutionException | TimeoutException exception) {
                    future.cancel(true);
                }
                catch (InterruptedException interruptedException) {
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    long l5 = zzk.zzln().elapsedRealtime() - l4;
                    zzbei zzbei2 = (zzbei)this.zzege.get();
                    if (zzbei2 != null) {
                        zzbei2.zzd(false, l5);
                    }
                    zzawz.zzds(new StringBuilder(44).append("Cache connection took ").append(l5).append("ms").toString());
                }
                zzbei zzbei3 = (zzbei)this.zzege.get();
                if (zzbei3 != null) {
                    zzbei3.zzd(true, l);
                }
                zzawz.zzds(new StringBuilder(44).append("Cache connection took ").append(l).append("ms").toString());
                return -1L;
            }
        } else {
            zzvs zzvs2 = null;
            if (zzvv2 != null) {
                zzvv2.zzbwy = zzjq2.zzahv;
                zzvs2 = zzk.zzlm().zza(zzvv2);
            }
            if (zzvs2 != null && zzvs2.zznh()) {
                this.zzegc = zzvs2.zzni();
                return -1L;
            }
        }
        if (zzvv2 != null) {
            zzjq2 = new zzjq(Uri.parse((String)zzvv2.url), zzjq2.zzapg, zzjq2.zzahv, zzjq2.zzcd, zzjq2.zzcc, zzjq2.flags);
        }
        return this.zzegd.zza(zzjq2);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to read closed CacheDataSource.");
        }
        if (this.zzegc != null) {
            return this.zzegc.read(byArray, n, n2);
        }
        return this.zzegd.read(byArray, n, n2);
    }
}

