/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzbbm;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbfa;
import com.google.android.gms.internal.ads.zzbfi;
import com.google.android.gms.internal.ads.zzbft;
import com.google.android.gms.internal.ads.zzbgq;
import com.google.android.gms.internal.ads.zzkv;
import com.google.android.gms.internal.ads.zzyt;
import java.io.IOException;

@zzard
@TargetApi(value=16)
public final class zzbgp
extends zzbft
implements zzbfi {
    private zzbfa zzeiu;
    private String zzecf;
    private boolean zzeih;
    private Exception zzeiv;
    private boolean zzeiw;

    public zzbgp(zzbdf zzbdf2, zzbde zzbde2) {
        super(zzbdf2);
        zzbde zzbde3 = zzbde2;
        Context context = zzbdf2.getContext();
        this.zzeiu = new zzbfa(context, zzbde3);
        this.zzeiu.zza(this);
    }

    @Override
    public final void zzd(boolean bl, long l) {
        zzbdf zzbdf2 = (zzbdf)this.zzeht.get();
        if (zzbdf2 != null) {
            zzbbm.zzeae.execute(new zzbgq(zzbdf2, bl, l));
        }
    }

    @Override
    public final void zzde(int n) {
    }

    @Override
    public final void zzo(int n, int n2) {
    }

    @Override
    public final void zza(String string2, Exception exception) {
        this.zzeiv = exception;
        zzawz.zzd((String)"Precache error", (Throwable)exception);
        this.zzfb(string2);
    }

    @Override
    public final void zzcz(int n) {
        this.zzeiu.zzzu().zzdh(n);
    }

    @Override
    public final void zzcy(int n) {
        this.zzeiu.zzzu().zzdg(n);
    }

    @Override
    public final void zzda(int n) {
        this.zzeiu.zzzu().zzda(n);
    }

    @Override
    public final void zzdb(int n) {
        this.zzeiu.zzzu().zzdb(n);
    }

    @Override
    public final void release() {
        if (this.zzeiu != null) {
            this.zzeiu.zza((zzbfi)null);
            this.zzeiu.release();
        }
        super.release();
    }

    @Override
    protected final String zzey(String string2) {
        String string3 = String.valueOf("cache:");
        String string4 = String.valueOf(super.zzey(string2));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    @Override
    public final boolean zzex(String string2) {
        return ((zzbft)this).zze(string2, new String[]{string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean zze(String string2, String[] stringArray) {
        this.zzecf = string2;
        String string3 = ((zzbft)this).zzey(string2);
        String string4 = "error";
        try {
            Uri[] uriArray = new Uri[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                uriArray[i] = Uri.parse((String)stringArray[i]);
            }
            this.zzeiu.zza(uriArray, this.zzdyb);
            zzbdf zzbdf2 = (zzbdf)this.zzeht.get();
            if (zzbdf2 != null) {
                zzbdf2.zza(string3, this);
            }
            Clock clock = zzk.zzln();
            long l = clock.currentTimeMillis();
            zzacj zzacj2 = zzacu.zzcly;
            long l2 = (Long)zzyt.zzpe().zzd(zzacj2);
            zzacj2 = zzacu.zzclx;
            long l3 = (Long)zzyt.zzpe().zzd(zzacj2) * 1000L;
            zzacj2 = zzacu.zzclw;
            long l4 = ((Integer)zzyt.zzpe().zzd(zzacj2)).intValue();
            long l5 = -1L;
            while (true) {
                zzbgp zzbgp2 = this;
                synchronized (zzbgp2) {
                    if (clock.currentTimeMillis() - l > l3) {
                        string4 = "downloadTimeout";
                        throw new IOException(new StringBuilder(47).append("Timeout reached. Limit: ").append(l3).append(" ms").toString());
                    }
                    if (this.zzeih) {
                        if (this.zzeiv != null) {
                            string4 = "badUrl";
                            throw this.zzeiv;
                        }
                        string4 = "externalAbort";
                        throw new IOException("Abort requested before buffering finished. ");
                    }
                    if (this.zzeiw) {
                        return true;
                    }
                    zzkv zzkv2 = this.zzeiu.zzzt();
                    if (zzkv2 == null) {
                        string4 = "exoPlayerReleased";
                        throw new IOException("ExoPlayer was released during preloading.");
                    }
                    long l6 = zzkv2.getDuration();
                    if (l6 > 0L) {
                        long l7 = zzkv2.getBufferedPosition();
                        if (l7 != l5) {
                            boolean bl = l7 > 0L;
                            this.zza(string2, string3, l7, l6, bl, zzbfa.zzyp(), zzbfa.zzyq());
                            l5 = l7;
                        }
                        if (l7 >= l6) {
                            this.zzb(string2, string3, l6);
                            return true;
                        }
                        if (this.zzeiu.getBytesTransferred() >= l4 && l7 > 0L) {
                            return true;
                        }
                    }
                    try {
                        this.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        string4 = "interrupted";
                        throw new IOException("Wait interrupted.");
                    }
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string5 = exception.getMessage();
            zzawz.zzep((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Failed to preload url ").append(string2).append(" Exception: ").append(string5).toString());
            ((zzbft)this).release();
            string5 = zzbgp.zzb(string4, exception2);
            this.zza(string2, string3, string4, string5);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzfb(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzfb(String string2) {
        Object object = this;
        synchronized (object) {
            this.zzeih = true;
            this.notify();
            ((zzbft)this).release();
        }
        if (this.zzecf != null) {
            object = ((zzbft)this).zzey(this.zzecf);
            if (this.zzeiv != null) {
                this.zza(this.zzecf, (String)object, "badUrl", zzbgp.zzb(string2, this.zzeiv));
                return;
            }
            this.zza(this.zzecf, (String)object, "externalAbort", "Programmatic precache abort.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzbfa zzaaa() {
        Object object = this;
        synchronized (object) {
            this.zzeiw = true;
            this.notify();
        }
        this.zzeiu.zza((zzbfi)null);
        object = this.zzeiu;
        this.zzeiu = null;
        return object;
    }

    private static String zzb(String string2, Exception exception) {
        String string3 = exception.getClass().getCanonicalName();
        String string4 = exception.getMessage();
        return new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append("/").append(string3).append(":").append(string4).toString();
    }
}

