/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzj;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzadb;
import com.google.android.gms.internal.ads.zzadg;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzadi;
import com.google.android.gms.internal.ads.zzadv;
import com.google.android.gms.internal.ads.zzadx;
import com.google.android.gms.internal.ads.zzaho;
import com.google.android.gms.internal.ads.zzaqb;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzaya;
import com.google.android.gms.internal.ads.zzazs;
import com.google.android.gms.internal.ads.zzazt;
import com.google.android.gms.internal.ads.zzbai;
import com.google.android.gms.internal.ads.zzbcw;
import com.google.android.gms.internal.ads.zzbfs;
import com.google.android.gms.internal.ads.zzbft;
import com.google.android.gms.internal.ads.zzbgz;
import com.google.android.gms.internal.ads.zzbha;
import com.google.android.gms.internal.ads.zzbhn;
import com.google.android.gms.internal.ads.zzbho;
import com.google.android.gms.internal.ads.zzbhp;
import com.google.android.gms.internal.ads.zzbhq;
import com.google.android.gms.internal.ads.zzbht;
import com.google.android.gms.internal.ads.zzbid;
import com.google.android.gms.internal.ads.zzbii;
import com.google.android.gms.internal.ads.zzbim;
import com.google.android.gms.internal.ads.zzbin;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzdob;
import com.google.android.gms.internal.ads.zzud;
import com.google.android.gms.internal.ads.zzwj;
import com.google.android.gms.internal.ads.zzwl;
import com.google.android.gms.internal.ads.zzwt;
import com.google.android.gms.internal.ads.zzxn;
import com.google.android.gms.internal.ads.zzyt;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzard
@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzbhm
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzbgz {
    private final zzbim zzekn;
    @Nullable
    private final zzdh zzeko;
    private final zzbai zzbtc;
    private final zzj zzekp;
    private final zza zzekq;
    private final DisplayMetrics zzwb;
    private final float zzekr;
    private boolean zzeks = false;
    private boolean zzekt = false;
    private zzbha zzeku;
    @GuardedBy(value="this")
    private zzd zzekv;
    @GuardedBy(value="this")
    private IObjectWrapper zzekw;
    @GuardedBy(value="this")
    private zzbin zzekx;
    @GuardedBy(value="this")
    private String zzaap;
    @GuardedBy(value="this")
    private boolean zzdko;
    @GuardedBy(value="this")
    private boolean zzeky;
    @GuardedBy(value="this")
    private boolean zzekz;
    @GuardedBy(value="this")
    private boolean zzela;
    @GuardedBy(value="this")
    private Boolean zzdtr;
    @GuardedBy(value="this")
    private int zzelb;
    @GuardedBy(value="this")
    private boolean zzelc = true;
    @GuardedBy(value="this")
    private boolean zzeld = false;
    @GuardedBy(value="this")
    private String zzdlx = "";
    @GuardedBy(value="this")
    private zzbhq zzele;
    @GuardedBy(value="this")
    private boolean zzelf;
    @GuardedBy(value="this")
    private boolean zzelg;
    @GuardedBy(value="this")
    private zzadx zzelh;
    @GuardedBy(value="this")
    private zzadv zzeli;
    @GuardedBy(value="this")
    private int zzelj;
    @GuardedBy(value="this")
    private int zzelk;
    private zzadg zzell;
    private zzadg zzeem;
    private zzadg zzelm;
    private zzadh zzeln;
    private WeakReference<View.OnClickListener> zzelo;
    @GuardedBy(value="this")
    private zzd zzelp;
    @GuardedBy(value="this")
    private boolean zzelq;
    private zzazs zzelr;
    private int zzdlu = -1;
    private int zzdlt = -1;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private Map<String, zzbft> zzels;
    private final WindowManager zzbtf;
    private final zzwj zzejd;

    static zzbhm zzb(Context context, zzbin zzbin2, String string2, boolean bl, boolean bl2, @Nullable zzdh zzdh2, zzbai zzbai2, zzadi zzadi2, zzj zzj2, zza zza2, zzwj zzwj2) {
        zzbim zzbim2 = new zzbim(context);
        return new zzbhm(zzbim2, zzbin2, string2, bl, bl2, zzdh2, zzbai2, zzadi2, zzj2, zza2, zzwj2);
    }

    @VisibleForTesting
    private zzbhm(zzbim zzbim2, zzbin zzbin2, String string2, boolean bl, boolean bl2, @Nullable zzdh zzdh2, zzbai zzbai2, zzadi zzadi2, zzj zzj2, zza zza2, zzwj zzwj2) {
        super((Context)zzbim2);
        this.zzekn = zzbim2;
        this.zzekx = zzbin2;
        this.zzaap = string2;
        this.zzekz = bl;
        this.zzelb = -1;
        this.zzeko = zzdh2;
        this.zzbtc = zzbai2;
        this.zzekp = zzj2;
        this.zzekq = zza2;
        this.zzbtf = (WindowManager)this.getContext().getSystemService("window");
        zzk.zzlg();
        this.zzwb = zzaxi.zza(this.zzbtf);
        this.zzekr = this.zzwb.density;
        this.zzejd = zzwj2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzawz.zzc((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzk.zzlg().zza((Context)zzbim2, zzbai2.zzbsx, webSettings);
        zzk.zzli().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzabn();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            this.addJavascriptInterface(zzbht.zzc(this), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzelr = new zzazs(this.zzekn.zzyd(), (View)this, this, null);
        zzadi zzadi3 = zzadi2;
        zzbhm zzbhm2 = this;
        zzbhm2.zzabr();
        zzbhm2.zzeln = new zzadh(new zzadi(true, "make_wv", zzbhm2.zzaap));
        zzbhm2.zzeln.zzqw().zzc(zzadi3);
        zzbhm2.zzeem = zzadb.zzb(zzbhm2.zzeln.zzqw());
        zzbhm2.zzeln.zza("native:view_create", zzbhm2.zzeem);
        zzbhm2.zzelm = null;
        zzbhm2.zzell = null;
        zzk.zzli().zzay((Context)zzbim2);
        zzk.zzlk().zzuz();
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzbha) {
            this.zzeku = (zzbha)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zza zzye() {
        return this.zzekq;
    }

    private final boolean zzabk() {
        int n;
        int n2;
        if (!this.zzeku.zzaay() && !this.zzeku.zzaaz()) {
            return false;
        }
        zzyt.zzpa();
        int n3 = zzazt.zzb((DisplayMetrics)this.zzwb, (int)this.zzwb.widthPixels);
        zzyt.zzpa();
        int n4 = zzazt.zzb((DisplayMetrics)this.zzwb, (int)this.zzwb.heightPixels);
        Activity activity = this.zzekn.zzyd();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzk.zzlg();
            int[] nArray = zzaxi.zzd(activity);
            zzyt.zzpa();
            n2 = zzazt.zzb((DisplayMetrics)this.zzwb, (int)nArray[0]);
            zzyt.zzpa();
            n = zzazt.zzb((DisplayMetrics)this.zzwb, (int)nArray[1]);
        }
        if (this.zzdlt == n3 && this.zzdlu == n4 && this.maxWidth == n2 && this.maxHeight == n) {
            return false;
        }
        boolean bl = this.zzdlt != n3 || this.zzdlu != n4;
        this.zzdlt = n3;
        this.zzdlu = n4;
        this.maxWidth = n2;
        this.maxHeight = n;
        new zzaqb(this).zza(n3, n4, n2, n, this.zzwb.density, this.zzbtf.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzk.zzlg().zzi(map);
        }
        catch (JSONException jSONException) {
            zzawz.zzep((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zza(string2, jSONObject);
    }

    @TargetApi(value=19)
    public final synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzawz.zzer((String)"#004 The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    private final synchronized void zzfc(String string2) {
        if (!this.isDestroyed()) {
            this.loadUrl(string2);
            return;
        }
        zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            try {
                super.loadUrl(string2);
                return;
            }
            catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
                zzk.zzlk().zza(throwable, "AdWebViewImpl.loadUrl");
                zzawz.zzd((String)"Could not call loadUrl. ", (Throwable)throwable);
                return;
            }
        }
        zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    private final synchronized void zzfd(String string2) {
        try {
            super.loadUrl(string2);
            return;
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
            zzk.zzlk().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
            zzawz.zzd((String)"Could not call loadUrl. ", (Throwable)throwable);
            return;
        }
    }

    @Override
    public final synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void zzb(String string2, String string3, @Nullable String string4) {
        if (!this.isDestroyed()) {
            zzacj zzacj2 = zzacu.zzcok;
            String string5 = (Boolean)zzyt.zzpe().zzd(zzacj2) != false ? zzbid.zzf(string3, zzbid.zzabt()) : string3;
            super.loadDataWithBaseURL(string2, string5, "text/html", "UTF-8", string4);
            return;
        }
        zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @TargetApi(value=19)
    private final synchronized void zza(String string2, ValueCallback<String> valueCallback) {
        if (!this.isDestroyed()) {
            this.evaluateJavascript(string2, null);
            return;
        }
        zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    private final void zzfe(String string2) {
        if (PlatformVersion.isAtLeastKitKat()) {
            if (this.zzux() == null) {
                this.zzabl();
            }
            if (this.zzux().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
                return;
            }
            String string3 = String.valueOf(string2);
            this.zzfc(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            return;
        }
        String string4 = String.valueOf(string2);
        this.zzfc(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
    }

    @Override
    public final void zzco(String string2) {
        this.zzfe(string2);
    }

    private final synchronized void zzabl() {
        this.zzdtr = zzk.zzlk().zzux();
        if (this.zzdtr == null) {
            try {
                String string2 = "(function(){})()";
                this.evaluateJavascript(string2, null);
                this.zza(true);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                this.zza(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void zza(Boolean bl) {
        zzbhm zzbhm2 = this;
        synchronized (zzbhm2) {
            this.zzdtr = bl;
        }
        zzk.zzlk().zza(bl);
    }

    @VisibleForTesting
    private final synchronized Boolean zzux() {
        return this.zzdtr;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        String string3;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string4 = string3 = jSONObject.toString();
        String string5 = string2;
        zzbhm zzbhm2 = this;
        String string6 = new StringBuilder(3 + String.valueOf(string5).length() + String.valueOf(string4).length()).append(string5).append("(").append(string4).append(");").toString();
        zzbhm2.zzfe(string6);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzawz.zzdp((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzfe(stringBuilder.toString());
    }

    @Override
    public final void zzaab() {
        this.zzabm();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbtc.zzbsx);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzdi(int n) {
        if (n == 0) {
            zzbhm zzbhm2 = this;
            zzadb.zza(zzbhm2.zzeln.zzqw(), zzbhm2.zzeem, "aebb2");
        }
        this.zzabm();
        if (this.zzeln.zzqw() != null) {
            this.zzeln.zzqw().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzbtc.zzbsx);
        this.zza("onhide", hashMap);
    }

    private final void zzabm() {
        zzadb.zza(this.zzeln.zzqw(), this.zzeem, "aeh2");
    }

    @Override
    public final void zztl() {
        if (this.zzell == null) {
            zzadb.zza(this.zzeln.zzqw(), this.zzeem, "aes2");
            this.zzell = zzadb.zzb(this.zzeln.zzqw());
            this.zzeln.zza("native:view_show", this.zzell);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbtc.zzbsx);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zzaac() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzk.zzll().zzpr()));
        hashMap.put("app_volume", String.valueOf(zzk.zzll().zzpq()));
        hashMap.put("device_volume", String.valueOf(zzaya.zzba(this.getContext())));
        this.zza("volume", hashMap);
    }

    @Override
    public final void zza(boolean bl, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("success", bl ? "1" : "0");
        hashMap.put("duration", Long.toString(l));
        this.zza("onCacheAccessComplete", hashMap);
    }

    @Override
    public final synchronized zzd zzaae() {
        return this.zzekv;
    }

    @Override
    public final synchronized IObjectWrapper zzaam() {
        return this.zzekw;
    }

    @Override
    public final synchronized zzd zzaaf() {
        return this.zzelp;
    }

    @Override
    public final synchronized zzbin zzaag() {
        return this.zzekx;
    }

    @Override
    public final synchronized String zzaah() {
        return this.zzaap;
    }

    @Override
    public final WebViewClient zzaaj() {
        return this.zzeku;
    }

    @Override
    public final synchronized boolean zzaak() {
        return this.zzdko;
    }

    @Override
    public final zzdh zzaal() {
        return this.zzeko;
    }

    @Override
    public final zzbai zzyh() {
        return this.zzbtc;
    }

    @Override
    public final synchronized boolean zzaan() {
        return this.zzekz;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzk.zzlg();
            zzaxi.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzawz.zzdp((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzeku.zzaaz()) {
            zzbhm zzbhm2 = this;
            synchronized (zzbhm2) {
                if (this.zzelh != null) {
                    this.zzelh.zzc(motionEvent);
                }
            }
        } else if (this.zzeko != null) {
            this.zzeko.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f = motionEvent.getAxisValue(9);
        float f2 = motionEvent.getAxisValue(10);
        if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
            return false;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzekz || this.zzekx.zzaby()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzekx.zzaca()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzekx.zzabz()) {
            zzacj zzacj2 = zzacu.zzcsk;
            if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
                super.onMeasure(n, n2);
                return;
            }
            float f = 0.0f;
            zzbhq zzbhq2 = this.zzyb();
            if (zzbhq2 != null) {
                f = zzbhq2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzekx.isFluid()) {
            int n11;
            Object object = zzacu.zzcsn;
            if (((Boolean)zzyt.zzpe().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzbho((zzbhm)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            this.zzfe(string2);
            float f = this.zzwb.density;
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzelk) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzelk * f);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzekx.zzabx()) {
            this.setMeasuredDimension(this.zzwb.widthPixels, this.zzwb.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzekx.widthPixels > n17 || this.zzekx.heightPixels > n18 ? 1 : 0;
        zzacj zzacj3 = zzacu.zzcvg;
        if (((Boolean)zzyt.zzpe().zzd(zzacj3)).booleanValue()) {
            int n20 = n4 = !((float)this.zzekx.widthPixels / this.zzekr > (float)n17 / this.zzekr) && !((float)this.zzekx.heightPixels / this.zzekr > (float)n18 / this.zzekr) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzekx.widthPixels / this.zzekr);
            int n21 = (int)((float)this.zzekx.heightPixels / this.zzekr);
            int n22 = (int)((float)n14 / this.zzekr);
            int n23 = (int)((float)n16 / this.zzekr);
            zzawz.zzep((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            if (!this.zzeks) {
                this.zzejd.zza(zzwl.zza.zzb.zzbyw);
                this.zzeks = true;
                return;
            }
        } else {
            if (this.getVisibility() != 8) {
                this.setVisibility(0);
            }
            if (!this.zzekt) {
                this.zzejd.zza(zzwl.zza.zzb.zzbyx);
                this.zzekt = true;
            }
            this.setMeasuredDimension(this.zzekx.widthPixels, this.zzekx.heightPixels);
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzabk();
        zzd zzd2 = this.zzaae();
        if (zzd2 != null && bl) {
            zzd2.zztk();
        }
    }

    @Override
    public final synchronized void zza(zzd zzd2) {
        this.zzekv = zzd2;
    }

    @Override
    public final synchronized void zzam(IObjectWrapper iObjectWrapper) {
        this.zzekw = iObjectWrapper;
    }

    @Override
    public final synchronized void zzb(zzd zzd2) {
        this.zzelp = zzd2;
    }

    @Override
    public final synchronized void zza(zzbin zzbin2) {
        this.zzekx = zzbin2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzaq(boolean bl) {
        boolean bl2 = bl != this.zzekz;
        this.zzekz = bl;
        this.zzabn();
        if (bl2) {
            new zzaqb(this).zzdj(bl ? "expanded" : "default");
        }
    }

    @Override
    public final void zzaar() {
        this.zzelr.zzwt();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzelr.onAttachedToWindow();
        }
        boolean bl = this.zzelf;
        if (this.zzeku != null && this.zzeku.zzaaz()) {
            bl = true;
            if (!this.zzelg) {
                this.zzeku.zzaba();
                this.zzeku.zzabb();
                this.zzelg = true;
            }
            this.zzabk();
        }
        this.zzav(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzbhm zzbhm2 = this;
        synchronized (zzbhm2) {
            if (!this.isDestroyed()) {
                this.zzelr.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzelg && this.zzeku != null && this.zzeku.zzaaz() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                this.zzeku.zzaba();
                this.zzeku.zzabb();
                this.zzelg = false;
            }
        }
        this.zzav(false);
    }

    @Override
    public final void zzbn(Context context) {
        this.zzekn.setBaseContext(context);
        this.zzelr.zzh(this.zzekn.zzyd());
    }

    @Override
    public final synchronized void zzaf(boolean bl) {
        if (this.zzekv != null) {
            this.zzekv.zza(this.zzeku.zzaay(), bl);
            return;
        }
        this.zzdko = bl;
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzelb = n;
        if (this.zzekv != null) {
            this.zzekv.setRequestedOrientation(this.zzelb);
        }
    }

    @Override
    public final Activity zzyd() {
        return this.zzekn.zzyd();
    }

    @Override
    public final Context zzaad() {
        return this.zzekn.zzaad();
    }

    private final synchronized void zzabn() {
        if (this.zzekz || this.zzekx.zzabx()) {
            zzawz.zzdp((String)"Enabling hardware acceleration on an overlay.");
            this.zzabp();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzawz.zzdp((String)"Disabling hardware acceleration on an AdView.");
            this.zzabo();
            return;
        }
        zzawz.zzdp((String)"Enabling hardware acceleration on an AdView.");
        this.zzabp();
    }

    private final synchronized void zzabo() {
        if (!this.zzela) {
            zzk.zzli();
            this.setLayerType(1, null);
        }
        this.zzela = true;
    }

    private final synchronized void zzabp() {
        if (this.zzela) {
            zzk.zzli();
            this.setLayerType(0, null);
        }
        this.zzela = false;
    }

    @Override
    public final synchronized void destroy() {
        this.zzabr();
        this.zzelr.zzwu();
        if (this.zzekv != null) {
            this.zzekv.close();
            this.zzekv.onDestroy();
            this.zzekv = null;
        }
        this.zzekw = null;
        this.zzeku.reset();
        if (this.zzeky) {
            return;
        }
        zzk.zzmc();
        zzbfs.zzc(this);
        this.zzabq();
        this.zzeky = true;
        zzawz.zzds("Initiating WebView self destruct sequence in 3...");
        zzawz.zzds("Loading blank page in WebView, 2...");
        this.zzfd("about:blank");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            zzbhm zzbhm2 = this;
            synchronized (zzbhm2) {
                if (!this.zzeky) {
                    this.zzeku.reset();
                    zzk.zzmc();
                    zzbfs.zzc(this);
                    this.zzabq();
                    this.zzva();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final synchronized void zzaao() {
        zzawz.zzds("Destroying WebView!");
        this.zzva();
        zzaxi.zzdvv.post((Runnable)new zzbhp(this));
    }

    private final synchronized void zzva() {
        if (!this.zzelq) {
            this.zzelq = true;
            zzk.zzlk().zzva();
        }
    }

    @Override
    public final synchronized boolean isDestroyed() {
        return this.zzeky;
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public final void zzaas() {
        if (this.zzelm == null) {
            this.zzelm = zzadb.zzb(this.zzeln.zzqw());
            this.zzeln.zza("native:view_load", this.zzelm);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzaav() {
        zzawz.zzds("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void zzat(boolean bl) {
        this.zzeku.zzat(bl);
    }

    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzar(boolean bl) {
        this.zzelc = bl;
    }

    @Override
    public final synchronized boolean zzaap() {
        return this.zzelc;
    }

    @Override
    public final synchronized void zzlc() {
        this.zzeld = true;
        if (this.zzekp != null) {
            this.zzekp.zzlc();
        }
    }

    @Override
    public final synchronized void zzld() {
        this.zzeld = false;
        if (this.zzekp != null) {
            this.zzekp.zzld();
        }
    }

    private final synchronized void zzabq() {
        if (this.zzels != null) {
            Iterator<zzbft> iterator = this.zzels.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
        this.zzels = null;
    }

    @Override
    public final synchronized void zza(String string2, zzbft zzbft2) {
        if (this.zzels == null) {
            this.zzels = new HashMap<String, zzbft>();
        }
        this.zzels.put(string2, zzbft2);
    }

    @Override
    public final synchronized zzbft zzet(String string2) {
        if (this.zzels == null) {
            return null;
        }
        return this.zzels.get(string2);
    }

    @Override
    public final synchronized String zzyf() {
        return this.zzdlx;
    }

    @Override
    public final zzbcw zzya() {
        return null;
    }

    @Override
    public final synchronized void zzyk() {
        if (this.zzeli != null) {
            this.zzeli.zzre();
        }
    }

    @Override
    public final synchronized void zza(zzadv zzadv2) {
        this.zzeli = zzadv2;
    }

    @Override
    public final zzadg zzyc() {
        return this.zzeem;
    }

    @Override
    public final zzadh zzyg() {
        return this.zzeln;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzelo = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final synchronized void zza(zzadx zzadx2) {
        this.zzelh = zzadx2;
    }

    @Override
    public final synchronized zzadx zzaat() {
        return this.zzelh;
    }

    @Override
    public final synchronized zzbhq zzyb() {
        return this.zzele;
    }

    @Override
    public final synchronized void zza(zzbhq zzbhq2) {
        if (this.zzele != null) {
            zzawz.zzen((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzele = zzbhq2;
    }

    @Override
    public final synchronized boolean zzaaq() {
        return this.zzelj > 0;
    }

    @Override
    public final synchronized void zzas(boolean bl) {
        this.zzelj += bl ? 1 : -1;
        if (this.zzelj <= 0 && this.zzekv != null) {
            this.zzekv.zztn();
        }
    }

    private final void zzabr() {
        if (this.zzeln == null) {
            return;
        }
        zzadi zzadi2 = this.zzeln.zzqw();
        if (zzadi2 != null && zzk.zzlk().zzuw() != null) {
            zzk.zzlk().zzuw().zza(zzadi2);
        }
    }

    @Override
    public final void zzaau() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzao(boolean bl) {
        this.zzeku.zzao(bl);
    }

    @Override
    public final void zztm() {
        zzd zzd2 = this.zzaae();
        if (zzd2 != null) {
            zzd2.zztm();
        }
    }

    @Override
    public final int zzyi() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzyj() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzeku.zza(zzc2);
    }

    @Override
    public final void zzc(boolean bl, int n) {
        this.zzeku.zzc(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzeku.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzeku.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzud zzud2) {
        zzbhm zzbhm2 = this;
        synchronized (zzbhm2) {
            this.zzelf = zzud2.zzbtk;
        }
        this.zzav(zzud2.zzbtk);
    }

    private final void zzav(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzaho<? super zzbgz> zzaho2) {
        if (this.zzeku != null) {
            this.zzeku.zza(string2, zzaho2);
        }
    }

    @Override
    public final void zzb(String string2, zzaho<? super zzbgz> zzaho2) {
        if (this.zzeku != null) {
            this.zzeku.zzb(string2, zzaho2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzaho<? super zzbgz>> predicate) {
        if (this.zzeku != null) {
            this.zzeku.zza(string2, predicate);
        }
    }

    @Override
    public final boolean zzb(boolean bl, int n) {
        this.destroy();
        this.zzejd.zza(new zzbhn(bl, n));
        this.zzejd.zza(zzwl.zza.zzb.zzbyy);
        return true;
    }

    @Override
    public final boolean zzaaw() {
        return false;
    }

    @Override
    public final /* synthetic */ zzbii zzaai() {
        return this.zzeku;
    }

    static final /* synthetic */ void zza(boolean bl, int n, zzxn zzxn2) {
        zzwt.zzv.zza zza2 = zzwt.zzv.zzop();
        if (zza2.zzoo() != bl) {
            zza2.zzr(bl);
        }
        zza2.zzcm(n);
        zzxn2.zzcfn = (zzwt.zzv)((zzdob)zza2.zzaya());
    }

    static /* synthetic */ int zza(zzbhm zzbhm2) {
        return zzbhm2.zzelk;
    }

    static /* synthetic */ int zza(zzbhm zzbhm2, int n) {
        zzbhm2.zzelk = n;
        return zzbhm2.zzelk;
    }

    static /* synthetic */ void zzb(zzbhm zzbhm2) {
        super.destroy();
    }
}

