/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzaag;
import com.google.android.gms.internal.ads.zzaak;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzagd;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzbad;
import com.google.android.gms.internal.ads.zzbai;
import com.google.android.gms.internal.ads.zzbao;
import com.google.android.gms.internal.ads.zzbmn;
import com.google.android.gms.internal.ads.zzbri;
import com.google.android.gms.internal.ads.zzbrt;
import com.google.android.gms.internal.ads.zzbva;
import com.google.android.gms.internal.ads.zzbxz;
import com.google.android.gms.internal.ads.zzbya;
import com.google.android.gms.internal.ads.zzbyt;
import com.google.android.gms.internal.ads.zzbzb;
import com.google.android.gms.internal.ads.zzbzc;
import com.google.android.gms.internal.ads.zzbzq;
import com.google.android.gms.internal.ads.zzccj;
import com.google.android.gms.internal.ads.zzcxm;
import com.google.android.gms.internal.ads.zzcxv;
import com.google.android.gms.internal.ads.zzdae;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzyt;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zzbxx
implements zzbzb {
    private final Context zzlj;
    private final zzbzc zzfgz;
    private final JSONObject zzfmo;
    private final zzccj zzfmp;
    private final zzbyt zzfmq;
    private final zzdh zzeko;
    private final zzbrt zzfmr;
    private final zzbri zzfms;
    private final zzcxm zzfig;
    private final zzbai zzbtc;
    private final zzcxv zzfjp;
    private final zzbmn zzfmt;
    private final zzbzq zzfmu;
    private final Clock zzbsa;
    private final zzbva zzfmv;
    private final zzdae zzffb;
    private boolean zzfmw = false;
    private boolean zzfmx;
    private boolean zzfmy = false;
    private boolean zzfmz = false;
    private Point zzfna = new Point();
    private Point zzfnb = new Point();
    private long zzfnc = 0L;
    private long zzfnd = 0L;
    private zzaag zzfne;

    public zzbxx(Context context, zzbzc zzbzc2, JSONObject jSONObject, zzccj zzccj2, zzbyt zzbyt2, zzdh zzdh2, zzbrt zzbrt2, zzbri zzbri2, zzcxm zzcxm2, zzbai zzbai2, zzcxv zzcxv2, zzbmn zzbmn2, zzbzq zzbzq2, Clock clock, zzbva zzbva2, zzdae zzdae2) {
        this.zzlj = context;
        this.zzfgz = zzbzc2;
        this.zzfmo = jSONObject;
        this.zzfmp = zzccj2;
        this.zzfmq = zzbyt2;
        this.zzeko = zzdh2;
        this.zzfmr = zzbrt2;
        this.zzfms = zzbri2;
        this.zzfig = zzcxm2;
        this.zzbtc = zzbai2;
        this.zzfjp = zzcxv2;
        this.zzfmt = zzbmn2;
        this.zzfmu = zzbzq2;
        this.zzbsa = clock;
        this.zzfmv = zzbva2;
        this.zzffb = zzdae2;
    }

    @Override
    public final void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        View view2;
        Iterator<Map.Entry<String, WeakReference<View>>> iterator;
        this.zzfna = new Point();
        this.zzfnb = new Point();
        if (!this.zzfmx) {
            this.zzfmv.zzq(view);
            this.zzfmx = true;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        this.zzfmt.zzq(this);
        if (map != null) {
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                view2.setOnTouchListener(onTouchListener);
                view2.setClickable(true);
                view2.setOnClickListener(onClickListener);
            }
        }
        if (map2 != null) {
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                view2.setOnTouchListener(onTouchListener);
                view2.setClickable(false);
            }
        }
    }

    @Override
    public final void zza(View view, @Nullable Map<String, WeakReference<View>> map) {
        this.zzfna = new Point();
        this.zzfnb = new Point();
        this.zzfmv.zzr(view);
        this.zzfmx = false;
    }

    private final boolean zzfh(String string2) {
        JSONObject jSONObject = this.zzfmo.optJSONObject("allow_pub_event_reporting");
        return jSONObject != null && jSONObject.optBoolean(string2, false);
    }

    @Override
    public final void zza(View view, @Nullable View view2, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, boolean bl) {
        JSONObject jSONObject = this.zza(map, map2, view2);
        JSONObject jSONObject2 = this.zzs(view2);
        JSONObject jSONObject3 = zzbxx.zzt(view2);
        JSONObject jSONObject4 = this.zzu(view2);
        String string2 = this.zzb(view, map);
        JSONObject jSONObject5 = this.zzfj(string2);
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null, bl, false);
    }

    @Nullable
    private final String zzb(@Nullable View view, @Nullable Map<String, WeakReference<View>> map) {
        if (map != null && view != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (!view.equals(view2)) continue;
                return entry.getKey();
            }
        }
        switch (this.zzfmq.zzahv()) {
            case 2: {
                return "2099";
            }
            case 1: {
                return "1099";
            }
            case 3: {
                return null;
            }
            case 6: {
                return "3099";
            }
        }
        return null;
    }

    @Override
    public final void zzfi(String string2) {
        this.zza(null, null, null, null, null, string2, null, null, false, false);
    }

    @Override
    public final void zzf(@Nullable Bundle bundle) {
        if (bundle == null) {
            zzawz.zzdp((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzfh("click_reporting")) {
            zzawz.zzen((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        Bundle bundle2 = bundle.getBundle("click_signal");
        String string2 = bundle2 != null ? bundle2.getString("asset_id") : null;
        JSONObject jSONObject = zzk.zzlg().zza(bundle, null);
        this.zza(null, null, null, null, null, string2, null, jSONObject, false, false);
    }

    @Override
    public final void zza(@Nullable View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, boolean bl) {
        if (!this.zzfmz) {
            zzawz.zzdp((String)"Custom click reporting failed. enableCustomClickGesture is not set.");
            return;
        }
        if (!this.zzahj()) {
            zzawz.zzdp((String)"Custom click reporting failed. Ad unit id not whitelisted.");
            return;
        }
        JSONObject jSONObject = this.zza(map, map2, view);
        JSONObject jSONObject2 = this.zzs(view);
        JSONObject jSONObject3 = zzbxx.zzt(view);
        JSONObject jSONObject4 = this.zzu(view);
        String string2 = this.zzb(null, map);
        JSONObject jSONObject5 = this.zzfj(string2);
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null, bl, true);
    }

    private final boolean zzahj() {
        return this.zzfmo.optBoolean("allow_custom_click_gesture", false);
    }

    @Override
    public final void zzro() {
        this.zzfmz = true;
    }

    private final void zza(@Nullable View view, @Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3, @Nullable JSONObject jSONObject4, @Nullable String string2, @Nullable JSONObject jSONObject5, @Nullable JSONObject jSONObject6, boolean bl, boolean bl2) {
        Preconditions.checkMainThread((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("ad", (Object)this.zzfmo);
            jSONObject7.put("asset_view_signal", (Object)jSONObject2);
            jSONObject7.put("ad_view_signal", (Object)jSONObject);
            jSONObject7.put("click_signal", (Object)jSONObject5);
            jSONObject7.put("scroll_view_signal", (Object)jSONObject3);
            jSONObject7.put("lock_screen_signal", (Object)jSONObject4);
            jSONObject7.put("has_custom_click_handler", this.zzfgz.zzfo(this.zzfmq.getCustomTemplateId()) != null);
            jSONObject7.put("provided_signals", (Object)jSONObject6);
            JSONObject jSONObject8 = new JSONObject();
            jSONObject8.put("asset_id", (Object)string2);
            jSONObject8.put("template", this.zzfmq.zzahv());
            jSONObject8.put("view_aware_api_used", bl);
            zzbxx zzbxx2 = this;
            jSONObject8.put("custom_mute_requested", zzbxx2.zzfjp.zzdgs != null && zzbxx2.zzfjp.zzdgs.zzbqh);
            zzbxx2 = this;
            jSONObject8.put("custom_mute_enabled", !zzbxx2.zzfmq.getMuteThisAdReasons().isEmpty() && zzbxx2.zzfmq.zzahx() != null);
            JSONObject jSONObject9 = jSONObject8;
            zzbxx2 = this;
            if (zzbxx2.zzfmu.zzaiz() != null && zzbxx2.zzfmo.optBoolean("custom_one_point_five_click_enabled", false)) {
                jSONObject9.put("custom_one_point_five_click_eligible", true);
            }
            jSONObject9.put("timestamp", zzbxx2.zzbsa.currentTimeMillis());
            boolean bl3 = bl2;
            jSONObject9 = jSONObject8;
            zzbxx2 = this;
            if (zzbxx2.zzfmz && zzbxx2.zzahj()) {
                jSONObject9.put("custom_click_gesture_eligible", true);
            }
            if (bl3) {
                jSONObject9.put("is_custom_click_gesture", true);
            }
            jSONObject8.put("has_custom_click_handler", this.zzfgz.zzfo(this.zzfmq.getCustomTemplateId()) != null);
            jSONObject8.put("click_signals", (Object)this.zzv(view));
            jSONObject7.put("click", (Object)jSONObject8);
            JSONObject jSONObject10 = new JSONObject();
            long l = this.zzbsa.currentTimeMillis();
            jSONObject10.put("time_from_last_touch_down", l - this.zzfnc);
            jSONObject10.put("time_from_last_touch", l - this.zzfnd);
            jSONObject7.put("touch_signal", (Object)jSONObject10);
            zzbao.zza(this.zzfmp.zzc("google.afma.nativeAds.handleClick", jSONObject7), "Error during performing handleClick");
            return;
        }
        catch (JSONException jSONException) {
            zzawz.zzc((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zza(View view, MotionEvent motionEvent, @Nullable View view2) {
        long l;
        View view3 = view2;
        MotionEvent motionEvent2 = motionEvent;
        int[] nArray = zzbxx.zzw(view3);
        int n = (int)motionEvent2.getRawX() - nArray[0];
        int n2 = (int)motionEvent2.getRawY() - nArray[1];
        this.zzfna = new Point(n, n2);
        this.zzfnd = l = this.zzbsa.currentTimeMillis();
        if (motionEvent.getAction() == 0) {
            this.zzfnc = l;
            this.zzfnb = this.zzfna;
        }
        MotionEvent motionEvent3 = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent3.setLocation((float)this.zzfna.x, (float)this.zzfna.y);
        this.zzeko.zza(motionEvent3);
        motionEvent3.recycle();
    }

    @Override
    public final void zzg(@Nullable Bundle bundle) {
        if (bundle == null) {
            zzawz.zzdp((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzfh("touch_reporting")) {
            zzawz.zzen((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzeko.zzcg().zza(n, n2, n3);
    }

    @Override
    public final void zzahk() {
        this.zza((JSONObject)null, (JSONObject)null, (JSONObject)null, (JSONObject)null, (JSONObject)null);
    }

    @Override
    public final void setClickConfirmingView(View view) {
        if (!this.zzfmo.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzawz.zzep((String)"setClickConfirmingView: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        View view2 = view;
        zzbzq zzbzq2 = this.zzfmu;
        if (view2 != null) {
            view2.setOnClickListener((View.OnClickListener)zzbzq2);
            view2.setClickable(true);
            zzbzq2.zzfqe = new WeakReference<View>(view2);
        }
    }

    @Override
    public final void zza(zzagd zzagd2) {
        if (!this.zzfmo.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzawz.zzep((String)"setUnconfirmedClickListener: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        this.zzfmu.zza(zzagd2);
    }

    @Override
    public final void cancelUnconfirmedClick() {
        if (!this.zzfmo.optBoolean("custom_one_point_five_click_enabled", false)) {
            return;
        }
        this.zzfmu.cancelUnconfirmedClick();
    }

    @Override
    public final void zza(@Nullable zzaak zzaak2) {
        try {
            if (this.zzfmy) {
                return;
            }
            if (zzaak2 == null && this.zzfmq.zzahx() != null) {
                this.zzfmy = true;
                this.zzffb.zzed(this.zzfmq.zzahx().zzpt());
                this.zzahl();
                return;
            }
            this.zzfmy = true;
            this.zzffb.zzed(zzaak2.zzpt());
            this.zzahl();
            return;
        }
        catch (RemoteException remoteException) {
            zzawz.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    @Override
    public final void zza(zzaag zzaag2) {
        this.zzfne = zzaag2;
    }

    @Override
    public final void zzahl() {
        try {
            if (this.zzfne != null) {
                this.zzfne.onAdMuted();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawz.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    @Override
    public final void zza(@Nullable View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2) {
        JSONObject jSONObject = this.zza(map, map2, view);
        JSONObject jSONObject2 = this.zzs(view);
        JSONObject jSONObject3 = zzbxx.zzt(view);
        JSONObject jSONObject4 = this.zzu(view);
        this.zza(jSONObject2, jSONObject, jSONObject3, jSONObject4, null);
    }

    @Override
    public final void zzahm() {
        Preconditions.checkMainThread((String)"recordDownloadedImpression must be called on the main UI thread.");
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzfmo);
            zzbao.zza(this.zzfmp.zzc("google.afma.nativeAds.handleDownloadedImpression", jSONObject), "Error during performing handleDownloadedImpression");
            return;
        }
        catch (JSONException jSONException) {
            zzbad.zzc((String)"", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final boolean zzh(Bundle bundle) {
        if (!this.zzfh("impression_reporting")) {
            zzawz.zzen((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzk.zzlg().zza(bundle, null);
        return this.zza(null, null, null, null, jSONObject);
    }

    private final boolean zza(@Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3, @Nullable JSONObject jSONObject4, @Nullable JSONObject jSONObject5) {
        Preconditions.checkMainThread((String)"recordImpression must be called on the main UI thread.");
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzfmo);
            jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            jSONObject6.put("ad_view_signal", (Object)jSONObject);
            jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            jSONObject6.put("lock_screen_signal", (Object)jSONObject4);
            jSONObject6.put("provided_signals", (Object)jSONObject5);
            this.zzfmp.zza("/logScionEvent", new zzbxz(this, null));
            this.zzfmp.zza("/nativeImpression", new zzbya(this, null));
            zzbao.zza(this.zzfmp.zzc("google.afma.nativeAds.handleImpression", jSONObject6), "Error during performing handleImpression");
        }
        catch (JSONException jSONException) {
            zzawz.zzc((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        if (!this.zzfmw && this.zzfig.zzgkj != null) {
            this.zzfmw |= zzk.zzlq().zzb(this.zzlj, this.zzbtc.zzbsx, this.zzfig.zzgkj.toString(), this.zzfjp.zzglb);
        }
        return true;
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzdm(rect.right - rect.left));
        jSONObject.put("height", this.zzdm(rect.bottom - rect.top));
        jSONObject.put("x", this.zzdm(rect.left));
        jSONObject.put("y", this.zzdm(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzs(@Nullable View view) {
        JSONObject jSONObject;
        Object object;
        JSONObject jSONObject2 = new JSONObject();
        if (view == null) {
            return jSONObject2;
        }
        try {
            Object object2;
            object = zzbxx.zzw(view);
            jSONObject = new JSONObject();
            jSONObject.put("width", this.zzdm(view.getMeasuredWidth()));
            jSONObject.put("height", this.zzdm(view.getMeasuredHeight()));
            jSONObject.put("x", this.zzdm((int)object[0]));
            jSONObject.put("y", this.zzdm((int)object[1]));
            jSONObject.put("relative_to", (Object)"window");
            jSONObject2.put("frame", (Object)jSONObject);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                object2 = this.zzb(rect);
            } else {
                object2 = new JSONObject();
                object2.put("width", 0);
                object2.put("height", 0);
                object2.put("x", this.zzdm((int)object[0]));
                object2.put("y", this.zzdm((int)object[1]));
                object2.put("relative_to", (Object)"window");
            }
            jSONObject2.put("visible_bounds", object2);
        }
        catch (Exception exception) {
            zzawz.zzep((String)"Unable to get native ad view bounding box");
        }
        zzacj zzacj2 = zzacu.zzcww;
        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            object = "";
            jSONObject = view.getParent();
            if (jSONObject != null) {
                try {
                    object = (String)jSONObject.getClass().getMethod("getTemplateTypeName", new Class[0]).invoke((Object)jSONObject, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    zzawz.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)securityException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    zzawz.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    zzawz.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)invocationTargetException);
                }
            }
            try {
                switch (object) {
                    case "small_template": {
                        jSONObject2.put("native_template_type", 1);
                        break;
                    }
                    case "medium_template": {
                        jSONObject2.put("native_template_type", 2);
                        break;
                    }
                    default: {
                        jSONObject2.put("native_template_type", 0);
                        break;
                    }
                }
            }
            catch (JSONException jSONException) {
                zzawz.zzc((String)"Could not log native template signal to JSON", (Throwable)jSONException);
            }
        }
        return jSONObject2;
    }

    private static JSONObject zzt(@Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzk.zzlg();
            int n = zzaxi.zzp(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zzu(@Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzk.zzlg();
            jSONObject.put("can_show_on_lock_screen", zzaxi.zzo(view));
            zzk.zzlg();
            jSONObject.put("is_keyguard_locked", zzaxi.zzat(this.zzlj));
        }
        catch (JSONException jSONException) {
            zzawz.zzep((String)"Unable to get lock screen information");
        }
        return jSONObject;
    }

    private final JSONObject zza(@Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, @Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzbxx.zzw(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = zzbxx.zzw(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzdm(view2.getMeasuredWidth()));
                jSONObject3.put("height", this.zzdm(view2.getMeasuredHeight()));
                jSONObject3.put("x", this.zzdm(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzdm(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("x", this.zzdm(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzdm(nArray2[1] - nArray[1]));
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject2.put("is_clickable", map2 != null && map2.containsKey(entry.getKey()) && view2.isClickable());
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzawz.zzep((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    private final String zzv(View view) {
        try {
            JSONObject jSONObject = this.zzfmo.optJSONObject("tracking_urls_and_actions");
            if (jSONObject == null) {
                jSONObject = new JSONObject();
            }
            String string2 = jSONObject.optString("click_string");
            return this.zzeko.zzcg().zza(this.zzlj, string2, view);
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Exception obtaining click signals", (Throwable)exception);
            return null;
        }
    }

    private final JSONObject zzfj(@Nullable String string2) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            jSONObject.put("click_point", (Object)this.zzahn());
            jSONObject.put("asset_id", (Object)string2);
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Error occurred while grabbing click signals.", (Throwable)exception);
        }
        return jSONObject;
    }

    @Nullable
    private final JSONObject zzahn() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("x", this.zzdm(this.zzfna.x));
            jSONObject.put("y", this.zzdm(this.zzfna.y));
            jSONObject.put("start_x", this.zzdm(this.zzfnb.x));
            jSONObject.put("start_y", this.zzdm(this.zzfnb.y));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            zzawz.zzc((String)"Error occurred while putting signals into JSON object.", (Throwable)jSONException);
            return null;
        }
    }

    private static int[] zzw(@Nullable View view) {
        int[] nArray = new int[2];
        if (view != null) {
            view.getLocationOnScreen(nArray);
        }
        return nArray;
    }

    private final int zzdm(int n) {
        return zzyt.zzpa().zzb(this.zzlj, n);
    }

    @Override
    public final void destroy() {
        this.zzfmp.destroy();
    }

    static /* synthetic */ zzbrt zza(zzbxx zzbxx2) {
        return zzbxx2.zzfmr;
    }

    static /* synthetic */ zzbri zzb(zzbxx zzbxx2) {
        return zzbxx2.zzfms;
    }
}

