/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaar;
import com.google.android.gms.internal.ads.zzadv;
import com.google.android.gms.internal.ads.zzajb;
import com.google.android.gms.internal.ads.zzajc;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbpc;
import com.google.android.gms.internal.ads.zzbyn;
import com.google.android.gms.internal.ads.zzbyt;
import com.google.android.gms.internal.ads.zzcbx;
import java.util.Collections;

public final class zzcbw
extends zzajb
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzadv {
    private View zzfom;
    private zzaar zzfoh;
    private zzbyn zzfpj;
    private boolean zzeky;
    private boolean zzfsb;

    public zzcbw(zzbyn zzbyn2, zzbyt zzbyt2) {
        this.zzfom = zzbyt2.zzahy();
        this.zzfoh = zzbyt2.getVideoController();
        this.zzfpj = zzbyn2;
        this.zzeky = false;
        this.zzfsb = false;
        if (zzbyt2.zzahz() != null) {
            zzbyt2.zzahz().zza(this);
        }
    }

    public final void zza(IObjectWrapper iObjectWrapper, zzajc zzajc2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzeky) {
            zzawz.zzen((String)"Instream ad is destroyed already.");
            zzcbw.zza(zzajc2, 2);
            return;
        }
        if (this.zzfom == null || this.zzfoh == null) {
            String string2 = String.valueOf(this.zzfom == null ? "can not get video view." : "can not get video controller.");
            zzawz.zzen((String)(string2.length() != 0 ? "Instream internal error: ".concat(string2) : new String("Instream internal error: ")));
            zzcbw.zza(zzajc2, 0);
            return;
        }
        if (this.zzfsb) {
            zzawz.zzen((String)"Instream ad should not be used again.");
            zzcbw.zza(zzajc2, 1);
            return;
        }
        this.zzfsb = true;
        this.zzajf();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(this.zzfom, new ViewGroup.LayoutParams(-1, -1));
        zzk.zzmd();
        zzbbz.zza(this.zzfom, this);
        zzk.zzmd();
        zzbbz.zza(this.zzfom, this);
        this.zzajg();
        zzajc zzajc3 = zzajc2;
        try {
            zzajc3.zzrt();
            return;
        }
        catch (RemoteException remoteException) {
            zzawz.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    public final zzaar getVideoController() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzeky) {
            zzawz.zzen((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzfoh;
    }

    public final void destroy() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzajf();
        if (this.zzfpj != null) {
            ((zzbpc)this.zzfpj).destroy();
        }
        this.zzfpj = null;
        this.zzfom = null;
        this.zzfoh = null;
        this.zzeky = true;
    }

    private final void zzajf() {
        if (this.zzfom == null) {
            return;
        }
        ViewParent viewParent = this.zzfom.getParent();
        if (viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzfom);
        }
    }

    public final void onGlobalLayout() {
        this.zzajg();
    }

    public final void onScrollChanged() {
        this.zzajg();
    }

    @Override
    public final void zzre() {
        zzaxi.zzdvv.post((Runnable)new zzcbx(this));
    }

    private final void zzajg() {
        if (this.zzfpj != null && this.zzfom != null) {
            this.zzfpj.zzb(this.zzfom, Collections.emptyMap(), Collections.emptyMap(), zzbyn.zzx(this.zzfom));
        }
    }

    private static void zza(zzajc zzajc2, int n) {
        try {
            zzajc2.zzcq(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzawz.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    final /* synthetic */ void zzajh() {
        try {
            this.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzawz.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

