/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.util.Log;
import com.google.android.gms.internal.ads.zzlh;
import com.google.android.gms.internal.ads.zzlm;
import com.google.android.gms.internal.ads.zzne;
import com.google.android.gms.internal.ads.zznp;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zznx;
import com.google.android.gms.internal.ads.zzod;
import com.google.android.gms.internal.ads.zzoe;
import com.google.android.gms.internal.ads.zzsp;
import com.google.android.gms.internal.ads.zzst;
import com.google.android.gms.internal.ads.zzsy;
import com.google.android.gms.internal.ads.zzta;
import com.google.android.gms.internal.ads.zztb;
import com.google.android.gms.internal.ads.zztg;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class zzog {
    public String zzaor;
    public int number;
    public int type;
    public int zzbbh;
    public boolean zzaos;
    public byte[] zzbbi;
    public zznx zzbbj;
    public byte[] zzaov;
    public zzne zzatr;
    public int width = -1;
    public int height = -1;
    public int zzbbk = -1;
    public int zzbbl = -1;
    public int zzbbm = 0;
    public byte[] zzatv = null;
    public int zzatu = -1;
    public boolean zzbbn = false;
    public int zzbbo = -1;
    public int zzbbp = -1;
    public int zzbbq = -1;
    public int zzbbr = 1000;
    public int zzbbs = 200;
    public float zzbbt = -1.0f;
    public float zzbbu = -1.0f;
    public float zzbbv = -1.0f;
    public float zzbbw = -1.0f;
    public float zzbbx = -1.0f;
    public float zzbby = -1.0f;
    public float zzbbz = -1.0f;
    public float zzbca = -1.0f;
    public float zzbcb = -1.0f;
    public float zzbcc = -1.0f;
    public int zzafu = 1;
    public int zzbcd = -1;
    public int zzafv = 8000;
    public long zzaow = 0L;
    public long zzaox = 0L;
    public boolean zzbce;
    public boolean zzbcf = true;
    private String zzauc = "eng";
    public zznw zzbcg;
    public int zzamf;

    private zzog() {
    }

    public final void zza(zznp zznp2, int n) throws zzlm {
        zzlh zzlh2;
        int n2;
        String string2;
        String string3;
        int n3 = -1;
        int n4 = -1;
        List<byte[]> list = null;
        switch (this.zzaor) {
            case "V_VP8": {
                string3 = "video/x-vnd.on2.vp8";
                break;
            }
            case "V_VP9": {
                string3 = "video/x-vnd.on2.vp9";
                break;
            }
            case "V_MPEG2": {
                string3 = "video/mpeg2";
                break;
            }
            case "V_MPEG4/ISO/SP": 
            case "V_MPEG4/ISO/ASP": 
            case "V_MPEG4/ISO/AP": {
                string3 = "video/mp4v-es";
                list = this.zzaov == null ? null : Collections.singletonList(this.zzaov);
                break;
            }
            case "V_MPEG4/ISO/AVC": {
                string3 = "video/avc";
                zzta zzta2 = zzta.zzf(new zzst(this.zzaov));
                list = zzta2.zzafw;
                this.zzamf = zzta2.zzamf;
                break;
            }
            case "V_MPEGH/ISO/HEVC": {
                string3 = "video/hevc";
                zztg zztg2 = zztg.zzh(new zzst(this.zzaov));
                list = zztg2.zzafw;
                this.zzamf = zztg2.zzamf;
                break;
            }
            case "V_MS/VFW/FOURCC": {
                list = zzog.zza(new zzst(this.zzaov));
                if (list != null) {
                    string3 = "video/wvc1";
                    break;
                }
                Log.w((String)"MatroskaExtractor", (String)"Unsupported FourCC. Setting mimeType to video/x-unknown");
                string3 = "video/x-unknown";
                break;
            }
            case "V_THEORA": {
                string3 = "video/x-unknown";
                break;
            }
            case "A_VORBIS": {
                string3 = "audio/vorbis";
                n3 = 8192;
                list = zzog.zze(this.zzaov);
                break;
            }
            case "A_OPUS": {
                string3 = "audio/opus";
                n3 = 5760;
                list = new ArrayList<byte[]>(3);
                list.add(this.zzaov);
                list.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.zzaow).array());
                list.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.zzaox).array());
                break;
            }
            case "A_AAC": {
                string3 = "audio/mp4a-latm";
                list = Collections.singletonList(this.zzaov);
                break;
            }
            case "A_MPEG/L2": {
                string3 = "audio/mpeg-L2";
                n3 = 4096;
                break;
            }
            case "A_MPEG/L3": {
                string3 = "audio/mpeg";
                n3 = 4096;
                break;
            }
            case "A_AC3": {
                string3 = "audio/ac3";
                break;
            }
            case "A_EAC3": {
                string3 = "audio/eac3";
                break;
            }
            case "A_TRUEHD": {
                string3 = "audio/true-hd";
                break;
            }
            case "A_DTS": 
            case "A_DTS/EXPRESS": {
                string3 = "audio/vnd.dts";
                break;
            }
            case "A_DTS/LOSSLESS": {
                string3 = "audio/vnd.dts.hd";
                break;
            }
            case "A_FLAC": {
                string3 = "audio/x-flac";
                list = Collections.singletonList(this.zzaov);
                break;
            }
            case "A_MS/ACM": {
                int n5;
                string3 = "audio/raw";
                if (zzog.zzb(new zzst(this.zzaov))) {
                    n4 = zzsy.zzbs(this.zzbcd);
                    if (n4 != 0) break;
                    n4 = -1;
                    string3 = "audio/x-unknown";
                    n5 = this.zzbcd;
                    string2 = string3;
                    Log.w((String)"MatroskaExtractor", (String)new StringBuilder(60 + String.valueOf(string2).length()).append("Unsupported PCM bit depth: ").append(n5).append(". Setting mimeType to ").append(string2).toString());
                    break;
                }
                string3 = "audio/x-unknown";
                String string4 = String.valueOf(string3);
                Log.w((String)"MatroskaExtractor", (String)(string4.length() != 0 ? "Non-PCM MS/ACM is unsupported. Setting mimeType to ".concat(string4) : new String("Non-PCM MS/ACM is unsupported. Setting mimeType to ")));
                break;
            }
            case "A_PCM/INT/LIT": {
                string3 = "audio/raw";
                n4 = zzsy.zzbs(this.zzbcd);
                if (n4 != 0) break;
                n4 = -1;
                string3 = "audio/x-unknown";
                int n5 = this.zzbcd;
                string2 = string3;
                Log.w((String)"MatroskaExtractor", (String)new StringBuilder(60 + String.valueOf(string2).length()).append("Unsupported PCM bit depth: ").append(n5).append(". Setting mimeType to ").append(string2).toString());
                break;
            }
            case "S_TEXT/UTF8": {
                string3 = "application/x-subrip";
                break;
            }
            case "S_VOBSUB": {
                string3 = "application/vobsub";
                list = Collections.singletonList(this.zzaov);
                break;
            }
            case "S_HDMV/PGS": {
                string3 = "application/pgs";
                break;
            }
            case "S_DVBSUB": {
                string3 = "application/dvbsubs";
                list = Collections.singletonList(new byte[]{this.zzaov[0], this.zzaov[1], this.zzaov[2], this.zzaov[3]});
                break;
            }
            default: {
                throw new zzlm("Unrecognized codec identifier.");
            }
        }
        int n6 = 0 | (this.zzbcf ? 1 : 0) | (this.zzbce ? 2 : 0);
        if (zzsp.zzav(string3)) {
            n2 = 1;
            zzlh2 = zzlh.zza(Integer.toString(n), string3, null, -1, n3, this.zzafu, this.zzafv, n4, list, this.zzatr, n6, this.zzauc);
        } else if (zzsp.zzbf(string3)) {
            n2 = 2;
            if (this.zzbbm == 0) {
                this.zzbbk = this.zzbbk == -1 ? this.width : this.zzbbk;
                this.zzbbl = this.zzbbl == -1 ? this.height : this.zzbbl;
            }
            float f = -1.0f;
            if (this.zzbbk != -1 && this.zzbbl != -1) {
                f = (float)(this.height * this.zzbbk) / (float)(this.width * this.zzbbl);
            }
            zztb zztb2 = null;
            if (this.zzbbn) {
                byte[] byArray;
                zzog zzog2 = this;
                if (zzog2.zzbbt == -1.0f || zzog2.zzbbu == -1.0f || zzog2.zzbbv == -1.0f || zzog2.zzbbw == -1.0f || zzog2.zzbbx == -1.0f || zzog2.zzbby == -1.0f || zzog2.zzbbz == -1.0f || zzog2.zzbca == -1.0f || zzog2.zzbcb == -1.0f || zzog2.zzbcc == -1.0f) {
                    byArray = null;
                } else {
                    byte[] byArray2 = new byte[25];
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                    byteBuffer.put((byte)0);
                    byteBuffer.putShort((short)(zzog2.zzbbt * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzog2.zzbbu * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzog2.zzbbv * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzog2.zzbbw * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzog2.zzbbx * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzog2.zzbby * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzog2.zzbbz * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzog2.zzbca * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzog2.zzbcb + 0.5f));
                    byteBuffer.putShort((short)(zzog2.zzbcc + 0.5f));
                    byteBuffer.putShort((short)zzog2.zzbbr);
                    byteBuffer.putShort((short)zzog2.zzbbs);
                    byArray = byArray2;
                }
                string2 = byArray;
                zztb2 = new zztb(this.zzbbo, this.zzbbq, this.zzbbp, (byte[])string2);
            }
            zzlh2 = zzlh.zza(Integer.toString(n), string3, null, -1, n3, this.width, this.height, -1.0f, list, -1, f, this.zzatv, this.zzatu, zztb2, this.zzatr);
        } else if ("application/x-subrip".equals(string3)) {
            n2 = 3;
            zzlh2 = zzlh.zza(Integer.toString(n), string3, null, -1, n6, this.zzauc, this.zzatr);
        } else if ("application/vobsub".equals(string3) || "application/pgs".equals(string3) || "application/dvbsubs".equals(string3)) {
            n2 = 3;
            zzlh2 = zzlh.zza(Integer.toString(n), string3, null, -1, list, this.zzauc, this.zzatr);
        } else {
            throw new zzlm("Unexpected MIME type.");
        }
        this.zzbcg = zznp2.zzd(this.number, n2);
        this.zzbcg.zze(zzlh2);
    }

    private static List<byte[]> zza(zzst zzst2) throws zzlm {
        try {
            zzst2.zzac(16);
            if (zzst2.zzkb() != 826496599L) {
                return null;
            }
            int n = zzst2.getPosition() + 20;
            byte[] byArray = zzst2.data;
            for (int i = n; i < byArray.length - 4; ++i) {
                if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 1 || byArray[i + 3] != 15) continue;
                return Collections.singletonList(Arrays.copyOfRange(byArray, i, byArray.length));
            }
            throw new zzlm("Failed to find FourCC VC1 initialization data");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new zzlm("Error parsing FourCC VC1 codec private");
        }
    }

    private static List<byte[]> zze(byte[] byArray) throws zzlm {
        try {
            if (byArray[0] != 2) {
                throw new zzlm("Error parsing vorbis codec private");
            }
            int n = 1;
            int n2 = 0;
            while (byArray[n] == -1) {
                n2 += 255;
                ++n;
            }
            n2 += byArray[n++];
            int n3 = 0;
            while (byArray[n] == -1) {
                n3 += 255;
                ++n;
            }
            n3 += byArray[n++];
            if (byArray[n] != 1) {
                throw new zzlm("Error parsing vorbis codec private");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (byArray[n += n2] != 3) {
                throw new zzlm("Error parsing vorbis codec private");
            }
            if (byArray[n += n3] != 5) {
                throw new zzlm("Error parsing vorbis codec private");
            }
            byte[] byArray3 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray3, 0, byArray.length - n);
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(2);
            arrayList.add(byArray2);
            arrayList.add(byArray3);
            return arrayList;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new zzlm("Error parsing vorbis codec private");
        }
    }

    private static boolean zzb(zzst zzst2) throws zzlm {
        try {
            int n = zzst2.zzka();
            if (n == 1) {
                return true;
            }
            if (n == 65534) {
                zzst2.setPosition(24);
                return zzst2.readLong() == zzod.zzik().getMostSignificantBits() && zzst2.readLong() == zzod.zzik().getLeastSignificantBits();
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new zzlm("Error parsing MS/ACM codec private");
        }
    }

    /* synthetic */ zzog(zzoe zzoe2) {
        this();
    }

    static /* synthetic */ String zza(zzog zzog2, String string2) {
        zzog2.zzauc = string2;
        return zzog2.zzauc;
    }
}

