/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import com.google.android.gms.internal.ads.zzku;
import com.google.android.gms.internal.ads.zzlh;
import com.google.android.gms.internal.ads.zznd;
import com.google.android.gms.internal.ads.zzne;
import com.google.android.gms.internal.ads.zznj;
import com.google.android.gms.internal.ads.zzpd;
import com.google.android.gms.internal.ads.zzpe;
import com.google.android.gms.internal.ads.zzpg;
import com.google.android.gms.internal.ads.zzpi;
import com.google.android.gms.internal.ads.zzpk;
import com.google.android.gms.internal.ads.zzsk;
import com.google.android.gms.internal.ads.zzsp;
import com.google.android.gms.internal.ads.zzsx;
import com.google.android.gms.internal.ads.zzsy;
import com.google.android.gms.internal.ads.zztd;
import com.google.android.gms.internal.ads.zztj;
import com.google.android.gms.internal.ads.zztk;
import com.google.android.gms.internal.ads.zztl;
import com.google.android.gms.internal.ads.zztn;
import com.google.android.gms.internal.ads.zzto;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public final class zzth
extends zzpe {
    private static final int[] zzbod = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private final Context zzlj;
    private final zztl zzboe;
    private final zzto zzbof;
    private final long zzbog;
    private final int zzboh;
    private final boolean zzboi;
    private final long[] zzboj;
    private zzlh[] zzbok;
    private zztj zzbol;
    private Surface zzaez;
    private Surface zzbom;
    private int zzbon;
    private boolean zzafb;
    private long zzboo;
    private long zzafd;
    private int zzbop;
    private int zzboq;
    private int zzbor;
    private float zzbos;
    private int zzaff;
    private int zzafg;
    private int zzbot;
    private float zzafh;
    private int zzbou;
    private int zzbov;
    private int zzbow;
    private float zzbox;
    private boolean zzawy;
    private int zzaul;
    zztk zzboy;
    private long zzboz;
    private int zzbpa;

    public zzth(Context context, zzpg zzpg2, long l, Handler handler, zztn zztn2, int n) {
        this(context, zzpg2, 0L, null, false, handler, zztn2, -1);
    }

    private zzth(Context context, zzpg zzpg2, long l, zznj<Object> zznj2, boolean bl, Handler handler, zztn zztn2, int n) {
        super(2, zzpg2, null, false);
        this.zzbog = 0L;
        this.zzboh = -1;
        this.zzlj = context.getApplicationContext();
        this.zzboe = new zztl(context);
        this.zzbof = new zzto(handler, zztn2);
        this.zzboi = zzsy.SDK_INT <= 22 && "foster".equals(zzsy.DEVICE) && "NVIDIA".equals(zzsy.MANUFACTURER);
        this.zzboj = new long[10];
        this.zzboz = -9223372036854775807L;
        this.zzboo = -9223372036854775807L;
        this.zzaff = -1;
        this.zzafg = -1;
        this.zzafh = -1.0f;
        this.zzbos = -1.0f;
        this.zzbon = 1;
        this.zzkk();
    }

    @Override
    protected final int zza(zzpg zzpg2, zzlh zzlh2) throws zzpk {
        int n;
        int n2;
        zzpd zzpd2;
        String string2 = zzlh2.zzatq;
        if (!zzsp.zzbf(string2)) {
            return 0;
        }
        boolean bl = false;
        zzne zzne2 = zzlh2.zzatr;
        if (zzne2 != null) {
            for (int i = 0; i < zzne2.zzazg; ++i) {
                bl |= zzne2.zzap((int)i).zzazh;
            }
        }
        if ((zzpd2 = zzpg2.zze(string2, bl)) == null) {
            return 1;
        }
        boolean bl2 = zzpd2.zzat(zzlh2.zzatn);
        if (bl2 && zzlh2.width > 0 && zzlh2.height > 0) {
            if (zzsy.SDK_INT >= 21) {
                bl2 = zzpd2.zza(zzlh2.width, zzlh2.height, zzlh2.zzats);
            } else {
                bl2 = zzlh2.width * zzlh2.height <= zzpi.zziw();
                if (!bl2) {
                    n2 = zzlh2.width;
                    n = zzlh2.height;
                    String string3 = zzsy.zzbnq;
                    Log.d((String)"MediaCodecVideoRenderer", (String)new StringBuilder(56 + String.valueOf(string3).length()).append("FalseCheck [legacyFrameSize, ").append(n2).append("x").append(n).append("] [").append(string3).append("]").toString());
                }
            }
        }
        n2 = zzpd2.zzabo ? 8 : 4;
        n = zzpd2.zzawy ? 16 : 0;
        int n3 = bl2 ? 3 : 2;
        return n2 | n | n3;
    }

    @Override
    protected final void zzg(boolean bl) throws zzku {
        super.zzg(bl);
        this.zzaul = this.zzgq().zzaul;
        this.zzawy = this.zzaul != 0;
        this.zzbof.zzc(this.zzbhl);
        this.zzboe.enable();
    }

    @Override
    protected final void zza(zzlh[] zzlhArray, long l) throws zzku {
        this.zzbok = zzlhArray;
        if (this.zzboz == -9223372036854775807L) {
            this.zzboz = l;
        } else {
            if (this.zzbpa == this.zzboj.length) {
                long l2 = this.zzboj[this.zzbpa - 1];
                Log.w((String)"MediaCodecVideoRenderer", (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l2).toString());
            } else {
                ++this.zzbpa;
            }
            this.zzboj[this.zzbpa - 1] = l;
        }
        super.zza(zzlhArray, l);
    }

    @Override
    protected final void zzd(long l, boolean bl) throws zzku {
        super.zzd(l, bl);
        this.zzki();
        this.zzboq = 0;
        if (this.zzbpa != 0) {
            this.zzboz = this.zzboj[this.zzbpa - 1];
            this.zzbpa = 0;
        }
        if (bl) {
            this.zzkh();
            return;
        }
        this.zzboo = -9223372036854775807L;
    }

    @Override
    public final boolean isReady() {
        if (super.isReady() && (this.zzafb || this.zzbom != null && this.zzaez == this.zzbom || this.zzir() == null)) {
            this.zzboo = -9223372036854775807L;
            return true;
        }
        if (this.zzboo == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.zzboo) {
            return true;
        }
        this.zzboo = -9223372036854775807L;
        return false;
    }

    @Override
    protected final void onStarted() {
        super.onStarted();
        this.zzbop = 0;
        this.zzafd = SystemClock.elapsedRealtime();
        this.zzboo = -9223372036854775807L;
    }

    @Override
    protected final void onStopped() {
        this.zzkm();
        super.onStopped();
    }

    @Override
    protected final void zzdz() {
        this.zzaff = -1;
        this.zzafg = -1;
        this.zzafh = -1.0f;
        this.zzbos = -1.0f;
        this.zzboz = -9223372036854775807L;
        this.zzbpa = 0;
        this.zzkk();
        this.zzki();
        this.zzboe.disable();
        this.zzboy = null;
        this.zzawy = false;
        try {
            super.zzdz();
            return;
        }
        finally {
            this.zzbhl.zzdk();
            this.zzbof.zzd(this.zzbhl);
        }
    }

    @Override
    public final void zza(int n, Object object) throws zzku {
        if (n == 1) {
            Surface surface = (Surface)object;
            zzth zzth2 = this;
            if (surface == null) {
                if (zzth2.zzbom != null) {
                    surface = zzth2.zzbom;
                } else {
                    zzpd zzpd2 = zzth2.zzis();
                    if (zzpd2 != null && zzth2.zzn(zzpd2.zzaer)) {
                        surface = zzth2.zzbom = zztd.zzc(zzth2.zzlj, zzpd2.zzaer);
                    }
                }
            }
            if (zzth2.zzaez != surface) {
                zzth2.zzaez = surface;
                int n2 = zzth2.getState();
                if (n2 == 1 || n2 == 2) {
                    MediaCodec mediaCodec = zzth2.zzir();
                    if (zzsy.SDK_INT >= 23 && mediaCodec != null && surface != null) {
                        Surface surface2 = surface;
                        mediaCodec.setOutputSurface(surface2);
                    } else {
                        ((zzpe)zzth2).zzed();
                        zzth2.zzea();
                    }
                }
                if (surface != null && surface != zzth2.zzbom) {
                    zzth2.zzkl();
                    zzth2.zzki();
                    if (n2 == 2) {
                        zzth2.zzkh();
                        return;
                    }
                } else {
                    zzth2.zzkk();
                    zzth2.zzki();
                }
                return;
            }
            if (surface != null && surface != zzth2.zzbom) {
                zzth2.zzkl();
                zzth zzth3 = zzth2;
                if (zzth3.zzafb) {
                    zzth3.zzbof.zzc(zzth3.zzaez);
                }
            }
            return;
        }
        if (n == 4) {
            this.zzbon = (Integer)object;
            MediaCodec mediaCodec = this.zzir();
            if (mediaCodec != null) {
                int n3 = this.zzbon;
                mediaCodec.setVideoScalingMode(n3);
            }
            return;
        }
        super.zza(n, object);
    }

    @Override
    protected final boolean zza(zzpd zzpd2) {
        return this.zzaez != null || this.zzn(zzpd2.zzaer);
    }

    @Override
    protected final void zza(zzpd zzpd2, MediaCodec mediaCodec, zzlh zzlh2, MediaCrypto mediaCrypto) throws zzpk {
        zztj zztj2;
        zzlh[] zzlhArray = this.zzbok;
        Object object = zzlh2;
        zzpd zzpd3 = zzpd2;
        int n = ((zzlh)object).width;
        int n2 = ((zzlh)object).height;
        int n3 = zzth.zzi((zzlh)object);
        if (zzlhArray.length == 1) {
            zztj2 = new zztj(n, n2, n3);
        } else {
            boolean bl = false;
            zzlh[] zzlhArray2 = zzlhArray;
            int n4 = zzlhArray.length;
            for (int i = 0; i < n4; ++i) {
                zzlh zzlh3 = zzlhArray2[i];
                if (!zzth.zza(zzpd3.zzabo, (zzlh)object, zzlh3)) continue;
                bl |= zzlh3.width == -1 || zzlh3.height == -1;
                n = Math.max(n, zzlh3.width);
                n2 = Math.max(n2, zzlh3.height);
                n3 = Math.max(n3, zzth.zzi(zzlh3));
            }
            if (bl) {
                Point point;
                Point point2;
                block16: {
                    int n5 = n;
                    n4 = n2;
                    Log.w((String)"MediaCodecVideoRenderer", (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n5).append("x").append(n4).toString());
                    Object object2 = object;
                    zzpd zzpd4 = zzpd3;
                    boolean bl2 = ((zzlh)object2).height > ((zzlh)object2).width;
                    int n6 = bl2 ? ((zzlh)object2).height : ((zzlh)object2).width;
                    int n7 = bl2 ? ((zzlh)object2).width : ((zzlh)object2).height;
                    float f = (float)n7 / (float)n6;
                    int[] nArray = zzbod;
                    int n8 = zzbod.length;
                    for (int i = 0; i < n8; ++i) {
                        int n9 = nArray[i];
                        int n10 = (int)((float)n9 * f);
                        if (n9 <= n6 || n10 <= n7) {
                            point2 = null;
                        } else if (zzsy.SDK_INT >= 21) {
                            Point point3 = zzpd4.zze(bl2 ? n10 : n9, bl2 ? n9 : n10);
                            float f2 = ((zzlh)object2).zzats;
                            if (!zzpd4.zza(point3.x, point3.y, f2)) continue;
                            point2 = point3;
                        } else {
                            if ((n9 = zzsy.zzb(n9, 16) << 4) * (n10 = zzsy.zzb(n10, 16) << 4) > zzpi.zziw()) continue;
                            point2 = new Point(bl2 ? n10 : n9, bl2 ? n9 : n10);
                        }
                        break block16;
                    }
                    point2 = point = null;
                }
                if (point2 != null) {
                    n = Math.max(n, point.x);
                    n2 = Math.max(n2, point.y);
                    n3 = Math.max(n3, zzth.zza(((zzlh)object).zzatq, n, n2));
                    Log.w((String)"MediaCodecVideoRenderer", (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n).append("x").append(n2).toString());
                }
            }
            zztj2 = new zztj(n, n2, n3);
        }
        this.zzbol = zztj2;
        int n11 = this.zzaul;
        boolean bl = this.zzboi;
        object = this.zzbol;
        MediaFormat mediaFormat = zzlh2.zzen();
        mediaFormat.setInteger("max-width", ((zztj)object).width);
        mediaFormat.setInteger("max-height", ((zztj)object).height);
        if (((zztj)object).zzbpb != -1) {
            mediaFormat.setInteger("max-input-size", ((zztj)object).zzbpb);
        }
        if (bl) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n11 != 0) {
            n3 = n11;
            MediaFormat mediaFormat2 = mediaFormat;
            mediaFormat2.setFeatureEnabled("tunneled-playback", true);
            mediaFormat2.setInteger("audio-session-id", n3);
        }
        MediaFormat mediaFormat3 = mediaFormat;
        if (this.zzaez == null) {
            zzsk.checkState(this.zzn(zzpd2.zzaer));
            if (this.zzbom == null) {
                this.zzbom = zztd.zzc(this.zzlj, zzpd2.zzaer);
            }
            this.zzaez = this.zzbom;
        }
        mediaCodec.configure(mediaFormat3, this.zzaez, null, 0);
        if (zzsy.SDK_INT >= 23 && this.zzawy) {
            this.zzboy = new zztk(this, mediaCodec, null);
        }
    }

    @Override
    protected final void zzed() {
        block4: {
            block5: {
                try {
                    super.zzed();
                    if (this.zzbom == null) break block4;
                    if (this.zzaez != this.zzbom) break block5;
                    this.zzaez = null;
                }
                catch (Throwable throwable) {
                    if (this.zzbom != null) {
                        if (this.zzaez == this.zzbom) {
                            this.zzaez = null;
                        }
                        this.zzbom.release();
                        this.zzbom = null;
                    }
                    throw throwable;
                }
            }
            this.zzbom.release();
            this.zzbom = null;
            return;
        }
    }

    @Override
    protected final void zzd(String string2, long l, long l2) {
        this.zzbof.zzc(string2, l, l2);
    }

    @Override
    protected final void zzd(zzlh zzlh2) throws zzku {
        super.zzd(zzlh2);
        this.zzbof.zzc(zzlh2);
        zzlh zzlh3 = zzlh2;
        this.zzbos = zzlh3.zzaft == -1.0f ? 1.0f : zzlh3.zzaft;
        this.zzbor = zzth.zzj(zzlh2);
    }

    @Override
    protected final void zza(zznd zznd2) {
        if (zzsy.SDK_INT < 23 && this.zzawy) {
            this.zzkj();
        }
    }

    @Override
    protected final void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl = mediaFormat.containsKey("crop-right") && mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top");
        this.zzaff = bl ? mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left") + 1 : mediaFormat.getInteger("width");
        this.zzafg = bl ? mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top") + 1 : mediaFormat.getInteger("height");
        this.zzafh = this.zzbos;
        if (zzsy.SDK_INT >= 21) {
            if (this.zzbor == 90 || this.zzbor == 270) {
                int n = this.zzaff;
                this.zzaff = this.zzafg;
                this.zzafg = n;
                this.zzafh = 1.0f / this.zzafh;
            }
        } else {
            this.zzbot = this.zzbor;
        }
        int n = this.zzbon;
        mediaCodec.setVideoScalingMode(n);
    }

    @Override
    protected final boolean zza(MediaCodec mediaCodec, boolean bl, zzlh zzlh2, zzlh zzlh3) {
        return zzth.zza(bl, zzlh2, zzlh3) && zzlh3.width <= this.zzbol.width && zzlh3.height <= this.zzbol.height && zzlh3.zzafs <= this.zzbol.zzbpb;
    }

    @Override
    protected final boolean zza(long l, long l2, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n, int n2, long l3, boolean bl) {
        while (this.zzbpa != 0 && l3 >= this.zzboj[0]) {
            this.zzboz = this.zzboj[0];
            --this.zzbpa;
            System.arraycopy(this.zzboj, 1, this.zzboj, 0, this.zzbpa);
        }
        long l4 = l3 - this.zzboz;
        if (bl) {
            this.zza(mediaCodec, n, l4);
            return true;
        }
        long l5 = l3 - l;
        if (this.zzaez == this.zzbom) {
            if (zzth.zzer(l5)) {
                this.zza(mediaCodec, n, l4);
                return true;
            }
            return false;
        }
        if (!this.zzafb) {
            if (zzsy.SDK_INT >= 21) {
                this.zza(mediaCodec, n, l4, System.nanoTime());
            } else {
                this.zzb(mediaCodec, n, l4);
            }
            return true;
        }
        if (this.getState() != 2) {
            return false;
        }
        long l6 = SystemClock.elapsedRealtime() * 1000L - l2;
        l5 -= l6;
        long l7 = System.nanoTime();
        long l8 = l7 + l5 * 1000L;
        long l9 = this.zzboe.zzg(l3, l8);
        l5 = (l9 - l7) / 1000L;
        if (zzth.zzer(l5)) {
            int n3 = n;
            MediaCodec mediaCodec2 = mediaCodec;
            zzth zzth2 = this;
            zzsx.beginSection("dropVideoBuffer");
            mediaCodec2.releaseOutputBuffer(n3, false);
            zzsx.endSection();
            ++zzth2.zzbhl.zzabm;
            ++zzth2.zzbop;
            ++zzth2.zzboq;
            zzth2.zzbhl.zzazd = Math.max(zzth2.zzboq, zzth2.zzbhl.zzazd);
            if (zzth2.zzbop == zzth2.zzboh) {
                zzth2.zzkm();
            }
            return true;
        }
        if (zzsy.SDK_INT >= 21) {
            if (l5 < 50000L) {
                this.zza(mediaCodec, n, l4, l9);
                return true;
            }
        } else if (l5 < 30000L) {
            if (l5 > 11000L) {
                try {
                    Thread.sleep((l5 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.zzb(mediaCodec, n, l4);
            return true;
        }
        return false;
    }

    private final void zza(MediaCodec mediaCodec, int n, long l) {
        zzsx.beginSection("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n, false);
        zzsx.endSection();
        ++this.zzbhl.zzabl;
    }

    private final void zzb(MediaCodec mediaCodec, int n, long l) {
        this.zzej();
        zzsx.beginSection("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n, true);
        zzsx.endSection();
        ++this.zzbhl.zzabk;
        this.zzboq = 0;
        this.zzkj();
    }

    @TargetApi(value=21)
    private final void zza(MediaCodec mediaCodec, int n, long l, long l2) {
        this.zzej();
        zzsx.beginSection("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n, l2);
        zzsx.endSection();
        ++this.zzbhl.zzabk;
        this.zzboq = 0;
        this.zzkj();
    }

    private final boolean zzn(boolean bl) {
        return zzsy.SDK_INT >= 23 && !this.zzawy && (!bl || zztd.zzc(this.zzlj));
    }

    private final void zzkh() {
        this.zzboo = this.zzbog > 0L ? SystemClock.elapsedRealtime() + this.zzbog : -9223372036854775807L;
    }

    private final void zzki() {
        MediaCodec mediaCodec;
        this.zzafb = false;
        if (zzsy.SDK_INT >= 23 && this.zzawy && (mediaCodec = this.zzir()) != null) {
            this.zzboy = new zztk(this, mediaCodec, null);
        }
    }

    final void zzkj() {
        if (!this.zzafb) {
            this.zzafb = true;
            this.zzbof.zzc(this.zzaez);
        }
    }

    private final void zzkk() {
        this.zzbou = -1;
        this.zzbov = -1;
        this.zzbox = -1.0f;
        this.zzbow = -1;
    }

    private final void zzej() {
        if (this.zzbou != this.zzaff || this.zzbov != this.zzafg || this.zzbow != this.zzbot || this.zzbox != this.zzafh) {
            this.zzbof.zzb(this.zzaff, this.zzafg, this.zzbot, this.zzafh);
            this.zzbou = this.zzaff;
            this.zzbov = this.zzafg;
            this.zzbow = this.zzbot;
            this.zzbox = this.zzafh;
        }
    }

    private final void zzkl() {
        if (this.zzbou != -1 || this.zzbov != -1) {
            this.zzbof.zzb(this.zzaff, this.zzafg, this.zzbot, this.zzafh);
        }
    }

    private final void zzkm() {
        if (this.zzbop > 0) {
            long l = SystemClock.elapsedRealtime();
            long l2 = l - this.zzafd;
            this.zzbof.zzg(this.zzbop, l2);
            this.zzbop = 0;
            this.zzafd = l;
        }
    }

    private static boolean zzer(long l) {
        return l < -30000L;
    }

    private static int zzi(zzlh zzlh2) {
        if (zzlh2.zzafs != -1) {
            return zzlh2.zzafs;
        }
        return zzth.zza(zzlh2.zzatq, zzlh2.width, zzlh2.height);
    }

    private static int zza(String string2, int n, int n2) {
        int n3;
        int n4;
        if (n == -1 || n2 == -1) {
            return -1;
        }
        switch (string2) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n4 = n * n2;
                n3 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(zzsy.MODEL)) {
                    return -1;
                }
                n4 = zzsy.zzb(n, 16) * zzsy.zzb(n2, 16) << 4 << 4;
                n3 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n4 = n * n2;
                n3 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n4 = n * n2;
                n3 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n4 * 3 / (2 * n3);
    }

    private static boolean zza(boolean bl, zzlh zzlh2, zzlh zzlh3) {
        return zzlh2.zzatq.equals(zzlh3.zzatq) && zzth.zzj(zzlh2) == zzth.zzj(zzlh3) && (bl || zzlh2.width == zzlh3.width && zzlh2.height == zzlh3.height);
    }

    private static int zzj(zzlh zzlh2) {
        if (zzlh2.zzatt == -1) {
            return 0;
        }
        return zzlh2.zzatt;
    }
}

