/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzbad;
import com.google.android.gms.internal.ads.zzus;
import com.google.android.gms.internal.ads.zzut;
import com.google.android.gms.internal.ads.zzvg;
import com.google.android.gms.internal.ads.zzyt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

@TargetApi(value=14)
final class zzur
implements Application.ActivityLifecycleCallbacks {
    @Nullable
    private Activity zzzd;
    private Context zzlj;
    private final Object lock = new Object();
    private boolean foreground = true;
    private boolean zzbut = false;
    @GuardedBy(value="lock")
    private final List<zzut> zzbuu = new ArrayList<zzut>();
    @GuardedBy(value="lock")
    private final List<zzvg> zzbuv = new ArrayList<zzvg>();
    private Runnable zzbuw;
    private boolean zzxs = false;
    private long zzbux;

    zzur() {
    }

    public final void zza(Application application, Context context) {
        if (!this.zzxs) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            if (context instanceof Activity) {
                this.setActivity((Activity)context);
            }
            this.zzlj = application;
            zzacj zzacj2 = zzacu.zzcox;
            this.zzbux = (Long)zzyt.zzpe().zzd(zzacj2);
            this.zzxs = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzut zzut2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzbuu.add(zzut2);
            return;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
    }

    @Nullable
    public final Activity getActivity() {
        return this.zzzd;
    }

    @Nullable
    public final Context getContext() {
        return this.zzlj;
    }

    public final void onActivityStarted(Activity activity) {
        this.setActivity(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onActivityResumed(Activity activity) {
        this.setActivity(activity);
        this.zzbut = false;
        boolean bl = !this.foreground;
        this.foreground = true;
        if (this.zzbuw != null) {
            zzaxi.zzdvv.removeCallbacks(this.zzbuw);
        }
        Object object = this.lock;
        synchronized (object) {
            for (zzvg object2 : this.zzbuv) {
                try {
                    object2.onActivityResumed(activity);
                }
                catch (Exception exception) {
                    zzk.zzlk().zza(exception, "AppActivityTracker.ActivityListener.onActivityResumed");
                    Exception exception2 = exception;
                    zzbad.zzc((String)"", (Throwable)exception2);
                }
            }
            if (bl) {
                for (zzut zzut2 : this.zzbuu) {
                    try {
                        zzut2.zzp(true);
                    }
                    catch (Exception exception) {
                        zzbad.zzc((String)"", (Throwable)exception);
                    }
                }
            } else {
                zzawz.zzdp((String)"App is still foreground.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onActivityPaused(Activity activity) {
        this.setActivity(activity);
        Object object = this.lock;
        synchronized (object) {
            for (zzvg zzvg2 : this.zzbuv) {
                try {
                    zzvg2.onActivityPaused(activity);
                }
                catch (Exception exception) {
                    zzk.zzlk().zza(exception, "AppActivityTracker.ActivityListener.onActivityPaused");
                    Exception exception2 = exception;
                    zzbad.zzc((String)"", (Throwable)exception2);
                }
            }
        }
        this.zzbut = true;
        if (this.zzbuw != null) {
            zzaxi.zzdvv.removeCallbacks(this.zzbuw);
        }
        this.zzbuw = new zzus(this);
        zzaxi.zzdvv.postDelayed(this.zzbuw, this.zzbux);
    }

    public final void onActivityStopped(Activity activity) {
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onActivityDestroyed(Activity activity) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzzd == null) {
                return;
            }
            if (this.zzzd.equals(activity)) {
                this.zzzd = null;
            }
            Iterator<zzvg> iterator = this.zzbuv.iterator();
            while (iterator.hasNext()) {
                zzvg zzvg2 = iterator.next();
                try {
                    if (!zzvg2.zza(activity)) continue;
                    iterator.remove();
                }
                catch (Exception exception) {
                    zzk.zzlk().zza(exception, "AppActivityTracker.ActivityListener.onActivityDestroyed");
                    Exception exception2 = exception;
                    zzbad.zzc((String)"", (Throwable)exception2);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setActivity(Activity activity) {
        Object object = this.lock;
        synchronized (object) {
            if (!activity.getClass().getName().startsWith("com.google.android.gms.ads")) {
                this.zzzd = activity;
            }
            return;
        }
    }

    static /* synthetic */ Object zza(zzur zzur2) {
        return zzur2.lock;
    }

    static /* synthetic */ boolean zzb(zzur zzur2) {
        return zzur2.foreground;
    }

    static /* synthetic */ boolean zzc(zzur zzur2) {
        return zzur2.zzbut;
    }

    static /* synthetic */ boolean zza(zzur zzur2, boolean bl) {
        zzur2.foreground = false;
        return false;
    }

    static /* synthetic */ List zzd(zzur zzur2) {
        return zzur2.zzbuu;
    }
}

