/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaeh;
import com.google.android.gms.internal.ads.zzaep;
import com.google.android.gms.internal.ads.zzaow;
import com.google.android.gms.internal.ads.zzbam;
import com.google.android.gms.internal.ads.zzbbl;
import com.google.android.gms.internal.ads.zzbbr;
import com.google.android.gms.internal.ads.zzbbu;
import com.google.android.gms.internal.ads.zzeev;
import com.google.android.gms.internal.ads.zzefd;
import com.google.android.gms.internal.ads.zzzy;
import java.util.concurrent.Executor;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zze {
    private Context zza;
    private long zzb = 0L;

    public final void zza(Context context, zzbbl zzbbl2, String string2, @Nullable Runnable runnable) {
        this.zzc(context, zzbbl2, true, null, string2, null, runnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzb(Context context, zzbbl zzbbl2, String string2, zzbam zzbam2) {
        String string3 = zzbam2 != null ? zzbam2.zze() : null;
        this.zzc(context, zzbbl2, false, zzbam2, string3, string2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final void zzc(Context object, zzbbl object2, boolean bl, @Nullable zzbam zzbam2, String string2, @Nullable String string3, @Nullable Runnable runnable) {
        if (zzs.zzj().elapsedRealtime() - ((zze)((Object)zzefd2)).zzb < 5000L) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"Not retrying to fetch app settings");
            return;
        }
        ((zze)((Object)zzefd2)).zzb = zzs.zzj().elapsedRealtime();
        if (zzbam2 != null) {
            long l = zzbam2.zzb();
            Clock clock = zzs.zzj();
            long l2 = clock.currentTimeMillis();
            clock = zzaep.zzck;
            if (l2 - l <= (Long)zzzy.zze().zzb((zzaeh)clock) && zzbam2.zzc()) {
                return;
            }
        }
        if (object == null) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"Context not provided to fetch application settings");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"App settings could not be fetched. Required parameters missing");
            return;
        }
        zzbam2 = object.getApplicationContext();
        if (zzbam2 == null) {
            zzbam2 = object;
        }
        ((zze)((Object)zzefd2)).zza = zzbam2;
        zzefd zzefd2 = zzs.zzp().zzb(((zze)((Object)zzefd2)).zza, (zzbbl)object2).zza("google.afma.config.fetchAppSettings", zzaow.zza, zzaow.zza);
        try {
            object2 = new JSONObject();
            boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
            if (!bl2) {
                object2.put("app_id", (Object)string2);
            } else {
                bl2 = TextUtils.isEmpty((CharSequence)string3);
                if (!bl2) {
                    object2.put("ad_unit_id", (Object)string3);
                }
            }
            object2.put("is_init", bl);
            object2.put("pn", (Object)object.getPackageName());
            zzefd2 = zzefd2.zzb(object2);
            object = zzd.zza;
            object2 = zzbbr.zzf;
            object = zzeev.zzh(zzefd2, object, (Executor)object2);
            if (runnable != null) {
                object2 = zzbbr.zzf;
                zzefd2.zze(runnable, (Executor)object2);
            }
            zzbbu.zza(object, "ConfigLoader.maybeFetchNewAppSettings");
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Error requesting application settings", (Throwable)exception);
            return;
        }
    }
}

