/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.util.zzbh;
import com.google.android.gms.ads.internal.util.zzby;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzl;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.ads.zzaaa;
import com.google.android.gms.internal.ads.zzaei;
import com.google.android.gms.internal.ads.zzaeq;
import com.google.android.gms.internal.ads.zzaex;
import com.google.android.gms.internal.ads.zzafc;
import com.google.android.gms.internal.ads.zzafd;
import com.google.android.gms.internal.ads.zzaff;
import com.google.android.gms.internal.ads.zzafp;
import com.google.android.gms.internal.ads.zzagt;
import com.google.android.gms.internal.ads.zzagw;
import com.google.android.gms.internal.ads.zzakp;
import com.google.android.gms.internal.ads.zzatk;
import com.google.android.gms.internal.ads.zzbbd;
import com.google.android.gms.internal.ads.zzbbk;
import com.google.android.gms.internal.ads.zzbbq;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbfg;
import com.google.android.gms.internal.ads.zzbfn;
import com.google.android.gms.internal.ads.zzbgf;
import com.google.android.gms.internal.ads.zzbgm;
import com.google.android.gms.internal.ads.zzbgv;
import com.google.android.gms.internal.ads.zzbgw;
import com.google.android.gms.internal.ads.zzbgx;
import com.google.android.gms.internal.ads.zzbhb;
import com.google.android.gms.internal.ads.zzbhd;
import com.google.android.gms.internal.ads.zzbhf;
import com.google.android.gms.internal.ads.zzbhg;
import com.google.android.gms.internal.ads.zzbhm;
import com.google.android.gms.internal.ads.zzbhu;
import com.google.android.gms.internal.ads.zzbhv;
import com.google.android.gms.internal.ads.zzcni;
import com.google.android.gms.internal.ads.zzcvk;
import com.google.android.gms.internal.ads.zzdqo;
import com.google.android.gms.internal.ads.zzdqr;
import com.google.android.gms.internal.ads.zzdvo;
import com.google.android.gms.internal.ads.zzebq;
import com.google.android.gms.internal.ads.zzefw;
import com.google.android.gms.internal.ads.zzfh;
import com.google.android.gms.internal.ads.zzrh;
import com.google.android.gms.internal.ads.zzsv;
import com.google.android.gms.internal.ads.zzug;
import com.google.android.gms.internal.ads.zzui;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzzy;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzbgy
extends WebView
implements DownloadListener,
ViewTreeObserver.OnGlobalLayoutListener,
zzbgf {
    private final zzbhu zzb;
    @Nullable
    private final zzfh zzc;
    @Nullable
    private final zzafp zzd;
    private final zzbbq zze;
    @Nullable
    private zzl zzf;
    private final zza zzg;
    private final DisplayMetrics zzh;
    private final float zzi;
    @Nullable
    private zzdqo zzj;
    @Nullable
    private zzdqr zzk;
    private boolean zzl = false;
    private boolean zzm = false;
    private zzbgm zzn;
    @GuardedBy(value="this")
    private zzm zzo;
    @GuardedBy(value="this")
    private IObjectWrapper zzp;
    @GuardedBy(value="this")
    private zzbhv zzq;
    @GuardedBy(value="this")
    private final String zzr;
    @GuardedBy(value="this")
    private boolean zzs;
    @GuardedBy(value="this")
    private boolean zzt;
    @GuardedBy(value="this")
    private boolean zzu;
    @GuardedBy(value="this")
    private boolean zzv;
    @GuardedBy(value="this")
    private Boolean zzw;
    @GuardedBy(value="this")
    private boolean zzx = true;
    @GuardedBy(value="this")
    private final String zzy;
    @GuardedBy(value="this")
    private zzbhb zzz;
    @GuardedBy(value="this")
    private boolean zzA;
    @GuardedBy(value="this")
    private boolean zzB;
    @GuardedBy(value="this")
    private zzagw zzC;
    @GuardedBy(value="this")
    private zzagt zzD;
    @GuardedBy(value="this")
    private zzsv zzE;
    @GuardedBy(value="this")
    private int zzF;
    @GuardedBy(value="this")
    private int zzG;
    private zzafc zzH;
    private final zzafc zzI;
    private zzafc zzJ;
    private final zzafd zzK;
    private WeakReference<View.OnClickListener> zzL;
    private int zzM;
    private int zzN;
    private int zzO;
    @GuardedBy(value="this")
    private zzm zzP;
    @GuardedBy(value="this")
    private boolean zzQ;
    private final zzby zzR;
    private int zzS = -1;
    private int zzT = -1;
    private int zzU = -1;
    private int zzV = -1;
    private Map<String, zzbfn> zzW;
    private final WindowManager zzX;
    private final zzug zzY;
    public static final /* synthetic */ int zza;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected zzbgy(zzbhu zzbhu2, zzbhv object, String object2, boolean bl, boolean bl2, @Nullable zzfh zzfh2, @Nullable zzafp zzafp2, zzbbq zzbbq2, zzaff zzaff2, zzl zzl2, zza zza2, zzug zzug2, zzdqo zzdqo2, zzdqr zzdqr2) {
        super((Context)zzbhu2);
        this.zzy = "";
        this.zzb = zzbhu2;
        this.zzq = object;
        this.zzr = object2;
        this.zzu = bl;
        this.zzc = zzfh2;
        this.zzd = zzafp2;
        this.zze = zzbbq2;
        this.zzf = zzl2;
        this.zzg = zza2;
        this.zzX = (WindowManager)this.getContext().getSystemService("window");
        com.google.android.gms.ads.internal.zzs.zzc();
        this.zzh = com.google.android.gms.ads.internal.util.zzr.zzy(this.zzX);
        this.zzi = this.zzh.density;
        this.zzY = zzug2;
        this.zzj = zzdqo2;
        this.zzk = zzdqr2;
        this.setBackgroundColor(0);
        object = this.getSettings();
        object.setAllowFileAccess(false);
        try {
            object.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        object.setSavePassword(false);
        object.setSupportMultipleWindows(true);
        object.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            object.setMixedContentMode(2);
        }
        object.setUserAgentString(com.google.android.gms.ads.internal.zzs.zzc().zze((Context)zzbhu2, zzbbq2.zza));
        com.google.android.gms.ads.internal.zzs.zze().zza(this.getContext(), (WebSettings)object);
        this.setDownloadListener(this);
        this.zzaX();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            object2 = new zzbhd(this);
            object = new zzbhg(this, (zzbhf)object2);
            this.addJavascriptInterface(object, "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        super(this.zzb.zza(), (View)this, this, null);
        this.zzR = object;
        this.zzbc();
        object2 = new zzaff(true, "make_wv", this.zzr);
        this.zzK = object = new zzafd((zzaff)object2);
        this.zzK.zzc().zza(null);
        object = zzaeq.zzbj;
        if (((Boolean)zzaaa.zzc().zzb((zzaei)object)).booleanValue() && (object = this.zzk) != null && ((zzdqr)object).zzb != null) {
            this.zzK.zzc().zzd("gqi", this.zzk.zzb);
        }
        this.zzK.zzc();
        this.zzI = zzaff.zzf();
        this.zzK.zza("native:view_create", this.zzI);
        this.zzJ = null;
        this.zzH = null;
        com.google.android.gms.ads.internal.zzs.zze().zzc((Context)zzbhu2);
        com.google.android.gms.ads.internal.zzs.zzg().zzi();
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzbgm) {
            this.zzn = (zzbgm)webViewClient;
            return;
        }
    }

    @Override
    public final WebView zzG() {
        return this;
    }

    @Override
    public final View zzH() {
        return this;
    }

    @Override
    public final zza zzk() {
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final boolean zzaK() {
        void var1_5;
        int n;
        int n2;
        if (!this.zzn.zzc() && !this.zzn.zzd()) {
            return false;
        }
        zzzy.zza();
        DisplayMetrics displayMetrics = this.zzh;
        int n3 = zzbbd.zzq((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzzy.zza();
        DisplayMetrics displayMetrics2 = this.zzh;
        int n4 = zzbbd.zzq((DisplayMetrics)displayMetrics2, (int)displayMetrics2.heightPixels);
        Activity activity = this.zzb.zza();
        if (activity != null) {
            if (activity.getWindow() == null) {
                int n5 = n3;
                n2 = n4;
            } else {
                com.google.android.gms.ads.internal.zzs.zzc();
                int[] nArray = com.google.android.gms.ads.internal.util.zzr.zzR(activity);
                zzzy.zza();
                n2 = zzbbd.zzq((DisplayMetrics)this.zzh, (int)nArray[0]);
                zzzy.zza();
                n = zzbbd.zzq((DisplayMetrics)this.zzh, (int)nArray[1]);
                int n6 = n2;
                n2 = n;
            }
        } else {
            int n7 = n3;
            n2 = n4;
        }
        if ((n = this.zzT) == n3 && this.zzS == n4 && this.zzU == var1_5 && this.zzV == n2) {
            return false;
        }
        n = n == n3 ? this.zzS != n4 : 1;
        this.zzT = n3;
        this.zzS = n4;
        this.zzU = var1_5;
        this.zzV = n2;
        zzatk zzatk2 = new zzatk(this, "");
        zzatk2.zzk(n3, n4, (int)var1_5, n2, this.zzh.density, this.zzX.getDefaultDisplay().getRotation());
        return n != 0;
    }

    @Override
    public final void zze(String string2, Map<String, ?> jSONObject) {
        try {
            jSONObject = com.google.android.gms.ads.internal.zzs.zzc().zzf((Map<String, ?>)jSONObject);
            this.zzd(string2, jSONObject);
            return;
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"Could not convert parameters to JSON.");
            return;
        }
    }

    @TargetApi(value=19)
    public final synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.zzX()) {
            zzbbk.zzl((String)"#004 The webview is destroyed. Ignoring action.", null);
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
                return;
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    protected final synchronized void zzaL(String string2) {
        if (!this.zzX()) {
            this.loadUrl(string2);
            return;
        }
        com.google.android.gms.ads.internal.util.zze.zzi((String)"#004 The webview is destroyed. Ignoring action.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final synchronized void loadUrl(String string2) {
        if (this.zzX()) {
            com.google.android.gms.ads.internal.util.zze.zzi((String)"#004 The webview is destroyed. Ignoring action.");
            return;
        }
        try {
            super.loadUrl(string2);
            return;
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
            com.google.android.gms.ads.internal.zzs.zzg().zzg(throwable, "AdWebViewImpl.loadUrl");
            com.google.android.gms.ads.internal.util.zze.zzj((String)"Could not call loadUrl. ", (Throwable)throwable);
            return;
        }
    }

    private final synchronized void zzaU(String string2) {
        string2 = "about:blank";
        try {
            super.loadUrl(string2);
            return;
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
            com.google.android.gms.ads.internal.zzs.zzg().zzg(throwable, "AdWebViewImpl.loadUrlUnsafe");
            com.google.android.gms.ads.internal.util.zze.zzj((String)"Could not call loadUrl. ", (Throwable)throwable);
            return;
        }
    }

    @Override
    public final synchronized void loadData(String string2, String string3, String string4) {
        if (!this.zzX()) {
            super.loadData(string2, string3, string4);
            return;
        }
        com.google.android.gms.ads.internal.util.zze.zzi((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.zzX()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        com.google.android.gms.ads.internal.util.zze.zzi((String)"#004 The webview is destroyed. Ignoring action.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final synchronized void zzat(String string2, String string3, @Nullable String charSequence) {
        String[] stringArray;
        block3: {
            if (this.zzX()) {
                com.google.android.gms.ads.internal.util.zze.zzi((String)"#004 The webview is destroyed. Ignoring action.");
                return;
            }
            stringArray = new String[1];
            charSequence = zzaeq.zzK;
            charSequence = (String)zzaaa.zzc().zzb((zzaei)charSequence);
            JSONObject jSONObject = new JSONObject();
            String string4 = "12.4.51-000";
            try {
                jSONObject.put("version", (Object)charSequence);
                jSONObject.put("sdk", (Object)"Google Mobile Ads");
                jSONObject.put("sdkVersion", (Object)string4);
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("<script>Object.defineProperty(window,'MRAID_ENV',{get:function(){return ");
            }
            catch (JSONException jSONException) {
                com.google.android.gms.ads.internal.util.zze.zzj((String)"Unable to build MRAID_ENV", (Throwable)jSONException);
                charSequence = null;
                break block3;
            }
            ((StringBuilder)charSequence).append(jSONObject.toString());
            ((StringBuilder)charSequence).append("}});</script>");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        stringArray[0] = charSequence;
        super.loadDataWithBaseURL(string2, zzbhm.zza(string3, stringArray), "text/html", "UTF-8", null);
    }

    @TargetApi(value=19)
    protected final synchronized void zzaM(String string2, ValueCallback<String> valueCallback) {
        if (!this.zzX()) {
            this.evaluateJavascript(string2, null);
            return;
        }
        com.google.android.gms.ads.internal.util.zze.zzi((String)"#004 The webview is destroyed. Ignoring action.");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void zzaN(String string2) {
        if (PlatformVersion.isAtLeastKitKat()) {
            if (this.zzaP() == null) {
                this.zzaV();
            }
            if (this.zzaP().booleanValue()) {
                this.zzaM(string2, null);
                return;
            }
            string2 = String.valueOf(string2);
            String string3 = "javascript:";
            string2 = string2.length() != 0 ? string3.concat(string2) : new String(string3);
            this.zzaL(string2);
            return;
        }
        string2 = String.valueOf(string2);
        String string4 = "javascript:";
        string2 = string2.length() != 0 ? string4.concat(string2) : new String(string4);
        this.zzaL(string2);
    }

    @Override
    public final void zza(String string2) {
        throw null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final synchronized void zzaV() {
        this.zzw = com.google.android.gms.ads.internal.zzs.zzg().zzc();
        if (this.zzw != null) return;
        try {
            this.evaluateJavascript("(function(){})()", null);
            this.zzaO(true);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.zzaO(false);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final void zzaO(Boolean bl) {
        synchronized (this) {
            this.zzw = bl;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl4 : MonitorExitStatement: MONITOREXIT : this
            com.google.android.gms.ads.internal.zzs.zzg().zzb(bl);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @VisibleForTesting
    final synchronized Boolean zzaP() {
        return this.zzw;
    }

    @Override
    public final void zzr(String string2, JSONObject jSONObject) {
        this.zzb(string2, jSONObject.toString());
    }

    @Override
    public final void zzb(String string2, String string3) {
        int n = string2.length();
        String string4 = String.valueOf(string3);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 3 + n2);
        stringBuilder.append(string2);
        stringBuilder.append("(");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        this.zzaN(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zzd(String string2, JSONObject object) {
        if (object == null) {
            object = new JSONObject();
        }
        object = object.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("',");
        stringBuilder.append((String)object);
        stringBuilder.append(");");
        string2 = String.valueOf(stringBuilder.toString());
        object = "Dispatching AFMA event: ";
        string2 = string2.length() != 0 ? ((String)object).concat(string2) : new String((String)object);
        com.google.android.gms.ads.internal.util.zze.zzd((String)string2);
        this.zzaN(stringBuilder.toString());
    }

    @Override
    public final void zzI() {
        this.zzaW();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zze.zza);
        this.zze("onhide", hashMap);
    }

    @Override
    public final void zzJ(int n) {
        HashMap<String, String> hashMap;
        if (n == 0) {
            hashMap = this.zzK;
            hashMap = ((zzafd)((Object)hashMap)).zzc();
            zzafc zzafc2 = this.zzI;
            String[] stringArray = new String[]{"aebb2"};
            zzaex.zza(hashMap, zzafc2, stringArray);
        }
        this.zzaW();
        this.zzK.zzc();
        this.zzK.zzc().zzd("close_type", String.valueOf(n));
        hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zze.zza);
        this.zze("onhide", hashMap);
    }

    private final void zzaW() {
        Object object = ((zzbgy)((Object)zzafc2)).zzK;
        object = ((zzafd)object).zzc();
        zzafc zzafc2 = ((zzbgy)((Object)zzafc2)).zzI;
        String[] stringArray = new String[]{"aeh2"};
        zzaex.zza((zzaff)object, zzafc2, stringArray);
    }

    @Override
    public final void zzK() {
        Object object;
        if (this.zzH == null) {
            object = this.zzK;
            object = ((zzafd)object).zzc();
            zzafc zzafc2 = this.zzI;
            String[] stringArray = new String[]{"aes2"};
            zzaex.zza((zzaff)object, zzafc2, stringArray);
            this.zzK.zzc();
            this.zzH = zzaff.zzf();
            this.zzK.zza("native:view_show", this.zzH);
        }
        object = new HashMap(1);
        ((HashMap)object).put("version", this.zze.zza);
        this.zze("onshow", (Map<String, ?>)object);
    }

    @Override
    public final void zzL() {
        throw null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zzv(boolean bl, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        String string2 = true != bl ? "0" : "1";
        hashMap.put("success", string2);
        hashMap.put("duration", Long.toString(l));
        this.zze("onCacheAccessComplete", hashMap);
    }

    @Override
    public final synchronized zzm zzN() {
        return this.zzo;
    }

    @Override
    public final synchronized IObjectWrapper zzV() {
        return this.zzp;
    }

    @Override
    public final synchronized zzm zzO() {
        return this.zzP;
    }

    @Override
    public final synchronized zzbhv zzP() {
        return this.zzq;
    }

    @Override
    public final synchronized String zzQ() {
        return this.zzr;
    }

    public final zzbgm zzaQ() {
        return this.zzn;
    }

    @Override
    public final WebViewClient zzS() {
        return this.zzn;
    }

    @Override
    public final synchronized boolean zzT() {
        return this.zzs;
    }

    @Override
    public final zzfh zzU() {
        return this.zzc;
    }

    @Override
    public final zzbbq zzt() {
        return this.zze;
    }

    @Override
    public final synchronized boolean zzW() {
        return this.zzu;
    }

    public final void onDownloadStart(String string2, String string3, String charSequence, String string4, long l) {
        try {
            string3 = new Intent("android.intent.action.VIEW");
            string3.setDataAndType(Uri.parse((String)string2), string4);
            com.google.android.gms.ads.internal.zzs.zzc();
            com.google.android.gms.ads.internal.util.zzr.zzN(string5.getContext(), (Intent)string3);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            String string5 = String.valueOf(string2);
            int n = string5.length();
            string3 = String.valueOf(string4);
            int n2 = string3.length();
            charSequence = new StringBuilder(n + 51 + n2);
            ((StringBuilder)charSequence).append("Couldn't find an Activity to view url/mimetype: ");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(" / ");
            ((StringBuilder)charSequence).append(string4);
            com.google.android.gms.ads.internal.util.zze.zzd((String)((StringBuilder)charSequence).toString());
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzn.zzd() && !this.zzn.zze()) {
            // MONITORENTER : this
            zzagw zzagw2 = this.zzC;
            if (zzagw2 != null) {
                zzagw2.zzb(motionEvent);
            }
            // MONITOREXIT : this
        } else {
            Object object = this.zzc;
            if (object != null) {
                ((zzfh)object).zzd(motionEvent);
            }
            if ((object = this.zzd) != null) {
                ((zzafp)object).zza(motionEvent);
            }
        }
        if (!this.zzX()) return super.onTouchEvent(motionEvent);
        return false;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : this
                throw throwable;
            }
        }
    }

    @Override
    public final zzefw<String> zzaE() {
        return this.zzd.zzb();
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f = motionEvent.getAxisValue(9);
        float f2 = motionEvent.getAxisValue(10);
        if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
            return false;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int var1_1, int var2_5) {
        block32: {
            block33: {
                block28: {
                    block29: {
                        if (this.zzX()) {
                            this.setMeasuredDimension(0, 0);
                            return;
                        }
                        if (this.isInEditMode() || this.zzu || this.zzq.zzh()) {
                            super.onMeasure(var1_1, var2_5);
                            return;
                        }
                        if (this.zzq.zzj()) {
                            super.onMeasure(var1_1, var2_5);
                            return;
                        }
                        if (!this.zzq.zzi()) break block28;
                        var3_6 /* !! */  = zzaeq.zzce;
                        if (((Boolean)zzaaa.zzc().zzb(var3_6 /* !! */ )).booleanValue()) {
                            super.onMeasure(var1_1, var2_5);
                            return;
                        }
                        var3_6 /* !! */  = this.zzh();
                        if (var3_6 /* !! */  == null) break block29;
                        var3_7 = var3_6 /* !! */ .zzm();
lbl18:
                        // 2 sources

                        while (true) {
                            block30: {
                                block31: {
                                    if (var3_7 == 0.0f) {
                                        super.onMeasure(var1_1, var2_5);
                                        return;
                                    }
                                    var4_15 = View.MeasureSpec.getSize((int)var1_1);
                                    var1_1 = View.MeasureSpec.getSize((int)var2_5);
                                    var5_18 = (int)((float)var1_1 * var3_7);
                                    var6_21 = (int)((float)var4_15 / var3_7);
                                    if (var1_1 == 0) {
                                        if (var6_21 != 0) {
                                            var2_5 = (int)((float)var6_21 * var3_7);
                                            var1_1 = var6_21;
                                            var3_8 = var4_15;
                                            var4_15 = var6_21;
lbl32:
                                            // 4 sources

                                            while (true) {
                                                this.setMeasuredDimension(Math.min(var2_5, var3_8), Math.min(var4_15, var1_1));
                                                return;
                                            }
                                        }
                                        var1_1 = 0;
                                    }
                                    if (var4_15 != 0) break block30;
                                    if (var5_18 == 0) break block31;
                                    var4_15 = (int)((float)var5_18 / var3_7);
                                    var2_5 = var5_18;
                                    var3_8 = var5_18;
                                    ** GOTO lbl32
                                }
                                var2_5 = var5_18;
                                var3_8 = 0;
                                var4_15 = var6_21;
                                ** GOTO lbl32
                            }
                            var2_5 = var5_18;
                            var3_8 = var4_15;
                            var4_15 = var6_21;
                            ** continue;
                            break;
                        }
                    }
                    var3_7 = 0.0f;
                    ** while (true)
                }
                if (this.zzq.zzf()) {
                    var3_9 /* !! */  = zzaeq.zzch;
                    if (((Boolean)zzaaa.zzc().zzb(var3_9 /* !! */ )).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                        super.onMeasure(var1_1, var2_5);
                        return;
                    }
                    var3_9 /* !! */  = new zzbgw(this);
                    this.zzab("/contentHeight", (zzakp<? super zzbgf>)var3_9 /* !! */ );
                    this.zzaN("(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();");
                    var3_10 = this.zzh.density;
                    var4_16 = View.MeasureSpec.getSize((int)var1_1);
                    var1_1 = this.zzG;
                    switch (var1_1) {
                        default: {
                            var1_1 = (int)((float)var1_1 * var3_10);
lbl70:
                            // 2 sources

                            while (true) {
                                this.setMeasuredDimension(var4_16, var1_1);
                                return;
                            }
                        }
                        case -1: 
                    }
                    var1_1 = View.MeasureSpec.getSize((int)var2_5);
                    ** continue;
                }
                if (this.zzq.zzg()) {
                    this.setMeasuredDimension(this.zzh.widthPixels, this.zzh.heightPixels);
                    return;
                }
                var3_11 = View.MeasureSpec.getMode((int)var1_1);
                var4_17 = View.MeasureSpec.getSize((int)var1_1);
                var5_19 = View.MeasureSpec.getMode((int)var2_5);
                var6_22 = View.MeasureSpec.getSize((int)var2_5);
                if (var3_11 == -2147483648) break block32;
                if (var3_11 != 0x40000000) break block33;
                var1_1 = var4_17;
lbl86:
                // 3 sources

                while (true) {
                    block34: {
                        block35: {
                            if (var5_19 == -2147483648) break block34;
                            if (var5_19 != 0x40000000) break block35;
                            var2_5 = var6_22;
lbl90:
                            // 3 sources

                            while (true) {
                                block36: {
                                    block37: {
                                        var3_12 = this.zzq;
                                        if (var3_12.zzb > var1_1) break block36;
                                        if (var3_12.zza <= var2_5) break block37;
                                        var3_13 = 1;
lbl95:
                                        // 3 sources

                                        while (true) {
                                            block38: {
                                                block39: {
                                                    var5_20 = zzaeq.zzdC;
                                                    if (!((Boolean)zzaaa.zzc().zzb((zzaei)var5_20)).booleanValue()) break block38;
                                                    var5_20 = this.zzq;
                                                    var7_23 = var5_20.zzb;
                                                    var8_24 = this.zzi;
                                                    if ((float)var7_23 / var8_24 > (float)var1_1 / var8_24) break block39;
                                                    if (!((float)var5_20.zza / var8_24 > (float)var2_5 / var8_24)) {
                                                        var1_1 = 1;
lbl104:
                                                        // 3 sources

                                                        while (true) {
                                                            if (1 != var3_13) {
                                                                var1_1 = var3_13;
                                                            }
lbl107:
                                                            // 4 sources

                                                            while (true) {
                                                                if (var1_1 != 0) {
                                                                    var1_2 = this.zzq;
                                                                    var2_5 = var1_2.zzb;
                                                                    var3_14 = this.zzi;
                                                                    var1_3 = var1_2.zza;
                                                                    var5_20 = new StringBuilder(103);
                                                                    var5_20.append("Not enough space to show ad. Needs ");
                                                                    var5_20.append((int)((float)var2_5 / var3_14));
                                                                    var5_20.append("x");
                                                                    var5_20.append((int)((float)var1_3 / var3_14));
                                                                    var5_20.append(" dp, but only has ");
                                                                    var5_20.append((int)((float)var4_17 / var3_14));
                                                                    var5_20.append("x");
                                                                    var5_20.append((int)((float)var6_22 / var3_14));
                                                                    var5_20.append(" dp.");
                                                                    com.google.android.gms.ads.internal.util.zze.zzi((String)var5_20.toString());
                                                                    if (this.getVisibility() != 8) {
                                                                        this.setVisibility(4);
                                                                    }
                                                                    this.setMeasuredDimension(0, 0);
                                                                    if (!this.zzl) {
                                                                        this.zzY.zzb(zzui.zzR);
                                                                        this.zzl = true;
                                                                        return;
                                                                    }
                                                                    return;
                                                                }
                                                                if (this.getVisibility() != 8) {
                                                                    this.setVisibility(0);
                                                                }
                                                                if (!this.zzm) {
                                                                    this.zzY.zzb(zzui.zzS);
                                                                    this.zzm = true;
                                                                }
                                                                var1_4 = this.zzq;
                                                                this.setMeasuredDimension(var1_4.zzb, var1_4.zza);
                                                                return;
                                                            }
                                                            break;
                                                        }
                                                    }
                                                    var1_1 = 0;
                                                    ** GOTO lbl104
                                                }
                                                var1_1 = 0;
                                                ** continue;
                                            }
                                            var1_1 = var3_13;
                                            ** continue;
                                            break;
                                        }
                                    }
                                    var3_13 = 0;
                                    ** GOTO lbl95
                                }
                                var3_13 = 1;
                                ** continue;
                                break;
                            }
                        }
                        var2_5 = 0x7FFFFFFF;
                        ** GOTO lbl90
                    }
                    var2_5 = var6_22;
                    ** continue;
                    break;
                }
            }
            var1_1 = 0x7FFFFFFF;
            ** GOTO lbl86
        }
        var1_1 = var4_17;
        ** while (true)
    }

    public final void onGlobalLayout() {
        boolean bl = ((zzbgy)this).zzaK();
        if ((this = ((zzbgy)this).zzN()) != null && bl) {
            ((zzm)this).zzC();
            return;
        }
    }

    @Override
    public final synchronized void zzae(zzm zzm2) {
        this.zzo = zzm2;
    }

    @Override
    public final synchronized void zzak(IObjectWrapper iObjectWrapper) {
        this.zzp = iObjectWrapper;
    }

    @Override
    public final synchronized void zzam(zzm zzm2) {
        this.zzP = zzm2;
    }

    @Override
    public final synchronized void zzaf(zzbhv zzbhv2) {
        this.zzq = zzbhv2;
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final synchronized void zzag(boolean bl) {
        boolean bl2 = ((zzbgy)((Object)string2)).zzu;
        ((zzbgy)((Object)string2)).zzu = bl;
        ((zzbgy)((Object)string2)).zzaX();
        if (bl != bl2) {
            Object object = zzaeq.zzL;
            if (!((Boolean)zzaaa.zzc().zzb((zzaei)object)).booleanValue() || !((zzbgy)((Object)string2)).zzq.zzg()) {
                object = new zzatk((zzbgf)((Object)string2), "");
                String string2 = true != bl ? "default" : "expanded";
                ((zzatk)object).zzj(string2);
                return;
            }
        }
    }

    @Override
    public final void zzah() {
        this.zzR.zzb();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.zzX()) {
            this.zzR.zzd();
        }
        boolean bl = this.zzA;
        zzbgm zzbgm2 = this.zzn;
        if (zzbgm2 != null && zzbgm2.zzd()) {
            if (!this.zzB) {
                this.zzn.zzf();
                this.zzn.zzg();
                this.zzB = true;
            }
            this.zzaK();
            bl = true;
        }
        this.zzbd(bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void onDetachedFromWindow() {
        synchronized (this) {
            boolean bl;
            ViewTreeObserver viewTreeObserver;
            boolean bl2;
            zzbgm zzbgm2;
            boolean bl3 = this.zzX();
            if (!bl3) {
                this.zzR.zze();
            }
            super.onDetachedFromWindow();
            bl3 = this.zzB;
            if (bl3 && (zzbgm2 = this.zzn) != null && (bl2 = zzbgm2.zzd()) && (viewTreeObserver = this.getViewTreeObserver()) != null && (bl = this.getViewTreeObserver().isAlive())) {
                zzbgm zzbgm3 = this.zzn;
                zzbgm3.zzf();
                zzbgm3 = this.zzn;
                zzbgm3.zzg();
                this.zzB = false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl16 : MonitorExitStatement: MONITOREXIT : this
            this.zzbd(false);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public final void zzai(Context context) {
        this.zzb.setBaseContext(context);
        this.zzR.zza(this.zzb.zza());
    }

    @Override
    public final synchronized void zzaj(boolean bl) {
        zzm zzm2 = this.zzo;
        if (zzm2 != null) {
            zzm2.zzt(this.zzn.zzc(), bl);
            return;
        }
        this.zzs = bl;
    }

    @Override
    public final synchronized void zzal(int n) {
        zzm zzm2 = ((zzbgy)((Object)zzm2)).zzo;
        if (zzm2 != null) {
            zzm2.zzw(n);
            return;
        }
    }

    @Override
    @Nullable
    public final Activity zzj() {
        return this.zzb.zza();
    }

    @Override
    public final Context zzM() {
        return this.zzb.zzb();
    }

    private final synchronized void zzaX() {
        if (this.zzu || this.zzq.zzg()) {
            com.google.android.gms.ads.internal.util.zze.zzd((String)"Enabling hardware acceleration on an overlay.");
            this.zzaZ();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            com.google.android.gms.ads.internal.util.zze.zzd((String)"Disabling hardware acceleration on an AdView.");
            this.zzaY();
            return;
        }
        com.google.android.gms.ads.internal.util.zze.zzd((String)"Enabling hardware acceleration on an AdView.");
        this.zzaZ();
    }

    private final synchronized void zzaY() {
        if (!this.zzv) {
            this.setLayerType(1, null);
        }
        this.zzv = true;
    }

    private final synchronized void zzaZ() {
        if (this.zzv) {
            this.setLayerType(0, null);
        }
        this.zzv = false;
    }

    @Override
    public final synchronized void destroy() {
        this.zzbc();
        this.zzR.zzc();
        zzm zzm2 = this.zzo;
        if (zzm2 != null) {
            zzm2.zzb();
            this.zzo.zzq();
            this.zzo = null;
        }
        this.zzp = null;
        this.zzn.zzv();
        this.zzE = null;
        this.zzf = null;
        this.setOnClickListener(null);
        this.setOnTouchListener(null);
        if (this.zzt) {
            return;
        }
        com.google.android.gms.ads.internal.zzs.zzy();
        zzbfg.zzd(this);
        this.zzbb();
        this.zzt = true;
        com.google.android.gms.ads.internal.util.zze.zza("Initiating WebView self destruct sequence in 3...");
        com.google.android.gms.ads.internal.util.zze.zza("Loading blank page in WebView, 2...");
        this.zzaU("about:blank");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void finalize() throws Throwable {
        block6: {
            try {
                synchronized (this) {
                    boolean bl = this.zzt;
                    if (bl) break block6;
                    this.zzn.zzv();
                }
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            {
                com.google.android.gms.ads.internal.zzs.zzy();
                zzbfg.zzd(this);
                this.zzbb();
                this.zzba();
            }
        }
        super.finalize();
    }

    @Override
    public final synchronized void zzY() {
        com.google.android.gms.ads.internal.util.zze.zza("Destroying WebView!");
        this.zzba();
        zzebq zzebq2 = com.google.android.gms.ads.internal.util.zzr.zza;
        zzbgx zzbgx2 = new zzbgx(this);
        zzebq2.post((Runnable)zzbgx2);
    }

    private final synchronized void zzba() {
        if (!this.zzQ) {
            this.zzQ = true;
            com.google.android.gms.ads.internal.zzs.zzg().zzj();
            return;
        }
    }

    @Override
    public final synchronized boolean zzX() {
        return this.zzt;
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.zzX()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public final void zzao() {
        if (this.zzJ == null) {
            this.zzK.zzc();
            this.zzJ = zzaff.zzf();
            this.zzK.zza("native:view_load", this.zzJ);
            return;
        }
    }

    @Override
    public final void onPause() {
        if (this.zzX()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.zzX()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzau() {
        throw null;
    }

    @Override
    public final void zzav(boolean bl) {
        this.zzn.zzB(bl);
    }

    public final void stopLoading() {
        if (this.zzX()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzan(boolean bl) {
        this.zzx = bl;
    }

    @Override
    public final synchronized boolean zzZ() {
        return this.zzx;
    }

    @Override
    public final synchronized void zzbl() {
        zzl zzl2 = ((zzbgy)zzl2).zzf;
        if (zzl2 != null) {
            zzl2.zzbl();
            return;
        }
    }

    @Override
    public final synchronized void zzbm() {
        zzl zzl2 = ((zzbgy)zzl2).zzf;
        if (zzl2 != null) {
            zzl2.zzbm();
            return;
        }
    }

    private final synchronized void zzbb() {
        Map<String, zzbfn> map = this.zzW;
        if (map != null) {
            map = map.values().iterator();
            while (map.hasNext()) {
                ((zzbfn)map.next()).release();
            }
        }
        this.zzW = null;
    }

    @Override
    public final synchronized void zzu(String string2, zzbfn zzbfn2) {
        if (this.zzW == null) {
            HashMap<String, zzbfn> hashMap = new HashMap<String, zzbfn>();
            this.zzW = hashMap;
        }
        this.zzW.put(string2, zzbfn2);
    }

    @Override
    public final synchronized zzbfn zzs(String string2) {
        Map<String, zzbfn> map = ((zzbgy)((Object)map)).zzW;
        if (map == null) {
            return null;
        }
        return (zzbfn)map.get(string2);
    }

    @Override
    public final synchronized String zzm() {
        return this.zzy;
    }

    @Override
    public final synchronized String zzn() {
        zzdqr zzdqr2 = ((zzbgy)((Object)zzdqr2)).zzk;
        if (zzdqr2 != null) {
            return zzdqr2.zzb;
        }
        return null;
    }

    @Override
    public final synchronized void zzo(int n) {
        this.zzM = n;
    }

    @Override
    public final synchronized int zzp() {
        return this.zzM;
    }

    @Override
    public final zzbdg zzf() {
        return null;
    }

    @Override
    public final synchronized void zzA() {
        zzagt zzagt2 = ((zzbgy)((Object)zzagt2)).zzD;
        if (zzagt2 != null) {
            zzagt2.zza();
            return;
        }
    }

    @Override
    public final synchronized void zzaw(zzagt zzagt2) {
        this.zzD = zzagt2;
    }

    @Override
    public final synchronized void zzax(zzsv zzsv2) {
        this.zzE = zzsv2;
    }

    @Override
    public final synchronized zzsv zzay() {
        return this.zzE;
    }

    @Override
    public final zzafc zzi() {
        return this.zzI;
    }

    @Override
    public final zzafd zzq() {
        return this.zzK;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        WeakReference<View.OnClickListener> weakReference = new WeakReference<View.OnClickListener>(onClickListener);
        this.zzL = weakReference;
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final synchronized void zzap(zzagw zzagw2) {
        this.zzC = zzagw2;
    }

    @Override
    public final synchronized zzagw zzaq() {
        return this.zzC;
    }

    @Override
    public final synchronized zzbhb zzh() {
        return this.zzz;
    }

    @Override
    public final synchronized void zzx(zzbhb zzbhb2) {
        if (this.zzz != null) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzz = zzbhb2;
    }

    @Override
    public final synchronized boolean zzaa() {
        return this.zzF > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final synchronized void zzar(boolean n) {
        int n2 = ((zzbgy)this).zzF;
        n = 1 != n ? -1 : 1;
        ((zzbgy)this).zzF = n = n2 + n;
        if (n <= 0 && (this = ((zzbgy)this).zzo) != null) {
            ((zzm)this).zzF();
            return;
        }
    }

    private final void zzbc() {
        Object object = ((zzbgy)object).zzK;
        if (object == null) {
            return;
        }
        object = ((zzafd)object).zzc();
        if (com.google.android.gms.ads.internal.zzs.zzg().zza() != null) {
            com.google.android.gms.ads.internal.zzs.zzg().zza().zzb((zzaff)object);
            return;
        }
    }

    @Override
    public final void zzas() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzg(boolean bl) {
        this.zzn.zzz(false);
    }

    @Override
    public final void zzl() {
        if ((this = ((zzbgy)this).zzN()) != null) {
            ((zzm)this).zzE();
            return;
        }
    }

    @Override
    public final int zzy() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzz() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zzB(int n) {
        this.zzN = n;
    }

    @Override
    public final void zzC(int n) {
        this.zzO = n;
    }

    @Override
    public final int zzD() {
        return this.zzN;
    }

    @Override
    public final int zzE() {
        return this.zzO;
    }

    @Override
    public final void zzaF(zzc zzc2) {
        this.zzn.zzm(zzc2);
    }

    @Override
    public final void zzaG(boolean bl, int n) {
        this.zzn.zzo(bl, n);
    }

    @Override
    public final void zzaH(boolean bl, int n, String string2) {
        this.zzn.zzp(bl, n, string2);
    }

    @Override
    public final void zzaI(boolean bl, int n, String string2, String string3) {
        this.zzn.zzq(bl, n, string2, string3);
    }

    @Override
    public final void zzaJ(zzbh zzbh2, zzcvk zzcvk2, zzcni zzcni2, zzdvo zzdvo2, String string2, String string3, int n) {
        this.zzn.zzn(zzbh2, zzcvk2, zzcni2, zzdvo2, string2, string3, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzc(zzrh zzrh2) {
        synchronized (this) {
            this.zzA = zzrh2.zzj;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl4 : MonitorExitStatement: MONITOREXIT : this
            this.zzbd(zzrh2.zzj);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzbd(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = true != bl ? "0" : "1";
        hashMap.put("isVisible", string2);
        this.zze("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zzab(String string2, zzakp<? super zzbgf> zzakp2) {
        zzyi zzyi2 = zzyi2.zzn;
        if (zzyi2 != null) {
            zzyi2.zzs(string2, zzakp2);
            return;
        }
    }

    @Override
    public final void zzac(String string2, zzakp<? super zzbgf> zzakp2) {
        zzyi zzyi2 = zzyi2.zzn;
        if (zzyi2 != null) {
            zzyi2.zzt(string2, zzakp2);
            return;
        }
    }

    @Override
    public final void zzad(String string2, Predicate<zzakp<? super zzbgf>> predicate) {
        zzyi zzyi2 = zzyi2.zzn;
        if (zzyi2 != null) {
            zzyi2.zzu(string2, predicate);
            return;
        }
    }

    @Override
    public final boolean zzaz(boolean bl, int n) {
        this.destroy();
        zzug zzug2 = this.zzY;
        zzbgv zzbgv2 = new zzbgv(bl, n);
        zzug2.zzc(zzbgv2);
        this.zzY.zzb(zzui.zzT);
        return true;
    }

    @Override
    public final boolean zzaA() {
        return false;
    }

    @Override
    public final void zzw(int n) {
    }

    @Override
    public final zzdqo zzF() {
        return this.zzj;
    }

    @Override
    public final zzdqr zzaB() {
        return this.zzk;
    }

    public final void onAdClicked() {
        zzyi zzyi2 = zzyi2.zzn;
        if (zzyi2 != null) {
            zzyi2.onAdClicked();
            return;
        }
    }

    @Override
    public final void zzaC(zzdqo zzdqo2, zzdqr zzdqr2) {
        this.zzj = zzdqo2;
        this.zzk = zzdqr2;
    }

    @Override
    public final synchronized void zzaD(boolean bl) {
        if (bl) {
            this.setBackgroundColor(0);
        }
        if ((this = ((zzbgy)this).zzo) != null) {
            ((zzm)this).zzu(bl);
            return;
        }
    }

    static /* synthetic */ int zzaR(zzbgy zzbgy2) {
        return zzbgy2.zzG;
    }

    static /* synthetic */ int zzaS(zzbgy zzbgy2, int n) {
        zzbgy2.zzG = n;
        return n;
    }

    static /* synthetic */ void zzaT(zzbgy zzbgy2) {
        super.destroy();
    }
}

