/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzagt;
import com.google.android.gms.internal.ads.zzahh;
import com.google.android.gms.internal.ads.zzamx;
import com.google.android.gms.internal.ads.zzanb;
import com.google.android.gms.internal.ads.zzbcj;
import com.google.android.gms.internal.ads.zzbql;
import com.google.android.gms.internal.ads.zzces;
import com.google.android.gms.internal.ads.zzcex;
import com.google.android.gms.internal.ads.zzcio;
import com.google.android.gms.internal.ads.zzcip;
import com.google.android.gms.internal.ads.zzebq;
import java.util.Collections;

public final class zzciq
extends zzamx
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzagt {
    private View zza;
    private zzacj zzb;
    private zzces zzc;
    private boolean zzd;
    private boolean zze;

    public zzciq(zzces zzces2, zzcex zzcex2) {
        this.zza = zzcex2.zzF();
        this.zzb = zzcex2.zzu();
        this.zzc = zzces2;
        this.zzd = false;
        this.zze = false;
        if (zzcex2.zzO() != null) {
            zzcex2.zzO().zzaw(this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzd(IObjectWrapper object, zzanb zzanb2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzciq)object2).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad can not be shown after destroy().");
            zzciq.zzi(zzanb2, 2);
            return;
        }
        View view = ((zzciq)object2).zza;
        if (view == null || ((zzciq)object2).zzb == null) {
            Object object2 = view == null ? "can not get video view." : "can not get video controller.";
            object = "Instream internal error: ";
            object2 = ((String)object2).length() != 0 ? ((String)object).concat((String)object2) : new String((String)object);
            com.google.android.gms.ads.internal.util.zze.zzf((String)object2);
            zzciq.zzi(zzanb2, 0);
            return;
        }
        if (((zzciq)object2).zze) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad should not be used again.");
            zzciq.zzi(zzanb2, 1);
            return;
        }
        ((zzciq)object2).zze = true;
        super.zzg();
        object = ObjectWrapper.unwrap((IObjectWrapper)object);
        object = (ViewGroup)object;
        view = ((zzciq)object2).zza;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        object.addView(view, layoutParams);
        zzs.zzz();
        zzbcj.zza(((zzciq)object2).zza, (ViewTreeObserver.OnGlobalLayoutListener)object2);
        zzs.zzz();
        zzbcj.zzb(((zzciq)object2).zza, (ViewTreeObserver.OnScrollChangedListener)object2);
        super.zzh();
        try {
            zzanb2.zze();
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzcip zzcip2 = new zzcip(this);
        this.zzd(iObjectWrapper, (zzanb)zzcip2);
    }

    public final zzacj zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    public final zzahh zzf() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzces zzces2 = this.zzc;
        if (zzces2 != null && zzces2.zzF() != null) {
            return this.zzc.zzF().zza();
        }
        return null;
    }

    public final void zzc() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzg();
        zzces zzces2 = this.zzc;
        if (zzces2 != null) {
            ((zzbql)zzces2).zzR();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view = this.zza;
        if (view == null) {
            return;
        }
        if ((view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.zza);
            return;
        }
    }

    public final void onGlobalLayout() {
        this.zzh();
    }

    public final void onScrollChanged() {
        this.zzh();
    }

    @Override
    public final void zza() {
        zzebq zzebq2 = zzr.zza;
        zzcio zzcio2 = new zzcio(this);
        zzebq2.post((Runnable)zzcio2);
    }

    private final void zzh() {
        View view;
        zzces zzces2 = this.zzc;
        if (zzces2 != null && (view = this.zza) != null) {
            zzces2.zzp(view, Collections.emptyMap(), Collections.emptyMap(), zzces.zzz(this.zza));
            return;
        }
    }

    private static final void zzi(zzanb zzanb2, int n) {
        try {
            zzanb2.zzf(n);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

