/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzu;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.internal.ads.zzbgq;
import com.google.android.gms.internal.ads.zzblb;
import com.google.android.gms.internal.ads.zzblj;

public final class zza {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean zzc(Context context, Uri uri, zzw zzw2, zzu zzu2) {
        int n;
        try {
            n = zzt.zzp().zzs(context, uri);
            if (zzw2 != null) {
                zzw2.zzg();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zze.zzj((String)activityNotFoundException.getMessage());
            n = 6;
        }
        if (zzu2 != null) {
            zzu2.zzb(n);
        }
        return n == 5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zza(Context context, Intent intent, zzw zzw2, @Nullable zzu zzu2, boolean bl) {
        if (bl) {
            return zza.zzc(context, intent.getData(), zzw2, zzu2);
        }
        try {
            String string2 = "Launching an intent: ";
            String string3 = String.valueOf(intent.toURI());
            int n = string3.length();
            string2 = n != 0 ? string2.concat(string3) : (string3 = new String(string2));
            zze.zza(string2);
            zzt.zzp();
            com.google.android.gms.ads.internal.util.zzt.zzQ(context, intent);
            if (zzw2 != null) {
                zzw2.zzg();
            }
            if (zzu2 != null) {
                zzu2.zza(true);
            }
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zze.zzj((String)activityNotFoundException.getMessage());
            if (zzu2 != null) {
                zzu2.zza(false);
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzb(Context object, @Nullable zzc object2, zzw zzw2, @Nullable zzu zzu2) {
        if (object2 == null) {
            zze.zzj((String)"No intent data for launcher overlay.");
            return false;
        }
        zzblj.zzc((Context)object);
        String[] stringArray = ((zzc)((Object)object2)).zzh;
        if (stringArray != null) {
            return zza.zza((Context)object, (Intent)stringArray, zzw2, zzu2, ((zzc)((Object)object2)).zzj);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)((zzc)((Object)object2)).zzb)) {
            zze.zzj((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)((zzc)((Object)object2)).zzc)) {
            intent.setDataAndType(Uri.parse((String)((zzc)((Object)object2)).zzb), ((zzc)((Object)object2)).zzc);
        } else {
            intent.setData(Uri.parse((String)((zzc)((Object)object2)).zzb));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)((zzc)((Object)object2)).zzd)) {
            intent.setPackage(((zzc)((Object)object2)).zzd);
        }
        if (!TextUtils.isEmpty((CharSequence)((zzc)((Object)object2)).zze)) {
            stringArray = ((zzc)((Object)object2)).zze.split("/", 2);
            if (stringArray.length < 2) {
                object = String.valueOf(((zzc)((Object)object2)).zze);
                object2 = "Could not parse component name from open GMSG: ";
                object = ((String)object).length() != 0 ? ((String)object2).concat((String)object) : new String((String)object2);
                zze.zzj((String)object);
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = ((zzc)((Object)object2)).zzf))) {
            int n;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zze.zzj((String)"Could not parse intent flags.");
                n = 0;
            }
            intent.addFlags(n);
        }
        zzblb zzblb2 = zzblj.zzdb;
        if (((Boolean)zzbgq.zzc().zzb(zzblb2)).booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
            return zza.zza((Context)object, intent, zzw2, zzu2, ((zzc)((Object)((Object)object2))).zzj);
        }
        zzblb2 = zzblj.zzda;
        if ((Boolean)zzbgq.zzc().zzb(zzblb2) == false) return zza.zza((Context)object, intent, zzw2, zzu2, ((zzc)((Object)((Object)object2))).zzj);
        zzt.zzp();
        com.google.android.gms.ads.internal.util.zzt.zzu((Context)object, intent);
        return zza.zza((Context)object, intent, zzw2, zzu2, ((zzc)((Object)object2)).zzj);
    }
}

