/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import com.google.android.gms.ads.formats.zzg;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.util.zzbs;
import com.google.android.gms.ads.internal.util.zzbt;
import com.google.android.gms.ads.internal.util.zzbv;
import com.google.android.gms.ads.internal.util.zzcc;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzf;
import com.google.android.gms.ads.internal.util.zzk;
import com.google.android.gms.ads.internal.util.zzl;
import com.google.android.gms.ads.internal.util.zzm;
import com.google.android.gms.ads.internal.util.zzn;
import com.google.android.gms.ads.internal.util.zzo;
import com.google.android.gms.ads.internal.util.zzq;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzbgq;
import com.google.android.gms.internal.ads.zzblb;
import com.google.android.gms.internal.ads.zzblh;
import com.google.android.gms.internal.ads.zzblj;
import com.google.android.gms.internal.ads.zzbmf;
import com.google.android.gms.internal.ads.zzbmh;
import com.google.android.gms.internal.ads.zzbne;
import com.google.android.gms.internal.ads.zzcee;
import com.google.android.gms.internal.ads.zzcir;
import com.google.android.gms.internal.ads.zzcis;
import com.google.android.gms.internal.ads.zzciy;
import com.google.android.gms.internal.ads.zzcjm;
import com.google.android.gms.internal.ads.zzcog;
import com.google.android.gms.internal.ads.zzcpm;
import com.google.android.gms.internal.ads.zzdwm;
import com.google.android.gms.internal.ads.zzfdn;
import com.google.android.gms.internal.ads.zzfdq;
import com.google.android.gms.internal.ads.zzfpj;
import com.google.android.gms.internal.ads.zzfwq;
import com.google.android.gms.internal.ads.zzfxa;
import com.google.android.gms.internal.ads.zzgqf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzt {
    public static final zzfpj zza;
    @GuardedBy(value="AdUtil.class")
    private static boolean zzb;
    private final AtomicReference<Pattern> zzc;
    private final AtomicReference<Pattern> zzd;
    private boolean zze;
    private final Object zzf;
    @GuardedBy(value="userAgentLock")
    private String zzg;
    private boolean zzh;
    private boolean zzi;
    private final Executor zzj;

    public static int zza(int n) {
        if (n >= 5000) {
            return n;
        }
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder(97);
            stringBuilder.append("HTTP timeout too low: ");
            stringBuilder.append(n);
            stringBuilder.append(" milliseconds. Reverting to default timeout: 60000 milliseconds.");
            com.google.android.gms.ads.internal.util.zze.zzj((String)stringBuilder.toString());
        }
        return 60000;
    }

    @Nullable
    private static KeyguardManager zzab(Context object) {
        if ((object = object.getSystemService("keyguard")) != null && object instanceof KeyguardManager) {
            return (KeyguardManager)object;
        }
        return null;
    }

    private static Bundle zzac(Context context) {
        try {
            context = Wrappers.packageManager((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            return context;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            com.google.android.gms.ads.internal.util.zze.zzb("Error getting metadata", throwable);
            return null;
        }
    }

    public final zzfxa<Map<String, String>> zzb(Uri uri) {
        zzk zzk2 = new zzk(uri);
        return zzfwq.zzk(zzk2, this.zzj);
    }

    static /* bridge */ /* synthetic */ Object zzc(zzt zzt2) {
        return zzt2.zzf;
    }

    private static String zzad(Bundle object) {
        if (object == null) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.getString("com.google.android.gms.ads.APPLICATION_ID")))) {
            return "";
        }
        if (((String)object).matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$") || ((String)object).matches("^/\\d+~.+$")) {
            return object;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzd(Context context, String string2) {
        Object object = ((zzt)this).zzf;
        synchronized (object) {
            int n;
            boolean bl;
            String string3 = ((zzt)this).zzg;
            if (string3 != null) {
                return string3;
            }
            if (string2 == null) {
                return zzt.zzw();
            }
            try {
                ((zzt)this).zzg = com.google.android.gms.ads.internal.zzt.zzq().zzd(context);
            }
            catch (Exception exception) {}
            if (bl = TextUtils.isEmpty((CharSequence)((zzt)this).zzg)) {
                zzbgo.zzb();
                bl = zzcis.zzp();
                if (bl) {
                    ((zzt)this).zzg = zzt.zzV(context);
                } else {
                    ((zzt)this).zzg = null;
                    Object object2 = zza;
                    Object object3 = new zzm((zzt)this, context);
                    object2.post((Runnable)object3);
                    while ((object2 = ((zzt)this).zzg) == null) {
                        try {
                            ((zzt)this).zzf.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            ((zzt)this).zzg = zzt.zzw();
                            object2 = "Interrupted, use default user agent: ";
                            object3 = String.valueOf(((zzt)this).zzg);
                            n = ((String)object3).length();
                            object2 = n != 0 ? ((String)object2).concat((String)object3) : (object3 = new String((String)object2));
                            com.google.android.gms.ads.internal.util.zze.zzj((String)object2);
                        }
                    }
                }
            }
            String string4 = String.valueOf(((zzt)this).zzg);
            int n2 = String.valueOf(string4).length();
            n2 += 10;
            n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n2 += n);
            stringBuilder.append(string4);
            stringBuilder.append(" (Mobile; ");
            stringBuilder.append(string2);
            ((zzt)this).zzg = stringBuilder.toString();
            try {
                boolean bl2 = Wrappers.packageManager((Context)context).isCallerInstantApp();
                if (bl2) {
                    ((zzt)this).zzg = String.valueOf(((zzt)this).zzg).concat(";aia");
                }
            }
            catch (Exception exception) {
                com.google.android.gms.ads.internal.zzt.zzo().zzs(exception, "AdUtil.getUserAgent");
            }
            ((zzt)this).zzg = String.valueOf(((zzt)this).zzg).concat(")");
            return ((zzt)this).zzg;
        }
    }

    private final JSONArray zzae(Collection<?> object) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        object = object.iterator();
        while (object.hasNext()) {
            this.zzaf(jSONArray, object.next());
        }
        return jSONArray;
    }

    public final JSONObject zze(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zzag(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final JSONObject zzf(Map<String, ?> object) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            Iterator iterator = object.keySet().iterator();
            while (true) {
                boolean bl;
                if (!(bl = iterator.hasNext())) {
                    return jSONObject;
                }
                String string2 = (String)iterator.next();
                this.zzag(jSONObject, string2, object.get(string2));
            }
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            String string4 = "Could not convert map to JSON: ";
            string3 = string3.length() != 0 ? string4.concat(string3) : new String(string4);
            object = new JSONException(string3);
            throw object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final JSONObject zzg(@Nullable Bundle bundle, JSONObject jSONObject) {
        if (bundle == null) return null;
        try {
            return this.zze(bundle);
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.zze.zzh((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ void zzh(zzt zzt2, boolean bl) {
        zzt2.zze = bl;
    }

    static /* bridge */ /* synthetic */ void zzi(zzt zzt2, String string2) {
        zzt2.zzg = string2;
    }

    static /* bridge */ /* synthetic */ void zzj(boolean bl) {
        zzb = bl;
    }

    static {
        zzf zzf2 = new zzf(Looper.getMainLooper());
        zza = zzf2;
        zzb = false;
    }

    public zzt() {
        Object object = new AtomicReference(null);
        this.zzc = object;
        object = new AtomicReference(null);
        this.zzd = object;
        this.zze = true;
        this.zzf = object = new Object();
        this.zzh = false;
        this.zzi = false;
        this.zzj = Executors.newSingleThreadExecutor();
    }

    private final void zzaf(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zze((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            jSONArray.put((Object)this.zzf((Map)object));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zzae((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            JSONArray jSONArray2 = new JSONArray();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzaf(jSONArray2, objectArray[i]);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zzag(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zze((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            jSONObject.put(string2, (Object)this.zzf((Map)object));
            return;
        }
        if (object instanceof Collection) {
            if (string2 == null) {
                string2 = "null";
            }
            jSONObject.put(string2, (Object)this.zzae((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zzae(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    /*
     * WARNING - void declaration
     */
    public final void zzk(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection, boolean bl2, int n) {
        void var4_5;
        void var6_8;
        int n2 = zzt.zza((int)var6_8);
        StringBuilder stringBuilder = new StringBuilder(39);
        stringBuilder.append("HTTP timeout: ");
        stringBuilder.append(n2);
        stringBuilder.append(" milliseconds.");
        com.google.android.gms.ads.internal.util.zze.zzi((String)stringBuilder.toString());
        var4_5.setConnectTimeout(n2);
        var4_5.setInstanceFollowRedirects(false);
        var4_5.setReadTimeout(n2);
        var4_5.setRequestProperty("User-Agent", this.zzd(context, string2));
        var4_5.setUseCaches(false);
    }

    @TargetApi(value=26)
    public final void zzl(Context object) {
        if (!PlatformVersion.isAtLeastO()) {
            return;
        }
        Object object2 = zzblj.zzgj;
        if (!((Boolean)zzbgq.zzc().zzb(object2)).booleanValue()) {
            return;
        }
        object = object.getSystemService("connectivity");
        object = (ConnectivityManager)object;
        object2 = new zzo(this);
        object.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)object2);
    }

    public static void zzm(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzcjm.zza.execute(runnable);
    }

    public final void zzn(Context context, @Nullable String string2, String object, Bundle bundle, boolean bl) {
        com.google.android.gms.ads.internal.zzt.zzp();
        bundle.putString("device", zzt.zzx());
        bundle.putString("eids", TextUtils.join((CharSequence)",", (Iterable)zzblj.zza()));
        zzbgo.zzb();
        object = new zzn(this, context, string2);
        zzcis.zzr((Context)context, (String)string2, (String)"gmob-apps", (Bundle)bundle, (boolean)true, (zzcir)object);
    }

    public final boolean zzo(String string2) {
        AtomicReference<Pattern> atomicReference = ((zzt)((Object)atomicReference)).zzc;
        zzblb zzblb2 = zzblj.zzW;
        return zzt.zzah(string2, atomicReference, (String)zzbgq.zzc().zzb(zzblb2));
    }

    public final boolean zzp(String string2) {
        AtomicReference<Pattern> atomicReference = ((zzt)((Object)atomicReference)).zzd;
        zzblb zzblb2 = zzblj.zzX;
        return zzt.zzah(string2, atomicReference, (String)zzbgq.zzc().zzb(zzblb2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzah(String string2, AtomicReference<Pattern> object, String object2) {
        Pattern pattern;
        block7: {
            block6: {
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return false;
                }
                try {
                    pattern = (Pattern)((AtomicReference)object).get();
                    if (pattern == null) break block6;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
                boolean bl = ((String)object2).equals(pattern.pattern());
                if (bl) break block7;
            }
            object2 = Pattern.compile((String)object2);
            ((AtomicReference)object).set(object2);
            object = object2;
            return ((Pattern)object).matcher(string2).matches();
        }
        object = pattern;
        return ((Pattern)object).matcher(string2).matches();
    }

    public final boolean zzq(Context context) {
        if (this.zzi) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        context = context.getApplicationContext();
        zzq zzq2 = new zzq(this, null);
        context.registerReceiver((BroadcastReceiver)zzq2, intentFilter);
        this.zzi = true;
        return true;
    }

    public final boolean zzr(Context context) {
        if (this.zzh) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context = context.getApplicationContext();
        zzs zzs2 = new zzs(this, null);
        context.registerReceiver((BroadcastReceiver)zzs2, intentFilter);
        this.zzh = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=18)
    public final int zzs(Context context, Uri uri) {
        zzt zzt2;
        int n;
        if (context == null) {
            com.google.android.gms.ads.internal.util.zze.zza("Trying to open chrome custom tab on a null context");
            return 3;
        }
        if (!PlatformVersion.isAtLeastJellyBeanMR2()) {
            com.google.android.gms.ads.internal.util.zze.zza("Chrome Custom Tabs can only work with version Jellybean onwards.");
            n = 1;
        } else if (!(context instanceof Activity)) {
            com.google.android.gms.ads.internal.util.zze.zza("Chrome Custom Tabs can only work with Activity context.");
            n = 2;
        } else {
            n = 0;
        }
        Object object = zzblj.zzdd;
        zzblh zzblh2 = zzbgq.zzc();
        object = zzblh2.zzb((zzblb)object);
        object = (Boolean)object;
        zzblh2 = zzblj.zzde;
        if (((Boolean)object).equals(zzbgq.zzc().zzb((zzblb)zzblh2))) {
            n = 9;
        }
        if (n != 0) {
            zzt2 = new Intent("android.intent.action.VIEW");
            zzt2.setData(uri);
            zzt2.addFlags(0x10000000);
            context.startActivity((Intent)zzt2);
            return n;
        }
        Object object2 = zzblj.zzdd;
        if (((Boolean)zzbgq.zzc().zzb((zzblb)object2)).booleanValue()) {
            object2 = new zzbmh();
            object = new zzl(zzt2, (zzbmh)object2, context, uri);
            ((zzbmh)object2).zze((zzbmf)object);
            ((zzbmh)object2).zzb((Activity)context);
        }
        zzt2 = zzblj.zzde;
        if (((Boolean)zzbgq.zzc().zzb((zzblb)zzt2)).booleanValue()) {
            zzt2 = new CustomTabsIntent.Builder();
            zzt2 = zzt2.build();
            ((CustomTabsIntent)zzt2).intent.setPackage(zzgqf.zza(context));
            zzt2.launchUrl(context, uri);
        }
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzt(View view) {
        if ((view = view.getRootView()) == null) {
            return false;
        }
        if (!((view = view.getContext()) instanceof Activity)) return false;
        view = (Activity)view;
        if (view == null) {
            return false;
        }
        if ((view = view.getWindow()) == null) {
            return false;
        }
        view = view.getAttributes();
        if (view == null) return false;
        if ((view.flags & 0x80000) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=18)
    public static final void zzu(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (!PlatformVersion.isAtLeastJellyBeanMR2()) {
            return;
        }
        Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
        bundle.putBinder("android.support.customtabs.extra.SESSION", null);
        bundle.putString("com.android.browser.application_id", context.getPackageName());
        intent.putExtras(bundle);
    }

    public static final String zzv(Context context) {
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        return zzt.zzad(zzt.zzac(context));
    }

    static final String zzw() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ");
        stringBuilder.append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ");
            stringBuilder.append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/");
                stringBuilder.append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    public static final String zzx() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        String string4 = String.valueOf(string3);
        int n = string4.length();
        String string5 = String.valueOf(string2);
        int n2 = string5.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
        stringBuilder.append(string3);
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static final DisplayMetrics zzy(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    protected static final int[] zzz() {
        int[] nArray = new int[]{0, 0};
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final long zzA(View view) {
        float f;
        block2: {
            float f2 = Float.MAX_VALUE;
            while (view instanceof View) {
                f2 = Math.min(f2, view.getAlpha());
                view = view.getParent();
                if (!(f2 <= 0.0f)) continue;
                f = f2;
                break block2;
            }
            f = f2;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return Math.round(f * 100.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final WebResourceResponse zzB(Context object, String object2, String object3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", com.google.android.gms.ads.internal.zzt.zzp().zzd((Context)object, (String)object2));
        hashMap.put("Cache-Control", "max-stale=3600");
        object2 = new zzbs((Context)object);
        object = ((zzbs)object2).zzb(0, (String)object3, hashMap, null);
        object = (String)object.get(60L, TimeUnit.SECONDS);
        if (object == null) return null;
        try {
            object3 = new ByteArrayInputStream(((String)object).getBytes("UTF-8"));
            return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)object3);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            com.google.android.gms.ads.internal.util.zze.zzk((String)"Could not fetch MRAID JS.", (Throwable)exception);
            return null;
        }
    }

    public static final int zzC(Context context) {
        context = (TelephonyManager)context.getSystemService("phone");
        if (PlatformVersion.isAtLeastR()) {
            zzblb zzblb2 = zzblj.zzgl;
            if (((Boolean)zzbgq.zzc().zzb(zzblb2)).booleanValue()) {
                return 0;
            }
        }
        return context.getNetworkType();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String zzD() {
        void var0_2;
        Resources resources = com.google.android.gms.ads.internal.zzt.zzo().zzd();
        if (resources == null) return var0_2;
        String string2 = resources.getString(R.string.s7);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final zzbv zzE(Context object) {
        void var0_4;
        Object obj;
        try {
            obj = object.getClassLoader().loadClass("com.google.android.gms.ads.internal.util.WorkManagerUtil").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.zzt.zzo().zzs(exception, "Failed to instantiate WorkManagerUtil");
            return null;
        }
        if (!(obj instanceof IBinder)) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instantiated WorkManagerUtil not instance of IBinder.");
            return null;
        }
        IBinder iBinder = (IBinder)obj;
        if (iBinder == null) {
            return var0_4;
        }
        IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.ads.internal.util.IWorkManagerUtil");
        if (iInterface instanceof zzbv) {
            zzbv zzbv2 = (zzbv)iInterface;
            return var0_4;
        }
        IInterface iInterface2 = iInterface = new zzbt(iBinder);
        return var0_4;
    }

    public static final boolean zzF(Context context, String string2) {
        context = zzcee.zza(context);
        String string3 = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string2, string3) == 0;
    }

    public static final boolean zzG(String string2) {
        int n;
        String[] stringArray;
        if (!zzciy.zzl()) {
            return false;
        }
        Object object = zzblj.zzdx;
        if (!((Boolean)zzbgq.zzc().zzb((zzblb)object)).booleanValue()) {
            return false;
        }
        object = zzblj.zzdz;
        object = (String)zzbgq.zzc().zzb((zzblb)object);
        if (!((String)object).isEmpty()) {
            stringArray = ((String)object).split(";");
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                return false;
            }
        }
        Object object2 = zzblj.zzdy;
        object2 = (String)zzbgq.zzc().zzb((zzblb)object2);
        if (((String)object2).isEmpty()) {
            return true;
        }
        stringArray = ((String)object2).split(";");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=16)
    public static final boolean zzH(Context context) {
        if (context == null || !PlatformVersion.isAtLeastJellyBean()) {
            return false;
        }
        return (context = zzt.zzab(context)) != null && context.isKeyguardLocked();
    }

    public static final boolean zzI(Context object) {
        try {
            object = object.getClassLoader();
            String string2 = "com.google.android.gms.ads.internal.ClientApi";
            ((ClassLoader)object).loadClass(string2);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.zze.zzh((String)"Error loading class.", (Throwable)throwable);
            com.google.android.gms.ads.internal.zzt.zzo().zzs(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzJ(Context object) {
        if (PlatformVersion.isAtLeastO()) {
            zzblb zzblb2 = zzblj.zzgj;
            if (((Boolean)zzbgq.zzc().zzb(zzblb2)).booleanValue()) {
                object = zzt.class;
                synchronized (object) {
                    return zzb;
                    {
                        catch (Throwable throwable) {}
                        {
                            throw throwable;
                        }
                    }
                }
            }
        }
        if ((object = ((ConnectivityManager)object.getSystemService("connectivity")).getActiveNetworkInfo()) == null) return false;
        if (!object.isConnected()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzK(Context context) {
        try {
            block5: {
                boolean bl;
                Object object = (ActivityManager)context.getSystemService("activity");
                KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
                if (object == null || keyguardManager == null) {
                    return false;
                }
                if ((object = object.getRunningAppProcesses()) == null) {
                    return false;
                }
                object = object.iterator();
                while (bl = object.hasNext()) {
                    boolean bl2;
                    int n;
                    ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                    int n2 = Process.myPid();
                    if (n2 != (n = runningAppProcessInfo.pid)) continue;
                    int n3 = runningAppProcessInfo.importance;
                    if (n3 == 100 && (n3 = (int)(keyguardManager.inKeyguardRestrictedInputMode() ? 1 : 0)) == 0 && (context = (PowerManager)context.getSystemService("power")) != null && (bl2 = context.isScreenOn())) break block5;
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final boolean zzL(Context context) {
        context = zzt.zzac(context);
        String string2 = context.getString("com.google.android.gms.ads.INTEGRATION_MANAGER");
        return TextUtils.isEmpty((CharSequence)zzt.zzad((Bundle)context)) && !TextUtils.isEmpty((CharSequence)string2);
    }

    public static final boolean zzM(Context context) {
        if (!(context instanceof Activity)) {
            return false;
        }
        if ((context = ((Activity)context).getWindow()) == null || context.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        context.getDecorView().getGlobalVisibleRect(rect, null);
        context.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzN(View object, int n, MotionEvent motionEvent) {
        int[] nArray = new int[2];
        Rect rect = new Rect();
        try {
            Object object2;
            Object object3;
            int n2;
            int n3;
            int n4;
            String string2;
            String string3 = object.getContext().getPackageName();
            boolean bl = object instanceof zzdwm;
            if (bl) {
                object = ((zzdwm)((Object)object)).getChildAt(0);
            }
            if ((bl = object instanceof zzg) || (bl = object instanceof NativeAdView)) {
                string2 = "NATIVE";
                n4 = 1;
            } else {
                string2 = "UNKNOWN";
                n4 = 0;
            }
            if ((n3 = object.getLocalVisibleRect(rect)) != 0) {
                n3 = rect.width();
                int n5 = rect.height();
                n2 = n3;
                n3 = n5;
            } else {
                n2 = 0;
                n3 = 0;
            }
            com.google.android.gms.ads.internal.zzt.zzp();
            long l = zzt.zzA((View)object);
            object.getLocationOnScreen(nArray);
            int n6 = nArray[0];
            int n7 = nArray[1];
            boolean bl2 = object instanceof zzcpm;
            String string4 = "none";
            if (bl2) {
                object3 = ((zzcpm)object).zzR();
                if (object3 != null) {
                    object3 = ((zzfdq)object3).zzb;
                    int n8 = object.hashCode();
                    int n9 = String.valueOf(object3).length();
                    object2 = new StringBuilder(n9 += 12);
                    ((StringBuilder)object2).append((String)object3);
                    ((StringBuilder)object2).append(":");
                    ((StringBuilder)object2).append(n8);
                    object.setContentDescription((CharSequence)((StringBuilder)object2).toString());
                } else {
                    object3 = string4;
                }
            } else {
                object3 = string4;
            }
            int n10 = object instanceof zzcog;
            String string5 = "none";
            if (n10 != 0) {
                zzfdn zzfdn2 = ((zzcog)object).zzF();
                if (zzfdn2 != null) {
                    string2 = zzfdn.zza(zzfdn2.zzb);
                    n4 = zzfdn2.zzf;
                    string5 = zzfdn2.zzF;
                    n10 = n4;
                } else {
                    n10 = n4;
                }
            } else {
                n10 = n4;
            }
            Locale locale = Locale.US;
            object2 = new Object[]{object.hashCode(), string3, string5, object3, string2, n10, object.getClass().getName(), n6, n7, object.getWidth(), object.getHeight(), n2, n3, l, Integer.toString(n, 2)};
            object = String.format(locale, "<Ad hashCode=%d, package=%s, adNetCls=%s, gwsQueryId=%s, format=%s, impType=%d, class=%s, x=%d, y=%d, width=%d, height=%d, vWidth=%d, vHeight=%d, alpha=%d, state=%s>", (Object[])object2);
            com.google.android.gms.ads.internal.util.zze.zzi((String)object);
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzh((String)"Failure getting view location.", (Throwable)exception);
            return;
        }
    }

    public static final void zzO(Context context, String string2, String object) {
        Object object2 = new ArrayList();
        object2.add(object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = object.next();
            object2 = (String)object2;
            zzcc zzcc2 = new zzcc(context, string2, (String)object2);
            zzcc2.zzb();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void zzP(Context context, Throwable throwable) {
        if (context == null) return;
        try {
            boolean bl = (Boolean)zzbne.zzb.zze();
            if (!bl) return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable);
    }

    public static final void zzQ(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static final int zzR(String string2) {
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            com.google.android.gms.ads.internal.util.zze.zzj((String)"Could not parse value:".concat(((Object)numberFormatException).toString()));
            return 0;
        }
    }

    public static final Map<String, String> zzS(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : uri.getQueryParameterNames()) {
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static final WebResourceResponse zzT(HttpURLConnection var0) throws IOException {
        block5: {
            com.google.android.gms.ads.internal.zzt.zzp();
            var1_1 = var0.getContentType();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block5;
            var1_1 = "";
lbl6:
            // 2 sources

            while (true) {
                block6: {
                    com.google.android.gms.ads.internal.zzt.zzp();
                    var2_2 = var0.getContentType();
                    if (TextUtils.isEmpty((CharSequence)var2_2)) {
                        var2_2 = "";
lbl12:
                        // 4 sources

                        while (true) {
                            var3_4 = var0.getHeaderFields();
                            var4_5 = new HashMap(var3_4.size());
                            for (Map.Entry var5_6 : var3_4.entrySet()) {
                                if (var5_6.getKey() == null || var5_6.getValue() == null || ((List)var5_6.getValue()).size() <= 0) continue;
                                var4_5.put((String)var5_6.getKey(), (String)((List)var5_6.getValue()).get(0));
                            }
                            return com.google.android.gms.ads.internal.zzt.zzq().zzm(var1_1, var2_2, var0.getResponseCode(), var0.getResponseMessage(), (Map<String, String>)var4_5, var0.getInputStream());
                        }
                    }
                    var3_4 = var2_2.split(";");
                    if (((String[])var3_4).length != 1) break block6;
                    var2_2 = "";
                    ** GOTO lbl12
                }
                for (var2_3 = 1; var2_3 < ((Object)var3_4).length; ++var2_3) {
                    if (!var3_4[var2_3].trim().startsWith("charset") || (var4_5 = var3_4[var2_3].trim().split("=")).length <= 1) continue;
                    var2_2 = var4_5[1].trim();
                    ** GOTO lbl12
                }
                var2_2 = "";
                ** continue;
                break;
            }
        }
        var1_1 = var1_1.split(";")[0].trim();
        ** while (true)
    }

    public static final int[] zzU(Activity activity) {
        if ((activity = activity.getWindow()) != null && (activity = activity.findViewById(0x1020002)) != null) {
            int[] nArray = new int[]{activity.getWidth(), activity.getHeight()};
            return nArray;
        }
        return zzt.zzz();
    }

    @VisibleForTesting
    protected static final String zzV(Context object) {
        try {
            WebView webView = new WebView(object);
            object = webView.getSettings().getUserAgentString();
            return object;
        }
        catch (Throwable throwable) {
            return zzt.zzw();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final int[] zzW(Activity activity) {
        void var1_4;
        int[] nArray;
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            nArray = new int[]{view.getTop(), view.getBottom()};
            int[] nArray2 = nArray;
        } else {
            int[] nArray3 = zzt.zzz();
        }
        nArray = new int[]{zzbgo.zzb().zzb((Context)activity, (int)var1_4[0]), zzbgo.zzb().zzb((Context)activity, (int)var1_4[1])};
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzX(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl = !com.google.android.gms.ads.internal.zzt.zzp().zze ? (keyguardManager == null ? true : (keyguardManager.inKeyguardRestrictedInputMode() ? zzt.zzt(view) : true)) : true;
        long l = zzt.zzA(view);
        if (view.getVisibility() != 0) {
            return false;
        }
        if (!view.isShown()) {
            return false;
        }
        if (powerManager != null && !powerManager.isScreenOn()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        powerManager = zzblj.zzaW;
        if (((Boolean)zzbgq.zzc().zzb((zzblb)powerManager)).booleanValue() && !view.getLocalVisibleRect((Rect)(powerManager = new Rect())) && !view.getGlobalVisibleRect((Rect)(powerManager = new Rect()))) {
            return false;
        }
        view = zzblj.zzhc;
        if ((Boolean)zzbgq.zzc().zzb((zzblb)view) == false) return true;
        view = zzblj.zzhe;
        if (l >= (long)((Integer)zzbgq.zzc().zzb((zzblb)view)).intValue()) return true;
        return false;
    }

    @TargetApi(value=18)
    public static final void zzY(Context object, Uri uri) {
        int n;
        Object object2;
        try {
            object2 = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            object2.putExtras(bundle);
            zzt.zzu(object, (Intent)object2);
            bundle.putString("com.android.browser.application_id", object.getPackageName());
            object.startActivity((Intent)object2);
            object = uri.toString();
            n = String.valueOf(object).length();
            n += 26;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.google.android.gms.ads.internal.util.zze.zzh((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
        object2 = new StringBuilder(n);
        ((StringBuilder)object2).append("Opening ");
        ((StringBuilder)object2).append((String)object);
        ((StringBuilder)object2).append(" in a new browser.");
        object = ((StringBuilder)object2).toString();
        com.google.android.gms.ads.internal.util.zze.zze((String)object);
    }

    public static final int[] zzZ(Activity activity) {
        int[] nArray = zzt.zzU(activity);
        int[] nArray2 = new int[]{zzbgo.zzb().zzb((Context)activity, nArray[0]), zzbgo.zzb().zzb((Context)activity, nArray[1])};
        return nArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzaa(View view, Context context) {
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            context2 = (PowerManager)context2.getSystemService("power");
            return zzt.zzX(view, (PowerManager)context2, zzt.zzab(context));
        }
        context2 = null;
        return zzt.zzX(view, (PowerManager)context2, zzt.zzab(context));
    }
}

