/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.internal.ads.zzato;
import com.google.android.gms.internal.ads.zzaxb;

@TargetApi(value=16)
public final class zzatc {
    public final String zza;
    public final boolean zzb;
    public final boolean zzc;
    public final boolean zzd;
    private final String zze;
    private final MediaCodecInfo.CodecCapabilities zzf;

    public static zzatc zza(String string2, String string3, MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2) {
        zzatc zzatc2 = new zzatc(string2, string3, codecCapabilities, bl, bl2);
        return zzatc2;
    }

    public static zzatc zzb(String object) {
        object = new zzatc("OMX.google.raw.decoder", null, null, false, false);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private zzatc(String string2, String string3, MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2) {
        if (string2 == null) {
            throw null;
        }
        this.zza = string2;
        this.zze = string3;
        this.zzf = codecCapabilities;
        boolean bl3 = !bl ? (codecCapabilities != null ? (zzaxb.zza >= 19 ? codecCapabilities.isFeatureSupported("adaptive-playback") : false) : false) : false;
        this.zzb = bl3;
        bl3 = codecCapabilities != null ? (zzaxb.zza >= 21 ? codecCapabilities.isFeatureSupported("tunneled-playback") : false) : false;
        this.zzc = bl3;
        bl3 = !bl2 ? (codecCapabilities != null ? (zzaxb.zza >= 21 ? codecCapabilities.isFeatureSupported("secure-playback") : false) : false) : true;
        this.zzd = bl3;
    }

    private final void zzh(String string2) {
        String string3 = ((zzatc)((Object)string4)).zza;
        String string4 = ((zzatc)((Object)string4)).zze;
        String string5 = zzaxb.zze;
        String string6 = String.valueOf(string3);
        int n = string6.length();
        String string7 = String.valueOf(string4);
        int n2 = string7.length();
        String string8 = String.valueOf(string5);
        int n3 = string8.length();
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 20 + n + n2 + n3);
        stringBuilder.append("NoSupport [");
        stringBuilder.append(string2);
        stringBuilder.append("] [");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append(string4);
        stringBuilder.append("] [");
        stringBuilder.append(string5);
        stringBuilder.append("]");
        Log.d((String)"MediaCodecInfo", (String)stringBuilder.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=21)
    private static boolean zzi(MediaCodecInfo.VideoCapabilities videoCapabilities, int n, int n2, double d) {
        if (d == -1.0) return videoCapabilities.isSizeSupported(n, n2);
        if (!(d <= 0.0)) return videoCapabilities.areSizeAndRateSupported(n, n2, d);
        return videoCapabilities.isSizeSupported(n, n2);
    }

    @TargetApi(value=21)
    public final boolean zzc(int n) {
        Object object = this.zzf;
        if (object == null) {
            this.zzh("channelCount.caps");
            return false;
        }
        if ((object = object.getAudioCapabilities()) == null) {
            this.zzh("channelCount.aCaps");
            return false;
        }
        if (object.getMaxInputChannelCount() < n) {
            object = new StringBuilder(33);
            ((StringBuilder)object).append("channelCount.support, ");
            ((StringBuilder)object).append(n);
            this.zzh(((StringBuilder)object).toString());
            return false;
        }
        return true;
    }

    @TargetApi(value=21)
    public final boolean zzd(int n) {
        Object object = this.zzf;
        if (object == null) {
            this.zzh("sampleRate.caps");
            return false;
        }
        if ((object = object.getAudioCapabilities()) == null) {
            this.zzh("sampleRate.aCaps");
            return false;
        }
        if (!object.isSampleRateSupported(n)) {
            object = new StringBuilder(31);
            ((StringBuilder)object).append("sampleRate.support, ");
            ((StringBuilder)object).append(n);
            this.zzh(((StringBuilder)object).toString());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean zze(String string2) {
        if (string2 == null) return true;
        if (this.zze == null) {
            return true;
        }
        String string3 = string2.trim();
        if (string3.startsWith("avc1") || string3.startsWith("avc3")) {
            string3 = "video/avc";
        } else if (string3.startsWith("hev1") || string3.startsWith("hvc1")) {
            string3 = "video/hevc";
        } else if (string3.startsWith("vp9")) {
            string3 = "video/x-vnd.on2.vp9";
        } else if (string3.startsWith("vp8")) {
            string3 = "video/x-vnd.on2.vp8";
        } else if (string3.startsWith("mp4a")) {
            string3 = "audio/mp4a-latm";
        } else if (string3.startsWith("ac-3") || string3.startsWith("dac3")) {
            string3 = "audio/ac3";
        } else if (string3.startsWith("ec-3") || string3.startsWith("dec3")) {
            string3 = "audio/eac3";
        } else if (string3.startsWith("dtsc") || string3.startsWith("dtse")) {
            string3 = "audio/vnd.dts";
        } else if (string3.startsWith("dtsh") || string3.startsWith("dtsl")) {
            string3 = "audio/vnd.dts.hd";
        } else if (string3.startsWith("opus")) {
            string3 = "audio/opus";
        } else {
            if (!string3.startsWith("vorbis")) return true;
            string3 = "audio/vorbis";
        }
        if (string3 == null) {
            return true;
        }
        if (!this.zze.equals(string3)) {
            StringBuilder stringBuilder = new StringBuilder(string2.length() + 13 + string3.length());
            stringBuilder.append("codec.mime ");
            stringBuilder.append(string2);
            stringBuilder.append(", ");
            stringBuilder.append(string3);
            this.zzh(stringBuilder.toString());
            return false;
        }
        Pair<Integer, Integer> pair = zzato.zzb(string2);
        if (pair == null) {
            return true;
        }
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = this.zzg();
        int n = codecProfileLevelArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                StringBuilder stringBuilder = new StringBuilder(string2.length() + 22 + string3.length());
                stringBuilder.append("codec.profileLevel, ");
                stringBuilder.append(string2);
                stringBuilder.append(", ");
                stringBuilder.append(string3);
                this.zzh(stringBuilder.toString());
                return false;
            }
            MediaCodecInfo.CodecProfileLevel codecProfileLevel = codecProfileLevelArray[n2];
            if (codecProfileLevel.profile == (Integer)pair.first && codecProfileLevel.level >= (Integer)pair.second) {
                return true;
            }
            ++n2;
        }
    }

    @TargetApi(value=21)
    public final boolean zzf(int n, int n2, double d) {
        Object object = ((zzatc)((Object)string4)).zzf;
        if (object == null) {
            ((zzatc)((Object)string4)).zzh("sizeAndRate.caps");
            return false;
        }
        if ((object = object.getVideoCapabilities()) == null) {
            ((zzatc)((Object)string4)).zzh("sizeAndRate.vCaps");
            return false;
        }
        if (!zzatc.zzi((MediaCodecInfo.VideoCapabilities)object, n, n2, d)) {
            if (n >= n2 || !zzatc.zzi((MediaCodecInfo.VideoCapabilities)object, n2, n, d)) {
                object = new StringBuilder(69);
                ((StringBuilder)object).append("sizeAndRate.support, ");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append("x");
                ((StringBuilder)object).append(n2);
                ((StringBuilder)object).append("x");
                ((StringBuilder)object).append(d);
                ((zzatc)((Object)string4)).zzh(((StringBuilder)object).toString());
                return false;
            }
            object = new StringBuilder(69);
            ((StringBuilder)object).append("sizeAndRate.rotated, ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append("x");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append("x");
            ((StringBuilder)object).append(d);
            String string2 = ((StringBuilder)object).toString();
            String string3 = ((zzatc)((Object)string4)).zza;
            String string4 = ((zzatc)((Object)string4)).zze;
            object = zzaxb.zze;
            String string5 = String.valueOf(string3);
            int n3 = string5.length();
            String string6 = String.valueOf(string4);
            int n4 = string6.length();
            String string7 = String.valueOf(object);
            int n5 = string7.length();
            StringBuilder stringBuilder = new StringBuilder(string2.length() + 25 + n3 + n4 + n5);
            stringBuilder.append("AssumedSupport [");
            stringBuilder.append(string2);
            stringBuilder.append("] [");
            stringBuilder.append(string3);
            stringBuilder.append(", ");
            stringBuilder.append(string4);
            stringBuilder.append("] [");
            stringBuilder.append((String)object);
            stringBuilder.append("]");
            Log.d((String)"MediaCodecInfo", (String)stringBuilder.toString());
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final MediaCodecInfo.CodecProfileLevel[] zzg() {
        MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzf;
        if (codecCapabilities == null) return new MediaCodecInfo.CodecProfileLevel[0];
        if (codecCapabilities.profileLevels != null) return this.zzf.profileLevels;
        return new MediaCodecInfo.CodecProfileLevel[0];
    }
}

