/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzt;
import com.google.android.gms.internal.ads.zzbak;
import com.google.android.gms.internal.ads.zzbgq;
import com.google.android.gms.internal.ads.zzblb;
import com.google.android.gms.internal.ads.zzblj;
import com.google.android.gms.internal.ads.zzckd;
import com.google.android.gms.internal.ads.zzcke;
import com.google.android.gms.internal.ads.zzckf;
import com.google.android.gms.internal.ads.zzckg;
import com.google.android.gms.internal.ads.zzckh;
import com.google.android.gms.internal.ads.zzcki;
import com.google.android.gms.internal.ads.zzckj;
import com.google.android.gms.internal.ads.zzckk;
import com.google.android.gms.internal.ads.zzckl;
import com.google.android.gms.internal.ads.zzckn;
import com.google.android.gms.internal.ads.zzcko;
import com.google.android.gms.internal.ads.zzclf;
import com.google.android.gms.internal.ads.zzclg;
import com.google.android.gms.internal.ads.zzclh;
import com.google.android.gms.internal.ads.zzcli;
import com.google.android.gms.internal.ads.zzfpj;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=14)
public final class zzckm
extends zzcko
implements TextureView.SurfaceTextureListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener {
    private static final Map<Integer, String> zzc;
    private final zzclh zzd;
    private final zzcli zze;
    private final boolean zzf;
    private int zzg = 0;
    private int zzh = 0;
    private MediaPlayer zzi;
    private Uri zzj;
    private int zzk;
    private int zzl;
    private int zzm;
    private int zzn;
    private int zzo;
    private zzclf zzp;
    private final boolean zzq;
    private int zzr;
    private zzckn zzs;
    private boolean zzt = false;
    private Integer zzu = null;

    @Override
    public final int zza() {
        if (this.zzH()) {
            return this.zzi.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final int zzb() {
        if (Build.VERSION.SDK_INT >= 26 && this.zzH()) {
            return this.zzi.getMetrics().getInt("android.media.mediaplayer.dropped");
        }
        return -1;
    }

    @Override
    public final int zzc() {
        if (this.zzH()) {
            return this.zzi.getDuration();
        }
        return -1;
    }

    @Override
    public final int zzd() {
        zzckm zzckm2 = zzckm2.zzi;
        if (zzckm2 != null) {
            return zzckm2.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final int zze() {
        zzckm zzckm2 = zzckm2.zzi;
        if (zzckm2 != null) {
            return zzckm2.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final long zzf() {
        return 0L;
    }

    @Override
    public final long zzg() {
        if (this.zzu != null) {
            return this.zzh() * (long)this.zzm / 100L;
        }
        return -1L;
    }

    @Override
    public final long zzh() {
        if (this.zzu != null) {
            return (long)this.zzc() * (long)this.zzu.intValue();
        }
        return -1L;
    }

    static /* bridge */ /* synthetic */ zzckn zzi(zzckm zzckm2) {
        return zzckm2.zzs;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String zzj() {
        String string2 = true != ((zzckm)((Object)string2)).zzq ? "" : " spherical";
        String string3 = "MediaPlayer";
        if (string2.length() == 0) return new String(string3);
        return string3.concat(string2);
    }

    public final String toString() {
        String string2 = string3.getClass().getName();
        String string3 = Integer.toHexString(string3.hashCode());
        String string4 = String.valueOf(string2);
        int n = string4.length();
        String string5 = String.valueOf(string3);
        int n2 = string5.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
        stringBuilder.append(string2);
        stringBuilder.append("@");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    static /* bridge */ /* synthetic */ void zzk(zzckm zzckm2, boolean bl) {
        zzckm2.zzt = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static /* bridge */ /* synthetic */ void zzl(zzckm zzckm2, MediaPlayer mediaPlayer) {
        MediaPlayer.TrackInfo[] trackInfoArray = zzblj.zzbr;
        if ((Boolean)zzbgq.zzc().zzb((zzblb)trackInfoArray) == false) return;
        if (zzckm2.zzd == null) return;
        if (mediaPlayer == null) return;
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        trackInfoArray = mediaPlayer.getTrackInfo();
        if (trackInfoArray == null) return;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = trackInfoArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (hashMap.isEmpty()) return;
                zzckm2.zzd.zzd("onMetadataEvent", hashMap);
                return;
            }
            MediaPlayer.TrackInfo trackInfo = trackInfoArray[n2];
            if (trackInfo != null) {
                switch (trackInfo.getTrackType()) {
                    default: {
                        break;
                    }
                    case 2: {
                        if ((trackInfo = trackInfo.getFormat()) == null) break;
                        if (trackInfo.containsKey("mime")) {
                            hashMap.put("audioMime", trackInfo.getString("mime"));
                        }
                        if (Build.VERSION.SDK_INT < 30 || !trackInfo.containsKey("codecs-string")) break;
                        hashMap.put("audioCodec", trackInfo.getString("codecs-string"));
                        break;
                    }
                    case 1: {
                        if ((trackInfo = trackInfo.getFormat()) == null) break;
                        if (trackInfo.containsKey("frame-rate")) {
                            try {
                                hashMap.put("frameRate", String.valueOf(trackInfo.getFloat("frame-rate")));
                            }
                            catch (ClassCastException classCastException) {
                                hashMap.put("frameRate", String.valueOf(trackInfo.getInteger("frame-rate")));
                            }
                        }
                        if (trackInfo.containsKey("bitrate")) {
                            zzckm2.zzu = trackInfo.getInteger("bitrate");
                            hashMap.put("bitRate", String.valueOf(zzckm2.zzu));
                        }
                        if (trackInfo.containsKey("width") && trackInfo.containsKey("height")) {
                            int n3 = trackInfo.getInteger("width");
                            int n4 = trackInfo.getInteger("height");
                            StringBuilder stringBuilder = new StringBuilder(23);
                            stringBuilder.append(n3);
                            stringBuilder.append("x");
                            stringBuilder.append(n4);
                            hashMap.put("resolution", stringBuilder.toString());
                        }
                        if (trackInfo.containsKey("mime")) {
                            hashMap.put("videoMime", trackInfo.getString("mime"));
                        }
                        if (Build.VERSION.SDK_INT < 30 || !trackInfo.containsKey("codecs-string")) break;
                        hashMap.put("videoCodec", trackInfo.getString("codecs-string"));
                    }
                }
            }
            ++n2;
        }
    }

    static {
        block1: {
            Map<Integer, String> map = new Map<Integer, String>();
            zzc = map;
            if (Build.VERSION.SDK_INT >= 17) {
                zzc.put(-1004, "MEDIA_ERROR_IO");
                zzc.put(-1007, "MEDIA_ERROR_MALFORMED");
                zzc.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
                zzc.put(-110, "MEDIA_ERROR_TIMED_OUT");
                zzc.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
            }
            zzc.put(100, "MEDIA_ERROR_SERVER_DIED");
            map = zzc;
            Integer n = 1;
            map.put(n, "MEDIA_ERROR_UNKNOWN");
            zzc.put(n, "MEDIA_INFO_UNKNOWN");
            zzc.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
            zzc.put(701, "MEDIA_INFO_BUFFERING_START");
            zzc.put(702, "MEDIA_INFO_BUFFERING_END");
            zzc.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
            zzc.put(801, "MEDIA_INFO_NOT_SEEKABLE");
            zzc.put(802, "MEDIA_INFO_METADATA_UPDATE");
            if (Build.VERSION.SDK_INT < 19) break block1;
            zzc.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzc.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }

    public zzckm(Context context, zzclh zzclh2, boolean bl, boolean bl2, zzclg zzclg2, zzcli zzcli2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzd = zzclh2;
        this.zze = zzcli2;
        this.zzq = bl;
        this.zzf = bl2;
        this.zze.zza(this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzC() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzj == null || surfaceTexture == null) {
            return;
        }
        this.zzE(false);
        try {
            void var1_3;
            MediaPlayer mediaPlayer;
            com.google.android.gms.ads.internal.zzt.zzk();
            this.zzi = mediaPlayer = new MediaPlayer();
            this.zzi.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzi.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzi.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzi.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzi.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzi.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzm = 0;
            boolean bl = this.zzq;
            if (bl) {
                zzclf zzclf2;
                this.zzp = zzclf2 = new zzclf(this.getContext());
                this.zzp.zzd(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzp.start();
                zzclf2 = this.zzp.zzb();
                if (zzclf2 != null) {
                    zzclf zzclf3 = zzclf2;
                } else {
                    this.zzp.zze();
                    this.zzp = null;
                }
            }
            this.zzi.setDataSource(this.getContext(), this.zzj);
            com.google.android.gms.ads.internal.zzt.zzl();
            Surface surface = new Surface((SurfaceTexture)var1_3);
            this.zzi.setSurface(surface);
            this.zzi.setAudioStreamType(3);
            this.zzi.setScreenOnWhilePlaying(true);
            this.zzi.prepareAsync();
            this.zzF(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzj);
            String.valueOf(string2).length();
            com.google.android.gms.ads.internal.util.zze.zzk((String)"Failed to initialize MediaPlayer at ".concat(String.valueOf(string2)), (Throwable)exception);
            this.onError(this.zzi, 1, 0);
            return;
        }
    }

    final /* synthetic */ void zzm(int n) {
        zzckn zzckn2 = ((zzckm)((Object)zzckn2)).zzs;
        if (zzckn2 != null) {
            zzckn2.onWindowVisibilityChanged(n);
            return;
        }
    }

    private final void zzD() {
        if (!this.zzf) {
            return;
        }
        if (this.zzH() && this.zzi.getCurrentPosition() > 0 && this.zzh != 3) {
            com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView nudging MediaPlayer");
            this.zzG(0.0f);
            this.zzi.start();
            int n = this.zzi.getCurrentPosition();
            long l = com.google.android.gms.ads.internal.zzt.zzA().currentTimeMillis();
            while (this.zzH() && this.zzi.getCurrentPosition() == n && com.google.android.gms.ads.internal.zzt.zzA().currentTimeMillis() - l <= 250L) {
            }
            this.zzi.pause();
            this.zzn();
            return;
        }
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzm = n;
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView completion");
        this.zzF(5);
        this.zzh = 5;
        mediaPlayer = com.google.android.gms.ads.internal.util.zzt.zza;
        zzckf zzckf2 = new zzckf(this);
        mediaPlayer.post((Runnable)zzckf2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onMeasure(int n, int n2) {
        block23: {
            int n3;
            int n4;
            block25: {
                block26: {
                    block27: {
                        int n5;
                        int n6;
                        block32: {
                            block31: {
                                block30: {
                                    block28: {
                                        block29: {
                                            n4 = zzckm.getDefaultSize((int)this.zzk, (int)n);
                                            n3 = zzckm.getDefaultSize((int)this.zzl, (int)n2);
                                            if (this.zzk <= 0) break block25;
                                            if (this.zzl <= 0) break block26;
                                            if (this.zzp != null) break block27;
                                            n4 = View.MeasureSpec.getMode((int)n);
                                            n3 = View.MeasureSpec.getSize((int)n);
                                            n6 = View.MeasureSpec.getMode((int)n2);
                                            n5 = View.MeasureSpec.getSize((int)n2);
                                            if (n4 != 0x40000000) break block28;
                                            if (n6 != 0x40000000) break block29;
                                            n = this.zzk;
                                            n2 = n * n5;
                                            n4 = this.zzl;
                                            n6 = n3 * n4;
                                            if (n2 < n6) {
                                                n = n2 / n4;
                                                n2 = n5;
                                                break block23;
                                            } else if (n2 > n6) {
                                                n2 = n6 / n;
                                                n = n3;
                                                break block23;
                                            } else {
                                                n = n3;
                                                n2 = n5;
                                            }
                                            break block23;
                                        }
                                        n = 0x40000000;
                                        break block30;
                                    }
                                    n = n4;
                                }
                                if (n != 0x40000000) break block31;
                                n2 = n3 * this.zzl / this.zzk;
                                if (n6 == Integer.MIN_VALUE) {
                                    if (n2 > n5) {
                                        n = n3;
                                        n2 = n5;
                                        break block23;
                                    } else {
                                        n = n3;
                                    }
                                    break block23;
                                } else {
                                    n = n3;
                                }
                                break block23;
                            }
                            if (n6 != 0x40000000) break block32;
                            n2 = n5 * this.zzk / this.zzl;
                            if (n == Integer.MIN_VALUE) {
                                if (n2 > n3) {
                                    n = n3;
                                    n2 = n5;
                                    break block23;
                                } else {
                                    n = n2;
                                    n2 = n5;
                                }
                                break block23;
                            } else {
                                n = n2;
                                n2 = n5;
                            }
                            break block23;
                        }
                        int n7 = this.zzk;
                        int n8 = this.zzl;
                        if (n6 == Integer.MIN_VALUE) {
                            if (n8 > n5) {
                                n2 = n5 * n7 / n8;
                                n4 = n5;
                            } else {
                                n2 = n7;
                                n4 = n8;
                            }
                        } else {
                            n2 = n7;
                            n4 = n8;
                        }
                        if (n == Integer.MIN_VALUE) {
                            if (n2 > n3) {
                                n2 = n3 * n8 / n7;
                                n = n3;
                                break block23;
                            } else {
                                n = n2;
                                n2 = n4;
                            }
                            break block23;
                        } else {
                            n = n2;
                            n2 = n4;
                        }
                        break block23;
                    }
                    n = n4;
                    n2 = n3;
                    break block23;
                }
                n = n4;
                n2 = n3;
                break block23;
            }
            n = n4;
            n2 = n3;
        }
        this.setMeasuredDimension(n, n2);
        zzclf zzclf2 = this.zzp;
        if (zzclf2 != null) {
            zzclf2.zzc(n, n2);
        }
        if (Build.VERSION.SDK_INT != 16) {
            return;
        }
        int n9 = this.zzn;
        if (n9 > 0 && n9 != n || (n9 = this.zzo) > 0 && n9 != n2) {
            this.zzD();
        }
        this.zzn = n;
        this.zzo = n2;
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView prepared");
        this.zzF(2);
        this.zze.zzb();
        zzfpj zzfpj2 = com.google.android.gms.ads.internal.util.zzt.zza;
        Object object = new zzcke(this, mediaPlayer);
        zzfpj2.post((Runnable)object);
        this.zzk = mediaPlayer.getVideoWidth();
        this.zzl = mediaPlayer.getVideoHeight();
        int n = this.zzr;
        if (n != 0) {
            this.zzq(n);
        }
        this.zzD();
        n = this.zzk;
        int n2 = this.zzl;
        object = new StringBuilder(62);
        ((StringBuilder)object).append("AdMediaPlayerView stream dimensions: ");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(" x ");
        ((StringBuilder)object).append(n2);
        com.google.android.gms.ads.internal.util.zze.zzi((String)((StringBuilder)object).toString());
        if (this.zzh == 3) {
            this.zzp();
        }
        this.zzn();
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface created");
        this.zzC();
        surfaceTexture = com.google.android.gms.ads.internal.util.zzt.zza;
        zzckh zzckh2 = new zzckh(this);
        surfaceTexture.post((Runnable)zzckh2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        zzclf zzclf2;
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface changed");
        int n3 = this.zzh;
        int n4 = this.zzk == n ? (this.zzl == n2 ? 1 : 0) : 0;
        if (this.zzi != null && n3 == 3 && n4 != 0) {
            n4 = this.zzr;
            if (n4 != 0) {
                this.zzq(n4);
            }
            this.zzp();
        }
        if ((zzclf2 = this.zzp) != null) {
            zzclf2.zzc(n, n2);
        }
        zzclf2 = com.google.android.gms.ads.internal.util.zzt.zza;
        zzcki zzcki2 = new zzcki(this, n, n2);
        zzclf2.post(zzcki2);
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zze.zzf(this);
        this.zza.zza(surfaceTexture, this.zzs);
    }

    @Override
    public final void zzn() {
        this.zzG(this.zzb.zza());
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder(57);
        stringBuilder.append("AdMediaPlayerView size changed: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(n2);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        this.zzk = mediaPlayer.getVideoWidth();
        this.zzl = n3 = mediaPlayer.getVideoHeight();
        if (this.zzk != 0 && n3 != 0) {
            this.requestLayout();
            return;
        }
    }

    protected final void onWindowVisibilityChanged(int n) {
        StringBuilder stringBuilder = new StringBuilder(58);
        stringBuilder.append("AdMediaPlayerView window visibility changed to ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        stringBuilder = com.google.android.gms.ads.internal.util.zzt.zza;
        zzckd zzckd2 = new zzckd(this, n);
        stringBuilder.post(zzckd2);
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzo() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView pause");
        if (this.zzH() && this.zzi.isPlaying()) {
            this.zzi.pause();
            this.zzF(4);
            zzfpj zzfpj2 = com.google.android.gms.ads.internal.util.zzt.zza;
            zzckl zzckl2 = new zzckl(this);
            zzfpj2.post((Runnable)zzckl2);
        }
        this.zzh = 4;
    }

    @Override
    public final void zzp() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView play");
        if (this.zzH()) {
            this.zzi.start();
            this.zzF(3);
            this.zza.zzb();
            zzfpj zzfpj2 = com.google.android.gms.ads.internal.util.zzt.zza;
            zzckk zzckk2 = new zzckk(this);
            zzfpj2.post((Runnable)zzckk2);
        }
        this.zzh = 3;
    }

    private final void zzE(boolean bl) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView release");
        zzclf zzclf2 = this.zzp;
        if (zzclf2 != null) {
            zzclf2.zze();
            this.zzp = null;
        }
        if ((zzclf2 = this.zzi) != null) {
            zzclf2.reset();
            this.zzi.release();
            this.zzi = null;
            this.zzF(0);
            if (bl) {
                this.zzh = 0;
                return;
            }
        }
    }

    @Override
    public final void zzq(int n) {
        StringBuilder stringBuilder = new StringBuilder(34);
        stringBuilder.append("AdMediaPlayerView seek ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        if (this.zzH()) {
            this.zzi.seekTo(n);
            this.zzr = 0;
            return;
        }
        this.zzr = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzF(int n) {
        if (n == 3) {
            this.zze.zzc();
            this.zzb.zzb();
        } else if (this.zzg == 3) {
            this.zze.zze();
            this.zzb.zzc();
        }
        this.zzg = n;
    }

    @Override
    public final void zzr(zzckn zzckn2) {
        this.zzs = zzckn2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzG(float f) {
        zzckm zzckm2;
        zzckm2 = zzckm2.zzi;
        if (zzckm2 == null) {
            com.google.android.gms.ads.internal.util.zze.zzj((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
            return;
        }
        try {
            zzckm2.setVolume(f, f);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Override
    public final void zzs(String string2) {
        zzbak zzbak2 = zzbak.zza((Uri)(string2 = Uri.parse((String)string2)));
        if (zzbak2 == null || zzbak2.zza != null) {
            if (zzbak2 != null) {
                string2 = Uri.parse((String)zzbak2.zza);
            }
            this.zzj = string2;
            this.zzr = 0;
            this.zzC();
            this.requestLayout();
            this.invalidate();
            return;
        }
    }

    @Override
    public final void zzt() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView stop");
        MediaPlayer mediaPlayer = this.zzi;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            this.zzi.release();
            this.zzi = null;
            this.zzF(0);
            this.zzh = 0;
        }
        this.zze.zzd();
    }

    @Override
    public final void zzu(float f, float f2) {
        zzclf zzclf2 = ((zzckm)((Object)zzclf2)).zzp;
        if (zzclf2 != null) {
            zzclf2.zzf(f, f2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ boolean zzv(zzckm zzckm2) {
        return zzckm2.zzt;
    }

    private final boolean zzH() {
        int n;
        return this.zzi != null && (n = this.zzg) != -1 && n != 0 && n != 1;
    }

    public final boolean onError(MediaPlayer object, int n, int n2) {
        object = zzc.get(n);
        String string2 = zzc.get(n2);
        String string3 = String.valueOf(object);
        int n3 = string3.length();
        String string4 = String.valueOf(string2);
        int n4 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n3 + 38 + n4);
        stringBuilder.append("AdMediaPlayerView MediaPlayer error: ");
        stringBuilder.append((String)object);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        com.google.android.gms.ads.internal.util.zze.zzj((String)stringBuilder.toString());
        this.zzF(-1);
        this.zzh = -1;
        zzfpj zzfpj2 = com.google.android.gms.ads.internal.util.zzt.zza;
        zzckg zzckg2 = new zzckg(this, (String)object, string2);
        zzfpj2.post((Runnable)zzckg2);
        return true;
    }

    public final boolean onInfo(MediaPlayer object, int n, int n2) {
        String string2 = zzc.get(n);
        object = zzc.get(n2);
        String string3 = String.valueOf(string2);
        int n3 = string3.length();
        String string4 = String.valueOf(object);
        int n4 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n3 + 37 + n4);
        stringBuilder.append("AdMediaPlayerView MediaPlayer info: ");
        stringBuilder.append(string2);
        stringBuilder.append(":");
        stringBuilder.append((String)object);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        return true;
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface destroyed");
        object = this.zzi;
        if (object != null && this.zzr == 0) {
            this.zzr = object.getCurrentPosition();
        }
        if ((object = this.zzp) != null) {
            ((zzclf)object).zze();
        }
        object = com.google.android.gms.ads.internal.util.zzt.zza;
        zzckj zzckj2 = new zzckj(this);
        object.post((Runnable)zzckj2);
        this.zzE(true);
        return true;
    }
}

