/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzfxu;
import com.google.android.gms.internal.ads.zzgak;
import com.google.android.gms.internal.ads.zzggv;
import com.google.android.gms.internal.ads.zzggw;
import com.google.android.gms.internal.ads.zzgig;
import com.google.android.gms.internal.ads.zzgii;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzggx
implements zzfxu {
    private static final ThreadLocal<Cipher> zza;
    private static final ThreadLocal<Cipher> zzb;
    private final byte[] zzc;
    private final byte[] zzd;
    private final SecretKeySpec zze;
    private final int zzf;

    static {
        ThreadLocal threadLocal;
        zza = threadLocal = new zzggv();
        zzb = threadLocal = new zzggw();
    }

    public zzggx(byte[] object, int n) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec;
        Object object2;
        if (!zzgak.zza(1)) {
            object2 = new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
            throw object2;
        }
        if (n != 12 && n != 16) {
            object2 = new IllegalArgumentException("IV size should be either 12 or 16 bytes");
            throw object2;
        }
        ((zzggx)object2).zzf = n;
        zzgii.zza(((byte[])object).length);
        ((zzggx)object2).zze = secretKeySpec = new SecretKeySpec((byte[])object, "AES");
        object = zza.get();
        ((Cipher)object).init(1, ((zzggx)object2).zze);
        ((zzggx)object2).zzc = zzggx.zzb(((Cipher)object).doFinal(new byte[16]));
        ((zzggx)object2).zzd = zzggx.zzb(((zzggx)object2).zzc);
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        int n2 = ((zzggx)object).zzf;
        if (n > Integer.MAX_VALUE - n2 + -16) {
            Object object = new GeneralSecurityException("plaintext too long");
            throw object;
        }
        byte[] byArray3 = new byte[n2 + n + 16];
        byte[] byArray4 = zzgig.zza(n2);
        System.arraycopy(byArray4, 0, byArray3, 0, ((zzggx)object).zzf);
        Cipher cipher = zza.get();
        cipher.init(1, ((zzggx)object).zze);
        byArray4 = super.zzc(cipher, 0, byArray4, 0, byArray4.length);
        byArray2 = super.zzc(cipher, 1, byArray2, 0, 0);
        Cipher cipher2 = zzb.get();
        SecretKeySpec secretKeySpec = ((zzggx)object).zze;
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4);
        cipher2.init(1, (Key)secretKeySpec, ivParameterSpec);
        cipher2.doFinal(byArray, 0, n, byArray3, ((zzggx)object).zzf);
        byArray = super.zzc(cipher, 2, byArray3, ((zzggx)object).zzf, n);
        n += ((zzggx)object).zzf;
        for (int i = 0; i < 16; ++i) {
            byArray3[n + i] = (byte)(byArray2[i] ^ byArray4[i] ^ byArray[i]);
        }
        return byArray3;
    }

    private static byte[] zzb(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 15) {
            byte by = byArray[n];
            int n2 = n + 1;
            byArray2[n] = (byte)((by + by ^ (byArray[n2] & 0xFF) >>> 7) & 0xFF);
            n = n2;
        }
        n = byArray[15];
        byArray2[15] = (byte)(n + n ^ byArray[0] >> 7 & 0x87);
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte[] zzc(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        Object object;
        byte[] byArray2 = new byte[16];
        byArray2[15] = (byte)n;
        if (n3 == 0) {
            return cipher.doFinal(zzggx.zzd(byArray2, ((zzggx)object).zzc));
        }
        byte[] byArray3 = cipher.doFinal(byArray2);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                byArray3[i] = (byte)(byArray3[i] ^ byArray[n2 + n4 + i]);
            }
            byArray3 = cipher.doFinal(byArray3);
            n4 += 16;
        }
        if ((byArray = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3)).length == 16) {
            object = zzggx.zzd(byArray, ((zzggx)object).zzc);
            return cipher.doFinal(zzggx.zzd(byArray3, (byte[])object));
        }
        byte[] byArray4 = Arrays.copyOf(((zzggx)object).zzd, 16);
        for (int i = 0; i < (n3 = byArray.length); ++i) {
            byArray4[i] = (byte)(byArray4[i] ^ byArray[i]);
        }
        byArray4[n3] = (byte)(byArray4[n3] ^ 0x80);
        object = byArray4;
        return cipher.doFinal(zzggx.zzd(byArray3, (byte[])object));
    }

    private static byte[] zzd(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }
}

