/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzbt;
import com.google.android.gms.internal.ads.zzdy;
import com.google.android.gms.internal.ads.zzep;
import com.google.android.gms.internal.ads.zzfn;
import com.google.android.gms.internal.ads.zzir;
import com.google.android.gms.internal.ads.zziu;
import com.google.android.gms.internal.ads.zziw;
import com.google.android.gms.internal.ads.zziz;
import com.google.android.gms.internal.ads.zzo;
import java.util.Iterator;

final class zzja {
    private final Context zza;
    private final Handler zzb;
    private final zziw zzc;
    private final AudioManager zzd;
    @Nullable
    private zziz zze;
    private int zzf;
    private int zzg;
    private boolean zzh;

    public final int zza() {
        return this.zzd.getStreamMaxVolume(this.zzf);
    }

    public final int zzb() {
        if (zzfn.zza >= 28) {
            return this.zzd.getStreamMinVolume(this.zzf);
        }
        return 0;
    }

    private static int zzg(AudioManager audioManager, int n) {
        try {
            int n2 = audioManager.getStreamVolume(n);
            return n2;
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder(60);
            stringBuilder.append("Could not retrieve stream volume for stream type ");
            stringBuilder.append(n);
            zzep.zzb("StreamVolumeManager", stringBuilder.toString(), runtimeException);
            return audioManager.getStreamMaxVolume(n);
        }
    }

    static /* bridge */ /* synthetic */ Handler zzc(zzja zzja2) {
        return zzja2.zzb;
    }

    static /* bridge */ /* synthetic */ void zzd(zzja zzja2) {
        zzja2.zzh();
    }

    public zzja(Context object, Handler handler, zziw zziw2) {
        this.zza = object.getApplicationContext();
        this.zzb = handler;
        this.zzc = zziw2;
        object = (AudioManager)this.zza.getSystemService("audio");
        zzdy.zzb(object);
        this.zzd = object;
        this.zzf = 3;
        this.zzg = zzja.zzg(this.zzd, 3);
        this.zzh = zzja.zzi(this.zzd, this.zzf);
        super(this, null);
        super("android.media.VOLUME_CHANGED_ACTION");
        try {
            this.zza.registerReceiver((BroadcastReceiver)object, (IntentFilter)handler);
            this.zze = object;
            return;
        }
        catch (RuntimeException runtimeException) {
            zzep.zzb("StreamVolumeManager", "Error registering stream volume receiver", runtimeException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze() {
        zziz zziz2 = this.zze;
        if (zziz2 == null) {
            return;
        }
        try {
            Context context = this.zza;
            context.unregisterReceiver((BroadcastReceiver)zziz2);
        }
        catch (RuntimeException runtimeException) {
            zzep.zzb("StreamVolumeManager", "Error unregistering stream volume receiver", runtimeException);
        }
        this.zze = null;
    }

    public final void zzf(int n) {
        if (((zzja)((Object)iterator)).zzf == 3) {
            return;
        }
        ((zzja)((Object)iterator)).zzf = 3;
        ((zzja)((Object)iterator)).zzh();
        Iterator iterator = ((zzja)((Object)iterator)).zzc;
        zzo zzo2 = zziu.zzw(zziu.zzx(((zzir)((Object)iterator)).zza));
        if (!zzo2.equals(zziu.zzv(((zzir)((Object)iterator)).zza))) {
            zziu.zzD(((zzir)((Object)iterator)).zza, zzo2);
            iterator = zziu.zzA(((zzir)((Object)iterator)).zza).iterator();
            while (iterator.hasNext()) {
                ((zzbt)iterator.next()).zzq(zzo2);
            }
        }
    }

    private final void zzh() {
        int n = zzja.zzg(((zzja)((Object)iterator)).zzd, ((zzja)((Object)iterator)).zzf);
        boolean bl = zzja.zzi(((zzja)((Object)iterator)).zzd, ((zzja)((Object)iterator)).zzf);
        if (((zzja)((Object)iterator)).zzg != n || ((zzja)((Object)iterator)).zzh != bl) {
            ((zzja)((Object)iterator)).zzg = n;
            ((zzja)((Object)iterator)).zzh = bl;
            Iterator iterator = zziu.zzA(((zzir)((zzja)((Object)iterator)).zzc).zza).iterator();
            while (iterator.hasNext()) {
                ((zzbt)iterator.next()).zzr(n, bl);
            }
        }
    }

    private static boolean zzi(AudioManager audioManager, int n) {
        if (zzfn.zza >= 23) {
            return audioManager.isStreamMute(n);
        }
        return zzja.zzg(audioManager, n) == 0;
    }
}

