/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.overlay.zzaa;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzt;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzbbw;

public final class zza {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean zzc(Context context, Uri uri, zzaa zzaa2, zzy zzy2) {
        int n;
        try {
            n = zzu.zzp().zzm(context, uri);
            if (zzaa2 != null) {
                zzaa2.zzg();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzm.zzj((String)activityNotFoundException.getMessage());
            n = 6;
        }
        if (zzy2 != null) {
            zzy2.zzb(n);
        }
        return n == 5;
    }

    public static final boolean zza(Context context, Intent intent, zzaa zzaa2, @Nullable zzy zzy2, boolean bl) {
        block7: {
            if (bl) {
                return zza.zzc(context, intent.getData(), zzaa2, zzy2);
            }
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Launching an intent: ");
                stringBuilder.append(intent.toURI());
                String string2 = stringBuilder.toString();
                zze.zza(string2);
                zzu.zzp();
                zzt.zzT(context, intent);
                if (zzaa2 == null) break block7;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                zzm.zzj((String)activityNotFoundException.getMessage());
                if (zzy2 != null) {
                    zzy2.zza(false);
                }
                return false;
            }
            zzaa2.zzg();
        }
        if (zzy2 != null) {
            zzy2.zza(true);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzb(Context object, @Nullable zzc zzc2, zzaa zzaa2, @Nullable zzy zzy2) {
        void var3_4;
        void var2_3;
        void var1_2;
        if (var1_2 == null) {
            zzm.zzj((String)"No intent data for launcher overlay.");
            return false;
        }
        zzbbw.zza((Context)object);
        String[] stringArray = var1_2.zzh;
        if (stringArray != null) {
            return zza.zza(object, (Intent)stringArray, (zzaa)var2_3, (zzy)var3_4, var1_2.zzj);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)var1_2.zzb)) {
            zzm.zzj((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)var1_2.zzc)) {
            stringArray = var1_2.zzc;
            intent.setDataAndType(Uri.parse((String)var1_2.zzb), (String)stringArray);
        } else {
            intent.setData(Uri.parse((String)var1_2.zzb));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)var1_2.zzd)) {
            intent.setPackage(var1_2.zzd);
        }
        if (!TextUtils.isEmpty((CharSequence)var1_2.zze)) {
            stringArray = var1_2.zze.split("/", 2);
            if (stringArray.length < 2) {
                String string2 = var1_2.zze;
                zzm.zzj((String)"Could not parse component name from open GMSG: ".concat(String.valueOf(string2)));
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = var1_2.zzf))) {
            int n;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzm.zzj((String)"Could not parse intent flags.");
                n = 0;
            }
            intent.addFlags(n);
        }
        zzbbn zzbbn2 = zzbbw.zzea;
        if (((Boolean)zzba.zzc().zza(zzbbn2)).booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
            return zza.zza(object, intent, (zzaa)var2_3, (zzy)var3_4, var1_2.zzj);
        }
        zzbbn2 = zzbbw.zzdZ;
        if ((Boolean)zzba.zzc().zza(zzbbn2) == false) return zza.zza(object, intent, (zzaa)var2_3, (zzy)var3_4, var1_2.zzj);
        zzu.zzp();
        zzt.zzo(object, intent);
        return zza.zza(object, intent, (zzaa)var2_3, (zzy)var3_4, var1_2.zzj);
    }
}

