/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzdq;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbfa;
import com.google.android.gms.internal.ads.zzblj;
import com.google.android.gms.internal.ads.zzbln;
import com.google.android.gms.internal.ads.zzcab;
import com.google.android.gms.internal.ads.zzcru;
import com.google.android.gms.internal.ads.zzdiw;
import com.google.android.gms.internal.ads.zzdjb;
import com.google.android.gms.internal.ads.zzdna;
import java.util.Collections;

public final class zzdnb
extends zzblj
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbep {
    private View zza;
    private zzdq zzb;
    private zzdiw zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzdq zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            zzm.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbfa zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdnb)((Object)zzdiw2)).zzd) {
            zzm.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdiw zzdiw2 = ((zzdnb)((Object)zzdiw2)).zzc;
        if (zzdiw2 != null && zzdiw2.zzc() != null) {
            return zzdiw2.zzc().zza();
        }
        return null;
    }

    public zzdnb(zzdiw zzdiw2, zzdjb zzdjb2) {
        this.zza = zzdjb2.zzf();
        this.zzb = zzdjb2.zzj();
        this.zzc = zzdiw2;
        this.zzd = false;
        this.zze = false;
        if (zzdjb2.zzs() != null) {
            zzdjb2.zzs().zzap(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdiw zzdiw2 = this.zzc;
        if (zzdiw2 != null) {
            ((zzcru)zzdiw2).zzb();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdiw zzdiw2 = this.zzc;
        if (zzdiw2 != null && (view = this.zza) != null) {
            zzdiw2.zzB(view, Collections.emptyMap(), Collections.emptyMap(), zzdiw.zzX(this.zza));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        View view = this.zza;
        if (view == null || !((view = view.getParent()) instanceof ViewGroup)) {
            return;
        }
        ((ViewGroup)view).removeView(this.zza);
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzf(iObjectWrapper, (zzbln)new zzdna(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper iObjectWrapper, zzbln zzbln2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdnb)((Object)string2)).zzd) {
            zzm.zzg((String)"Instream ad can not be shown after destroy().");
            zzdnb.zzi(zzbln2, 2);
            return;
        }
        View view = ((zzdnb)((Object)string2)).zza;
        if (view == null || ((zzdnb)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            zzm.zzg((String)"Instream internal error: ".concat(string2));
            zzdnb.zzi(zzbln2, 0);
            return;
        }
        if (((zzdnb)((Object)string2)).zze) {
            zzm.zzg((String)"Instream ad should not be used again.");
            zzdnb.zzi(zzbln2, 1);
            return;
        }
        ((zzdnb)((Object)string2)).zze = true;
        super.zzh();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(((zzdnb)((Object)string2)).zza, new ViewGroup.LayoutParams(-1, -1));
        zzu.zzx();
        zzcab.zza(((zzdnb)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzu.zzx();
        zzcab.zzb(((zzdnb)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            zzbln2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbln zzbln2, int n) {
        try {
            zzbln2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

