/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Build;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzaon;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class zzfoc {
    @VisibleForTesting
    protected static final byte[] zza = new byte[]{61, 122, 18, 35, 1, -102, -93, -99, -98, -96, -29, 67, 106, -73, -64, -119, 107, -5, 79, -74, 121, -12, -34, 95, -25, -62, 63, 50, 108, -113, -103, 74};
    @VisibleForTesting
    protected static final byte[] zzb = new byte[]{-110, -13, -34, 70, -83, 43, 97, 21, -44, 16, -54, -125, -28, -57, -125, -127, -7, 17, 102, -69, 116, -121, -79, 43, -13, 120, 58, 55, -29, -108, 95, 83};
    private final byte[] zzc = zzb;
    private final byte[] zzd = zza;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zza(File object) throws GeneralSecurityException {
        X509Certificate[][] x509CertificateArray;
        String string2 = ((File)object).getAbsolutePath();
        try {
            x509CertificateArray = zzaon.zza(string2);
        }
        catch (IOException | RuntimeException exception) {
            throw new GeneralSecurityException("Failed to verify signatures", exception);
        }
        catch (zzaok zzaok2) {
            throw new GeneralSecurityException("Package is not signed", zzaok2);
        }
        if (x509CertificateArray.length != 1) {
            throw new GeneralSecurityException("APK has more than one signature.");
        }
        X509Certificate x509Certificate = x509CertificateArray[0][0];
        byte[] byArray = MessageDigest.getInstance("SHA-256").digest(x509Certificate.getEncoded());
        if (Arrays.equals(this.zzd, byArray)) return true;
        if ("user".equals(Build.TYPE)) return false;
        if (!Arrays.equals(this.zzc, byArray)) return false;
        return true;
    }
}

