/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.ads.zzaro;
import com.google.android.gms.internal.ads.zzasj;
import com.google.android.gms.internal.ads.zzfoh;
import com.google.android.gms.internal.ads.zzfoj;
import com.google.android.gms.internal.ads.zzfop;
import com.google.android.gms.internal.ads.zzfou;
import com.google.android.gms.internal.ads.zzfov;
import com.google.android.gms.internal.ads.zzfow;
import com.google.android.gms.internal.ads.zzfox;
import com.google.android.gms.internal.ads.zzfoy;
import com.google.android.gms.internal.ads.zzfoz;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfpa {
    private final Context zza;
    private final Executor zzb;
    private final zzfoh zzc;
    private final zzfoj zzd;
    private final zzfoz zze;
    private final zzfoz zzf;
    private Task zzg;
    private Task zzh;

    public final zzasj zza() {
        zzfoz zzfoz2 = this.zze;
        return zzfpa.zzg(this.zzg, zzfoz2.zza());
    }

    public final zzasj zzb() {
        zzfoz zzfoz2 = this.zzf;
        return zzfpa.zzg(this.zzh, zzfoz2.zza());
    }

    private static zzasj zzg(@NonNull Task task, @NonNull zzasj zzasj2) {
        if (!task.isSuccessful()) {
            return zzasj2;
        }
        return (zzasj)((Object)task.getResult());
    }

    final /* synthetic */ zzasj zzc() throws Exception {
        zzaro zzaro2 = zzasj.zza();
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)((zzfpa)object).zza);
        Object object = info.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzaro2.zzs((String)object);
            zzaro2.zzr(info.isLimitAdTrackingEnabled());
            zzaro2.zzab(6);
        }
        return (zzasj)zzaro2.zzbn();
    }

    final /* synthetic */ zzasj zzd() throws Exception {
        zzfpa zzfpa2 = zzfpa2.zza;
        PackageInfo packageInfo = zzfpa2.getPackageManager().getPackageInfo(zzfpa2.getPackageName(), 0);
        zzfpa zzfpa3 = zzfpa2;
        return zzfop.zza((Context)zzfpa3, zzfpa3.getPackageName(), Integer.toString(packageInfo.versionCode));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzfpa zze(@NonNull Context context, @NonNull Executor executor, @NonNull zzfoh zzfoh2, @NonNull zzfoj zzfoj2) {
        zzfpa zzfpa2 = new zzfpa(context, executor, zzfoh2, zzfoj2, new zzfox(), new zzfoy());
        if (zzfpa2.zzd.zzd()) {
            zzfpa zzfpa3 = zzfpa2;
            zzfpa3.zzg = zzfpa3.zzh(new zzfou(zzfpa3));
        } else {
            zzfpa2.zzg = Tasks.forResult((Object)((Object)zzfpa2.zze.zza()));
        }
        zzfpa zzfpa4 = zzfpa2;
        zzfpa4.zzh = zzfpa4.zzh(new zzfov(zzfpa4));
        return zzfpa2;
    }

    private final Task zzh(@NonNull Callable object) {
        Task task = Tasks.call((Executor)this.zzb, (Callable)object);
        object = new zzfow(this);
        return task.addOnFailureListener(this.zzb, (OnFailureListener)object);
    }

    @VisibleForTesting
    zzfpa(Context context, Executor executor, zzfoh zzfoh2, zzfoj zzfoj2, zzfox zzfox2, zzfoy zzfoy2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfoh2;
        this.zzd = zzfoj2;
        this.zze = zzfox2;
        this.zzf = zzfoy2;
    }

    final /* synthetic */ void zzf(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }
}

