/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzavs;
import com.google.android.gms.internal.ads.zzavw;
import com.google.android.gms.internal.ads.zzawi;
import com.google.android.gms.internal.ads.zzawj;
import java.lang.ref.WeakReference;

public final class zzawk
implements View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
Application.ActivityLifecycleCallbacks {
    private static final Handler zza = new Handler(Looper.getMainLooper());
    private final Context zzb;
    private Application zzc;
    @Nullable
    private final PowerManager zzd;
    @Nullable
    private final KeyguardManager zze;
    private BroadcastReceiver zzf;
    private final zzavw zzg;
    private WeakReference zzh;
    @Nullable
    private WeakReference zzi;
    private zzavs zzj;
    private byte zzk = (byte)-1;
    private int zzl = -1;
    private long zzm = -3L;

    public final long zza() {
        if (this.zzm <= -2L && this.zzb() == null) {
            this.zzm = -3L;
        }
        return this.zzm;
    }

    @Nullable
    final View zzb() {
        WeakReference weakReference = ((zzawk)((Object)weakReference)).zzi;
        if (weakReference != null) {
            return (View)weakReference.get();
        }
        return null;
    }

    static /* bridge */ /* synthetic */ void zzc(zzawk zzawk2) {
        zzawk2.zzf();
    }

    public zzawk(Context context, zzavw zzavw2) {
        this.zzb = context.getApplicationContext();
        this.zzg = zzavw2;
        this.zzd = (PowerManager)this.zzb.getSystemService("power");
        this.zze = (KeyguardManager)this.zzb.getSystemService("keyguard");
        context = this.zzb;
        if (context instanceof Application) {
            context = (Application)context;
            this.zzc = context;
            this.zzj = new zzavs((Application)context, this);
        }
        this.zzd(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zze(Activity activity, int n) {
        block3: {
            block2: {
                if (this.zzi == null || (activity = activity.getWindow()) == null) break block2;
                activity = activity.peekDecorView();
                View view = this.zzb();
                if (view != null && activity != null && view.getRootView() == activity.getRootView()) break block3;
            }
            return;
        }
        this.zzl = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzf() {
        byte by;
        block24: {
            block21: {
                View view;
                block22: {
                    block23: {
                        Object object;
                        block20: {
                            if (this.zzi == null) break block21;
                            view = this.zzb();
                            if (view == null) {
                                this.zzm = -3L;
                                this.zzk = (byte)-1;
                                return;
                            }
                            by = view.getVisibility() != 0 ? (byte)1 : 0;
                            if (!view.isShown()) {
                                by |= 2;
                            }
                            if ((object = this.zzd) != null && !object.isScreenOn()) {
                                by |= 4;
                            }
                            if (this.zzg.zza()) break block22;
                            object = this.zze;
                            if (object == null || !object.inKeyguardRestrictedInputMode()) break block23;
                            object = view.getRootView();
                            if (object == null) {
                                object = view;
                            }
                            int n = 0;
                            Context context = object.getContext();
                            while (context instanceof ContextWrapper) {
                                if (n < 10) {
                                    if (context instanceof Activity) {
                                        object = (Activity)context;
                                        break block20;
                                    } else {
                                        ++n;
                                        context = ((ContextWrapper)context).getBaseContext();
                                        continue;
                                    }
                                }
                                object = null;
                                break block20;
                            }
                            object = null;
                        }
                        if (object != null && (object = (object = object.getWindow()) == null ? null : object.getAttributes()) != null && (object.flags & 0x80000) != 0) break block22;
                    }
                    by |= 8;
                }
                if (!view.getGlobalVisibleRect(new Rect())) {
                    by |= 0x10;
                }
                if (!view.getLocalVisibleRect(new Rect())) {
                    by |= 0x20;
                }
                int n = view.getWindowVisibility();
                int n2 = this.zzl;
                if (n2 != -1) {
                    n = n2;
                }
                if (n != 0) {
                    by |= 0x40;
                }
                if (this.zzk != by) break block24;
            }
            return;
        }
        this.zzk = by;
        long l = by == 0 ? SystemClock.elapsedRealtime() : -3L - (long)by;
        this.zzm = l;
    }

    private final void zzg() {
        zza.post((Runnable)new zzawi(this));
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zze(activity, 0);
        this.zzf();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzf();
    }

    public final void onActivityPaused(Activity activity) {
        this.zze(activity, 4);
        this.zzf();
    }

    public final void onActivityResumed(Activity activity) {
        this.zze(activity, 0);
        this.zzf();
        this.zzg();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzf();
    }

    public final void onActivityStarted(Activity activity) {
        this.zze(activity, 0);
        this.zzf();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzf();
    }

    public final void onGlobalLayout() {
        this.zzf();
    }

    public final void onScrollChanged() {
        this.zzf();
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzl = -1;
        this.zzh(view);
        this.zzf();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzl = -1;
        this.zzf();
        this.zzg();
        this.zzi(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void zzh(View view) {
        if ((view = view.getViewTreeObserver()).isAlive()) {
            this.zzh = new WeakReference<View>(view);
            view.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            view.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        if (this.zzf == null) {
            view = new IntentFilter();
            view.addAction("android.intent.action.SCREEN_ON");
            view.addAction("android.intent.action.SCREEN_OFF");
            view.addAction("android.intent.action.USER_PRESENT");
            this.zzf = new zzawj(this);
            this.zzb.registerReceiver(this.zzf, (IntentFilter)view);
        }
        if ((view = this.zzc) == null) return;
        try {
            view.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    final void zzd(View view) {
        View view2 = this.zzb();
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzi(view2);
        }
        this.zzi = new WeakReference<View>(view);
        if (view != null) {
            if (view.getWindowToken() != null || view.getWindowVisibility() != 8) {
                this.zzh(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzm = -2L;
            return;
        }
        this.zzm = -3L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private final void zzi(View view) {
        try {
            WeakReference weakReference = this.zzh;
            if (weakReference != null) {
                boolean bl;
                if ((weakReference = (ViewTreeObserver)weakReference.get()) != null && (bl = weakReference.isAlive())) {
                    weakReference.removeOnScrollChangedListener(this);
                    weakReference.removeGlobalOnLayoutListener(this);
                }
                this.zzh = null;
            }
        }
        catch (Exception exception) {}
        try {
            view = view.getViewTreeObserver();
            boolean bl = view.isAlive();
            if (bl) {
                view.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                view.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        if ((view = this.zzf) != null) {
            try {
                Context context = this.zzb;
                context.unregisterReceiver((BroadcastReceiver)view);
            }
            catch (Exception exception) {}
            this.zzf = null;
        }
        if ((view = this.zzc) == null) return;
        try {
            view.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

