/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsSession;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.internal.client.zzbe;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.ads.nonagon.signalgeneration.zzaa;
import com.google.android.gms.ads.nonagon.signalgeneration.zzf;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.internal.ads.zzbcc;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbdn;
import com.google.android.gms.internal.ads.zzbdo;
import com.google.android.gms.internal.ads.zzbdp;
import com.google.android.gms.internal.ads.zzbeq;
import com.google.android.gms.internal.ads.zzdsb;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbdq {
    private final ScheduledExecutorService zza;
    private final com.google.android.gms.ads.nonagon.signalgeneration.zzo zzb;
    private final zzf zzc;
    private final zzdsb zzd;
    private Runnable zze;
    private zzbdn zzf;
    private CustomTabsSession zzg;
    private String zzh;
    private long zzi = 0L;
    private long zzj;
    private JSONArray zzk;
    private Context zzl;

    static /* bridge */ /* synthetic */ CustomTabsSession zza(zzbdq zzbdq2) {
        return zzbdq2.zzg;
    }

    @Nullable
    public final CustomTabsSession zzb() {
        return this.zzg;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final JSONObject zzc(String string2, String string3) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("paw_id", (Object)string2);
        jSONObject.put("error", (Object)string3);
        long l = (Boolean)zzbeq.zzc.zze() != false ? (Long)zzbeq.zzf.zze() : 0L;
        jSONObject.put("sdk_ttl_ms", l);
        ((zzbdq)((Object)zzf2)).zzk(jSONObject);
        if (((Boolean)zzbeq.zza.zze()).booleanValue()) {
            zzf zzf2 = ((zzbdq)((Object)zzf2)).zzc;
            jSONObject.put("as", (Object)zzf2.zza());
        }
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final JSONObject zzd(String string2, String string3) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("paw_id", (Object)string2);
        jSONObject.put("signal", (Object)string3);
        long l = (Boolean)zzbeq.zzc.zze() != false ? (Long)zzbeq.zzf.zze() : 0L;
        jSONObject.put("sdk_ttl_ms", l);
        ((zzbdq)((Object)zzf2)).zzk(jSONObject);
        if (((Boolean)zzbeq.zza.zze()).booleanValue()) {
            zzf zzf2 = ((zzbdq)((Object)zzf2)).zzc;
            jSONObject.put("as", (Object)zzf2.zza());
        }
        return jSONObject;
    }

    public static /* synthetic */ void zze(zzbdq zzbdq2) {
        zzbdq2.zzj();
    }

    @VisibleForTesting
    public zzbdq(ScheduledExecutorService scheduledExecutorService, com.google.android.gms.ads.nonagon.signalgeneration.zzo zzo2, zzf zzf2, zzdsb zzdsb2) {
        this.zza = scheduledExecutorService;
        this.zzb = zzo2;
        this.zzc = zzf2;
        this.zzd = zzdsb2;
    }

    final void zzf() {
        zzbcc zzbcc2 = zzbcl.zzjI;
        this.zzi = zzv.zzC().elapsedRealtime() + (long)((Integer)zzbe.zzc().zza(zzbcc2)).intValue();
        if (this.zze == null) {
            this.zze = new zzbdo(this);
        }
        this.zzj();
    }

    public final void zzg(@Nonnull Context object, @Nonnull CustomTabsClient customTabsClient, @Nonnull String string2, @Nullable CustomTabsCallback customTabsCallback) {
        if (object == null) {
            throw new IllegalArgumentException("App Context parameter is null");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Origin parameter is empty or null");
        }
        if (customTabsClient != null) {
            pairArray.zzl = object;
            pairArray.zzh = string2;
            object = pairArray.zzd;
            pairArray.zzf = new zzbdn((zzbdq)pairArray, customTabsCallback, (zzdsb)object);
            pairArray.zzg = customTabsClient.newSession((CustomTabsCallback)pairArray.zzf);
            if (pairArray.zzg == null) {
                zzo.zzg((String)"CustomTabsClient failed to create new session.");
            }
        } else {
            throw new IllegalArgumentException("CustomTabsClient parameter is null");
        }
        Pair[] pairArray = new Pair[]{new Pair((Object)"pe", (Object)"pact_init")};
        zzaa.zzd(pairArray.zzd, null, "pact_action", pairArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzj() {
        block5: {
            block6: {
                zzbdn zzbdn2 = zzbdq2.zzf;
                if (zzbdn2 == null) {
                    zzo.zzg((String)"PACT callback is not present, please initialize the PawCustomTabsImpl.");
                    return;
                }
                if (zzbdn2.zza().booleanValue()) {
                    return;
                }
                if (zzbdq2.zzh == null || zzbdq2.zzg == null || zzbdq2.zza == null) break block5;
                if (zzbdq2.zzi != 0L && zzv.zzC().elapsedRealtime() <= zzbdq2.zzi) break block6;
                zzbdn2 = zzbcl.zzjJ;
                if (!((Boolean)zzbe.zzc().zza((zzbcc)zzbdn2)).booleanValue()) break block5;
            }
            zzbdq2.zzg.requestPostMessageChannel(Uri.parse((String)zzbdq2.zzh));
            zzbdq zzbdq2 = zzbcl.zzjK;
            zzbdq2.zza.schedule(zzbdq2.zze, (long)((Long)zzbe.zzc().zza((zzbcc)zzbdq2)), TimeUnit.MILLISECONDS);
            return;
        }
        com.google.android.gms.ads.internal.util.zze.zza("PACT max retry connection duration timed out");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzh(String string2) {
        try {
            CustomTabsSession customTabsSession = this.zzg;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("gsppack", true);
            jSONObject.put("fpt", (Object)new Date(this.zzj).toString());
            this.zzk(jSONObject);
            boolean bl = (Boolean)zzbeq.zza.zze();
            if (bl) {
                jSONObject.put("as", (Object)this.zzc.zza());
            }
            customTabsSession.postMessage(jSONObject.toString(), null);
            zzbdp zzbdp2 = new zzbdp(this, string2);
            boolean bl2 = (Boolean)zzbeq.zzc.zze();
            if (bl2) {
                this.zzb.zzg(this.zzg, zzbdp2);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("query_info_type", "requester_type_6");
            QueryInfo.generate((Context)this.zzl, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, bundle)).build(), (QueryInfoGenerationCallback)zzbdp2);
            return;
        }
        catch (JSONException jSONException) {
            zzo.zzh((String)"Error creating JSON: ", (Throwable)jSONException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzk(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = this.zzk;
            if (jSONArray == null) {
                zzbcc zzbcc2 = zzbcl.zzjM;
                Object object = zzbe.zzc().zza(zzbcc2);
                this.zzk = jSONArray = new JSONArray((String)object);
            }
            jSONObject.put("eids", (Object)this.zzk);
            return;
        }
        catch (JSONException jSONException) {
            zzo.zzh((String)"Error fetching the PACT active eids JSON: ", (Throwable)jSONException);
            return;
        }
    }

    public final void zzi(long l) {
        this.zzj = l;
    }
}

