/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzfr;
import com.google.android.gms.internal.ads.zzfz;
import com.google.android.gms.internal.ads.zzgd;
import com.google.android.gms.internal.ads.zzgv;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class zzgw
extends zzfr {
    private final Context zza;
    @Nullable
    private zzgd zzb;
    @Nullable
    private AssetFileDescriptor zzc;
    @Nullable
    private InputStream zzd;
    private long zze;
    private boolean zzf;

    private static int zzk(String string2) throws zzgv {
        int n;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new zzgv("Resource identifier must be an integer.", null, 1004);
        }
        return n;
    }

    @Override
    public final int zza(byte[] byArray, int n, int n2) throws zzgv {
        if (n2 == 0) {
            return 0;
        }
        long l = ((zzgw)object).zze;
        if (l != 0L) {
            int n3;
            block7: {
                block8: {
                    if (l != -1L) {
                        long l2 = Math.min(l, (long)n2);
                        n2 = (int)l2;
                    }
                    try {
                        InputStream inputStream = ((zzgw)object).zzd;
                        n3 = inputStream.read(byArray, n, n2);
                        if (n3 != -1) break block7;
                        if (((zzgw)object).zze == -1L) break block8;
                        Object object = new EOFException();
                    }
                    catch (IOException iOException) {
                        throw new zzgv(null, iOException, 2000);
                    }
                    throw new zzgv("End of stream reached having not read sufficient data.", (Throwable)object, 2000);
                }
                return -1;
            }
            long l3 = ((zzgw)object).zze;
            if (l3 != -1L) {
                ((zzgw)object).zze = l3 - (long)n3;
            }
            ((zzfr)object).zzg(n3);
            return n3;
        }
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final long zzb(zzgd var1_2) throws zzgv {
        block12: {
            block11: {
                this.zzb = var1_2;
                this.zzi(var1_2);
                this.zzc = zzgw.zzl(this.zza, var1_2);
                var6_3 = this.zzc.getLength();
                var8_4 = new FileInputStream(this.zzc.getFileDescriptor());
                this.zzd = var8_4;
                if (var6_3 == -1L) ** GOTO lbl11
                try {
                    var9_5 = var1_2.zze;
                    if (var9_5 > var6_3) ** GOTO lbl-1000
lbl11:
                    // 2 sources

                    if ((var11_7 = var8_4.skip((var2_6 = this.zzc.getStartOffset()) + var1_2.zze) - var2_6) != (var13_8 = var1_2.zze)) {
                        throw new zzgv(null, null, 2008);
                    }
                    if (var6_3 != -1L) break block11;
                    var2_6 = (var8_4 = var8_4.getChannel()).size();
                    if (var2_6 != 0L) ** GOTO lbl-1000
                    this.zze = -1L;
                    var2_6 = -1L;
                }
                catch (zzgv v0) {
                    throw v0;
                }
                catch (IOException var0_1) {
                    throw new zzgv(null, var0_1, 2000);
                }
lbl18:
                // 3 sources

                while (true) {
                    var9_5 = var1_2.zzf;
                    if (var9_5 != -1L) {
                        var4_9 = var2_6 == -1L ? var9_5 : Math.min(var2_6, var9_5);
                        this.zze = var4_9;
                    }
                    this.zzf = true;
                    this.zzj(var1_2);
                    var2_6 = var1_2.zzf;
                    if (var2_6 != -1L) {
                        return var2_6;
                    }
                    return this.zze;
                }
lbl-1000:
                // 1 sources

                {
                    this.zze = var15_10 = var8_4.size() - var8_4.position();
                    if (var15_10 < 0L) ** GOTO lbl44
                    var2_6 = var15_10;
                    ** GOTO lbl18
                }
            }
            var9_5 = var6_3 - var11_7;
            {
                this.zze = var9_5;
                if (var9_5 < 0L) {
                    throw new zzfz(2008);
                }
                break block12;
            }
lbl-1000:
            // 1 sources

            {
                throw new zzgv(null, null, 2008);
lbl44:
                // 1 sources

                throw new zzgv(null, null, 2008);
            }
        }
        var2_6 = var9_5;
        ** while (true)
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AssetFileDescriptor zzl(Context object, zzgd object2) throws zzgv {
        AssetFileDescriptor assetFileDescriptor;
        block15: {
            int n;
            Object object3;
            Uri uri = ((zzgd)object3).zza.normalizeScheme();
            object3 = uri.getScheme();
            if (TextUtils.equals((CharSequence)"rawresource", (CharSequence)object3)) {
                Resources resources = object.getResources();
                object3 = uri.getPathSegments();
                if (object3.size() != 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("rawresource:// URI must have exactly one path element, found ");
                    stringBuilder.append(object3.size());
                    throw new zzgv(stringBuilder.toString());
                }
                n = zzgw.zzk((String)object3.get(0));
            } else {
                String string2;
                object3 = uri.getScheme();
                if (!TextUtils.equals((CharSequence)"android.resource", (CharSequence)object3)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unsupported URI scheme (");
                    stringBuilder.append(uri.getScheme());
                    stringBuilder.append("). Only android.resource is supported.");
                    throw new zzgv(stringBuilder.toString(), null, 1004);
                }
                object3 = uri.getPath();
                if (object3 == null) {
                    throw null;
                }
                if (((String)(object3 = (String)object3)).startsWith("/")) {
                    object3 = ((String)object3).substring(1);
                }
                if ((string2 = TextUtils.isEmpty((CharSequence)uri.getHost()) ? object.getPackageName() : uri.getHost()).equals(object.getPackageName())) {
                    Resources resources = object.getResources();
                } else {
                    Resources resources = object.getPackageManager().getResourcesForApplication(string2);
                }
                if (((String)object3).matches("\\d+")) {
                    n = zzgw.zzk((String)object3);
                } else {
                    void var0_6;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string2);
                    stringBuilder.append(":");
                    stringBuilder.append((String)object3);
                    n = var0_6.getIdentifier(stringBuilder.toString(), "raw", null);
                    if (n == 0) {
                        throw new zzgv("Resource not found.", null, 2005);
                    }
                }
            }
            try {
                void var0_2;
                assetFileDescriptor = var0_2.openRawResourceFd(n);
                if (assetFileDescriptor != null) break block15;
            }
            catch (Resources.NotFoundException notFoundException) {
                throw new zzgv(null, notFoundException, 2005);
            }
            String string3 = String.valueOf(String.valueOf(uri));
            throw new zzgv("Resource is compressed: ".concat(string3), null, 2000);
        }
        return assetFileDescriptor;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new zzgv("Package in android.resource:// URI not found. Check http://g.co/dev/packagevisibility.", nameNotFoundException, 2005);
        }
    }

    @Deprecated
    public static Uri buildRawResourceUri(int rawResourceId) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("rawresource:///");
        stringBuilder.append(n);
        return Uri.parse((String)stringBuilder.toString());
    }

    @Override
    @Nullable
    public final Uri zzc() {
        zzgd zzgd2 = ((zzgw)((Object)zzgd2)).zzb;
        if (zzgd2 != null) {
            return zzgd2.zza;
        }
        return null;
    }

    public zzgw(Context context) {
        super(false);
        this.zza = context.getApplicationContext();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzd() throws zzgv {
        this.zzb = null;
        var1_1 = this.zzd;
        if (var1_1 != null) {
            var1_1.close();
        }
        this.zzd = null;
        var1_1 = this.zzc;
        if (var1_1 != null) {
            var1_1.close();
        }
        this.zzc = null;
        if (this.zzf) {
            this.zzf = false;
            this.zzh();
            return;
        }
        return;
        catch (IOException var1_2) {
            try {
                throw new zzgv(null, var1_2, 2000);
            }
            catch (Throwable var1_3) {
                block18: {
                    this.zzd = null;
                    try {
                        var2_10 = this.zzc;
                        if (var2_10 != null) {
                            var2_10.close();
                        }
                        this.zzc = null;
                        if (!this.zzf) break block18;
                        this.zzf = false;
                        this.zzh();
                    }
                    catch (IOException var1_7) {
                        try {
                            throw new zzgv(null, var1_7, 2000);
                        }
                        catch (Throwable var1_8) {
                            ** continue;
                        }
                    }
                }
                throw var1_3;
                catch (IOException var1_4) {
                    try {
                        throw new zzgv(null, var1_4, 2000);
                    }
                    catch (Throwable var1_5) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            this.zzc = null;
                            if (this.zzf) {
                                this.zzf = false;
                                this.zzh();
                            }
                            throw var1_6;
                        }
                    }
                }
            }
        }
    }
}

