/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.graphics.Point;
import android.media.MediaCodecInfo;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.ads.zzab;
import com.google.android.gms.internal.ads.zzbb;
import com.google.android.gms.internal.ads.zzcy;
import com.google.android.gms.internal.ads.zzdo;
import com.google.android.gms.internal.ads.zzei;
import com.google.android.gms.internal.ads.zzfk;
import com.google.android.gms.internal.ads.zzht;
import com.google.android.gms.internal.ads.zzk;
import com.google.android.gms.internal.ads.zzsi;
import com.google.android.gms.internal.ads.zzsu;
import com.google.android.gms.internal.ads.zzta;
import java.util.Objects;

public final class zzsg {
    public final String zza;
    public final String zzb;
    public final String zzc;
    @Nullable
    public final MediaCodecInfo.CodecCapabilities zzd;
    public final boolean zze;
    public final boolean zzf;
    public final boolean zzg;
    public final boolean zzh;
    private final boolean zzi;

    private static Point zzi(MediaCodecInfo.VideoCapabilities videoCapabilities, int n, int n2) {
        int n3 = videoCapabilities.getWidthAlignment();
        int n4 = videoCapabilities.getHeightAlignment();
        return new Point((n + n3 + -1) / n3 * n3, (n2 + n4 + -1) / n4 * n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Point zza(int n, int n2) {
        zzsg zzsg2 = zzsg2.zzd;
        if (zzsg2 == null || (zzsg2 = zzsg2.getVideoCapabilities()) == null) {
            return null;
        }
        return zzsg.zzi((MediaCodecInfo.VideoCapabilities)zzsg2, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzht zzb(zzab zzab2, zzab zzab3) {
        Object object;
        block19: {
            int n;
            block18: {
                String string2;
                String string3;
                block17: {
                    n = true != Objects.equals(zzab2.zzo, zzab3.zzo) ? 8 : 0;
                    if (!((zzsg)object).zzi) break block17;
                    if (zzab2.zzy != zzab3.zzy) {
                        n |= 0x400;
                    }
                    if (!(((zzsg)object).zze || zzab2.zzv == zzab3.zzv && zzab2.zzw == zzab3.zzw)) {
                        n |= 0x200;
                    }
                    if (!(zzk.zzg(zzab2.zzC) && zzk.zzg(zzab3.zzC) || Objects.equals(zzab2.zzC, zzab3.zzC))) {
                        n |= 0x800;
                    }
                    String string4 = ((zzsg)object).zza;
                    if (zzei.zzd.startsWith("SM-T230") && "OMX.MARVELL.VIDEO.HW.CODA7542DECODER".equals(string4) && !zzab2.zzd(zzab3)) {
                        n |= 2;
                    }
                    if (n == 0) {
                        String string5 = ((zzsg)object).zza;
                        int n2 = true != zzab2.zzd(zzab3) ? 2 : 3;
                        return new zzht(string5, zzab2, zzab3, n2, 0);
                    }
                    break block18;
                }
                if (zzab2.zzD != zzab3.zzD) {
                    n |= 0x1000;
                }
                if (zzab2.zzE != zzab3.zzE) {
                    n |= 0x2000;
                }
                if (zzab2.zzF != zzab3.zzF) {
                    n |= 0x4000;
                }
                if (n == 0 && "audio/mp4a-latm".equals(string3 = ((zzsg)object).zzb)) {
                    string3 = zzcy.zza(zzab2);
                    Pair pair = zzcy.zza(zzab3);
                    if (string3 != null && pair != null) {
                        int n3 = (Integer)pair.first;
                        if ((Integer)((Pair)string3).first == 42 && n3 == 42) {
                            object = ((zzsg)object).zza;
                            return new zzht((String)object, zzab2, zzab3, 3, 0);
                        }
                    }
                }
                if (!zzab2.zzd(zzab3)) {
                    n |= 0x20;
                }
                if ("audio/opus".equals(string2 = ((zzsg)object).zzb)) {
                    n |= 2;
                }
                if (n == 0) break block19;
            }
            object = ((zzsg)object).zza;
            return new zzht((String)object, zzab2, zzab3, 0, n);
        }
        object = ((zzsg)object).zza;
        return new zzht((String)object, zzab2, zzab3, 1, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzsg zzc(String string2, String string3, String string4, @Nullable MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        bl4 = codecCapabilities != null ? (codecCapabilities.isFeatureSupported("adaptive-playback") ? (zzei.zza <= 22 ? ("ODROID-XU3".equals(zzei.zzd) || "Nexus 10".equals(zzei.zzd) ? (!"OMX.Exynos.AVC.Decoder".equals(string2) ? !"OMX.Exynos.AVC.Decoder.secure".equals(string2) : false) : true) : true) : false) : false;
        boolean bl6 = codecCapabilities != null ? codecCapabilities.isFeatureSupported("tunneled-playback") : false;
        bl5 = !bl5 ? (codecCapabilities != null ? codecCapabilities.isFeatureSupported("secure-playback") : false) : true;
        boolean bl7 = zzei.zza >= 35 ? (codecCapabilities != null ? codecCapabilities.isFeatureSupported("detached-surface") : false) : false;
        return new zzsg(string2, string3, string4, codecCapabilities, bl, bl2, bl3, bl4, bl6, bl5, bl7);
    }

    public final String toString() {
        return this.zza;
    }

    @VisibleForTesting
    zzsg(String string2, String string3, String string4, @Nullable MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        if (string2 == null) {
            throw null;
        }
        this.zza = string2;
        this.zzb = string3;
        this.zzc = string4;
        this.zzd = codecCapabilities;
        this.zzg = bl;
        this.zze = bl4;
        this.zzf = bl6;
        this.zzh = bl7;
        this.zzi = zzbb.zzi(string3);
    }

    private final void zzj(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NoSupport [");
        stringBuilder.append(string2);
        stringBuilder.append("] [");
        stringBuilder.append(((zzsg)((Object)string3)).zza);
        stringBuilder.append(", ");
        stringBuilder.append(((zzsg)((Object)string3)).zzb);
        stringBuilder.append("] [");
        stringBuilder.append(zzei.zze);
        stringBuilder.append("]");
        String string3 = stringBuilder.toString();
        zzdo.zzb("MediaCodecInfo", string3);
    }

    private static boolean zzk(MediaCodecInfo.VideoCapabilities videoCapabilities, int n, int n2, double d) {
        Point point = zzsg.zzi(videoCapabilities, n, n2);
        n = point.x;
        n2 = point.y;
        if (d == -1.0 || d < 1.0) {
            return videoCapabilities.isSizeSupported(n, n2);
        }
        return videoCapabilities.areSizeAndRateSupported(n, n2, Math.floor(d));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final boolean zzl(zzab object, boolean bl) {
        void var5_18;
        String string2;
        int n;
        int n2;
        block36: {
            block38: {
                Object object2 = zzcy.zza((zzab)object);
                String string3 = ((zzab)object).zzo;
                if (string3 != null && string3.equals("video/mv-hevc") && this.zzc.equals("video/hevc")) {
                    object2 = zzfk.zzg(((zzab)object).zzr);
                    if (object2 == null) {
                        return true;
                    }
                    Object object3 = object2;
                    object2 = zzcy.zzb((String)object3, ((String)object3).trim().split("\\.", -1), ((zzab)object).zzC);
                }
                if (object2 == null) return true;
                n2 = (Integer)((Pair)object2).first;
                n = (Integer)((Pair)object2).second;
                String string4 = ((zzab)object).zzo;
                if (!"video/dolby-vision".equals(string4)) break block38;
                String string5 = this.zzb;
                if ("video/avc".equals(string5)) {
                    n = 8;
                    n2 = 0;
                    break block36;
                } else {
                    String string6 = this.zzb;
                    if ("video/hevc".equals(string6)) {
                        n = 2;
                        n2 = 0;
                        break block36;
                    } else {
                        int n3 = n;
                        n = n2;
                        n2 = n3;
                    }
                }
                break block36;
            }
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        if (!this.zzi) {
            if (n != 42) return true;
            n = 42;
        }
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = this.zzh();
        if (zzei.zza <= 23 && "video/x-vnd.on2.vp9".equals(string2 = this.zzb) && codecProfileLevelArray.length == 0) {
            void var5_16;
            void var5_14;
            MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzd;
            if (codecCapabilities != null) {
                MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                if (videoCapabilities != null) {
                    int n5 = (Integer)videoCapabilities.getBitrateRange().getUpper();
                } else {
                    boolean bl2 = false;
                }
            } else {
                boolean bl3 = false;
            }
            if (var5_14 >= 180000000) {
                int n6 = 1024;
            } else if (var5_14 >= 120000000) {
                int n7 = 512;
            } else if (var5_14 >= 60000000) {
                int n8 = 256;
            } else if (var5_14 >= 30000000) {
                int n9 = 128;
            } else if (var5_14 >= 18000000) {
                int n10 = 64;
            } else if (var5_14 >= 12000000) {
                int n11 = 32;
            } else if (var5_14 >= 0x6DDD00) {
                int n12 = 16;
            } else if (var5_14 >= 3600000) {
                int n13 = 8;
            } else if (var5_14 >= 1800000) {
                int n14 = 4;
            } else if (var5_14 >= 800000) {
                int n15 = 2;
            } else {
                boolean bl4 = true;
            }
            string2 = new MediaCodecInfo.CodecProfileLevel();
            ((MediaCodecInfo.CodecProfileLevel)string2).profile = 1;
            ((MediaCodecInfo.CodecProfileLevel)string2).level = var5_16;
            MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray2 = new MediaCodecInfo.CodecProfileLevel[]{string2};
        }
        int n16 = ((void)var5_18).length;
        int n17 = 0;
        while (true) {
            if (n17 >= n16) {
                object = ((zzab)object).zzk;
                zzsg zzsg2 = this;
                String string7 = zzsg2.zzc;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("codec.profileLevel, ");
                stringBuilder.append((String)object);
                stringBuilder.append(", ");
                stringBuilder.append(string7);
                zzsg2.zzj(stringBuilder.toString());
                return false;
            }
            void var8_36 = var5_18[n17];
            if (!(var8_36.profile != n || var8_36.level < n2 && bl)) {
                String string8 = this.zzb;
                if (!"video/hevc".equals(string8)) return true;
                if (n != 2) return true;
                if (!"sailfish".equals(zzei.zzb) && !"marlin".equals(zzei.zzb)) {
                    return true;
                }
            }
            ++n17;
        }
    }

    public final boolean zzd(zzab zzab2) {
        return this.zzm(zzab2) && this.zzl(zzab2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean zze(zzab zzab2) throws zzsu {
        int n;
        int n2;
        block14: {
            int n3;
            block15: {
                block17: {
                    block18: {
                        block19: {
                            block20: {
                                block21: {
                                    block22: {
                                        block23: {
                                            block24: {
                                                block25: {
                                                    String string2;
                                                    String string3;
                                                    block16: {
                                                        if (!this.zzm(zzab2)) {
                                                            return false;
                                                        }
                                                        if (!this.zzl(zzab2, true)) {
                                                            return false;
                                                        }
                                                        if (this.zzi) {
                                                            int n4 = zzab2.zzv;
                                                            if (n4 <= 0) return true;
                                                            int n5 = zzab2.zzw;
                                                            if (n5 > 0) return this.zzg(n4, n5, zzab2.zzx);
                                                            return true;
                                                        }
                                                        n2 = zzab2.zzE;
                                                        if (n2 != -1) {
                                                            MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzd;
                                                            if (codecCapabilities == null) {
                                                                this.zzj("sampleRate.caps");
                                                                return false;
                                                            }
                                                            MediaCodecInfo.AudioCapabilities audioCapabilities = codecCapabilities.getAudioCapabilities();
                                                            if (audioCapabilities == null) {
                                                                this.zzj("sampleRate.aCaps");
                                                                return false;
                                                            }
                                                            if (!audioCapabilities.isSampleRateSupported(n2)) {
                                                                StringBuilder stringBuilder = new StringBuilder();
                                                                stringBuilder.append("sampleRate.support, ");
                                                                stringBuilder.append(n2);
                                                                this.zzj(stringBuilder.toString());
                                                                return false;
                                                            }
                                                        }
                                                        if ((n2 = zzab2.zzD) == -1) {
                                                            return true;
                                                        }
                                                        zzab2 = this.zzd;
                                                        if (zzab2 == null) {
                                                            this.zzj("channelCount.caps");
                                                            return false;
                                                        }
                                                        if ((zzab2 = zzab2.getAudioCapabilities()) == null) {
                                                            this.zzj("channelCount.aCaps");
                                                            return false;
                                                        }
                                                        string3 = this.zza;
                                                        string2 = this.zzb;
                                                        n3 = zzab2.getMaxInputChannelCount();
                                                        if (n3 > 1) break block15;
                                                        if (zzei.zza < 26 || n3 <= 0) break block16;
                                                        n = n3;
                                                        break block14;
                                                    }
                                                    if ("audio/mpeg".equals(string2)) break block17;
                                                    if ("audio/3gpp".equals(string2)) break block18;
                                                    if ("audio/amr-wb".equals(string2)) break block19;
                                                    if ("audio/mp4a-latm".equals(string2)) break block20;
                                                    if ("audio/vorbis".equals(string2)) break block21;
                                                    if ("audio/opus".equals(string2)) break block22;
                                                    if ("audio/raw".equals(string2)) break block23;
                                                    if ("audio/flac".equals(string2)) break block24;
                                                    if ("audio/g711-alaw".equals(string2)) break block25;
                                                    if (!"audio/g711-mlaw".equals(string2)) {
                                                        if ("audio/gsm".equals(string2)) {
                                                            n = n3;
                                                            break block14;
                                                        } else {
                                                            n = "audio/ac3".equals(string2) ? 6 : ("audio/eac3".equals(string2) ? 16 : 30);
                                                            StringBuilder stringBuilder = new StringBuilder();
                                                            stringBuilder.append("AssumedMaxChannelAdjustment: ");
                                                            stringBuilder.append(string3);
                                                            stringBuilder.append(", [");
                                                            stringBuilder.append(n3);
                                                            stringBuilder.append(" to ");
                                                            stringBuilder.append(n);
                                                            stringBuilder.append("]");
                                                            String string4 = stringBuilder.toString();
                                                            zzdo.zzf("MediaCodecInfo", string4);
                                                        }
                                                        break block14;
                                                    } else {
                                                        n = n3;
                                                    }
                                                    break block14;
                                                }
                                                n = n3;
                                                break block14;
                                            }
                                            n = n3;
                                            break block14;
                                        }
                                        n = n3;
                                        break block14;
                                    }
                                    n = n3;
                                    break block14;
                                }
                                n = n3;
                                break block14;
                            }
                            n = n3;
                            break block14;
                        }
                        n = n3;
                        break block14;
                    }
                    n = n3;
                    break block14;
                }
                n = n3;
                break block14;
            }
            n = n3;
        }
        if (n >= n2) return true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("channelCount.support, ");
        stringBuilder.append(n2);
        this.zzj(stringBuilder.toString());
        return false;
    }

    private final boolean zzm(zzab zzab2) {
        return this.zzb.equals(zzab2.zzo) || this.zzb.equals(zzta.zzb(zzab2));
    }

    public final boolean zzf(zzab zzab2) {
        if (zzsg2.zzi) {
            return zzsg2.zze;
        }
        zzsg zzsg2 = zzcy.zza(zzab2);
        return zzsg2 != null && (Integer)((Pair)zzsg2).first == 42;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean zzg(int n, int n2, double d) {
        String string2;
        MediaCodecInfo.CodecCapabilities codecCapabilities = ((zzsg)object).zzd;
        if (codecCapabilities == null) {
            ((zzsg)object).zzj("sizeAndRate.caps");
            return false;
        }
        if ((codecCapabilities = codecCapabilities.getVideoCapabilities()) == null) {
            ((zzsg)object).zzj("sizeAndRate.vCaps");
            return false;
        }
        if (zzei.zza >= 29) {
            int n3 = zzsi.zza((MediaCodecInfo.VideoCapabilities)codecCapabilities, n, n2, d);
            if (n3 == 2) {
                return true;
            }
            if (n3 == 1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("sizeAndRate.cover, ");
                stringBuilder.append(n);
                stringBuilder.append("x");
                stringBuilder.append(n2);
                stringBuilder.append("@");
                stringBuilder.append(d);
                ((zzsg)object).zzj(stringBuilder.toString());
                return false;
            }
        }
        if (zzsg.zzk((MediaCodecInfo.VideoCapabilities)codecCapabilities, n, n2, d)) return true;
        if (!(n >= n2 || "OMX.MTK.VIDEO.DECODER.HEVC".equals(string2 = ((zzsg)object).zza) && "mcv5a".equals(zzei.zzb) || !zzsg.zzk((MediaCodecInfo.VideoCapabilities)codecCapabilities, n2, n, d))) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("sizeAndRate.rotated, ");
            stringBuilder.append(n);
            stringBuilder.append("x");
            stringBuilder.append(n2);
            stringBuilder.append("@");
            stringBuilder.append(d);
            String string3 = stringBuilder.toString();
            String string4 = ((zzsg)object).zza;
            Object object = ((zzsg)object).zzb;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("AssumedSupport [");
            stringBuilder2.append(string3);
            stringBuilder2.append("] [");
            stringBuilder2.append(string4);
            stringBuilder2.append(", ");
            stringBuilder2.append((String)object);
            stringBuilder2.append("] [");
            stringBuilder2.append(zzei.zze);
            stringBuilder2.append("]");
            object = stringBuilder2.toString();
            zzdo.zzb("MediaCodecInfo", (String)object);
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sizeAndRate.support, ");
        stringBuilder.append(n);
        stringBuilder.append("x");
        stringBuilder.append(n2);
        stringBuilder.append("@");
        stringBuilder.append(d);
        ((zzsg)object).zzj(stringBuilder.toString());
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final MediaCodecInfo.CodecProfileLevel[] zzh() {
        MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzd;
        if (codecCapabilities == null) return new MediaCodecInfo.CodecProfileLevel[0];
        if (codecCapabilities.profileLevels != null) return this.zzd.profileLevels;
        return new MediaCodecInfo.CodecProfileLevel[0];
    }
}

