/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.internal.zzeo;
import java.util.Date;
import java.util.Set;

@zzeo
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationInterstitialAdapter {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzd;
    private InterstitialAd zze;

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string2;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string2 = (String)location.next();
                builder.addKeyword(string2);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            builder.addTestDevice(zzj.zzbJ().zzC(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        string2 = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string2);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzd != null) {
            this.zzd.destroy();
            this.zzd = null;
        }
        if (this.zze != null) {
            this.zze = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzd != null) {
            this.zzd.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzd != null) {
            this.zzd.resume();
        }
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener bannerListener, Bundle serverParameters, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle extras) {
        this.zzd = new AdView(context);
        this.zzd.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzd.setAdUnitId(serverParameters.getString(AD_UNIT_ID_PARAMETER));
        this.zzd.setAdListener(new zza(this, bannerListener));
        this.zzd.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public View getBannerView() {
        return this.zzd;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener interstitialListener, Bundle serverParameters, MediationAdRequest mediationAdRequest, Bundle extras) {
        this.zze = new InterstitialAd(context);
        this.zze.setAdUnitId(serverParameters.getString(AD_UNIT_ID_PARAMETER));
        this.zze.setAdListener(new zzb(this, interstitialListener));
        this.zze.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public void showInterstitial() {
        this.zze.show();
    }

    static final class zzb
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzf;
        final MediationInterstitialListener zzh;

        public zzb(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzf = abstractAdViewAdapter;
            this.zzh = mediationInterstitialListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzh.onAdLoaded(this.zzf);
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzh.onAdFailedToLoad(this.zzf, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzh.onAdOpened(this.zzf);
        }

        @Override
        public void onAdClosed() {
            this.zzh.onAdClosed(this.zzf);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzh.onAdLeftApplication(this.zzf);
        }

        @Override
        public void onAdClicked() {
            this.zzh.onAdClicked(this.zzf);
        }
    }

    static final class zza
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzf;
        final MediationBannerListener zzg;

        public zza(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzf = abstractAdViewAdapter;
            this.zzg = mediationBannerListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzg.onAdLoaded(this.zzf);
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzg.onAdFailedToLoad(this.zzf, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzg.onAdOpened(this.zzf);
        }

        @Override
        public void onAdClosed() {
            this.zzg.onAdClosed(this.zzf);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzg.onAdLeftApplication(this.zzf);
        }

        @Override
        public void onAdClicked() {
            this.zzg.onAdClicked(this.zzf);
        }
    }
}

