/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzal;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public class zzl
extends zzfh {
    static final long zzzO = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zznu = new Object();
    private static boolean zzzP = false;
    private static zzcf zzzQ = null;
    private static zzbt zzzR = null;
    private static zzbx zzzS = null;
    private static zzbs zzzT = null;
    private final zza.zza zzyN;
    private final AdRequestInfoParcel.zza zzyO;
    private final Object zzyg = new Object();
    private final Context mContext;
    private zzfx<zzy> zzzU;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzl(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        this.zzyN = zza3;
        this.mContext = context;
        this.zzyO = zza2;
        Object object = zznu;
        synchronized (object) {
            if (!zzzP) {
                zzzS = new zzbx();
                zzzR = new zzbt(context.getApplicationContext(), zza2.zzmJ);
                zzzT = new zzc();
                zzzQ = new zzcf(this.mContext.getApplicationContext(), this.zzyO.zzmJ, zzat.zzrh.get(), new zzb(), new zza());
                zzzP = true;
            }
        }
    }

    protected static void zze(zzy zzy2) {
        zzy2.zza("/loadAd", zzzS);
        zzy2.zza("/fetchHttpRequest", zzzR);
        zzy2.zza("/invalidRequest", zzzT);
    }

    protected static void zzf(zzy zzy2) {
        zzy2.zzb("/loadAd", zzzS);
        zzy2.zzb("/fetchHttpRequest", zzzR);
        zzy2.zzb("/invalidRequest", zzzT);
    }

    @Override
    public void zzcX() {
        com.google.android.gms.ads.internal.util.client.zzb.zzaj("SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzyO, null, null);
        AdResponseParcel adResponseParcel = this.zzf(adRequestInfoParcel);
        long l = zzh.zzaU().elapsedRealtime();
        final zzfa.zza zza2 = new zzfa.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzzx, null);
        com.google.android.gms.ads.internal.util.client.zza.zzCH.post(new Runnable(){

            @Override
            public void run() {
                zzl.this.zzyN.zza(zza2);
                if (zzl.this.zzzU != null) {
                    zzzQ.zzb(zzl.this.zzzU);
                    zzl.this.zzzU = null;
                }
            }
        });
    }

    private AdResponseParcel zzf(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string2 = UUID.randomUUID().toString();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string2);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzh.zzaU().elapsedRealtime();
        Future<JSONObject> future = zzzS.zzG(string2);
        com.google.android.gms.ads.internal.util.client.zza.zzCH.post(new Runnable(){

            @Override
            public void run() {
                zzl.this.zzzU = zzzQ.zzda();
                zzl.this.zzzU.zza(new zzfx.zzd<zzy>(){

                    public void zzc(zzy zzy2) {
                        try {
                            zzy2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            com.google.android.gms.ads.internal.util.client.zzb.zzb("Error requesting an ad url", exception);
                            zzzS.zzH(string2);
                        }
                    }

                    @Override
                    public /* synthetic */ void zza(Object object) {
                        this.zzc((zzy)object);
                    }
                }, new zzfx.zza(){

                    @Override
                    public void run() {
                        zzzS.zzH(string2);
                    }
                });
            }
        });
        long l2 = zzzO - (zzh.zzaU().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zzer.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.zzzr)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string2) {
        Bundle bundle = adRequestInfoParcel.zzyW.extras.getBundle("sdk_less_server_data");
        String string3 = adRequestInfoParcel.zzyW.extras.getString("sdk_less_network_id");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzer.zza(adRequestInfoParcel, new zzev(this.mContext), null, new zzal(zzat.zzrh.get()), null, null, new ArrayList<String>());
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Cannot get advertising id info", throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("network_id", string3);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzh.zzaQ().zzx(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzyg;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzCH.post(new Runnable(){

                @Override
                public void run() {
                    if (zzl.this.zzzU != null) {
                        zzzQ.zzb(zzl.this.zzzU);
                        zzl.this.zzzU = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzfx.zzd<zzy> {
        public void zzc(zzy zzy2) {
            zzl.zzf(zzy2);
        }

        @Override
        public /* synthetic */ void zza(Object object) {
            this.zzc((zzy)object);
        }
    }

    public static class zzb
    implements zzfx.zzd<zzy> {
        public void zzc(zzy zzy2) {
            zzl.zze(zzy2);
        }

        @Override
        public /* synthetic */ void zza(Object object) {
            this.zzc((zzy)object);
        }
    }

    public static class zzc
    implements zzbs {
        @Override
        public void zza(zzgd zzgd2, Map<String, String> map) {
            String string2 = map.get("request_id");
            String string3 = map.get("errors");
            com.google.android.gms.ads.internal.util.client.zzb.zzan("Invalid request: " + string3);
            zzzS.zzH(string2);
        }
    }
}

