/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzac;
import com.google.android.gms.internal.zzad;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzen;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzic;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public class zzae
extends Thread {
    private boolean mStarted = false;
    private boolean zzpg = false;
    private boolean zzph = false;
    private final Object zzoe;
    private final zzad zzpi;
    private final zzac zzpj;
    private final zzen zzpk;
    private final int zzpl;
    private final int zzoT;
    private final int zzpm;
    private final int zzoV;
    private final int zzpn;

    public zzae(zzad zzad2, zzac zzac2, zzen zzen2) {
        this.zzpi = zzad2;
        this.zzpj = zzac2;
        this.zzpk = zzen2;
        this.zzoe = new Object();
        this.zzoT = zzat.zzrH.get();
        this.zzpm = zzat.zzrI.get();
        this.zzoV = zzat.zzrJ.get();
        this.zzpn = zzat.zzrK.get();
        this.zzpl = zzat.zzrL.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbz() {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.mStarted) {
                zzb.zzaj("Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.zzph) {
            Object object;
            try {
                if (this.zzbA()) {
                    object = this.zzpi.getActivity();
                    if (object == null) {
                        zzb.zzaj("ContentFetchThread: no activity");
                        continue;
                    }
                    this.zza((Activity)object);
                } else {
                    zzb.zzaj("ContentFetchTask: sleeping");
                    this.zzbC();
                }
                Thread.sleep(this.zzpl * 1000);
            }
            catch (Throwable throwable) {
                zzb.zzb("Error in ContentFetchTask", throwable);
                this.zzpk.zza(throwable, true);
            }
            object = this.zzoe;
            synchronized (object) {
                while (this.zzpg) {
                    try {
                        zzb.zzaj("ContentFetchTask: waiting");
                        this.zzoe.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zzf(final View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzae.this.zzg(view);
            }
        });
        return true;
    }

    void zzg(View view) {
        try {
            zzab zzab2 = new zzab(this.zzoT, this.zzpm, this.zzoV, this.zzpn);
            zza zza2 = this.zza(view, zzab2);
            zzab2.zzbw();
            if (zza2.zzpu == 0 && zza2.zzpv == 0) {
                return;
            }
            if (zza2.zzpv == 0 && zzab2.zzbx() == 0) {
                return;
            }
            if (zza2.zzpv == 0 && this.zzpj.zza(zzab2)) {
                return;
            }
            this.zzpj.zzc(zzab2);
        }
        catch (Exception exception) {
            zzb.zzb("Exception in fetchContentOnUIThread", exception);
            this.zzpk.zza(exception, true);
        }
    }

    boolean zzm(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzbA() {
        try {
            Context context = this.zzpi.getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzm(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
            view = activity.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (view == null) {
            return;
        }
        this.zzf(view);
    }

    zza zza(View view, zzab zzab2) {
        if (view == null) {
            return new zza(0, 0);
        }
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzab2.zzk(string2);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzgd)) {
            zzab2.zzbv();
            if (this.zza((WebView)view, zzab2)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzab2);
                n += zza2.zzpu;
                n2 += zza2.zzpv;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    boolean zza(final WebView webView, final zzab zzab2) {
        if (!zzic.zznk()) {
            return false;
        }
        zzab2.zzbv();
        webView.post(new Runnable(){
            ValueCallback<String> zzpq = new ValueCallback<String>(){

                public void zzm(String string2) {
                    zzae.this.zza(zzab2, webView, string2);
                }

                public /* synthetic */ void onReceiveValue(Object x0) {
                    this.zzm((String)x0);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzpq);
                    }
                    catch (Throwable throwable) {
                        this.zzpq.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzab zzab2, WebView webView, String string2) {
        zzab2.zzbu();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    zzab2.zzj(webView.getTitle() + "\n" + string3);
                } else {
                    zzab2.zzj(string3);
                }
            }
            if (zzab2.zzbr()) {
                this.zzpj.zzb(zzab2);
            }
        }
        catch (JSONException jSONException) {
            zzb.zzaj("Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzb.zza("Failed to get webview content.", throwable);
            this.zzpk.zza(throwable, true);
        }
    }

    public zzab zzbB() {
        return this.zzpj.zzby();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzpg = false;
            this.zzoe.notifyAll();
            zzb.zzaj("ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbC() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzpg = true;
            zzb.zzaj("ContentFetchThread: paused, mPause = " + this.zzpg);
        }
    }

    public boolean zzbD() {
        return this.zzpg;
    }

    @zzeo
    class zza {
        final int zzpu;
        final int zzpv;

        zza(int n, int n2) {
            this.zzpu = n;
            this.zzpv = n2;
        }
    }
}

